/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.net.InetAddress;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.nio.conn.scheme.LayeringStrategy;
import org.apache.http.nio.conn.scheme.Scheme;
import org.apache.http.nio.conn.scheme.SchemeRegistry;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class DefaultHttpAsyncRoutePlanner
implements HttpRoutePlanner {
    private final SchemeRegistry schemeRegistry;

    public DefaultHttpAsyncRoutePlanner(SchemeRegistry schemeRegistry) {
        this.schemeRegistry = schemeRegistry;
    }

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (request == null) {
            throw new IllegalStateException("Request may not be null");
        }
        HttpRoute route = ConnRouteParams.getForcedRoute((HttpParams)request.getParams());
        if (route != null) {
            return route;
        }
        if (target == null) {
            throw new IllegalStateException("Target host may be null");
        }
        InetAddress local = ConnRouteParams.getLocalAddress((HttpParams)request.getParams());
        HttpHost proxy = ConnRouteParams.getDefaultProxy((HttpParams)request.getParams());
        Scheme scheme = this.schemeRegistry.getScheme(target);
        LayeringStrategy layeringStrategy = scheme.getLayeringStrategy();
        boolean secure = layeringStrategy != null && layeringStrategy.isSecure();
        route = proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
        return route;
    }
}

