/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRouteDirector;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.RoutedRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncExchangeHandler;
import org.apache.http.nio.client.HttpAsyncRequestProducer;
import org.apache.http.nio.client.HttpAsyncResponseConsumer;
import org.apache.http.nio.concurrent.BasicFuture;
import org.apache.http.nio.concurrent.FutureCallback;
import org.apache.http.nio.conn.ClientConnectionManager;
import org.apache.http.nio.conn.ManagedClientConnection;
import org.apache.http.nio.conn.scheme.Scheme;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultAsyncRequestDirector<T>
implements HttpAsyncExchangeHandler<T> {
    public static final String HTTP_EXCHANGE_HANDLER = "http.nio.async-exchange-handler";
    private final Log log;
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final HttpContext localContext;
    private final BasicFuture<T> resultFuture;
    private final ClientConnectionManager connmgr;
    private final HttpProcessor httppocessor;
    private final HttpRoutePlanner routePlanner;
    private final HttpRouteDirector routeDirector;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;
    private final RedirectStrategy redirectStrategy;
    private final AuthState targetAuthState;
    private final AuthState proxyAuthState;
    private final HttpParams clientParams;
    private RoutedRequest mainRequest;
    private RoutedRequest followup;
    private HttpResponse finalResponse;
    private ClientParamsStack params;
    private RequestWrapper currentRequest;
    private HttpResponse currentResponse;
    private boolean routeEstablished;
    private Future<ManagedClientConnection> connFuture;
    private ManagedClientConnection managedConn;
    private int redirectCount;
    private ByteBuffer tmpbuf;

    public DefaultAsyncRequestDirector(Log log, HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext localContext, FutureCallback<T> callback, ClientConnectionManager connmgr, HttpProcessor httppocessor, HttpRoutePlanner routePlanner, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy, RedirectStrategy redirectStrategy, HttpParams clientParams) {
        this.log = log;
        this.requestProducer = requestProducer;
        this.responseConsumer = responseConsumer;
        this.localContext = localContext;
        this.resultFuture = new BasicFuture<T>(callback);
        this.connmgr = connmgr;
        this.httppocessor = httppocessor;
        this.routePlanner = routePlanner;
        this.reuseStrategy = reuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
        this.redirectStrategy = redirectStrategy;
        this.routeDirector = new BasicRouteDirector();
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
        this.clientParams = clientParams;
    }

    public synchronized void start() {
        try {
            HttpHost target = this.requestProducer.getTarget();
            HttpRequest request = this.requestProducer.generateRequest();
            this.params = new ClientParamsStack(null, this.clientParams, request.getParams(), null);
            RequestWrapper wrapper = this.wrapRequest(request);
            wrapper.setParams((HttpParams)this.params);
            HttpRoute route = this.determineRoute(target, (HttpRequest)wrapper, this.localContext);
            this.mainRequest = new RoutedRequest(wrapper, route);
            this.requestConnection();
        }
        catch (Exception ex) {
            this.failed(ex);
        }
    }

    public Future<T> getResultFuture() {
        return this.resultFuture;
    }

    @Override
    public HttpHost getTarget() {
        return this.requestProducer.getTarget();
    }

    @Override
    public synchronized HttpRequest generateRequest() throws IOException, HttpException {
        HttpHost target;
        HttpRoute route = this.mainRequest.getRoute();
        if (!this.routeEstablished) {
            int step;
            do {
                HttpRoute fact = this.managedConn.getRoute();
                step = this.routeDirector.nextStep((RouteInfo)route, (RouteInfo)fact);
                switch (step) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.log.debug((Object)"Tunnel required");
                        HttpRequest connect = this.createConnectRequest(route);
                        this.currentRequest = this.wrapRequest(connect);
                        this.currentRequest.setParams((HttpParams)this.params);
                        break;
                    }
                    case 4: {
                        throw new HttpException("Proxy chains are not supported");
                    }
                    case 5: {
                        this.managedConn.layerProtocol(this.localContext, (HttpParams)this.params);
                        break;
                    }
                    case -1: {
                        throw new HttpException("Unable to establish route: planned = " + route + "; current = " + fact);
                    }
                    case 0: {
                        this.routeEstablished = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                    }
                }
            } while (step > 0 && this.currentRequest == null);
        }
        if ((target = (HttpHost)this.params.getParameter("http.virtual-host")) == null) {
            target = route.getTargetHost();
        }
        HttpHost proxy = route.getProxyHost();
        if (this.currentRequest == null) {
            this.currentRequest = this.mainRequest.getRequest();
            this.rewriteRequestURI(this.currentRequest, route);
        }
        this.currentRequest.resetHeaders();
        this.localContext.setAttribute("http.request", (Object)this.currentRequest);
        this.localContext.setAttribute("http.target_host", (Object)target);
        this.localContext.setAttribute("http.proxy_host", (Object)proxy);
        this.httppocessor.process((HttpRequest)this.currentRequest, this.localContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Request submitted: " + this.currentRequest.getRequestLine()));
        }
        return this.currentRequest;
    }

    @Override
    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.requestProducer.produceContent(encoder, ioctrl);
        if (encoder.isCompleted()) {
            this.requestProducer.resetRequest();
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.requestProducer.isRepeatable();
    }

    @Override
    public void resetRequest() {
        this.requestProducer.resetRequest();
    }

    @Override
    public synchronized void responseReceived(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Response: " + response.getStatusLine()));
        }
        this.currentResponse = response;
        this.currentResponse.setParams((HttpParams)this.params);
        this.localContext.setAttribute("http.response", (Object)this.currentResponse);
        this.httppocessor.process(this.currentResponse, this.localContext);
        int status = this.currentResponse.getStatusLine().getStatusCode();
        if (!this.routeEstablished) {
            String method = this.currentRequest.getMethod();
            if (method.equalsIgnoreCase("CONNECT") && status == 200) {
                this.managedConn.tunnelTarget((HttpParams)this.params);
            } else {
                this.finalResponse = response;
            }
        } else {
            this.followup = this.handleResponse();
            if (this.followup == null) {
                this.finalResponse = response;
            }
        }
        if (this.finalResponse != null) {
            this.responseConsumer.responseReceived(response);
        }
    }

    @Override
    public synchronized void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        if (this.finalResponse != null) {
            this.responseConsumer.consumeContent(decoder, ioctrl);
        } else {
            if (this.tmpbuf == null) {
                this.tmpbuf = ByteBuffer.allocate(2048);
            }
            this.tmpbuf.clear();
            decoder.read(this.tmpbuf);
        }
    }

    private void releaseResources() {
        if (this.managedConn != null) {
            try {
                this.managedConn.getContext().removeAttribute(HTTP_EXCHANGE_HANDLER);
                this.managedConn.releaseConnection();
            }
            catch (IOException ioex) {
                this.log.debug((Object)"I/O error releasing connection", (Throwable)ioex);
            }
        }
        this.managedConn = null;
        if (this.connFuture != null) {
            this.connFuture.cancel(true);
            this.connFuture = null;
        }
        this.requestProducer.resetRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void failed(Exception ex) {
        try {
            this.responseConsumer.failed(ex);
        }
        finally {
            try {
                this.resultFuture.failed(ex);
            }
            finally {
                this.releaseResources();
            }
        }
    }

    @Override
    public synchronized boolean keepAlive(HttpResponse response) {
        return this.reuseStrategy.keepAlive(response, this.localContext);
    }

    @Override
    public synchronized void responseCompleted() {
        this.log.debug((Object)"Response fully read");
        try {
            if (this.managedConn.isOpen()) {
                long duration = this.keepaliveStrategy.getKeepAliveDuration(this.currentResponse, this.localContext);
                if (this.log.isDebugEnabled()) {
                    String s = duration > 0L ? "for " + duration + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                    this.log.debug((Object)("Connection can be kept alive " + s));
                }
                this.managedConn.setIdleDuration(duration, TimeUnit.MILLISECONDS);
            }
            if (this.finalResponse != null) {
                this.responseConsumer.responseCompleted();
                this.log.debug((Object)"Response processed");
                this.resultFuture.completed(this.responseConsumer.getResult());
                this.releaseResources();
            } else {
                if (this.followup != null) {
                    HttpRoute newRoute;
                    HttpRoute actualRoute = this.mainRequest.getRoute();
                    if (!actualRoute.equals((Object)(newRoute = this.followup.getRoute()))) {
                        this.releaseResources();
                    }
                    this.mainRequest = this.followup;
                }
                if (this.managedConn != null) {
                    this.managedConn.requestOutput();
                } else {
                    this.requestConnection();
                }
            }
            this.followup = null;
            this.currentRequest = null;
            this.currentResponse = null;
        }
        catch (RuntimeException runex) {
            this.failed(runex);
            throw runex;
        }
    }

    @Override
    public synchronized void cancel() {
        this.log.debug((Object)"HTTP exchange cancelled");
        try {
            this.responseConsumer.cancel();
            this.resultFuture.cancel(true);
            this.releaseResources();
        }
        catch (RuntimeException runex) {
            this.failed(runex);
            throw runex;
        }
    }

    @Override
    public boolean isDone() {
        return this.resultFuture.isDone();
    }

    @Override
    public T getResult() {
        return this.responseConsumer.getResult();
    }

    private synchronized void connectionRequestCompleted(ManagedClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request suceeded: " + conn));
        }
        try {
            HttpRoute route = this.mainRequest.getRoute();
            if (!conn.isOpen()) {
                conn.open(route, this.localContext, (HttpParams)this.params);
            }
            this.managedConn = conn;
            this.managedConn.getContext().setAttribute(HTTP_EXCHANGE_HANDLER, (Object)this);
            this.managedConn.requestOutput();
            this.routeEstablished = route.equals((Object)conn.getRoute());
        }
        catch (IOException ex) {
            this.failed(ex);
        }
        catch (RuntimeException runex) {
            this.failed(runex);
            throw runex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectionRequestFailed(Exception ex) {
        this.log.debug((Object)"Connection request failed", (Throwable)ex);
        try {
            this.requestProducer.resetRequest();
            this.responseConsumer.failed(ex);
        }
        finally {
            this.resultFuture.failed(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectionRequestCancelled() {
        this.log.debug((Object)"Connection request cancelled");
        try {
            this.requestProducer.resetRequest();
            this.responseConsumer.cancel();
        }
        finally {
            this.resultFuture.cancel(true);
        }
    }

    private void requestConnection() {
        HttpRoute route = this.mainRequest.getRoute();
        long connectTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)this.params);
        Object userToken = this.localContext.getAttribute("http.user-token");
        this.connFuture = this.connmgr.leaseConnection(route, userToken, connectTimeout, TimeUnit.MILLISECONDS, new InternalFutureCallback());
    }

    protected HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (target == null) {
            target = (HttpHost)request.getParams().getParameter("http.default-host");
        }
        if (target == null) {
            throw new IllegalStateException("Target host could not be resolved");
        }
        return this.routePlanner.determineRoute(target, request, context);
    }

    private RequestWrapper wrapRequest(HttpRequest request) throws ProtocolException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
        }
        return new RequestWrapper(request);
    }

    protected void rewriteRequestURI(RequestWrapper request, HttpRoute route) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (route.getProxyHost() != null && !route.isTunnelled()) {
                if (!uri.isAbsolute()) {
                    HttpHost target = route.getTargetHost();
                    uri = URIUtils.rewriteURI((URI)uri, (HttpHost)target);
                    request.setURI(uri);
                }
            } else if (uri.isAbsolute()) {
                uri = URIUtils.rewriteURI((URI)uri, null);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), (Throwable)ex);
        }
    }

    private HttpRequest createConnectRequest(HttpRoute route) {
        HttpHost target = route.getTargetHost();
        String host = target.getHostName();
        int port = target.getPort();
        if (port < 0) {
            Scheme scheme = this.connmgr.getSchemeRegistry().getScheme(target.getSchemeName());
            port = scheme.getDefaultPort();
        }
        StringBuilder buffer = new StringBuilder(host.length() + 6);
        buffer.append(host);
        buffer.append(':');
        buffer.append(Integer.toString(port));
        ProtocolVersion ver = HttpProtocolParams.getVersion((HttpParams)this.params);
        BasicHttpRequest req = new BasicHttpRequest("CONNECT", buffer.toString(), ver);
        return req;
    }

    private RoutedRequest handleResponse() throws HttpException {
        HttpRoute route = this.mainRequest.getRoute();
        RequestWrapper request = this.mainRequest.getRequest();
        if (HttpClientParams.isRedirecting((HttpParams)this.params) && this.redirectStrategy.isRedirected((HttpRequest)this.currentRequest, this.currentResponse, this.localContext)) {
            int maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
            if (this.redirectCount >= maxRedirects) {
                throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            HttpUriRequest redirect = this.redirectStrategy.getRedirect((HttpRequest)this.currentRequest, this.currentResponse, this.localContext);
            HttpRequest orig = request.getOriginal();
            redirect.setHeaders(orig.getAllHeaders());
            URI uri = redirect.getURI();
            if (uri.getHost() == null) {
                throw new ProtocolException("Redirect URI does not specify a valid host name: " + uri);
            }
            HttpHost newTarget = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            this.targetAuthState.setAuthScope(null);
            this.proxyAuthState.setAuthScope(null);
            if (!route.getTargetHost().equals((Object)newTarget)) {
                this.targetAuthState.invalidate();
                AuthScheme authScheme = this.proxyAuthState.getAuthScheme();
                if (authScheme != null && authScheme.isConnectionBased()) {
                    this.proxyAuthState.invalidate();
                }
            }
            RequestWrapper newRequest = this.wrapRequest((HttpRequest)redirect);
            newRequest.setParams((HttpParams)this.params);
            HttpRoute newRoute = this.determineRoute(newTarget, (HttpRequest)newRequest, this.localContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Redirecting to '" + uri + "' via " + newRoute));
            }
            return new RoutedRequest(newRequest, newRoute);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InternalFutureCallback
    implements FutureCallback<ManagedClientConnection> {
        InternalFutureCallback() {
        }

        @Override
        public void completed(ManagedClientConnection session) {
            DefaultAsyncRequestDirector.this.connectionRequestCompleted(session);
        }

        @Override
        public void failed(Exception ex) {
            DefaultAsyncRequestDirector.this.connectionRequestFailed(ex);
        }

        @Override
        public void cancelled() {
            DefaultAsyncRequestDirector.this.connectionRequestCancelled();
        }
    }
}

