/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.CircularRedirectException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RedirectException;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.RequestBuilder;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class RedirectExec
implements ExecChainHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull((Object)routePlanner, (String)"HTTP route planner");
        Args.notNull((Object)redirectStrategy, (String)"HTTP redirect strategy");
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpClientContext context = scope.clientContext;
        RedirectLocations redirectLocations = context.getRedirectLocations();
        if (redirectLocations == null) {
            redirectLocations = new RedirectLocations();
            context.setAttribute("http.protocol.redirect-locations", redirectLocations);
        }
        redirectLocations.clear();
        RequestConfig config = context.getRequestConfig();
        int maxRedirects = config.getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        ClassicHttpRequest currentRequest = request;
        ExecChain.Scope currentScope = scope;
        int redirectCount = 0;
        while (true) {
            ClassicHttpResponse response = chain.proceed(currentRequest, currentScope);
            try {
                HttpRoute newRoute;
                HttpHost newTarget;
                if (!config.isRedirectsEnabled()) return response;
                if (!this.redirectStrategy.isRedirected((HttpRequest)request, (HttpResponse)response, (HttpContext)context)) return response;
                HttpEntity requestEntity = request.getEntity();
                if (requestEntity != null && !requestEntity.isRepeatable()) {
                    this.log.debug("Cannot redirect non-repeatable request");
                    return response;
                }
                if (redirectCount >= maxRedirects) {
                    throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                }
                ++redirectCount;
                URI redirectUri = this.redirectStrategy.getLocationURI((HttpRequest)currentRequest, (HttpResponse)response, (HttpContext)context);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Redirect requested to location '" + redirectUri + "'");
                }
                if (!config.isCircularRedirectsAllowed() && redirectLocations.contains(redirectUri)) {
                    throw new CircularRedirectException("Circular redirect to '" + redirectUri + "'");
                }
                redirectLocations.add(redirectUri);
                ClassicHttpRequest originalRequest = scope.originalRequest;
                ClassicHttpRequest redirect = null;
                int statusCode = response.getCode();
                switch (statusCode) {
                    case 301: 
                    case 302: 
                    case 303: {
                        if (!StandardMethods.isSafe(request.getMethod())) {
                            HttpGet httpGet = new HttpGet(redirectUri);
                            httpGet.setHeaders(originalRequest.getHeaders());
                            redirect = httpGet;
                            break;
                        }
                        redirect = null;
                        break;
                    }
                }
                if (redirect == null) {
                    redirect = RequestBuilder.copy(originalRequest).setUri(redirectUri).build();
                }
                if ((newTarget = URIUtils.extractHost(redirectUri)) == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + redirectUri);
                }
                HttpRoute currentRoute = currentScope.route;
                if (!LangUtils.equals((Object)currentRoute.getTargetHost(), (Object)newTarget) && !LangUtils.equals((Object)currentRoute, (Object)(newRoute = this.routePlanner.determineRoute(newTarget, (HttpContext)context)))) {
                    AuthExchange proxyAuthExchange;
                    this.log.debug("New route required");
                    AuthExchange targetAuthExchange = context.getAuthExchange(currentRoute.getTargetHost());
                    this.log.debug("Resetting target auth state");
                    targetAuthExchange.reset();
                    if (currentRoute.getProxyHost() != null && (proxyAuthExchange = context.getAuthExchange(currentRoute.getProxyHost())).isConnectionBased()) {
                        this.log.debug("Resetting proxy auth state");
                        proxyAuthExchange.reset();
                    }
                    currentScope = new ExecChain.Scope(currentScope.exchangeId, newRoute, currentScope.originalRequest, currentScope.execRuntime, currentScope.clientContext);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Redirecting to '" + redirectUri + "' via " + currentRoute);
                }
                currentRequest = redirect;
                RequestEntityProxy.enhance(currentRequest);
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
            }
            catch (IOException | RuntimeException ex) {
                response.close();
                throw ex;
            }
            catch (HttpException ex) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    throw ex;
                }
                catch (IOException ioex) {
                    this.log.debug("I/O error while releasing connection", (Throwable)ioex);
                    throw ex;
                }
                finally {
                    response.close();
                }
            }
        }
    }
}

