/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.jetty.client;

import java.util.List;
import org.apache.htrace.jetty.client.HttpClient;
import org.apache.htrace.jetty.client.HttpContentResponse;
import org.apache.htrace.jetty.client.HttpConversation;
import org.apache.htrace.jetty.client.HttpExchange;
import org.apache.htrace.jetty.client.HttpRequest;
import org.apache.htrace.jetty.client.HttpRequestException;
import org.apache.htrace.jetty.client.ProtocolHandler;
import org.apache.htrace.jetty.client.ResponseNotifier;
import org.apache.htrace.jetty.client.api.Request;
import org.apache.htrace.jetty.client.api.Response;
import org.apache.htrace.jetty.client.api.Result;
import org.apache.htrace.jetty.client.util.BufferingResponseListener;
import org.apache.htrace.jetty.http.HttpHeader;
import org.apache.htrace.jetty.http.HttpHeaderValue;

public class ContinueProtocolHandler
implements ProtocolHandler {
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    public ContinueProtocolHandler(HttpClient client) {
        this.client = client;
        this.notifier = new ResponseNotifier();
    }

    @Override
    public boolean accept(Request request, Response response) {
        boolean expect100 = request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        HttpConversation conversation = ((HttpRequest)request).getConversation();
        boolean handled100 = conversation.getAttribute(ATTRIBUTE) != null;
        return expect100 && !handled100;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    protected class ContinueListener
    extends BufferingResponseListener {
        protected ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            switch (response.getStatus()) {
                case 100: {
                    exchange.resetResponse(true);
                    exchange.proceed(null);
                    break;
                }
                default: {
                    List<Response.ResponseListener> listeners = exchange.getResponseListeners();
                    HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                    ContinueProtocolHandler.this.notifier.forwardSuccess(listeners, contentResponse);
                    exchange.proceed(new HttpRequestException("Expectation failed", exchange.getRequest()));
                    break;
                }
            }
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            List<Response.ResponseListener> listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            ContinueProtocolHandler.this.notifier.forwardFailureComplete(listeners, exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure);
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

