/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.List;
import org.apache.htrace.javax.servlet.ServletException;
import org.apache.htrace.javax.servlet.http.HttpServletRequest;
import org.apache.htrace.javax.servlet.http.HttpServletResponse;
import org.apache.htrace.org.eclipse.jetty.server.Handler;
import org.apache.htrace.org.eclipse.jetty.server.Request;
import org.apache.htrace.org.eclipse.jetty.server.Server;
import org.apache.htrace.org.eclipse.jetty.server.handler.AbstractHandlerContainer;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Parameter handler is null.");
        }
        try {
            this.updateBean(this._handler, handler);
            this._handler = handler;
            Server server = this.getServer();
            handler.setServer(server);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    public void setServer(Server server) {
        if (this.isRunning()) {
            throw new IllegalStateException("RUNNING");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        this.expandHandler(this._handler, list, byClass);
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
            child.destroy();
        }
        super.destroy();
    }
}

