/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.hadoop.hive.metastore.tools.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BenchmarkSuite {
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkSuite.class);
    private static final double MARGIN = 2.0;
    private final Map<String, Supplier<DescriptiveStatistics>> suite = new HashMap<String, Supplier<DescriptiveStatistics>>();
    private final List<String> benchmarks = new ArrayList<String>();
    private final Map<String, DescriptiveStatistics> result = new TreeMap<String, DescriptiveStatistics>();
    private boolean doSanitize = false;
    private TimeUnit scale = TimeUnit.MILLISECONDS;

    public BenchmarkSuite setScale(TimeUnit scale) {
        this.scale = scale;
        return this;
    }

    public BenchmarkSuite doSanitize(boolean sanitize) {
        this.doSanitize = sanitize;
        return this;
    }

    public Map<String, DescriptiveStatistics> getResult() {
        return this.result;
    }

    private BenchmarkSuite runAll(List<String> names) {
        if (this.doSanitize) {
            names.forEach(name -> {
                LOG.info("Running benchmark {}", name);
                this.result.put((String)name, BenchmarkSuite.sanitize(this.suite.get(name).get()));
            });
        } else {
            names.forEach(name -> {
                LOG.info("Running benchmark {}", name);
                this.result.put((String)name, this.suite.get(name).get());
            });
        }
        return this;
    }

    public List<String> listMatching(@Nullable Pattern[] positive, @Nullable Pattern[] negatve) {
        return Util.filterMatches(this.benchmarks, positive, negatve);
    }

    public BenchmarkSuite runMatching(@Nullable Pattern[] positive, @Nullable Pattern[] negatve) {
        return this.runAll(Util.filterMatches(this.benchmarks, positive, negatve));
    }

    public BenchmarkSuite add(@NotNull String name, @NotNull Supplier<DescriptiveStatistics> b) {
        this.suite.put(name, b);
        this.benchmarks.add(name);
        return this;
    }

    private static DescriptiveStatistics sanitize(@NotNull DescriptiveStatistics data) {
        double meanValue = data.getMean();
        double delta = 2.0 * meanValue;
        double minVal = meanValue - delta;
        double maxVal = meanValue + delta;
        return new DescriptiveStatistics(Arrays.stream(data.getValues()).filter(x -> x > minVal && x < maxVal).toArray());
    }

    private static double median(@NotNull DescriptiveStatistics data) {
        return new Median().evaluate(data.getValues());
    }

    private void displayStats(@NotNull Formatter fmt, @NotNull String name, @NotNull DescriptiveStatistics stats) {
        double mean = stats.getMean();
        double err = stats.getStandardDeviation() / mean * 100.0;
        long conv = this.scale.toNanos(1L);
        fmt.format("%-30s %-8.4g %-8.4g %-8.4g %-8.4g %-8.4g%n", name, mean / (double)conv, BenchmarkSuite.median(stats) / (double)conv, stats.getMin() / (double)conv, stats.getMax() / (double)conv, err);
    }

    private void displayCSV(@NotNull Formatter fmt, @NotNull String name, @NotNull DescriptiveStatistics stats, @NotNull String separator) {
        double mean = stats.getMean();
        double err = stats.getStandardDeviation() / mean * 100.0;
        long conv = this.scale.toNanos(1L);
        fmt.format("%s%s%g%s%g%s%g%s%g%s%g%n", name, separator, mean / (double)conv, separator, BenchmarkSuite.median(stats) / (double)conv, separator, stats.getMin() / (double)conv, separator, stats.getMax() / (double)conv, separator, err);
    }

    BenchmarkSuite display(Formatter fmt) {
        fmt.format("%-30s %-8s %-8s %-8s %-8s %-8s%n", "Operation", "Mean", "Med", "Min", "Max", "Err%");
        this.result.forEach((name, stat) -> this.displayStats(fmt, (String)name, (DescriptiveStatistics)stat));
        return this;
    }

    BenchmarkSuite displayCSV(Formatter fmt, String separator) {
        fmt.format("%s%s%s%s%s%s%s%s%s%s%s%n", "Operation", separator, "Mean", separator, "Med", separator, "Min", separator, "Max", separator, "Err%");
        this.result.forEach((name, s) -> this.displayCSV(fmt, (String)name, (DescriptiveStatistics)s, separator));
        return this;
    }
}

