/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsResult;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsResult;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.tools.Util;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HMSClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HMSClient.class);
    private static final String METASTORE_URI = "hive.metastore.uris";
    private static final String CONFIG_DIR = "/etc/hive/conf";
    private static final String HIVE_SITE = "hive-site.xml";
    private static final String CORE_SITE = "core-site.xml";
    private static final String PRINCIPAL_KEY = "hive.metastore.kerberos.principal";
    private final String confDir;
    private ThriftHiveMetastore.Iface client;
    private TTransport transport;
    private URI serverURI;
    private Configuration hadoopConf;

    public URI getServerURI() {
        return this.serverURI;
    }

    public String toString() {
        return this.serverURI.toString();
    }

    HMSClient(@Nullable URI uri) throws TException, IOException, InterruptedException, LoginException, URISyntaxException {
        this(uri, CONFIG_DIR);
    }

    HMSClient(@Nullable URI uri, @Nullable String confDir) throws TException, IOException, InterruptedException, LoginException, URISyntaxException {
        this.confDir = confDir == null ? CONFIG_DIR : confDir;
        this.getClient(uri);
    }

    private void addResource(Configuration conf, @NotNull String r) throws MalformedURLException {
        File f = new File(this.confDir + "/" + r);
        if (f.exists() && !f.isDirectory()) {
            LOG.debug("Adding configuration resource {}", (Object)r);
            conf.addResource(f.toURI().toURL());
        } else {
            LOG.debug("Configuration {} does not exist", (Object)r);
        }
    }

    private void getClient(@Nullable URI uri) throws TException, IOException, InterruptedException, URISyntaxException, LoginException {
        HiveConf conf = new HiveConf();
        this.addResource((Configuration)conf, HIVE_SITE);
        if (uri != null) {
            conf.set(METASTORE_URI, uri.toString());
        }
        this.serverURI = uri != null ? uri : new URI(conf.get(METASTORE_URI).split(",")[0]);
        String principal = conf.get(PRINCIPAL_KEY);
        if (principal == null) {
            this.open((Configuration)conf, this.serverURI);
            return;
        }
        LOG.debug("Opening kerberos connection to HMS");
        this.addResource((Configuration)conf, CORE_SITE);
        this.hadoopConf = new Configuration();
        this.addResource(this.hadoopConf, HIVE_SITE);
        this.addResource(this.hadoopConf, CORE_SITE);
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
        UserGroupInformation.getLoginUser().doAs(() -> this.lambda$getClient$0((Configuration)conf));
    }

    boolean dbExists(@NotNull String dbName) throws TException {
        return this.getAllDatabases(dbName).contains(dbName);
    }

    boolean tableExists(@NotNull String dbName, @NotNull String tableName) throws TException {
        return this.getAllTables(dbName, tableName).contains(tableName);
    }

    Database getDatabase(@NotNull String dbName) throws TException {
        return this.client.get_database(dbName);
    }

    Set<String> getAllDatabases(@Nullable String filter) throws TException {
        if (filter == null || filter.isEmpty()) {
            return new HashSet<String>(this.client.get_all_databases());
        }
        return this.client.get_all_databases().stream().filter(n -> n.matches(filter)).collect(Collectors.toSet());
    }

    Set<String> getAllTables(@NotNull String dbName, @Nullable String filter) throws TException {
        if (filter == null || filter.isEmpty()) {
            return new HashSet<String>(this.client.get_all_tables(dbName));
        }
        return this.client.get_all_tables(dbName).stream().filter(n -> n.matches(filter)).collect(Collectors.toSet());
    }

    boolean createDatabase(@NotNull String name) throws TException {
        return this.createDatabase(name, null, null, null);
    }

    boolean createDatabase(@NotNull String name, @Nullable String description, @Nullable String location, @Nullable Map<String, String> params) throws TException {
        Database db = new Database(name, description, location, params);
        this.client.create_database(db);
        return true;
    }

    boolean createDatabase(Database db) throws TException {
        this.client.create_database(db);
        return true;
    }

    boolean dropDatabase(@NotNull String dbName) throws TException {
        this.client.drop_database(dbName, true, true);
        return true;
    }

    boolean createTable(Table table) throws TException {
        this.client.create_table(table);
        return true;
    }

    boolean dropTable(@NotNull String dbName, @NotNull String tableName) throws TException {
        return this.dropTable(dbName, tableName, true);
    }

    boolean dropTable(@NotNull String dbName, @NotNull String tableName, boolean deleteData) throws TException {
        this.client.drop_table(dbName, tableName, deleteData);
        return true;
    }

    Table getTable(@NotNull String dbName, @NotNull String tableName) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        return this.client.get_table_req(req).getTable();
    }

    Partition createPartition(@NotNull Table table, @NotNull List<String> values) throws TException {
        return this.client.add_partition(new Util.PartitionBuilder(table).withValues(values).build());
    }

    Partition addPartition(@NotNull Partition partition) throws TException {
        return this.client.add_partition(partition);
    }

    void addPartitions(List<Partition> partitions) throws TException {
        this.client.add_partitions(partitions);
    }

    void updatePartitionColumnStats(ColumnStatistics colStats) throws TException {
        this.client.update_partition_column_statistics(colStats);
    }

    List<Partition> listPartitions(@NotNull String dbName, @NotNull String tableName) throws TException {
        return this.client.get_partitions(dbName, tableName, (short)-1);
    }

    Long getCurrentNotificationId() throws TException {
        return this.client.get_current_notificationEventId().getEventId();
    }

    List<String> getPartitionNames(@NotNull String dbName, @NotNull String tableName) throws TException {
        return this.client.get_partition_names(dbName, tableName, (short)-1);
    }

    public boolean dropPartition(@NotNull String dbName, @NotNull String tableName, @NotNull List<String> arguments) throws TException {
        return this.client.drop_partition(dbName, tableName, arguments, true);
    }

    public boolean dropPartition(@NotNull String dbName, @NotNull String tableName, @NotNull String arguments) throws TException {
        List partVals = Warehouse.getPartValuesFromPartName((String)arguments);
        return this.dropPartition(dbName, tableName, partVals);
    }

    List<Partition> getPartitions(@NotNull String dbName, @NotNull String tableName) throws TException {
        return this.client.get_partitions(dbName, tableName, (short)-1);
    }

    DropPartitionsResult dropPartitions(@NotNull String dbName, @NotNull String tableName, @Nullable List<String> partNames) throws TException {
        if (partNames == null) {
            return this.dropPartitions(dbName, tableName, this.getPartitionNames(dbName, tableName));
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return this.client.drop_partitions_req(new DropPartitionsRequest(dbName, tableName, RequestPartsSpec.names(partNames)));
    }

    List<Partition> getPartitionsByNames(@NotNull String dbName, @NotNull String tableName, @Nullable List<String> names) throws TException {
        if (names == null) {
            return this.client.get_partitions_by_names(dbName, tableName, this.getPartitionNames(dbName, tableName));
        }
        return this.client.get_partitions_by_names(dbName, tableName, names);
    }

    List<Partition> getPartitionsByFilter(@NotNull String dbName, @NotNull String tableName, @NotNull String filter) throws TException {
        return this.client.get_partitions_by_filter(dbName, tableName, filter, (short)-1);
    }

    List<Partition> getPartitionsByPs(@NotNull String dbName, @NotNull String tableName, @NotNull List<String> partVals) throws TException {
        return this.client.get_partitions_ps_with_auth(dbName, tableName, partVals, (short)-1, null, null);
    }

    PartitionsStatsResult getPartitionsStats(PartitionsStatsRequest request) throws TException {
        return this.client.get_partitions_statistics_req(request);
    }

    boolean alterTable(@NotNull String dbName, @NotNull String tableName, @NotNull Table newTable) throws TException {
        this.client.alter_table(dbName, tableName, newTable);
        return true;
    }

    void alterPartition(@NotNull String dbName, @NotNull String tableName, @NotNull Partition partition) throws TException {
        this.client.alter_partition(dbName, tableName, partition);
    }

    void alterPartitions(@NotNull String dbName, @NotNull String tableName, @NotNull List<Partition> partitions) throws TException {
        this.client.alter_partitions(dbName, tableName, partitions);
    }

    void appendPartition(@NotNull String dbName, @NotNull String tableName, @NotNull List<String> partitionValues) throws TException {
        this.client.append_partition_with_environment_context(dbName, tableName, partitionValues, null);
    }

    List<Long> getOpenTxns() throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        GetOpenTxnsResponse txns = this.client.get_open_txns_req(getOpenTxnsRequest);
        ArrayList<Long> openTxns = new ArrayList<Long>();
        BitSet abortedBits = BitSet.valueOf(txns.getAbortedBits());
        int i = 0;
        Iterator iterator = txns.getOpen_txns().iterator();
        while (iterator.hasNext()) {
            long txnId = (Long)iterator.next();
            if (!abortedBits.get(i)) {
                openTxns.add(txnId);
            }
            ++i;
        }
        return openTxns;
    }

    List<TxnInfo> getOpenTxnsInfo() throws TException {
        return this.client.get_open_txns_info().getOpen_txns();
    }

    boolean commitTxn(long txnId) throws TException {
        this.client.commit_txn(new CommitTxnRequest(txnId));
        return true;
    }

    boolean abortTxns(List<Long> txnIds) throws TException {
        this.client.abort_txns(new AbortTxnsRequest(txnIds));
        return true;
    }

    boolean allocateTableWriteIds(String dbName, String tableName, List<Long> openTxns) throws TException {
        AllocateTableWriteIdsRequest awiRqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        openTxns.forEach(t -> awiRqst.addToTxnIds(t.longValue()));
        this.client.allocate_table_write_ids(awiRqst);
        return true;
    }

    boolean getValidWriteIds(List<String> fullTableNames) throws TException {
        this.client.get_valid_write_ids(new GetValidWriteIdsRequest(fullTableNames));
        return true;
    }

    LockResponse lock(@NotNull LockRequest rqst) throws TException {
        return this.client.lock(rqst);
    }

    List<Long> openTxn(int howMany) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr("", howMany, null);
        return txns.getTxn_ids();
    }

    private TTransport open(Configuration conf, @NotNull URI uri) throws TException, IOException, LoginException {
        boolean useSSL = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_SSL);
        boolean useSasl = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_SASL);
        boolean useFramedTransport = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
        boolean useCompactProtocol = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        int clientSocketTimeout = (int)MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        int connectionTimeout = (int)MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_CONNECTION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.debug("Connecting to {}, framedTransport = {}", (Object)uri, (Object)useFramedTransport);
        String host = uri.getHost();
        int port = uri.getPort();
        if (!useSSL) {
            this.transport = new TSocket(new TConfiguration(), host, port, clientSocketTimeout, connectionTimeout);
        } else {
            String trustStorePath = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH).trim();
            if (trustStorePath.isEmpty()) {
                throw new IllegalArgumentException(MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH.toString() + " Not configured for SSL connection");
            }
            String trustStorePassword = MetastoreConf.getPassword((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PASSWORD);
            String trustStoreType = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTSTORE_TYPE).trim();
            String trustStoreAlgorithm = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTMANAGERFACTORY_ALGORITHM).trim();
            this.transport = SecurityUtils.getSSLSocket((String)host, (int)port, (int)clientSocketTimeout, (int)connectionTimeout, (String)trustStorePath, (String)trustStorePassword, (String)trustStoreType, (String)trustStoreAlgorithm);
            LOG.info("Opened an SSL connection to metastore, current connections");
        }
        if (useSasl) {
            HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClient();
            String tokenSig = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TOKEN_SIGNATURE);
            String tokenStrForm = SecurityUtils.getTokenStrForm((String)tokenSig);
            if (tokenStrForm != null) {
                LOG.info("HMSC::open(): Found delegation token. Creating DIGEST-based thrift connection.");
                this.transport = authBridge.createClientTransport(null, host, "DIGEST", tokenStrForm, this.transport, MetaStoreUtils.getMetaStoreSaslProperties((Configuration)conf, (boolean)useSSL));
            } else {
                LOG.info("HMSC::open(): Could not find delegation token. Creating KERBEROS-based thrift connection.");
                String principalConfig = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.KERBEROS_PRINCIPAL);
                this.transport = authBridge.createClientTransport(principalConfig, host, "KERBEROS", null, this.transport, MetaStoreUtils.getMetaStoreSaslProperties((Configuration)conf, (boolean)useSSL));
            }
        } else if (useFramedTransport) {
            this.transport = new TFramedTransport(this.transport);
        }
        Object protocol = useCompactProtocol ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
        this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
        if (!this.transport.isOpen()) {
            this.transport.open();
            LOG.info("Opened a connection to metastore, current connections");
            if (!useSasl && MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI)) {
                try {
                    UserGroupInformation ugi = SecurityUtils.getUGI();
                    this.client.set_ugi(ugi.getUserName(), Arrays.asList(ugi.getGroupNames()));
                }
                catch (LoginException e) {
                    LOG.warn("Failed to do login. set_ugi() is not successful, Continuing without it.", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn("Failed to find ugi of client set_ugi() is not successful, Continuing without it.", (Throwable)e);
                }
                catch (TException e) {
                    LOG.warn("set_ugi() not successful, Likely cause: new client talking to old server. Continuing without it.", (Throwable)e);
                }
            }
        }
        LOG.debug("Connected to metastore, using compact protocol = {}", (Object)useCompactProtocol);
        return this.transport;
    }

    private OpenTxnsResponse openTxnsIntr(String user, int numTxns, TxnType txnType) throws TException {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        OpenTxnRequest rqst = new OpenTxnRequest(numTxns, user, hostname);
        if (txnType != null) {
            rqst.setTxn_type(txnType);
        }
        return this.client.open_txns(rqst);
    }

    @Override
    public void close() throws Exception {
        if (this.transport != null && this.transport.isOpen()) {
            LOG.debug("Closing thrift transport");
            this.transport.close();
        }
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    private /* synthetic */ TTransport lambda$getClient$0(Configuration conf) throws Exception {
        return this.open(conf, this.serverURI);
    }
}

