/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.utils.ByteUtils;

public class DescribeLogDirsRequestData
implements ApiMessage {
    private List<DescribableLogDirTopic> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DescribeLogDirsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeLogDirsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DescribeLogDirsRequestData() {
        this.topics = new ArrayList<DescribableLogDirTopic>();
    }

    @Override
    public short apiKey() {
        return 35;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            ArrayList<DescribableLogDirTopic> newCollection = new ArrayList<DescribableLogDirTopic>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribableLogDirTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.topics == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topics.size());
            for (DescribableLogDirTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("topics");
        if (_nestedObjects == null) {
            this.topics = null;
        } else {
            this.topics = new ArrayList<DescribableLogDirTopic>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new DescribableLogDirTopic((Struct)nestedObject, _version));
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (DescribableLogDirTopic element : this.topics) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (this.topics == null) {
            _size += 4;
        } else {
            int _arraySize = 0;
            _arraySize += 4;
            for (DescribableLogDirTopic topicsElement : this.topics) {
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeLogDirsRequestData)) {
            return false;
        }
        DescribeLogDirsRequestData other = (DescribeLogDirsRequestData)obj;
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeLogDirsRequestData(topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ")";
    }

    public List<DescribableLogDirTopic> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeLogDirsRequestData setTopics(List<DescribableLogDirTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", ArrayOf.nullable(DescribableLogDirTopic.SCHEMA_0), "Each topic that we want to describe log directories for, or null for all topics."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DescribableLogDirTopic
    implements Message {
        private String topic;
        private List<Integer> partitionIndex;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribableLogDirTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribableLogDirTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DescribableLogDirTopic() {
            this.topic = "";
            this.partitionIndex = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribableLogDirTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndex was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndex = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribableLogDirTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitionIndex.size());
            _stringBytes = this.partitionIndex.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribableLogDirTopic");
            }
            this._unknownTaggedFields = null;
            this.topic = struct.getString("topic");
            Object[] _nestedObjects = struct.getArray("partition_index");
            this.partitionIndex = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionIndex.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribableLogDirTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic", (Object)this.topic);
            Integer[] _nestedObjects = new Integer[this.partitionIndex.size()];
            int i = 0;
            for (Integer element : this.partitionIndex) {
                _nestedObjects[i++] = element;
            }
            struct.set("partition_index", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribableLogDirTopic");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            _size += (_arraySize += this.partitionIndex.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribableLogDirTopic)) {
                return false;
            }
            DescribableLogDirTopic other = (DescribableLogDirTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return !(this.partitionIndex == null ? other.partitionIndex != null : !this.partitionIndex.equals(other.partitionIndex));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndex == null ? 0 : this.partitionIndex.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribableLogDirTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionIndex=" + MessageUtil.deepToString(this.partitionIndex.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribableLogDirTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public DescribableLogDirTopic setPartitionIndex(List<Integer> v) {
            this.partitionIndex = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name"), new Field("partition_index", new ArrayOf(Type.INT32), "The partition indxes."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

