/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesque.common.protocol.ApiMessage;
import org.apache.kafkaesqueesque.common.protocol.Message;
import org.apache.kafkaesqueesque.common.protocol.MessageUtil;
import org.apache.kafkaesqueesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesqueesque.common.protocol.Readable;
import org.apache.kafkaesqueesque.common.protocol.Writable;
import org.apache.kafkaesqueesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesqueesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesque.common.utils.ByteUtils;

public class WriteTxnMarkersResponseData
implements ApiMessage {
    private List<WritableTxnMarkerResult> markers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("markers", new ArrayOf(WritableTxnMarkerResult.SCHEMA_0), "The results for writing makers."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public WriteTxnMarkersResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public WriteTxnMarkersResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public WriteTxnMarkersResponseData() {
        this.markers = new ArrayList<WritableTxnMarkerResult>();
    }

    @Override
    public short apiKey() {
        return 27;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field markers was serialized as null");
        }
        ArrayList<WritableTxnMarkerResult> newCollection = new ArrayList<WritableTxnMarkerResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new WritableTxnMarkerResult(_readable, _version));
        }
        this.markers = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.markers.size());
        for (WritableTxnMarkerResult markersElement : this.markers) {
            markersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("markers");
        this.markers = new ArrayList<WritableTxnMarkerResult>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.markers.add(new WritableTxnMarkerResult((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.markers.size()];
        int i = 0;
        for (WritableTxnMarkerResult element : this.markers) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("markers", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (WritableTxnMarkerResult markersElement : this.markers) {
            _arraySize += markersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WriteTxnMarkersResponseData)) {
            return false;
        }
        WriteTxnMarkersResponseData other = (WriteTxnMarkersResponseData)obj;
        return !(this.markers == null ? other.markers != null : !this.markers.equals(other.markers));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.markers == null ? 0 : this.markers.hashCode());
        return hashCode;
    }

    public String toString() {
        return "WriteTxnMarkersResponseData(markers=" + MessageUtil.deepToString(this.markers.iterator()) + ")";
    }

    public List<WritableTxnMarkerResult> markers() {
        return this.markers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public WriteTxnMarkersResponseData setMarkers(List<WritableTxnMarkerResult> v) {
        this.markers = v;
        return this;
    }

    public static class WritableTxnMarkerPartitionResult
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public WritableTxnMarkerPartitionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public WritableTxnMarkerPartitionResult(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public WritableTxnMarkerPartitionResult() {
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerPartitionResult");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerPartitionResult");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerPartitionResult");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerPartitionResult");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of WritableTxnMarkerPartitionResult");
            }
            _size += 4;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerPartitionResult)) {
                return false;
            }
            WritableTxnMarkerPartitionResult other = (WritableTxnMarkerPartitionResult)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "WritableTxnMarkerPartitionResult(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public WritableTxnMarkerPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public WritableTxnMarkerPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }
    }

    public static class WritableTxnMarkerTopicResult
    implements Message {
        private String name;
        private List<WritableTxnMarkerPartitionResult> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(WritableTxnMarkerPartitionResult.SCHEMA_0), "The results by partition."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public WritableTxnMarkerTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public WritableTxnMarkerTopicResult(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public WritableTxnMarkerTopicResult() {
            this.name = "";
            this.partitions = new ArrayList<WritableTxnMarkerPartitionResult>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerTopicResult");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<WritableTxnMarkerPartitionResult> newCollection = new ArrayList<WritableTxnMarkerPartitionResult>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new WritableTxnMarkerPartitionResult(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerTopicResult");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                WritableTxnMarkerPartitionResult partitionsElement = (WritableTxnMarkerPartitionResult)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerTopicResult");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<WritableTxnMarkerPartitionResult>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new WritableTxnMarkerPartitionResult((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerTopicResult");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (WritableTxnMarkerPartitionResult element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of WritableTxnMarkerTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (WritableTxnMarkerPartitionResult partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerTopicResult)) {
                return false;
            }
            WritableTxnMarkerTopicResult other = (WritableTxnMarkerTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "WritableTxnMarkerTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<WritableTxnMarkerPartitionResult> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public WritableTxnMarkerTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public WritableTxnMarkerTopicResult setPartitions(List<WritableTxnMarkerPartitionResult> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class WritableTxnMarkerResult
    implements Message {
        private long producerId;
        private List<WritableTxnMarkerTopicResult> topics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("producer_id", Type.INT64, "The current producer ID in use by the transactional ID."), new Field("topics", new ArrayOf(WritableTxnMarkerTopicResult.SCHEMA_0), "The results by topic."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public WritableTxnMarkerResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public WritableTxnMarkerResult(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public WritableTxnMarkerResult() {
            this.producerId = 0L;
            this.topics = new ArrayList<WritableTxnMarkerTopicResult>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerResult");
            }
            this.producerId = _readable.readLong();
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            ArrayList<WritableTxnMarkerTopicResult> newCollection = new ArrayList<WritableTxnMarkerTopicResult>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new WritableTxnMarkerTopicResult(_readable, _version));
            }
            this.topics = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerResult");
            }
            int _numTaggedFields = 0;
            _writable.writeLong(this.producerId);
            _writable.writeInt(this.topics.size());
            for (WritableTxnMarkerTopicResult topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerResult");
            }
            this._unknownTaggedFields = null;
            this.producerId = struct.getLong("producer_id");
            Object[] _nestedObjects = struct.getArray("topics");
            this.topics = new ArrayList<WritableTxnMarkerTopicResult>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new WritableTxnMarkerTopicResult((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerResult");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("producer_id", (Object)this.producerId);
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (WritableTxnMarkerTopicResult element : this.topics) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of WritableTxnMarkerResult");
            }
            _size += 8;
            int _arraySize = 0;
            _arraySize += 4;
            for (WritableTxnMarkerTopicResult topicsElement : this.topics) {
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerResult)) {
                return false;
            }
            WritableTxnMarkerResult other = (WritableTxnMarkerResult)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        public String toString() {
            return "WritableTxnMarkerResult(producerId=" + this.producerId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public List<WritableTxnMarkerTopicResult> topics() {
            return this.topics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public WritableTxnMarkerResult setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public WritableTxnMarkerResult setTopics(List<WritableTxnMarkerTopicResult> v) {
            this.topics = v;
            return this;
        }
    }
}

