/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColumnVector
extends ColumnVector {
    public HiveDecimalWritable[] vector;
    public short scale;
    public short precision;

    public DecimalColumnVector(int precision, int scale) {
        this(1024, precision, scale);
    }

    public DecimalColumnVector(int size, int precision, int scale) {
        super(size);
        this.precision = (short)precision;
        this.scale = (short)scale;
        this.vector = new HiveDecimalWritable[size];
        for (int i = 0; i < size; ++i) {
            this.vector[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
    }

    public void fill(HiveDecimal value) {
        this.noNulls = true;
        this.isRepeating = true;
        if (this.vector[0] == null) {
            this.vector[0] = new HiveDecimalWritable(value);
        } else {
            this.vector[0].set(value);
        }
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            HiveDecimal hiveDec = ((DecimalColumnVector)inputVector).vector[inputElementNum].getHiveDecimal(this.precision, this.scale);
            if (hiveDec == null) {
                this.isNull[outElementNum] = true;
                this.noNulls = false;
            } else {
                this.isNull[outElementNum] = false;
                this.vector[outElementNum].set(hiveDec);
            }
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append(this.vector[row].toString());
        } else {
            buffer.append("null");
        }
    }

    public void set(int elementNum, HiveDecimalWritable writeable) {
        if (writeable == null) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            HiveDecimal hiveDec = writeable.getHiveDecimal(this.precision, this.scale);
            if (hiveDec == null) {
                this.noNulls = false;
                this.isNull[elementNum] = true;
            } else {
                this.vector[elementNum].set(hiveDec);
            }
        }
    }

    public void set(int elementNum, HiveDecimal hiveDec) {
        HiveDecimal checkedDec = HiveDecimal.enforcePrecisionScale(hiveDec, (int)this.precision, (int)this.scale);
        if (checkedDec == null) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            this.vector[elementNum].set(checkedDec);
        }
    }

    public void setNullDataValue(int elementNum) {
        HiveDecimal minimumNonZeroValue = HiveDecimal.create(BigInteger.ONE, this.scale);
        this.vector[elementNum].set(minimumNonZeroValue);
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (size <= this.vector.length) {
            return;
        }
        HiveDecimalWritable[] oldArray = this.vector;
        this.vector = new HiveDecimalWritable[size];
        int initPos = 0;
        if (preserveData) {
            initPos = oldArray.length;
            System.arraycopy(oldArray, 0, this.vector, 0, oldArray.length);
        }
        for (int i = initPos; i < this.vector.length; ++i) {
            this.vector[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
    }
}

