/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ReadyToCleanAbortHandler
implements QueryHandler<List<CompactionInfo>> {
    private static final String SELECT_ABORTS_WITH_MIN_OPEN_WRITETXN_QUERY = " \"res1\".\"TC_DATABASE\" AS \"DB\", \"res1\".\"TC_TABLE\" AS \"TBL\", \"res1\".\"TC_PARTITION\" AS \"PART\",  \"res1\".\"MIN_TXN_START_TIME\" AS \"MIN_TXN_START_TIME\", \"res1\".\"ABORTED_TXN_COUNT\" AS \"ABORTED_TXN_COUNT\",  \"res2\".\"MIN_OPEN_WRITE_TXNID\" AS \"MIN_OPEN_WRITE_TXNID\", \"res3\".\"RETRY_RETENTION\" AS \"RETRY_RETENTION\",  \"res3\".\"ID\" AS \"RETRY_CQ_ID\"  FROM  ( SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", MIN(\"TXN_STARTED\") AS \"MIN_TXN_START_TIME\",  COUNT(*) AS \"ABORTED_TXN_COUNT\" FROM \"TXNS\", \"TXN_COMPONENTS\"  WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = :abortedState GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" %s ) \"res1\"  LEFT JOIN( SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", MIN(\"TC_TXNID\") AS \"MIN_OPEN_WRITE_TXNID\"  FROM \"TXNS\", \"TXN_COMPONENTS\"  WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = :openState GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" ) \"res2\" ON \"res1\".\"TC_DATABASE\" = \"res2\".\"TC_DATABASE\" AND \"res1\".\"TC_TABLE\" = \"res2\".\"TC_TABLE\" AND (\"res1\".\"TC_PARTITION\" = \"res2\".\"TC_PARTITION\"  OR (\"res1\".\"TC_PARTITION\" IS NULL AND \"res2\".\"TC_PARTITION\" IS NULL))  LEFT JOIN ( SELECT \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", MAX(\"CQ_ID\") AS \"ID\",  MAX(\"CQ_RETRY_RETENTION\") AS \"RETRY_RETENTION\",  MIN(\"CQ_COMMIT_TIME\") - %s + MAX(\"CQ_RETRY_RETENTION\") AS \"RETRY_RECORD_CHECK\" FROM \"COMPACTION_QUEUE\"  WHERE \"CQ_TYPE\" = :type GROUP BY \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\") \"res3\"  ON \"res1\".\"TC_DATABASE\" = \"res3\".\"CQ_DATABASE\"  AND \"res1\".\"TC_TABLE\" = \"res3\".\"CQ_TABLE\"  AND (\"res1\".\"TC_PARTITION\" = \"res3\".\"CQ_PARTITION\"  OR (\"res1\".\"TC_PARTITION\" IS NULL AND \"res3\".\"CQ_PARTITION\" IS NULL)) WHERE \"res3\".\"RETRY_RECORD_CHECK\" <= 0 OR \"res3\".\"RETRY_RECORD_CHECK\" IS NULL";
    private final long abortedTimeThreshold;
    private final int abortedThreshold;
    private final int fetchSize;

    @Override
    public String getParameterizedQueryString(DatabaseProduct dbProduct) throws MetaException {
        return dbProduct.addLimitClause(this.fetchSize, String.format(SELECT_ABORTS_WITH_MIN_OPEN_WRITETXN_QUERY, this.abortedTimeThreshold >= 0L ? "" : " HAVING COUNT(*) > " + this.abortedThreshold, TxnUtils.getEpochFn(dbProduct)));
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("abortedState", (Object)TxnStatus.ABORTED.getSqlConst(), 1).addValue("openState", (Object)TxnStatus.OPEN.getSqlConst(), 1).addValue("type", (Object)Character.toString('c'), 1);
    }

    public List<CompactionInfo> extractData(ResultSet rs) throws DataAccessException, SQLException {
        boolean checkAbortedTimeThreshold;
        ArrayList<CompactionInfo> readyToCleanAborts = new ArrayList<CompactionInfo>();
        long systemTime = System.currentTimeMillis();
        boolean bl = checkAbortedTimeThreshold = this.abortedTimeThreshold >= 0L;
        while (rs.next()) {
            boolean pastTimeThreshold = checkAbortedTimeThreshold && rs.getLong("MIN_TXN_START_TIME") + this.abortedTimeThreshold < systemTime;
            int numAbortedTxns = rs.getInt("ABORTED_TXN_COUNT");
            if (numAbortedTxns <= this.abortedThreshold && !pastTimeThreshold) continue;
            CompactionInfo info = new CompactionInfo();
            info.dbname = rs.getString("DB");
            info.tableName = rs.getString("TBL");
            info.partName = rs.getString("PART");
            long value = rs.getLong("MIN_OPEN_WRITE_TXNID");
            info.minOpenWriteTxnId = !rs.wasNull() ? value : Long.MAX_VALUE;
            info.type = CompactionType.ABORT_TXN_CLEANUP;
            info.state = (char)114;
            info.retryRetention = rs.getLong("RETRY_RETENTION");
            info.id = rs.getLong("RETRY_CQ_ID");
            readyToCleanAborts.add(info);
        }
        return readyToCleanAborts;
    }

    public ReadyToCleanAbortHandler(Configuration conf, long abortedTimeThreshold, int abortedThreshold) {
        this.abortedTimeThreshold = abortedTimeThreshold;
        this.abortedThreshold = abortedThreshold;
        this.fetchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FETCH_SIZE);
    }
}

