/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.util.Collection;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;

class MetaToolTaskExecuteJDOQLQuery
extends MetaToolTask {
    MetaToolTaskExecuteJDOQLQuery() {
    }

    @Override
    void execute() {
        String query = this.getCl().getJDOQLQuery();
        if (query.toLowerCase().trim().startsWith("select")) {
            try {
                this.executeJDOQLSelect(query);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (query.toLowerCase().trim().startsWith("update")) {
            try {
                this.executeJDOQLUpdate(query);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("HiveMetaTool:Unsupported statement type, only select and update supported");
        }
    }

    private void executeJDOQLSelect(String query) throws Exception {
        System.out.println("Executing query: " + query);
        Collection<?> result = this.getObjectStore().executeJDOQLSelect(query);
        if (result != null) {
            for (Object o : result) {
                System.out.println(o.toString());
            }
        } else {
            System.err.println("Encountered error during executeJDOQLSelect");
        }
    }

    private void executeJDOQLUpdate(String query) throws Exception {
        System.out.println("Executing query: " + query);
        long numUpdated = this.getObjectStore().executeJDOQLUpdate(query);
        if (numUpdated >= 0L) {
            System.out.println("Number of records updated: " + numUpdated);
        } else {
            System.err.println("Encountered error during executeJDOQL - commit of JDO transaction failed.");
        }
    }
}

