/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.LeaderElectionContext;
import org.apache.hadoop.hive.metastore.leader.LeaseLeaderElection;
import org.apache.hadoop.hive.metastore.leader.StaticLeaderElection;

public class LeaderElectionFactory {
    private static final Map<Method, ElectionCreator> ELECTION_CREATOR_MAP = new ConcurrentHashMap<Method, ElectionCreator>();

    private LeaderElectionFactory() {
        throw new AssertionError((Object)"The constructor shouldn't be called");
    }

    public static LeaderElection create(Configuration conf) throws IOException {
        String method = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_ELECTION);
        Method m = (Method)EnumUtils.getEnum(Method.class, (String)method.toUpperCase());
        ElectionCreator creator = null;
        if (m != null) {
            creator = ELECTION_CREATOR_MAP.get((Object)m);
        }
        if (creator == null) {
            throw new UnsupportedOperationException(method + " not supported for electing the leader");
        }
        return creator.createElector(conf);
    }

    public static Object getMutex(Configuration conf, LeaderElectionContext.TTYPE ttype, String servHost) {
        String method = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_ELECTION);
        Method m = (Method)EnumUtils.getEnum(Method.class, (String)method.toUpperCase());
        if (m != null) {
            switch (m.ordinal()) {
                case 0: {
                    return servHost;
                }
                case 1: {
                    TableName mutex = ttype.getTableName();
                    String namespace = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_LOCK_NAMESPACE);
                    if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                        return new TableName(mutex.getCat(), namespace, mutex.getTable());
                    }
                    return mutex;
                }
            }
        }
        throw new UnsupportedOperationException(method + " not supported for leader election");
    }

    @VisibleForTesting
    public static void addElectionCreator(Method method, ElectionCreator creator) {
        ELECTION_CREATOR_MAP.put(method, creator);
    }

    static {
        LeaderElectionFactory.addElectionCreator(Method.HOST, conf -> new StaticLeaderElection());
        LeaderElectionFactory.addElectionCreator(Method.LOCK, conf -> new LeaseLeaderElection());
    }

    public static enum Method {
        HOST,
        LOCK;

    }

    public static interface ElectionCreator {
        public LeaderElection createElector(Configuration var1) throws IOException;
    }
}

