/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanColumnStatsMerger
extends ColumnStatsMerger<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        BooleanColumnStatsData aggregateData = aggregateColStats.getStatsData().getBooleanStats();
        BooleanColumnStatsData newData = newColStats.getStatsData().getBooleanStats();
        aggregateData.setNumTrues(aggregateData.getNumTrues() + newData.getNumTrues());
        aggregateData.setNumFalses(aggregateData.getNumFalses() + newData.getNumFalses());
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
    }
}

