/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.cache.ByteArrayWrapper;
import org.apache.hadoop.hive.metastore.cache.CacheUtils;
import org.apache.hadoop.hive.metastore.cache.CachedStore;
import org.apache.hadoop.hive.metastore.cache.TableCacheObjects;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCache {
    private static ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private static final long MAX_DEFAULT_CACHE_SIZE = 0x100000L;
    private boolean isCatalogCachePrewarmed = false;
    private Map<String, Catalog> catalogCache = new TreeMap<String, Catalog>();
    private HashSet<String> catalogsDeletedDuringPrewarm = new HashSet();
    private AtomicBoolean isCatalogCacheDirty = new AtomicBoolean(false);
    private Map<String, Database> databaseCache = new TreeMap<String, Database>();
    private boolean isDatabaseCachePrewarmed = false;
    private HashSet<String> databasesDeletedDuringPrewarm = new HashSet();
    private AtomicBoolean isDatabaseCacheDirty = new AtomicBoolean(false);
    private Cache<String, TableWrapper> tableCache = null;
    private int concurrencyLevel = -1;
    private int refreshInterval = 10000;
    private boolean isTableCachePrewarmed = false;
    private HashSet<String> tablesDeletedDuringPrewarm = new HashSet();
    private AtomicBoolean isTableCacheDirty = new AtomicBoolean(false);
    private Map<ByteArrayWrapper, StorageDescriptorWrapper> sdCache = new HashMap<ByteArrayWrapper, StorageDescriptorWrapper>();
    private static MessageDigest md;
    private static final Logger LOG;
    private AtomicLong cacheUpdateCount = new AtomicLong(0L);
    private long maxCacheSizeInBytes = -1L;
    private HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> sizeEstimators = null;
    private Set<String> tableToUpdateSize = new ConcurrentHashSet();
    private ScheduledExecutorService executor = null;
    private Map<String, Integer> tableSizeMap = null;

    public void setConcurrencyLevel(int cl) {
        this.concurrencyLevel = cl;
    }

    public void setRefreshInterval(int interval) {
        this.refreshInterval = interval;
    }

    public void setTableSizeMap(Map<String, Integer> map) {
        this.tableSizeMap = map;
    }

    public void initialize(Configuration conf) {
        this.maxCacheSizeInBytes = MetastoreConf.getSizeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY);
        if (this.maxCacheSizeInBytes > 0L && this.sizeEstimators == null) {
            this.sizeEstimators = IncrementalObjectSizeEstimator.createEstimators(SharedCache.class);
        }
        if (this.tableCache == null) {
            CacheBuilder b = CacheBuilder.newBuilder().maximumWeight(this.maxCacheSizeInBytes > 0L ? this.maxCacheSizeInBytes : 0x100000L).weigher((Weigher)new Weigher<String, TableWrapper>(this){

                public int weigh(String key, TableWrapper value) {
                    return value.getSize();
                }
            }).removalListener((RemovalListener)new RemovalListener<String, TableWrapper>(){

                public void onRemoval(RemovalNotification<String, TableWrapper> notification) {
                    byte[] sdHash;
                    LOG.debug("Eviction happened for table " + (String)notification.getKey());
                    LOG.debug("current table cache contains " + SharedCache.this.tableCache.size() + "entries");
                    TableWrapper tblWrapper = (TableWrapper)notification.getValue();
                    RemovalCause cause = notification.getCause();
                    if ((cause.equals((Object)RemovalCause.COLLECTED) || cause.equals((Object)RemovalCause.EXPIRED)) && (sdHash = tblWrapper.getSdHash()) != null) {
                        SharedCache.this.decrSd(sdHash);
                    }
                }
            });
            if (this.concurrencyLevel > 0) {
                b.concurrencyLevel(this.concurrencyLevel);
            }
            this.tableCache = b.recordStats().build();
        }
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("SharedCache table size updater: Thread-" + t.getId());
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleAtFixedRate(new TableWrapperSizeUpdater(this.tableToUpdateSize, this.tableCache), 0L, this.refreshInterval, TimeUnit.MILLISECONDS);
    }

    private IncrementalObjectSizeEstimator.ObjectEstimator getMemorySizeEstimator(Class<?> clazz) {
        if (this.sizeEstimators == null) {
            return null;
        }
        IncrementalObjectSizeEstimator.ObjectEstimator estimator = this.sizeEstimators.get(clazz);
        if (estimator == null) {
            IncrementalObjectSizeEstimator.createEstimators(clazz, this.sizeEstimators);
            estimator = this.sizeEstimators.get(clazz);
        }
        return estimator;
    }

    public int getObjectSize(Class<?> clazz, Object obj) {
        if (this.sizeEstimators == null) {
            return 0;
        }
        try {
            IncrementalObjectSizeEstimator.ObjectEstimator oe = this.getMemorySizeEstimator(clazz);
            return oe.estimate(obj, this.sizeEstimators);
        }
        catch (Exception e) {
            LOG.error("Error while getting object size.", (Throwable)e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCatalogsInCache(Collection<Catalog> catalogs) {
        for (Catalog cat : catalogs) {
            Catalog catCopy = cat.deepCopy();
            catCopy.setName(catCopy.getName().toLowerCase());
            try {
                cacheLock.writeLock().lock();
                if (this.catalogsDeletedDuringPrewarm.contains(catCopy.getName())) continue;
                this.catalogCache.putIfAbsent(catCopy.getName(), catCopy);
                this.catalogsDeletedDuringPrewarm.clear();
                this.isCatalogCachePrewarmed = true;
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
    }

    public Catalog getCatalogFromCache(String name) {
        Catalog cat = null;
        try {
            cacheLock.readLock().lock();
            if (this.catalogCache.get(name) != null) {
                cat = this.catalogCache.get(name).deepCopy();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return cat;
    }

    public void addCatalogToCache(Catalog cat) {
        try {
            cacheLock.writeLock().lock();
            Catalog catCopy = cat.deepCopy();
            catCopy.setName(catCopy.getName().toLowerCase());
            this.catalogCache.put(cat.getName(), catCopy);
            this.isCatalogCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public void alterCatalogInCache(String catName, Catalog newCat) {
        try {
            cacheLock.writeLock().lock();
            this.removeCatalogFromCache(catName);
            this.addCatalogToCache(newCat.deepCopy());
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public void removeCatalogFromCache(String name) {
        name = StringUtils.normalizeIdentifier((String)name);
        try {
            cacheLock.writeLock().lock();
            if (!this.isCatalogCachePrewarmed) {
                this.catalogsDeletedDuringPrewarm.add(name);
            }
            if (this.catalogCache.remove(name) != null) {
                this.isCatalogCacheDirty.set(true);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public List<String> listCachedCatalogs() {
        try {
            cacheLock.readLock().lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.catalogCache.keySet());
            return arrayList;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    public boolean isCatalogCachePrewarmed() {
        return this.isCatalogCachePrewarmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabaseFromCache(String catName, String name) {
        Database db = null;
        try {
            cacheLock.readLock().lock();
            String key = CacheUtils.buildDbKey(catName, name);
            if (this.databaseCache.get(key) != null) {
                db = this.databaseCache.get(key).deepCopy();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateDatabasesInCache(List<Database> databases) {
        for (Database db : databases) {
            Database dbCopy = db.deepCopy();
            dbCopy.setName(dbCopy.getName().toLowerCase());
            try {
                cacheLock.writeLock().lock();
                String key = CacheUtils.buildDbKey(dbCopy.getCatalogName().toLowerCase(), dbCopy.getName().toLowerCase());
                if (this.databasesDeletedDuringPrewarm.contains(key)) continue;
                this.databaseCache.putIfAbsent(key, dbCopy);
                this.databasesDeletedDuringPrewarm.clear();
                this.isDatabaseCachePrewarmed = true;
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
    }

    public boolean isDatabaseCachePrewarmed() {
        return this.isDatabaseCachePrewarmed;
    }

    public void addDatabaseToCache(Database db) {
        try {
            cacheLock.writeLock().lock();
            Database dbCopy = db.deepCopy();
            dbCopy.setName(dbCopy.getName().toLowerCase());
            dbCopy.setCatalogName(dbCopy.getCatalogName().toLowerCase());
            this.databaseCache.put(CacheUtils.buildDbKey(dbCopy.getCatalogName(), dbCopy.getName()), dbCopy);
            this.isDatabaseCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabaseFromCache(String catName, String dbName) {
        try {
            cacheLock.writeLock().lock();
            String key = CacheUtils.buildDbKey(catName, dbName);
            if (!this.isDatabaseCachePrewarmed) {
                this.databasesDeletedDuringPrewarm.add(key);
            }
            if (this.databaseCache.remove(key) != null) {
                this.isDatabaseCacheDirty.set(true);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedDatabases(String catName) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (String pair : this.databaseCache.keySet()) {
                String[] n = CacheUtils.splitDbName(pair);
                if (!catName.equals(n[0])) continue;
                results.add(n[1]);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedDatabases(String catName, String pattern) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (String pair : this.databaseCache.keySet()) {
                String[] n = CacheUtils.splitDbName(pair);
                if (!catName.equals(n[0])) continue;
                n[1] = StringUtils.normalizeIdentifier((String)n[1]);
                if (!CacheUtils.matches(n[1], pattern)) continue;
                results.add(n[1]);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterDatabaseInCache(String catName, String dbName, Database newDb) {
        try {
            cacheLock.writeLock().lock();
            this.removeDatabaseFromCache(catName, dbName);
            this.addDatabaseToCache(newDb.deepCopy());
            this.isDatabaseCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshDatabasesInCache(List<Database> databases) {
        if (this.isDatabaseCacheDirty.compareAndSet(true, false)) {
            LOG.debug("Skipping database cache update; the database list we have is dirty.");
            return false;
        }
        try {
            cacheLock.writeLock().lock();
            this.databaseCache.clear();
            for (Database db : databases) {
                this.addDatabaseToCache(db);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public int getCachedDatabaseCount() {
        try {
            cacheLock.readLock().lock();
            int n = this.databaseCache.size();
            return n;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateTableInCache(Table table, TableCacheObjects cacheObjects) {
        String catName = StringUtils.normalizeIdentifier((String)table.getCatName());
        String dbName = StringUtils.normalizeIdentifier((String)table.getDbName());
        String tableName = StringUtils.normalizeIdentifier((String)table.getTableName());
        SQLAllTableConstraints constraints = cacheObjects.getTableConstraints();
        if (this.tablesDeletedDuringPrewarm.contains(CacheUtils.buildTableKey(catName, dbName, tableName))) {
            return false;
        }
        TableWrapper tblWrapper = this.createTableWrapper(catName, dbName, tableName, table);
        if (!table.isSetPartitionKeys() && cacheObjects.getTableColStats() != null) {
            if (table.getPartitionKeys().isEmpty() && cacheObjects.getTableColStats() != null) {
                return false;
            }
        } else {
            if (cacheObjects.getPartitions() != null && !tblWrapper.cachePartitions(cacheObjects.getPartitions(), this, true)) {
                return false;
            }
            if (cacheObjects.getPartitionColStats() != null) {
                for (ColumnStatistics cs : cacheObjects.getPartitionColStats()) {
                    try {
                        List colStats;
                        AbstractList partVal = Warehouse.makeValsFromName((String)cs.getStatsDesc().getPartName(), null);
                        if (tblWrapper.updatePartitionColStats(partVal, colStats = cs.getStatsObj())) continue;
                        return false;
                    }
                    catch (MetaException e) {
                        LOG.debug("Unable to cache partition column stats for table: " + tableName, (Throwable)e);
                    }
                }
            }
            tblWrapper.cacheAggrPartitionColStats(cacheObjects.getAggrStatsAllPartitions(), cacheObjects.getAggrStatsAllButDefaultPartition());
        }
        tblWrapper.setMemberCacheUpdated(MemberName.PARTITION_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.TABLE_COL_STATS_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.PARTITION_COL_STATS_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.AGGR_COL_STATS_CACHE, false);
        if (!tblWrapper.cacheConstraints(constraints, true)) {
            return false;
        }
        tblWrapper.setMemberCacheUpdated(MemberName.PRIMARY_KEY_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.FOREIGN_KEY_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.NOTNULL_CONSTRAINT_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.UNIQUE_CONSTRAINT_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.DEFAULT_CONSTRAINT_CACHE, false);
        tblWrapper.setMemberCacheUpdated(MemberName.CHECK_CONSTRAINT_CACHE, false);
        try {
            cacheLock.writeLock().lock();
            this.tableCache.put((Object)CacheUtils.buildTableKey(catName, dbName, tableName), (Object)tblWrapper);
            boolean bl = true;
            return bl;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public void completeTableCachePrewarm() {
        try {
            cacheLock.writeLock().lock();
            this.tablesDeletedDuringPrewarm.clear();
            this.isTableCachePrewarmed = true;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableFromCache(String catName, String dbName, String tableName) {
        Table t = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                t = CacheUtils.assemble(tblWrapper, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableWrapper addTableToCache(String catName, String dbName, String tblName, Table tbl) {
        try {
            cacheLock.writeLock().lock();
            TableWrapper wrapper = this.createTableWrapper(catName, dbName, tblName, tbl);
            this.tableCache.put((Object)CacheUtils.buildTableKey(catName, dbName, tblName), (Object)wrapper);
            this.isTableCacheDirty.set(true);
            TableWrapper tableWrapper = wrapper;
            return tableWrapper;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private TableWrapper createTableWrapper(String catName, String dbName, String tblName, Table tbl) {
        TableWrapper wrapper;
        Table tblCopy = tbl.deepCopy();
        tblCopy.setCatName(StringUtils.normalizeIdentifier((String)catName));
        tblCopy.setDbName(StringUtils.normalizeIdentifier((String)dbName));
        tblCopy.setTableName(StringUtils.normalizeIdentifier((String)tblName));
        if (tblCopy.getPartitionKeys() != null) {
            for (FieldSchema fs : tblCopy.getPartitionKeys()) {
                fs.setName(StringUtils.normalizeIdentifier((String)fs.getName()));
            }
        }
        if (tbl.getSd() != null) {
            byte[] sdHash = MetaStoreServerUtils.hashStorageDescriptor(tbl.getSd(), md);
            StorageDescriptor sd = tbl.getSd();
            this.increSd(sd, sdHash);
            tblCopy.setSd(null);
            wrapper = new TableWrapper(tblCopy, sdHash, sd.getLocation(), sd.getParameters());
        } else {
            wrapper = new TableWrapper(tblCopy, null, null, null);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableFromCache(String catName, String dbName, String tblName) {
        try {
            String tblKey;
            TableWrapper tblWrapper;
            cacheLock.writeLock().lock();
            if (!this.isTableCachePrewarmed) {
                this.tablesDeletedDuringPrewarm.add(CacheUtils.buildTableKey(catName, dbName, tblName));
            }
            if ((tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)(tblKey = CacheUtils.buildTableKey(catName, dbName, tblName)))) == null) {
                return;
            }
            byte[] sdHash = tblWrapper.getSdHash();
            if (sdHash != null) {
                this.decrSd(sdHash);
            }
            this.tableCache.invalidate((Object)tblKey);
            this.isTableCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTableInCache(String catName, String dbName, String tblName, Table newTable) {
        try {
            cacheLock.writeLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.updateTableObj(newTable, this);
                this.tableCache.put((Object)CacheUtils.buildTableKey(catName, newTable.getDbName(), newTable.getTableName()), (Object)tblWrapper);
                this.isTableCacheDirty.set(true);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTableAndStatsInCache(String catName, String dbName, String tblName, long writeId, List<ColumnStatisticsObj> colStatsObjs, Map<String, String> newParams) {
        try {
            cacheLock.writeLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper == null) {
                LOG.info("Table " + tblName + " is missing from cache. Cannot update table stats in cache");
                return;
            }
            Table newTable = tblWrapper.getTable();
            newTable.setWriteId(writeId);
            newTable.setParameters(newParams);
            String newDbName = StringUtils.normalizeIdentifier((String)newTable.getDbName());
            String newTblName = StringUtils.normalizeIdentifier((String)newTable.getTableName());
            tblWrapper.updateTableColStats(colStatsObjs);
            this.tableCache.put((Object)CacheUtils.buildTableKey(catName, newDbName, newTblName), (Object)tblWrapper);
            this.isTableCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Table> listCachedTables(String catName, String dbName) {
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            cacheLock.readLock().lock();
            for (TableWrapper wrapper : this.tableCache.asMap().values()) {
                if (!wrapper.sameDatabase(catName, dbName)) continue;
                tables.add(CacheUtils.assemble(wrapper, this));
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedTableNames(String catName, String dbName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (TableWrapper wrapper : this.tableCache.asMap().values()) {
                if (!wrapper.sameDatabase(catName, dbName)) continue;
                tableNames.add(StringUtils.normalizeIdentifier((String)wrapper.getTable().getTableName()));
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedTableNames(String catName, String dbName, String pattern, int maxTables) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            int count = 0;
            for (TableWrapper wrapper : this.tableCache.asMap().values()) {
                if (!wrapper.sameDatabase(catName, dbName) || !CacheUtils.matches(wrapper.getTable().getTableName(), pattern) || maxTables != -1 && count >= maxTables) continue;
                tableNames.add(StringUtils.normalizeIdentifier((String)wrapper.getTable().getTableName()));
                ++count;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedTableNames(String catName, String dbName, String pattern, TableType tableType, int limit) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            int count = 0;
            for (TableWrapper wrapper : this.tableCache.asMap().values()) {
                if (!wrapper.sameDatabase(catName, dbName) || !CacheUtils.matches(wrapper.getTable().getTableName(), pattern) || !wrapper.getTable().getTableType().equals(tableType.toString()) || limit != -1 && count >= limit) continue;
                tableNames.add(StringUtils.normalizeIdentifier((String)wrapper.getTable().getTableName()));
                ++count;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshTablesInCache(String catName, String dbName, List<Table> tables) {
        if (this.isTableCacheDirty.compareAndSet(true, false)) {
            LOG.debug("Skipping table cache update; the table list we have is dirty.");
            return false;
        }
        TreeMap<String, TableWrapper> newCacheForDB = new TreeMap<String, TableWrapper>();
        for (Table tbl : tables) {
            String tblName = StringUtils.normalizeIdentifier((String)tbl.getTableName());
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.updateTableObj(tbl, this);
            } else {
                tblWrapper = this.createTableWrapper(catName, dbName, tblName, tbl);
            }
            newCacheForDB.put(CacheUtils.buildTableKey(catName, dbName, tblName), tblWrapper);
        }
        try {
            cacheLock.writeLock().lock();
            Iterator entryIterator = this.tableCache.asMap().entrySet().iterator();
            while (entryIterator.hasNext()) {
                String key = (String)entryIterator.next().getKey();
                if (!key.startsWith(CacheUtils.buildDbKeyWithDelimiterSuffix(catName, dbName))) continue;
                entryIterator.remove();
            }
            this.tableCache.putAll(newCacheForDB);
            boolean bl = true;
            return bl;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnStatistics getTableColStatsFromCache(String catName, String dbName, String tblName, List<String> colNames, String validWriteIds, boolean areTxnStatsSupported) throws MetaException {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper == null) {
                LOG.info("Table " + tblName + " is missing from cache.");
                ColumnStatistics columnStatistics = null;
                return columnStatistics;
            }
            ColumnStatisticsDesc csd = new ColumnStatisticsDesc(true, dbName, tblName);
            ColumnStatistics columnStatistics = tblWrapper.getCachedTableColStats(csd, colNames, validWriteIds, areTxnStatsSupported);
            return columnStatistics;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableColStatsFromCache(String catName, String dbName, String tblName, String colName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removeTableColStats(colName);
            } else {
                LOG.info("Table " + tblName + " is missing from cache.");
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTableColStatsFromCache(String catName, String dbName, String tblName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removeAllTableColStats();
            } else {
                LOG.info("Table " + tblName + " is missing from cache.");
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableColStatsInCache(String catName, String dbName, String tableName, List<ColumnStatisticsObj> colStatsForTable) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                tblWrapper.updateTableColStats(colStatsForTable);
            } else {
                LOG.info("Table " + tableName + " is missing from cache.");
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTableColStatsInCache(String catName, String dbName, String tableName, List<ColumnStatisticsObj> colStatsForTable) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                tblWrapper.refreshTableColStats(colStatsForTable);
            } else {
                LOG.info("Table " + tableName + " is missing from cache.");
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    public int getCachedTableCount() {
        try {
            cacheLock.readLock().lock();
            int n = this.tableCache.asMap().size();
            return n;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableMeta> getTableMeta(String catName, String dbNames, String tableNames, List<String> tableTypes) {
        ArrayList<TableMeta> tableMetas = new ArrayList<TableMeta>();
        try {
            cacheLock.readLock().lock();
            for (String dbName : this.listCachedDatabases(catName)) {
                if (!CacheUtils.matches(dbName, dbNames)) continue;
                for (Table table : this.listCachedTables(catName, dbName)) {
                    if (!CacheUtils.matches(table.getTableName(), tableNames) || tableTypes != null && !tableTypes.contains(table.getTableType())) continue;
                    TableMeta metaData = new TableMeta(dbName, table.getTableName(), table.getTableType());
                    metaData.setCatName(catName);
                    metaData.setComments((String)table.getParameters().get("comment"));
                    tableMetas.add(metaData);
                }
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableMetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionToCache(String catName, String dbName, String tblName, Partition part) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null) {
                tblWrapper.cachePartition(part, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimaryKeysToCache(String catName, String dbName, String tblName, List<SQLPrimaryKey> keys) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addForeignKeysToCache(String catName, String dbName, String tblName, List<SQLForeignKey> keys) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUniqueConstraintsToCache(String catName, String dbName, String tblName, List<SQLUniqueConstraint> keys) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotNullConstraintsToCache(String catName, String dbName, String tblName, List<SQLNotNullConstraint> keys) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultConstraintsToCache(String catName, String dbName, String tblName, List<SQLDefaultConstraint> keys) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraintsToCache(String catName, String dbName, String tblName, List<SQLCheckConstraint> keys) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableConstraintsToCache(String catName, String dbName, String tblName, SQLAllTableConstraints constraints) {
        try {
            cacheLock.readLock().lock();
            String tblKey = CacheUtils.buildTableKey(catName, dbName, tblName);
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)tblKey);
            if (tblWrapper != null) {
                tblWrapper.cacheConstraints(constraints, false);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionsToCache(String catName, String dbName, String tblName, Iterable<Partition> parts) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.cachePartitions(parts, this, false);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partition getPartitionFromCache(String catName, String dbName, String tblName, List<String> partVals) {
        Partition part = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                part = tblWrapper.getPartition(partVals, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existPartitionFromCache(String catName, String dbName, String tblName, List<String> partVals) {
        boolean existsPart = false;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                existsPart = tblWrapper.containsPartition(partVals);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return existsPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstraintFromCache(String catName, String dbName, String tblName, String constraintName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                tblWrapper.invalidateConstraintsCache();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partition removePartitionFromCache(String catName, String dbName, String tblName, List<String> partVals) {
        Partition part = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                part = tblWrapper.removePartition(partVals, this);
            } else {
                LOG.warn("This is abnormal");
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionsFromCache(String catName, String dbName, String tblName, List<List<String>> partVals) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removePartitions(partVals, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> listCachedPartitions(String catName, String dbName, String tblName, int max) {
        ArrayList<Partition> parts = new ArrayList();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                parts = tblWrapper.listPartitions(max, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLPrimaryKey> listCachedPrimaryKeys(String catName, String dbName, String tblName) {
        List<SQLPrimaryKey> keys = new ArrayList<SQLPrimaryKey>();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                keys = tblWrapper.getPrimaryKeys();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLAllTableConstraints listCachedAllTableConstraints(String catName, String dbName, String tblName) {
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                constraints = tblWrapper.getAllTableConstraints();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLForeignKey> listCachedForeignKeys(String catName, String foreignDbName, String foreignTblName, String parentDbName, String parentTblName) {
        ArrayList<SQLForeignKey> keys = new ArrayList();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, foreignDbName, foreignTblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                keys = tblWrapper.getForeignKeys();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        if (!StringUtils.isEmpty((CharSequence)parentTblName) && !StringUtils.isEmpty((CharSequence)parentDbName)) {
            return keys.stream().filter(key -> parentDbName.equalsIgnoreCase(key.getPktable_db()) && parentTblName.equalsIgnoreCase(key.getPktable_name())).collect(Collectors.toList());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLUniqueConstraint> listCachedUniqueConstraint(String catName, String dbName, String tblName) {
        List<SQLUniqueConstraint> keys = new ArrayList<SQLUniqueConstraint>();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                keys = tblWrapper.getUniqueConstraints();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLDefaultConstraint> listCachedDefaultConstraint(String catName, String dbName, String tblName) {
        List<SQLDefaultConstraint> keys = new ArrayList<SQLDefaultConstraint>();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                keys = tblWrapper.getDefaultConstraints();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLCheckConstraint> listCachedCheckConstraint(String catName, String dbName, String tblName) {
        List<SQLCheckConstraint> keys = new ArrayList<SQLCheckConstraint>();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                keys = tblWrapper.getCheckConstraints();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLNotNullConstraint> listCachedNotNullConstraints(String catName, String dbName, String tblName) {
        List<SQLNotNullConstraint> keys = new ArrayList<SQLNotNullConstraint>();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null && tblWrapper.isConstraintsValid()) {
                keys = tblWrapper.getNotNullConstraints();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableConstraintValid(String catName, String dbName, String tblName) {
        boolean isValid = false;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                isValid = tblWrapper.isConstraintsValid();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllTableConstraintsInCache(String catName, String dbName, String tblName, SQLAllTableConstraints constraints) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshAllTableConstraints(constraints);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPartitionInCache(String catName, String dbName, String tblName, List<String> partVals, Partition newPart) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.alterPartition(partVals, newPart, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPartitionAndStatsInCache(String catName, String dbName, String tblName, long writeId, List<String> partVals, Map<String, String> parameters, List<ColumnStatisticsObj> colStatsObjs) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.alterPartitionAndStats(partVals, this, writeId, parameters, colStatsObjs);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPartitionsInCache(String catName, String dbName, String tblName, List<List<String>> partValsList, List<Partition> newParts) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.alterPartitions(partValsList, newParts, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPartitionsInCache(String catName, String dbName, String tblName, List<Partition> partitions) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshPartitions(partitions, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionColStatsFromCache(String catName, String dbName, String tblName, List<String> partVals, String colName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removePartitionColStats(partVals, colName);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPartitionColStatsFromCache(String catName, String dbName, String tblName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removeAllPartitionColStats();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePartitionColStatsInCache(String catName, String dbName, String tableName, List<String> partVals, List<ColumnStatisticsObj> colStatsObjs) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                tblWrapper.updatePartitionColStats(partVals, colStatsObjs);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumStatsWithWriteId getPartitionColStatsFromCache(String catName, String dbName, String tblName, List<String> partVal, String colName, String writeIdList) {
        ColumStatsWithWriteId colStatObj = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                colStatObj = tblWrapper.getPartitionColStats(partVal, colName, writeIdList);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return colStatObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnStatistics> getPartitionColStatsListFromCache(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, String writeIdList, boolean txnStatSupported) {
        List<ColumnStatistics> colStatObjs = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                colStatObjs = tblWrapper.getPartColStatsList(partNames, colNames, writeIdList, txnStatSupported);
            }
        }
        catch (MetaException e) {
            LOG.warn("Failed to get partition column statistics");
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return colStatObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPartitionColStatsInCache(String catName, String dbName, String tblName, List<ColumnStatistics> partitionColStats) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshPartitionColStats(partitionColStats);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnStatisticsObj> getAggrStatsFromCache(String catName, String dbName, String tblName, List<String> colNames, StatsType statsType) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                List<ColumnStatisticsObj> list = tblWrapper.getAggrPartitionColStats(colNames, statsType);
                return list;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAggregateStatsToCache(String catName, String dbName, String tblName, AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.cacheAggrPartitionColStats(aggrStatsAllPartitions, aggrStatsAllButDefaultPartition);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAggregateStatsInCache(String catName, String dbName, String tblName, AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition, Map<List<String>, Long> partNameToWriteId) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = (TableWrapper)this.tableCache.getIfPresent((Object)CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshAggrPartitionColStats(aggrStatsAllPartitions, aggrStatsAllButDefaultPartition, this, partNameToWriteId);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    public synchronized void increSd(StorageDescriptor sd, byte[] sdHash) {
        ByteArrayWrapper byteArray = new ByteArrayWrapper(sdHash);
        if (this.sdCache.containsKey(byteArray)) {
            ++this.sdCache.get((Object)byteArray).refCount;
        } else {
            StorageDescriptor sdToCache = sd.deepCopy();
            sdToCache.setLocation(null);
            sdToCache.setParameters(null);
            this.sdCache.put(byteArray, new StorageDescriptorWrapper(sdToCache, 1));
        }
    }

    public synchronized void decrSd(byte[] sdHash) {
        ByteArrayWrapper byteArray = new ByteArrayWrapper(sdHash);
        StorageDescriptorWrapper sdWrapper = this.sdCache.get(byteArray);
        --sdWrapper.refCount;
        if (sdWrapper.getRefCount() == 0) {
            this.sdCache.remove(byteArray);
        }
    }

    public synchronized StorageDescriptor getSdFromCache(byte[] sdHash) {
        StorageDescriptorWrapper sdWrapper = this.sdCache.get(new ByteArrayWrapper(sdHash));
        return sdWrapper.getSd();
    }

    @VisibleForTesting
    Map<String, Database> getDatabaseCache() {
        return this.databaseCache;
    }

    @VisibleForTesting
    void clearTableCache() {
        this.tableCache.invalidateAll();
    }

    @VisibleForTesting
    Map<ByteArrayWrapper, StorageDescriptorWrapper> getSdCache() {
        return this.sdCache;
    }

    void resetCatalogCache() {
        this.isCatalogCachePrewarmed = false;
        this.catalogCache.clear();
        this.catalogsDeletedDuringPrewarm.clear();
        this.isCatalogCacheDirty.set(false);
    }

    void clearDirtyFlags() {
        this.isCatalogCacheDirty.set(false);
        this.isDatabaseCacheDirty.set(false);
        this.isTableCacheDirty.set(false);
    }

    public void printCacheStats() {
        CacheStats cs = this.tableCache.stats();
        LOG.info(cs.toString());
    }

    public long getUpdateCount() {
        return this.cacheUpdateCount.get();
    }

    public void incrementUpdateCount() {
        this.cacheUpdateCount.incrementAndGet();
    }

    static {
        LOG = LoggerFactory.getLogger((String)SharedCache.class.getName());
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    static class TableWrapperSizeUpdater
    implements Runnable {
        private Set<String> setToUpdate;
        private Cache<String, TableWrapper> cache;

        TableWrapperSizeUpdater(Set<String> set, Cache<String, TableWrapper> cache1) {
            this.setToUpdate = set;
            this.cache = cache1;
        }

        @Override
        public void run() {
            for (String s : this.setToUpdate) {
                this.refreshTableWrapperInCache(s);
            }
            this.setToUpdate.clear();
        }

        void refreshTableWrapperInCache(String tblKey) {
            TableWrapper tw = (TableWrapper)this.cache.getIfPresent((Object)tblKey);
            if (tw != null) {
                this.cache.put((Object)tblKey, (Object)tw);
            }
        }
    }

    class TableWrapper {
        private Table t;
        private String location;
        private Map<String, String> parameters;
        private byte[] sdHash;
        private int otherSize;
        private int[] memberObjectsSize = new int[MemberName.values().length];
        private AtomicBoolean[] memberCacheUpdated = new AtomicBoolean[MemberName.values().length];
        private ReentrantReadWriteLock tableLock = new ReentrantReadWriteLock(true);
        private Map<String, ColumnStatisticsObj> tableColStatsCache = new ConcurrentHashMap<String, ColumnStatisticsObj>();
        private Map<String, PartitionWrapper> partitionCache = new ConcurrentHashMap<String, PartitionWrapper>();
        private Map<String, ColumnStatisticsObj> partitionColStatsCache = new ConcurrentHashMap<String, ColumnStatisticsObj>();
        private Map<String, List<ColumnStatisticsObj>> aggrColStatsCache = new ConcurrentHashMap<String, List<ColumnStatisticsObj>>();
        private Map<String, SQLPrimaryKey> primaryKeyCache = new ConcurrentHashMap<String, SQLPrimaryKey>();
        private Map<String, SQLForeignKey> foreignKeyCache = new ConcurrentHashMap<String, SQLForeignKey>();
        private Map<String, SQLNotNullConstraint> notNullConstraintCache = new ConcurrentHashMap<String, SQLNotNullConstraint>();
        private Map<String, SQLUniqueConstraint> uniqueConstraintCache = new ConcurrentHashMap<String, SQLUniqueConstraint>();
        private Map<String, SQLDefaultConstraint> defaultConstraintCache = new ConcurrentHashMap<String, SQLDefaultConstraint>();
        private Map<String, SQLCheckConstraint> checkConstraintCache = new ConcurrentHashMap<String, SQLCheckConstraint>();
        private boolean isConstraintsValid = false;

        TableWrapper(Table t, byte[] sdHash, String location, Map<String, String> parameters) {
            this.t = t;
            this.sdHash = sdHash;
            this.location = location;
            this.parameters = parameters;
            for (MemberName mn : MemberName.values()) {
                this.memberObjectsSize[mn.ordinal()] = 0;
                this.memberCacheUpdated[mn.ordinal()] = new AtomicBoolean(false);
            }
            this.otherSize = this.getTableWrapperSizeWithoutMaps();
        }

        public boolean isConstraintsValid() {
            return this.isConstraintsValid;
        }

        public void setConstraintsValid(boolean constraintsValid) {
            this.isConstraintsValid = constraintsValid;
        }

        public boolean compareAndSetMemberCacheUpdated(MemberName mn, boolean oldValue, boolean newValue) {
            return this.memberCacheUpdated[mn.ordinal()].compareAndSet(oldValue, newValue);
        }

        public void setMemberCacheUpdated(MemberName mn, boolean newValue) {
            this.memberCacheUpdated[mn.ordinal()].set(newValue);
        }

        private int getTableWrapperSizeWithoutMaps() {
            Class<TableWrapper> clazz = TableWrapper.class;
            Field[] fields = clazz.getDeclaredFields();
            int size = 0;
            for (Field field : fields) {
                if (field.getType().equals(ConcurrentHashMap.class) || field.getType().equals(SharedCache.class)) continue;
                try {
                    field.setAccessible(true);
                    Object val = field.get(this);
                    IncrementalObjectSizeEstimator.ObjectEstimator oe = SharedCache.this.getMemorySizeEstimator(field.getType());
                    if (oe == null) continue;
                    size += oe.estimate(val, SharedCache.this.sizeEstimators);
                }
                catch (Exception ex) {
                    LOG.error("Not able to estimate size.", (Throwable)ex);
                }
            }
            return size;
        }

        public int getSize() {
            String tblKey;
            if (SharedCache.this.tableSizeMap != null && SharedCache.this.tableSizeMap.containsKey(tblKey = CacheUtils.buildTableKey(this.t.getCatName(), this.t.getDbName(), this.t.getTableName()))) {
                return SharedCache.this.tableSizeMap.get(tblKey);
            }
            if (SharedCache.this.sizeEstimators == null) {
                return 0;
            }
            int membersSize = 0;
            for (MemberName mn : MemberName.values()) {
                membersSize += this.memberObjectsSize[mn.ordinal()];
            }
            return this.otherSize + membersSize;
        }

        public Table getTable() {
            return this.t;
        }

        public void setTable(Table t) {
            this.t = t;
        }

        public byte[] getSdHash() {
            return this.sdHash;
        }

        public void setSdHash(byte[] sdHash) {
            this.sdHash = sdHash;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        boolean sameDatabase(String catName, String dbName) {
            return catName.equals(this.t.getCatName()) && dbName.equals(this.t.getDbName());
        }

        private void updateMemberSize(MemberName mn, Integer size, SizeMode mode) {
            if (SharedCache.this.sizeEstimators == null) {
                return;
            }
            switch (mode.ordinal()) {
                case 0: {
                    int n = mn.ordinal();
                    this.memberObjectsSize[n] = this.memberObjectsSize[n] + size;
                    break;
                }
                case 1: {
                    this.memberObjectsSize[mn.ordinal()] = size;
                }
            }
            String tblKey = this.getTblKey();
            SharedCache.this.tableToUpdateSize.add(tblKey);
        }

        String getTblKey() {
            Table tbl = this.t;
            String catName = tbl.getCatName();
            String dbName = tbl.getDbName();
            String tblName = tbl.getTableName();
            return CacheUtils.buildTableKey(catName, dbName, tblName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cachePartition(Partition part, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                PartitionWrapper wrapper = this.makePartitionWrapper(part, sharedCache);
                this.partitionCache.put(CacheUtils.buildPartitionCacheKey(part.getValues()), wrapper);
                int size = SharedCache.this.getObjectSize(PartitionWrapper.class, wrapper);
                this.updateMemberSize(MemberName.PARTITION_CACHE, size, SizeMode.Delta);
                this.setMemberCacheUpdated(MemberName.PARTITION_CACHE, true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                    this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cachePartitions(Iterable<Partition> parts, SharedCache sharedCache, boolean fromPrewarm) {
            try {
                this.tableLock.writeLock().lock();
                int size = 0;
                for (Partition part : parts) {
                    PartitionWrapper wrapper = this.makePartitionWrapper(part, sharedCache);
                    this.partitionCache.put(CacheUtils.buildPartitionCacheKey(part.getValues()), wrapper);
                    size += SharedCache.this.getObjectSize(PartitionWrapper.class, wrapper);
                    if (fromPrewarm) continue;
                    this.setMemberCacheUpdated(MemberName.PARTITION_CACHE, true);
                }
                this.updateMemberSize(MemberName.PARTITION_CACHE, size, SizeMode.Delta);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                    this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cacheConstraints(SQLAllTableConstraints constraints, boolean fromPrewarm) {
            try {
                this.tableLock.writeLock().lock();
                this.isConstraintsValid = this.cacheConstraints(constraints.getPrimaryKeys(), fromPrewarm, MemberName.PRIMARY_KEY_CACHE) && this.cacheConstraints(constraints.getForeignKeys(), fromPrewarm, MemberName.FOREIGN_KEY_CACHE) && this.cacheConstraints(constraints.getDefaultConstraints(), fromPrewarm, MemberName.DEFAULT_CONSTRAINT_CACHE) && this.cacheConstraints(constraints.getUniqueConstraints(), fromPrewarm, MemberName.UNIQUE_CONSTRAINT_CACHE) && this.cacheConstraints(constraints.getNotNullConstraints(), fromPrewarm, MemberName.NOTNULL_CONSTRAINT_CACHE) && this.cacheConstraints(constraints.getCheckConstraints(), fromPrewarm, MemberName.CHECK_CONSTRAINT_CACHE);
                SharedCache.this.tableToUpdateSize.add(this.getTblKey());
                boolean bl = this.isConstraintsValid;
                return bl;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cacheConstraints(List constraintsList, boolean fromPrewarm, MemberName mn) {
            if (CollectionUtils.isEmpty((Collection)constraintsList)) {
                return true;
            }
            try {
                this.tableLock.writeLock().lock();
                int totalSize = constraintsList.stream().mapToInt(constraint -> {
                    int size = 0;
                    switch (mn.ordinal()) {
                        case 4: {
                            SQLPrimaryKey pk = (SQLPrimaryKey)constraint;
                            String pkName = StringUtils.normalizeIdentifier((String)pk.getPk_name());
                            this.primaryKeyCache.put(pkName, pk);
                            size = SharedCache.this.getObjectSize(SQLPrimaryKey.class, constraint);
                            break;
                        }
                        case 5: {
                            SQLForeignKey fk = (SQLForeignKey)constraint;
                            String fkName = StringUtils.normalizeIdentifier((String)fk.getFk_name());
                            this.foreignKeyCache.put(fkName, fk);
                            size = SharedCache.this.getObjectSize(SQLForeignKey.class, constraint);
                            break;
                        }
                        case 7: {
                            SQLUniqueConstraint uc = (SQLUniqueConstraint)constraint;
                            String ucName = StringUtils.normalizeIdentifier((String)uc.getUk_name());
                            this.uniqueConstraintCache.put(ucName, uc);
                            size = SharedCache.this.getObjectSize(SQLUniqueConstraint.class, constraint);
                            break;
                        }
                        case 6: {
                            SQLNotNullConstraint nn = (SQLNotNullConstraint)constraint;
                            String nnName = StringUtils.normalizeIdentifier((String)nn.getNn_name());
                            this.notNullConstraintCache.put(nnName, nn);
                            size = SharedCache.this.getObjectSize(SQLNotNullConstraint.class, constraint);
                            break;
                        }
                        case 8: {
                            SQLDefaultConstraint dc = (SQLDefaultConstraint)constraint;
                            String dcName = StringUtils.normalizeIdentifier((String)dc.getDc_name());
                            this.defaultConstraintCache.put(dcName, dc);
                            size = SharedCache.this.getObjectSize(SQLDefaultConstraint.class, constraint);
                            break;
                        }
                        case 9: {
                            SQLCheckConstraint cc = (SQLCheckConstraint)constraint;
                            String ccName = StringUtils.normalizeIdentifier((String)cc.getDc_name());
                            this.checkConstraintCache.put(ccName, cc);
                            size = SharedCache.this.getObjectSize(SQLCheckConstraint.class, constraint);
                            break;
                        }
                        default: {
                            LOG.error("Should not reach here");
                        }
                    }
                    return size;
                }).sum();
                if (!fromPrewarm) {
                    this.setMemberCacheUpdated(mn, true);
                }
                this.updateMemberSize(mn, totalSize, SizeMode.Snapshot);
                boolean bl = true;
                return bl;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        public void invalidateConstraintsCache() {
            try {
                this.tableLock.writeLock().lock();
                this.setConstraintsValid(false);
                SharedCache.this.tableToUpdateSize.add(this.getTblKey());
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        public List<SQLPrimaryKey> getPrimaryKeys() {
            try {
                this.tableLock.readLock().lock();
                ArrayList<SQLPrimaryKey> arrayList = new ArrayList<SQLPrimaryKey>(this.primaryKeyCache.values());
                return arrayList;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public SQLAllTableConstraints getAllTableConstraints() {
            try {
                this.tableLock.readLock().lock();
                SQLAllTableConstraints constraints = new SQLAllTableConstraints();
                if (this.isConstraintsValid) {
                    constraints.setPrimaryKeys(new ArrayList<SQLPrimaryKey>(this.primaryKeyCache.values()));
                    constraints.setForeignKeys(new ArrayList<SQLForeignKey>(this.foreignKeyCache.values()));
                    constraints.setNotNullConstraints(new ArrayList<SQLNotNullConstraint>(this.notNullConstraintCache.values()));
                    constraints.setUniqueConstraints(new ArrayList<SQLUniqueConstraint>(this.uniqueConstraintCache.values()));
                    constraints.setDefaultConstraints(new ArrayList<SQLDefaultConstraint>(this.defaultConstraintCache.values()));
                    constraints.setCheckConstraints(new ArrayList<SQLCheckConstraint>(this.checkConstraintCache.values()));
                }
                SQLAllTableConstraints sQLAllTableConstraints = constraints;
                return sQLAllTableConstraints;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public List<SQLForeignKey> getForeignKeys() {
            try {
                this.tableLock.readLock().lock();
                ArrayList<SQLForeignKey> arrayList = new ArrayList<SQLForeignKey>(this.foreignKeyCache.values());
                return arrayList;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public List<SQLUniqueConstraint> getUniqueConstraints() {
            try {
                this.tableLock.readLock().lock();
                ArrayList<SQLUniqueConstraint> arrayList = new ArrayList<SQLUniqueConstraint>(this.uniqueConstraintCache.values());
                return arrayList;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public List<SQLNotNullConstraint> getNotNullConstraints() {
            try {
                this.tableLock.readLock().lock();
                ArrayList<SQLNotNullConstraint> arrayList = new ArrayList<SQLNotNullConstraint>(this.notNullConstraintCache.values());
                return arrayList;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public List<SQLDefaultConstraint> getDefaultConstraints() {
            try {
                this.tableLock.readLock().lock();
                ArrayList<SQLDefaultConstraint> arrayList = new ArrayList<SQLDefaultConstraint>(this.defaultConstraintCache.values());
                return arrayList;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public List<SQLCheckConstraint> getCheckConstraints() {
            try {
                this.tableLock.readLock().lock();
                ArrayList<SQLCheckConstraint> arrayList = new ArrayList<SQLCheckConstraint>(this.checkConstraintCache.values());
                return arrayList;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Partition getPartition(List<String> partVals, SharedCache sharedCache) {
            Partition part = null;
            try {
                this.tableLock.readLock().lock();
                PartitionWrapper wrapper = this.partitionCache.get(CacheUtils.buildPartitionCacheKey(partVals));
                if (wrapper == null) {
                    LOG.debug("Partition: " + String.valueOf(partVals) + " is not present in the cache.");
                    Partition partition = null;
                    return partition;
                }
                part = CacheUtils.assemble(wrapper, sharedCache);
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Partition> listPartitions(int max, SharedCache sharedCache) {
            ArrayList<Partition> parts = new ArrayList<Partition>();
            int count = 0;
            try {
                this.tableLock.readLock().lock();
                for (PartitionWrapper wrapper : this.partitionCache.values()) {
                    if (max != -1 && count >= max) continue;
                    parts.add(CacheUtils.assemble(wrapper, sharedCache));
                    ++count;
                }
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return parts;
        }

        public boolean containsPartition(List<String> partVals) {
            boolean containsPart = false;
            try {
                this.tableLock.readLock().lock();
                containsPart = this.partitionCache.containsKey(CacheUtils.buildPartitionCacheKey(partVals));
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return containsPart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeConstraint(String name) {
            try {
                this.tableLock.writeLock().lock();
                SQLPrimaryKey constraint = null;
                MemberName mn = null;
                Class<SQLPrimaryKey> constraintClass = null;
                name = StringUtils.normalizeIdentifier((String)name);
                if (this.primaryKeyCache.containsKey(name)) {
                    constraint = this.primaryKeyCache.remove(name);
                    mn = MemberName.PRIMARY_KEY_CACHE;
                    constraintClass = SQLPrimaryKey.class;
                } else if (this.foreignKeyCache.containsKey(name)) {
                    constraint = this.foreignKeyCache.remove(name);
                    mn = MemberName.FOREIGN_KEY_CACHE;
                    constraintClass = SQLForeignKey.class;
                } else if (this.notNullConstraintCache.containsKey(name)) {
                    constraint = this.notNullConstraintCache.remove(name);
                    mn = MemberName.NOTNULL_CONSTRAINT_CACHE;
                    constraintClass = SQLNotNullConstraint.class;
                } else if (this.uniqueConstraintCache.containsKey(name)) {
                    constraint = this.uniqueConstraintCache.remove(name);
                    mn = MemberName.UNIQUE_CONSTRAINT_CACHE;
                    constraintClass = SQLUniqueConstraint.class;
                } else if (this.defaultConstraintCache.containsKey(name)) {
                    constraint = this.defaultConstraintCache.remove(name);
                    mn = MemberName.DEFAULT_CONSTRAINT_CACHE;
                    constraintClass = SQLDefaultConstraint.class;
                } else if (this.checkConstraintCache.containsKey(name)) {
                    constraint = this.checkConstraintCache.remove(name);
                    mn = MemberName.CHECK_CONSTRAINT_CACHE;
                    constraintClass = SQLCheckConstraint.class;
                }
                if (constraint == null) {
                    LOG.debug("Constraint: " + name + " does not exist in cache.");
                    return;
                }
                this.setMemberCacheUpdated(mn, true);
                int size = SharedCache.this.getObjectSize(constraintClass, constraint);
                this.updateMemberSize(mn, -1 * size, SizeMode.Delta);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        public void refreshAllTableConstraints(SQLAllTableConstraints constraints) {
            try {
                this.tableLock.writeLock().lock();
                this.isConstraintsValid = this.refreshConstraint(constraints.getPrimaryKeys(), MemberName.PRIMARY_KEY_CACHE) && this.refreshConstraint(constraints.getForeignKeys(), MemberName.FOREIGN_KEY_CACHE) && this.refreshConstraint(constraints.getUniqueConstraints(), MemberName.UNIQUE_CONSTRAINT_CACHE) && this.refreshConstraint(constraints.getDefaultConstraints(), MemberName.DEFAULT_CONSTRAINT_CACHE) && this.refreshConstraint(constraints.getNotNullConstraints(), MemberName.NOTNULL_CONSTRAINT_CACHE) && this.refreshConstraint(constraints.getCheckConstraints(), MemberName.CHECK_CONSTRAINT_CACHE);
                SharedCache.this.tableToUpdateSize.add(this.getTblKey());
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        private boolean refreshConstraint(List constraints, MemberName mn) {
            int size = 0;
            switch (mn.ordinal()) {
                case 4: {
                    ConcurrentHashMap<String, SQLPrimaryKey> newPk = new ConcurrentHashMap<String, SQLPrimaryKey>();
                    if (!CollectionUtils.isEmpty((Collection)constraints)) {
                        for (SQLPrimaryKey key : constraints) {
                            String pkName = StringUtils.normalizeIdentifier((String)key.getPk_name());
                            key.setPk_name(pkName);
                            newPk.put(pkName, key);
                            size += SharedCache.this.getObjectSize(SQLPrimaryKey.class, key);
                        }
                    }
                    this.primaryKeyCache = newPk;
                    break;
                }
                case 5: {
                    ConcurrentHashMap<String, SQLForeignKey> newFk = new ConcurrentHashMap<String, SQLForeignKey>();
                    if (!CollectionUtils.isEmpty((Collection)constraints)) {
                        for (SQLForeignKey key : constraints) {
                            String fkName = StringUtils.normalizeIdentifier((String)key.getFk_name());
                            key.setFk_name(fkName);
                            newFk.put(fkName, key);
                            size += SharedCache.this.getObjectSize(SQLForeignKey.class, key);
                        }
                    }
                    this.foreignKeyCache = newFk;
                    break;
                }
                case 7: {
                    ConcurrentHashMap<String, SQLUniqueConstraint> newUc = new ConcurrentHashMap<String, SQLUniqueConstraint>();
                    if (!CollectionUtils.isEmpty((Collection)constraints)) {
                        for (SQLUniqueConstraint constraint : constraints) {
                            String ucName = StringUtils.normalizeIdentifier((String)constraint.getUk_name());
                            constraint.setUk_name(ucName);
                            newUc.put(ucName, constraint);
                            size += SharedCache.this.getObjectSize(SQLUniqueConstraint.class, constraint);
                        }
                    }
                    this.uniqueConstraintCache = newUc;
                    break;
                }
                case 6: {
                    ConcurrentHashMap<String, SQLNotNullConstraint> newNn = new ConcurrentHashMap<String, SQLNotNullConstraint>();
                    if (!CollectionUtils.isEmpty((Collection)constraints)) {
                        for (SQLNotNullConstraint constraint : constraints) {
                            String nnName = StringUtils.normalizeIdentifier((String)constraint.getNn_name());
                            constraint.setNn_name(nnName);
                            newNn.put(nnName, constraint);
                            size += SharedCache.this.getObjectSize(SQLNotNullConstraint.class, constraint);
                        }
                    }
                    this.notNullConstraintCache = newNn;
                    break;
                }
                case 8: {
                    ConcurrentHashMap<String, SQLDefaultConstraint> newDc = new ConcurrentHashMap<String, SQLDefaultConstraint>();
                    if (!CollectionUtils.isEmpty((Collection)constraints)) {
                        for (SQLDefaultConstraint constraint : constraints) {
                            String dcName = StringUtils.normalizeIdentifier((String)constraint.getDc_name());
                            constraint.setDc_name(dcName);
                            newDc.put(dcName, constraint);
                            size += SharedCache.this.getObjectSize(SQLDefaultConstraint.class, constraint);
                        }
                    }
                    this.defaultConstraintCache = newDc;
                    break;
                }
                case 9: {
                    ConcurrentHashMap<String, SQLCheckConstraint> newCc = new ConcurrentHashMap<String, SQLCheckConstraint>();
                    if (!CollectionUtils.isEmpty((Collection)constraints)) {
                        for (SQLCheckConstraint constraint : constraints) {
                            String ccName = StringUtils.normalizeIdentifier((String)constraint.getDc_name());
                            constraint.setDc_name(ccName);
                            newCc.put(ccName, constraint);
                            size += SharedCache.this.getObjectSize(SQLCheckConstraint.class, constraint);
                        }
                    }
                    this.checkConstraintCache = newCc;
                    break;
                }
                default: {
                    LOG.error("Should not reach here");
                    return false;
                }
            }
            this.updateMemberSize(mn, size, SizeMode.Snapshot);
            LOG.debug("{}  refresh was successful for {}.{}.{}", new Object[]{mn, this.getTable().getCatName(), this.getTable().getDbName(), this.getTable().getTableName()});
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Partition removePartition(List<String> partVal, SharedCache sharedCache) {
            Partition part = null;
            try {
                this.tableLock.writeLock().lock();
                PartitionWrapper wrapper = this.partitionCache.remove(CacheUtils.buildPartitionCacheKey(partVal));
                if (wrapper == null) {
                    Partition partition = null;
                    return partition;
                }
                this.setMemberCacheUpdated(MemberName.PARTITION_CACHE, true);
                int size = SharedCache.this.getObjectSize(PartitionWrapper.class, wrapper);
                this.updateMemberSize(MemberName.PARTITION_CACHE, -1 * size, SizeMode.Delta);
                part = CacheUtils.assemble(wrapper, sharedCache);
                if (wrapper.getSdHash() != null) {
                    sharedCache.decrSd(wrapper.getSdHash());
                }
                String partialKey = CacheUtils.buildPartitionCacheKey(partVal);
                Iterator<Map.Entry<String, ColumnStatisticsObj>> iterator = this.partitionColStatsCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ColumnStatisticsObj> entry = iterator.next();
                    String key = entry.getKey();
                    if (!key.toLowerCase().startsWith(partialKey.toLowerCase())) continue;
                    int statsSize = SharedCache.this.getObjectSize(ColumnStatisticsObj.class, entry.getValue());
                    this.updateMemberSize(MemberName.PARTITION_COL_STATS_CACHE, -1 * statsSize, SizeMode.Delta);
                    iterator.remove();
                }
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                    this.updateMemberSize(MemberName.PARTITION_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePartitions(List<List<String>> partVals, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                for (List<String> partVal : partVals) {
                    this.removePartition(partVal, sharedCache);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alterPartition(List<String> partVals, Partition newPart, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                this.removePartition(partVals, sharedCache);
                this.cachePartition(newPart, sharedCache);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alterPartitionAndStats(List<String> partVals, SharedCache sharedCache, long writeId, Map<String, String> parameters, List<ColumnStatisticsObj> colStatsObjs) {
            try {
                this.tableLock.writeLock().lock();
                PartitionWrapper partitionWrapper = this.partitionCache.get(CacheUtils.buildPartitionCacheKey(partVals));
                if (partitionWrapper == null) {
                    LOG.info("Partition " + String.valueOf(partVals) + " is missing from cache. Cannot update the partition stats in cache.");
                    return;
                }
                Partition newPart = partitionWrapper.getPartition();
                newPart.setParameters(parameters);
                newPart.setWriteId(writeId);
                this.removePartition(partVals, sharedCache);
                this.cachePartition(newPart, sharedCache);
                this.updatePartitionColStats(partVals, colStatsObjs);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alterPartitions(List<List<String>> partValsList, List<Partition> newParts, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                for (int i = 0; i < partValsList.size(); ++i) {
                    List<String> partVals = partValsList.get(i);
                    Partition newPart = newParts.get(i);
                    this.alterPartition(partVals, newPart, sharedCache);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPartitions(List<Partition> partitions, SharedCache sharedCache) {
            HashMap<String, PartitionWrapper> newPartitionCache = new HashMap<String, PartitionWrapper>();
            try {
                this.tableLock.writeLock().lock();
                int size = 0;
                for (Partition part : partitions) {
                    if (this.compareAndSetMemberCacheUpdated(MemberName.PARTITION_CACHE, true, false)) {
                        LOG.debug("Skipping partition cache update for table: " + this.getTable().getTableName() + "; the partition list we have is dirty.");
                        return;
                    }
                    String key = CacheUtils.buildPartitionCacheKey(part.getValues());
                    PartitionWrapper wrapper = this.partitionCache.get(key);
                    if (wrapper != null && wrapper.getSdHash() != null) {
                        sharedCache.decrSd(wrapper.getSdHash());
                    }
                    wrapper = this.makePartitionWrapper(part, sharedCache);
                    newPartitionCache.put(key, wrapper);
                    size += SharedCache.this.getObjectSize(PartitionWrapper.class, wrapper);
                }
                this.partitionCache = newPartitionCache;
                this.updateMemberSize(MemberName.PARTITION_CACHE, size, SizeMode.Snapshot);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateTableColStats(List<ColumnStatisticsObj> colStatsForTable) {
            try {
                this.tableLock.writeLock().lock();
                int statsSize = 0;
                for (ColumnStatisticsObj colStatObj : colStatsForTable) {
                    String key = colStatObj.getColName();
                    ColumnStatisticsObj oldStatsObj = this.tableColStatsCache.get(key);
                    if (oldStatsObj != null) {
                        statsSize -= SharedCache.this.getObjectSize(ColumnStatisticsObj.class, oldStatsObj);
                        StatObjectConverter.setFieldsIntoOldStats(oldStatsObj, colStatObj);
                    } else {
                        this.tableColStatsCache.put(key, colStatObj.deepCopy());
                    }
                    statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, colStatObj);
                }
                this.updateMemberSize(MemberName.TABLE_COL_STATS_CACHE, statsSize, SizeMode.Delta);
                this.setMemberCacheUpdated(MemberName.TABLE_COL_STATS_CACHE, true);
                boolean bl = true;
                return bl;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshTableColStats(List<ColumnStatisticsObj> colStatsForTable) {
            HashMap<String, ColumnStatisticsObj> newTableColStatsCache = new HashMap<String, ColumnStatisticsObj>();
            try {
                this.tableLock.writeLock().lock();
                int statsSize = 0;
                for (ColumnStatisticsObj colStatObj : colStatsForTable) {
                    if (this.compareAndSetMemberCacheUpdated(MemberName.TABLE_COL_STATS_CACHE, true, false)) {
                        LOG.debug("Skipping table col stats cache update for table: " + this.getTable().getTableName() + "; the table col stats list we have is dirty.");
                        return;
                    }
                    String key = colStatObj.getColName();
                    newTableColStatsCache.put(key, colStatObj.deepCopy());
                    statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, colStatObj);
                }
                this.tableColStatsCache = newTableColStatsCache;
                this.updateMemberSize(MemberName.TABLE_COL_STATS_CACHE, statsSize, SizeMode.Snapshot);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColumnStatistics getCachedTableColStats(ColumnStatisticsDesc csd, List<String> colNames, String validWriteIds, boolean areTxnStatsSupported) throws MetaException {
            ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
            try {
                this.tableLock.readLock().lock();
                for (String colName : colNames) {
                    ColumnStatisticsObj colStatObj = this.tableColStatsCache.get(colName);
                    if (colStatObj == null) continue;
                    colStatObjs.add(colStatObj);
                }
                ColumnStatistics colStat = new ColumnStatistics(csd, colStatObjs);
                colStat.setEngine("hive");
                ColumnStatistics columnStatistics = CachedStore.adjustColStatForGet(this.getTable().getParameters(), colStat, this.getTable().getWriteId(), validWriteIds, areTxnStatsSupported);
                return columnStatistics;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        public void removeTableColStats(String colName) {
            try {
                this.tableLock.writeLock().lock();
                if (colName == null) {
                    this.tableColStatsCache.clear();
                    this.updateMemberSize(MemberName.TABLE_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                } else {
                    this.tableColStatsCache.remove(colName);
                    this.updateMemberSize(MemberName.TABLE_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
                this.setMemberCacheUpdated(MemberName.TABLE_COL_STATS_CACHE, true);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        public void removeAllTableColStats() {
            try {
                this.tableLock.writeLock().lock();
                this.tableColStatsCache.clear();
                this.updateMemberSize(MemberName.TABLE_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                this.setMemberCacheUpdated(MemberName.TABLE_COL_STATS_CACHE, true);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColumStatsWithWriteId getPartitionColStats(List<String> partVal, String colName, String writeIdList) {
            try {
                this.tableLock.readLock().lock();
                ColumnStatisticsObj statisticsObj = this.partitionColStatsCache.get(CacheUtils.buildPartitonColStatsCacheKey(partVal, colName));
                if (statisticsObj == null || writeIdList == null) {
                    ColumStatsWithWriteId columStatsWithWriteId = new ColumStatsWithWriteId(-1L, statisticsObj);
                    return columStatsWithWriteId;
                }
                PartitionWrapper wrapper = this.partitionCache.get(CacheUtils.buildPartitionCacheKey(partVal));
                if (wrapper == null) {
                    LOG.info("Partition: " + String.valueOf(partVal) + " is not present in the cache. Cannot update stats in cache.");
                    ColumStatsWithWriteId columStatsWithWriteId = null;
                    return columStatsWithWriteId;
                }
                long writeId = wrapper.getPartition().getWriteId();
                ValidReaderWriteIdList list4TheQuery = ValidReaderWriteIdList.fromValue((String)writeIdList);
                if (!list4TheQuery.isWriteIdValid(writeId)) {
                    LOG.debug("Write id list " + writeIdList + " is not compatible with write id " + writeId);
                    ColumStatsWithWriteId columStatsWithWriteId = null;
                    return columStatsWithWriteId;
                }
                ColumStatsWithWriteId columStatsWithWriteId = new ColumStatsWithWriteId(writeId, statisticsObj);
                return columStatsWithWriteId;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ColumnStatistics> getPartColStatsList(List<String> partNames, List<String> colNames, String writeIdList, boolean txnStatSupported) throws MetaException {
            ArrayList<ColumnStatistics> colStatObjs = new ArrayList<ColumnStatistics>();
            try {
                this.tableLock.readLock().lock();
                Table tbl = this.getTable();
                for (String partName : partNames) {
                    ColumnStatisticsDesc csd = new ColumnStatisticsDesc(false, tbl.getDbName(), tbl.getTableName());
                    csd.setCatName(tbl.getCatName());
                    csd.setPartName(partName);
                    csd.setLastAnalyzed(0L);
                    ArrayList<ColumnStatisticsObj> statObject = new ArrayList<ColumnStatisticsObj>();
                    List partVal = Warehouse.getPartValuesFromPartName((String)partName);
                    for (String colName : colNames) {
                        ColumnStatisticsObj statisticsObj = this.partitionColStatsCache.get(CacheUtils.buildPartitonColStatsCacheKey(partVal, colName));
                        if (statisticsObj == null) {
                            LOG.info("Stats not available in cachedStore for col " + colName + " in partition " + String.valueOf(partVal));
                            List<ColumnStatistics> list = null;
                            return list;
                        }
                        statObject.add(statisticsObj);
                    }
                    ColumnStatistics columnStatistics = new ColumnStatistics(csd, statObject);
                    columnStatistics.setEngine("hive");
                    if (writeIdList != null && TxnUtils.isTransactionalTable(this.getParameters())) {
                        columnStatistics.setIsStatsCompliant(true);
                        if (!txnStatSupported) {
                            columnStatistics.setIsStatsCompliant(false);
                        } else {
                            PartitionWrapper wrapper = this.partitionCache.get(CacheUtils.buildPartitionCacheKey(partVal));
                            if (wrapper == null) {
                                columnStatistics.setIsStatsCompliant(false);
                            } else {
                                Partition partition = wrapper.getPartition();
                                if (!ObjectStore.isCurrentStatsValidForTheQuery(partition.getParameters(), partition.getWriteId(), writeIdList, false)) {
                                    LOG.debug("The current cached store transactional partition column statistics for {}.{}.{} (write ID {}) are not valid for current query ({})", new Object[]{tbl.getDbName(), tbl.getTableName(), partName, partition.getWriteId(), writeIdList});
                                    columnStatistics.setIsStatsCompliant(false);
                                }
                            }
                        }
                    }
                    colStatObjs.add(columnStatistics);
                }
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return colStatObjs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updatePartitionColStats(List<String> partVal, List<ColumnStatisticsObj> colStatsObjs) {
            try {
                this.tableLock.writeLock().lock();
                int statsSize = 0;
                for (ColumnStatisticsObj colStatObj : colStatsObjs) {
                    String key = CacheUtils.buildPartitonColStatsCacheKey(partVal, colStatObj.getColName());
                    ColumnStatisticsObj oldStatsObj = this.partitionColStatsCache.get(key);
                    if (oldStatsObj != null) {
                        statsSize -= SharedCache.this.getObjectSize(ColumnStatisticsObj.class, oldStatsObj);
                        StatObjectConverter.setFieldsIntoOldStats(oldStatsObj, colStatObj);
                    } else {
                        this.partitionColStatsCache.put(key, colStatObj.deepCopy());
                    }
                    statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, colStatObj);
                }
                this.updateMemberSize(MemberName.PARTITION_COL_STATS_CACHE, statsSize, SizeMode.Delta);
                this.setMemberCacheUpdated(MemberName.PARTITION_COL_STATS_CACHE, true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                    this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePartitionColStats(List<String> partVals, String colName) {
            try {
                this.tableLock.writeLock().lock();
                ColumnStatisticsObj statsObj = this.partitionColStatsCache.remove(CacheUtils.buildPartitonColStatsCacheKey(partVals, colName));
                if (statsObj != null) {
                    int statsSize = SharedCache.this.getObjectSize(ColumnStatisticsObj.class, statsObj);
                    this.updateMemberSize(MemberName.PARTITION_COL_STATS_CACHE, -1 * statsSize, SizeMode.Delta);
                }
                this.setMemberCacheUpdated(MemberName.PARTITION_COL_STATS_CACHE, true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                    this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        public void removeAllPartitionColStats() {
            try {
                this.tableLock.writeLock().lock();
                this.partitionColStatsCache.clear();
                this.updateMemberSize(MemberName.PARTITION_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                this.setMemberCacheUpdated(MemberName.PARTITION_COL_STATS_CACHE, true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                    this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, 0, SizeMode.Snapshot);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void refreshPartitionColStats(List<ColumnStatistics> partitionColStats) {
            HashMap<String, ColumnStatisticsObj> newPartitionColStatsCache = new HashMap<String, ColumnStatisticsObj>();
            try {
                this.tableLock.writeLock().lock();
                String tableName = StringUtils.normalizeIdentifier((String)this.getTable().getTableName());
                int statsSize = 0;
                Iterator<ColumnStatistics> iterator = partitionColStats.iterator();
                block6: while (true) {
                    ColumnStatistics cs;
                    if (iterator.hasNext()) {
                        cs = iterator.next();
                        if (this.compareAndSetMemberCacheUpdated(MemberName.PARTITION_COL_STATS_CACHE, true, false)) {
                            LOG.debug("Skipping partition column stats cache update for table: " + this.getTable().getTableName() + "; the partition column stats list we have is dirty");
                            this.tableLock.writeLock().unlock();
                            return;
                        }
                    } else {
                        this.partitionColStatsCache = newPartitionColStatsCache;
                        this.updateMemberSize(MemberName.PARTITION_COL_STATS_CACHE, statsSize, SizeMode.Snapshot);
                        this.tableLock.writeLock().unlock();
                        return;
                    }
                    AbstractList partVal = Warehouse.makeValsFromName((String)cs.getStatsDesc().getPartName(), null);
                    List colStatsObjs = cs.getStatsObj();
                    Iterator iterator2 = colStatsObjs.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block6;
                        ColumnStatisticsObj colStatObj = (ColumnStatisticsObj)iterator2.next();
                        if (this.compareAndSetMemberCacheUpdated(MemberName.PARTITION_COL_STATS_CACHE, true, false)) {
                            LOG.debug("Skipping partition column stats cache update for table: " + this.getTable().getTableName() + "; the partition column list we have is dirty");
                            this.tableLock.writeLock().unlock();
                            return;
                        }
                        String key = CacheUtils.buildPartitonColStatsCacheKey(partVal, colStatObj.getColName());
                        newPartitionColStatsCache.put(key, colStatObj.deepCopy());
                        statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, colStatObj);
                        continue;
                        break;
                    }
                    catch (MetaException e) {
                        LOG.debug("Unable to cache partition column stats for table: " + tableName, (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.tableLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ColumnStatisticsObj> getAggrPartitionColStats(List<String> colNames, StatsType statsType) {
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
            try {
                this.tableLock.readLock().lock();
                for (String colName : colNames) {
                    List<ColumnStatisticsObj> colStatList = this.aggrColStatsCache.get(colName);
                    if (colStatList == null) {
                        List<ColumnStatisticsObj> list = null;
                        return list;
                    }
                    ColumnStatisticsObj colStatObj = colStatList.get(statsType.getPosition());
                    if (colStatObj == null) {
                        List<ColumnStatisticsObj> list = null;
                        return list;
                    }
                    colStats.add(colStatObj);
                }
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return colStats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cacheAggrPartitionColStats(AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
            try {
                List<Object> aggrStats;
                this.tableLock.writeLock().lock();
                int statsSize = 0;
                if (aggrStatsAllPartitions != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllPartitions.getColStats()) {
                        if (statObj == null) continue;
                        aggrStats = new ArrayList<ColumnStatisticsObj>();
                        aggrStats.add(StatsType.ALL.ordinal(), statObj.deepCopy());
                        this.aggrColStatsCache.put(statObj.getColName(), aggrStats);
                        statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, statObj);
                    }
                }
                if (aggrStatsAllButDefaultPartition != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllButDefaultPartition.getColStats()) {
                        if (statObj == null) continue;
                        aggrStats = this.aggrColStatsCache.get(statObj.getColName());
                        if (aggrStats == null) {
                            aggrStats = new ArrayList();
                        }
                        aggrStats.add(StatsType.ALLBUTDEFAULT.ordinal(), statObj.deepCopy());
                        statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, statObj);
                    }
                }
                this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, statsSize, SizeMode.Snapshot);
                this.setMemberCacheUpdated(MemberName.AGGR_COL_STATS_CACHE, true);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshAggrPartitionColStats(AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition, SharedCache sharedCache, Map<List<String>, Long> partNameToWriteId) {
            HashMap<String, List<ColumnStatisticsObj>> newAggrColStatsCache = new HashMap<String, List<ColumnStatisticsObj>>();
            try {
                List<ColumnStatisticsObj> aggrStats;
                this.tableLock.writeLock().lock();
                int statsSize = 0;
                if (partNameToWriteId != null) {
                    for (Map.Entry<List<String>, Long> partValuesWriteIdSet : partNameToWriteId.entrySet()) {
                        List<String> partValues = partValuesWriteIdSet.getKey();
                        Partition partition = this.getPartition(partValues, sharedCache);
                        if (partition == null) {
                            LOG.info("Could not refresh the aggregate stat as partition " + String.valueOf(partValues) + " does not exist");
                            return;
                        }
                        long writeId = partition.getWriteId();
                        if (writeId == partValuesWriteIdSet.getValue()) continue;
                        LOG.info("Could not refresh the aggregate stat as partition " + String.valueOf(partValues) + " has write id " + String.valueOf(partValuesWriteIdSet.getValue()) + " instead of " + writeId);
                        return;
                    }
                }
                if (aggrStatsAllPartitions != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllPartitions.getColStats()) {
                        if (this.compareAndSetMemberCacheUpdated(MemberName.AGGR_COL_STATS_CACHE, true, false)) {
                            LOG.debug("Skipping aggregate stats cache update for table: " + this.getTable().getTableName() + "; the aggregate stats list we have is dirty");
                            return;
                        }
                        if (statObj == null) continue;
                        aggrStats = new ArrayList<ColumnStatisticsObj>();
                        aggrStats.add(StatsType.ALL.ordinal(), statObj.deepCopy());
                        newAggrColStatsCache.put(statObj.getColName(), aggrStats);
                        statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, statObj);
                    }
                }
                if (aggrStatsAllButDefaultPartition != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllButDefaultPartition.getColStats()) {
                        if (this.compareAndSetMemberCacheUpdated(MemberName.AGGR_COL_STATS_CACHE, true, false)) {
                            LOG.debug("Skipping aggregate stats cache update for table: " + this.getTable().getTableName() + "; the aggregate stats list we have is dirty");
                            return;
                        }
                        if (statObj == null) continue;
                        aggrStats = (List)newAggrColStatsCache.get(statObj.getColName());
                        if (aggrStats == null) {
                            aggrStats = new ArrayList();
                        }
                        aggrStats.add(StatsType.ALLBUTDEFAULT.ordinal(), statObj.deepCopy());
                        statsSize += SharedCache.this.getObjectSize(ColumnStatisticsObj.class, statObj);
                    }
                }
                this.aggrColStatsCache = newAggrColStatsCache;
                this.updateMemberSize(MemberName.AGGR_COL_STATS_CACHE, statsSize, SizeMode.Snapshot);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        private void updateTableObj(Table newTable, SharedCache sharedCache) {
            Table tblCopy;
            byte[] sdHash = this.getSdHash();
            if (sdHash != null) {
                sharedCache.decrSd(sdHash);
            }
            if ((tblCopy = newTable.deepCopy()).getPartitionKeys() != null) {
                for (FieldSchema fs : tblCopy.getPartitionKeys()) {
                    fs.setName(StringUtils.normalizeIdentifier((String)fs.getName()));
                }
            }
            if (tblCopy.getSd() != null) {
                sdHash = MetaStoreServerUtils.hashStorageDescriptor(tblCopy.getSd(), md);
                StorageDescriptor sd = tblCopy.getSd();
                sharedCache.increSd(sd, sdHash);
                tblCopy.setSd(null);
                this.setSdHash(sdHash);
                this.setLocation(sd.getLocation());
                this.setParameters(sd.getParameters());
            } else {
                this.setSdHash(null);
                this.setLocation(null);
                this.setParameters(null);
            }
            tblCopy.setTableName(tblCopy.getTableName().toLowerCase());
            this.setTable(tblCopy);
        }

        private PartitionWrapper makePartitionWrapper(Partition part, SharedCache sharedCache) {
            PartitionWrapper wrapper;
            Partition partCopy = part.deepCopy();
            if (part.getSd() != null) {
                byte[] sdHash = MetaStoreServerUtils.hashStorageDescriptor(part.getSd(), md);
                StorageDescriptor sd = part.getSd();
                sharedCache.increSd(sd, sdHash);
                partCopy.setSd(null);
                wrapper = new PartitionWrapper(partCopy, sdHash, sd.getLocation(), sd.getParameters());
            } else {
                wrapper = new PartitionWrapper(partCopy, null, null, null);
            }
            return wrapper;
        }
    }

    private static enum MemberName {
        TABLE_COL_STATS_CACHE,
        PARTITION_CACHE,
        PARTITION_COL_STATS_CACHE,
        AGGR_COL_STATS_CACHE,
        PRIMARY_KEY_CACHE,
        FOREIGN_KEY_CACHE,
        NOTNULL_CONSTRAINT_CACHE,
        UNIQUE_CONSTRAINT_CACHE,
        DEFAULT_CONSTRAINT_CACHE,
        CHECK_CONSTRAINT_CACHE;

    }

    public static class ColumStatsWithWriteId {
        private long writeId;
        private ColumnStatisticsObj columnStatisticsObj;

        public ColumStatsWithWriteId(long writeId, ColumnStatisticsObj columnStatisticsObj) {
            this.writeId = writeId;
            this.columnStatisticsObj = columnStatisticsObj;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public ColumnStatisticsObj getColumnStatisticsObj() {
            return this.columnStatisticsObj;
        }
    }

    static enum StatsType {
        ALL(0),
        ALLBUTDEFAULT(1),
        PARTIAL(2);

        private final int position;

        private StatsType(int position) {
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }

    static class StorageDescriptorWrapper {
        private StorageDescriptor sd;
        private int refCount = 0;

        StorageDescriptorWrapper(StorageDescriptor sd, int refCount) {
            this.sd = sd;
            this.refCount = refCount;
        }

        public StorageDescriptor getSd() {
            return this.sd;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }

    static class PartitionWrapper {
        private Partition p;
        private String location;
        private Map<String, String> parameters;
        private byte[] sdHash;

        PartitionWrapper(Partition p, byte[] sdHash, String location, Map<String, String> parameters) {
            this.p = p;
            this.sdHash = sdHash;
            this.location = location;
            this.parameters = parameters;
        }

        public Partition getPartition() {
            return this.p;
        }

        public byte[] getSdHash() {
            return this.sdHash;
        }

        public String getLocation() {
            return this.location;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }

    static enum SizeMode {
        Delta,
        Snapshot;

    }
}

