/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import java.io.PrintWriter;
import java.util.Optional;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.service.auth.ldap.LdapAuthService;

public class LoginServlet
extends HttpServlet {
    public static final String LOGIN_FAILURE_MESSAGE = "login_failure_message";
    private final LdapAuthService ldapAuthService;

    public LoginServlet(LdapAuthService ldapAuthService) {
        this.ldapAuthService = ldapAuthService;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        boolean success = this.ldapAuthService.authenticate(request, response);
        PrintWriter out = null;
        try {
            RequestDispatcher dispatcher;
            out = response.getWriter();
            if (success) {
                dispatcher = request.getRequestDispatcher("/hiveserver2.jsp");
            } else {
                request.setAttribute(LOGIN_FAILURE_MESSAGE, (Object)"Invalid username or password");
                dispatcher = request.getRequestDispatcher("/loginForm.jsp");
            }
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            if (out == null) {
                return;
            }
            Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
            String servletName = Optional.ofNullable((String)request.getAttribute("javax.servlet.error.servlet_name")).orElse("Unknown");
            String requestUri = Optional.ofNullable((String)request.getAttribute("javax.servlet.error.request_uri")).orElse("Unknown");
            response.setContentType("text/html");
            out.write("<html><head><title>Exception/Error Details</title></head><body>");
            out.write("<h3>Error Details</h3>");
            out.write("<strong>Status Code</strong>:" + statusCode + "<br>");
            out.write("<ul><li>Servlet Name:" + servletName + "</li>");
            out.write("<li>Requested URI:" + requestUri + "</li>");
            out.write("<li>Exception Name:" + e.getClass().getName() + "</li>");
            out.write("<li>Exception Message:" + e.getMessage() + "</li>");
            out.write("</ul><br><br></body></html>");
        }
    }
}

