/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.io.OutputStream;
import java.sql.Timestamp;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.Text;

public class PrimitiveObjectInspectorConverter {

    public static class StringConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;

        public StringConverter(PrimitiveObjectInspector inputOI) {
            this.inputOI = inputOI;
        }

        @Override
        public Object convert(Object input) {
            return PrimitiveObjectInspectorUtils.getString(input, this.inputOI);
        }
    }

    public static class TextConverter
    implements ObjectInspectorConverters.Converter {
        private final PrimitiveObjectInspector inputOI;
        private final Text t = new Text();
        private final ByteStream.Output out = new ByteStream.Output();
        private static byte[] trueBytes = new byte[]{84, 82, 85, 69};
        private static byte[] falseBytes = new byte[]{70, 65, 76, 83, 69};

        public TextConverter(PrimitiveObjectInspector inputOI) {
            this.inputOI = inputOI;
        }

        public Text convert(Object input) {
            if (input == null) {
                return null;
            }
            switch (this.inputOI.getPrimitiveCategory()) {
                case VOID: {
                    return null;
                }
                case BOOLEAN: {
                    this.t.set(((BooleanObjectInspector)this.inputOI).get(input) ? trueBytes : falseBytes);
                    return this.t;
                }
                case BYTE: {
                    this.out.reset();
                    LazyInteger.writeUTF8NoException((OutputStream)((Object)this.out), ((ByteObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getCount());
                    return this.t;
                }
                case SHORT: {
                    this.out.reset();
                    LazyInteger.writeUTF8NoException((OutputStream)((Object)this.out), ((ShortObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getCount());
                    return this.t;
                }
                case INT: {
                    this.out.reset();
                    LazyInteger.writeUTF8NoException((OutputStream)((Object)this.out), ((IntObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getCount());
                    return this.t;
                }
                case LONG: {
                    this.out.reset();
                    LazyLong.writeUTF8NoException((OutputStream)((Object)this.out), ((LongObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getCount());
                    return this.t;
                }
                case FLOAT: {
                    this.t.set(String.valueOf(((FloatObjectInspector)this.inputOI).get(input)));
                    return this.t;
                }
                case DOUBLE: {
                    this.t.set(String.valueOf(((DoubleObjectInspector)this.inputOI).get(input)));
                    return this.t;
                }
                case STRING: {
                    if (this.inputOI.preferWritable()) {
                        this.t.set(((StringObjectInspector)this.inputOI).getPrimitiveWritableObject(input));
                    } else {
                        this.t.set(((StringObjectInspector)this.inputOI).getPrimitiveJavaObject(input));
                    }
                    return this.t;
                }
                case TIMESTAMP: {
                    this.t.set(((TimestampObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
                case BINARY: {
                    this.t.set(((BinaryObjectInspector)this.inputOI).getPrimitiveWritableObject(input).getBytes());
                    return this.t;
                }
            }
            throw new RuntimeException("Hive 2 Internal error: type = " + this.inputOI.getTypeName());
        }
    }

    public static class BinaryConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableBinaryObjectInspector outputOI;
        Object r;

        public BinaryConverter(PrimitiveObjectInspector inputOI, SettableBinaryObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            ByteArrayRef ba = new ByteArrayRef();
            ba.setData(new byte[0]);
            this.r = outputOI.create(ba);
        }

        @Override
        public Object convert(Object input) {
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getBinary(input, this.inputOI));
        }
    }

    public static class TimestampConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableTimestampObjectInspector outputOI;
        Object r;

        public TimestampConverter(PrimitiveObjectInspector inputOI, SettableTimestampObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new Timestamp(0L));
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getTimestamp(input, this.inputOI));
        }
    }

    public static class DoubleConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableDoubleObjectInspector outputOI;
        Object r;

        public DoubleConverter(PrimitiveObjectInspector inputOI, SettableDoubleObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0.0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getDouble(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class FloatConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableFloatObjectInspector outputOI;
        Object r;

        public FloatConverter(PrimitiveObjectInspector inputOI, SettableFloatObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0.0f);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getFloat(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class LongConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableLongObjectInspector outputOI;
        Object r;

        public LongConverter(PrimitiveObjectInspector inputOI, SettableLongObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0L);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getLong(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class IntConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableIntObjectInspector outputOI;
        Object r;

        public IntConverter(PrimitiveObjectInspector inputOI, SettableIntObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getInt(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class ShortConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableShortObjectInspector outputOI;
        Object r;

        public ShortConverter(PrimitiveObjectInspector inputOI, SettableShortObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create((short)0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getShort(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class ByteConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableByteObjectInspector outputOI;
        Object r;

        public ByteConverter(PrimitiveObjectInspector inputOI, SettableByteObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create((byte)0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getByte(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class BooleanConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableBooleanObjectInspector outputOI;
        Object r;

        public BooleanConverter(PrimitiveObjectInspector inputOI, SettableBooleanObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(false);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getBoolean(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

