/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;

public class ASTErrorUtils {
    static final String LINE_SEP = System.getProperty("line.separator");

    private static int getLine(ASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getToken().getLine();
        }
        return ASTErrorUtils.getLine((ASTNode)tree.getChild(0));
    }

    private static int getCharPositionInLine(ASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getToken().getCharPositionInLine();
        }
        return ASTErrorUtils.getCharPositionInLine((ASTNode)tree.getChild(0));
    }

    public static String getText(ASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getText();
        }
        return ASTErrorUtils.getText((ASTNode)tree.getChild(tree.getChildCount() - 1));
    }

    public static String getMsg(String mesg, ASTNode tree) {
        StringBuilder sb = new StringBuilder();
        ASTErrorUtils.renderPosition(sb, tree);
        sb.append(" ");
        sb.append(mesg);
        sb.append(" '");
        sb.append(ASTErrorUtils.getText(tree));
        sb.append("'");
        ASTErrorUtils.renderOrigin(sb, tree.getOrigin());
        return sb.toString();
    }

    public static void renderOrigin(StringBuilder sb, ASTNodeOrigin origin) {
        while (origin != null) {
            sb.append(" in definition of ");
            sb.append(origin.getObjectType());
            sb.append(" ");
            sb.append(origin.getObjectName());
            sb.append(" [");
            sb.append(LINE_SEP);
            sb.append(origin.getObjectDefinition());
            sb.append(LINE_SEP);
            sb.append("] used as ");
            sb.append(origin.getUsageAlias());
            sb.append(" at ");
            ASTNode usageNode = origin.getUsageNode();
            ASTErrorUtils.renderPosition(sb, usageNode);
            origin = usageNode.getOrigin();
        }
    }

    private static void renderPosition(StringBuilder sb, ASTNode tree) {
        sb.append("Line ");
        sb.append(ASTErrorUtils.getLine(tree));
        sb.append(":");
        sb.append(ASTErrorUtils.getCharPositionInLine(tree));
    }

    public static String renderPosition(ASTNode n) {
        StringBuilder sb = new StringBuilder();
        ASTErrorUtils.renderPosition(sb, n);
        return sb.toString();
    }

    public static String getMsg(String mesg, Tree tree) {
        return ASTErrorUtils.getMsg(mesg, (ASTNode)tree);
    }

    public static String getMsg(String mesg, ASTNode tree, String reason) {
        return ASTErrorUtils.getMsg(mesg, tree) + ": " + reason;
    }

    public static String getMsg(String mesg, Tree tree, String reason) {
        return ASTErrorUtils.getMsg(mesg, (ASTNode)tree, reason);
    }
}

