/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.tools.HMSClient;
import org.apache.hadoop.hive.metastore.tools.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkUtils.class);

    static void createManyTables(HMSClient client, int howMany, String dbName, String format) {
        List columns = Util.createSchema(Arrays.asList("name", "string"));
        List partitions = Util.createSchema(Arrays.asList("date", "string"));
        IntStream.range(0, howMany).forEach(i -> Util.throwingSupplierWrapper(() -> client.createTable(new Util.TableBuilder(dbName, String.format(format, i)).withType(TableType.MANAGED_TABLE).withColumns(columns).withPartitionKeys(partitions).build())));
    }

    static void dropManyTables(HMSClient client, int howMany, String dbName, String format) {
        IntStream.range(0, howMany).forEach(i -> Util.throwingSupplierWrapper(() -> client.dropTable(dbName, String.format(format, i))));
    }

    static void createPartitionedTable(HMSClient client, String dbName, String tableName) {
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName, Util.createSchema(Collections.singletonList("date")));
    }

    static void createPartitionedTable(HMSClient client, String dbName, String tableName, List<FieldSchema> partitionKeys) {
        Util.throwingSupplierWrapper(() -> client.createTable(new Util.TableBuilder(dbName, tableName).withType(TableType.MANAGED_TABLE).withColumns(Util.createSchema(Collections.singletonList("name:string"))).withPartitionKeys(partitionKeys).build()));
    }

    static boolean checkTxnsCleaned(HMSClient client, List<Long> txnsOpenedByBenchmark) throws InterruptedException {
        Thread.sleep(100000L);
        ArrayList notCleanedTxns = new ArrayList();
        Util.throwingSupplierWrapper(() -> {
            List txnInfos = client.getOpenTxnsInfo();
            return txnInfos.stream().map(TxnInfo::getId).anyMatch(txnsOpenedByBenchmark::contains);
        });
        return false;
    }
}

