/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.tools.BenchmarkUtils;
import org.apache.hadoop.hive.metastore.tools.HMSClient;
import org.apache.hadoop.hive.metastore.tools.HMSConfig;
import org.apache.hadoop.hive.metastore.tools.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.thrift.TException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACIDBenchmarks {
    private static final Logger LOG = LoggerFactory.getLogger(CoreContext.class);

    @State(value=Scope.Benchmark)
    public static class CoreContext {
        @Param(value={"1"})
        protected int howMany;

        @Setup
        public void setup() {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration ctxConfig = ctx.getConfiguration();
            ctxConfig.getLoggerConfig(CoreContext.class.getName()).setLevel(org.apache.logging.log4j.Level.INFO);
            ctx.updateLoggers(ctxConfig);
        }

        @State(value=Scope.Thread)
        public static class ThreadState {
            HMSClient client;

            @Setup
            public void doSetup() throws Exception {
                LOG.debug("Creating client");
                this.client = HMSConfig.getInstance().newClient();
            }

            @TearDown
            public void doTearDown() throws Exception {
                this.client.close();
                LOG.debug("Closed a connection to metastore.");
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class TestGetValidWriteIds
    extends CoreContext {
        String dbName = "test_db";
        String tblName = "table_%d";
        List<String> fullTableNames = new ArrayList<String>();
        HMSClient client;

        @Setup
        public void doSetup() {
            try {
                this.client = HMSConfig.getInstance().newClient();
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
            try {
                if (!this.client.dbExists(this.dbName)) {
                    this.client.createDatabase(this.dbName);
                }
            }
            catch (TException e) {
                LOG.error(e.getMessage());
            }
            LOG.info("creating {} tables", (Object)this.howMany);
            BenchmarkUtils.createManyTables(this.client, this.howMany, this.dbName, this.tblName);
            for (int i = 0; i < this.howMany; ++i) {
                this.fullTableNames.add(this.dbName + ".table_" + i);
            }
        }

        @TearDown
        public void doTearDown() throws Exception {
            LOG.debug("dropping {} tables", (Object)this.howMany);
            BenchmarkUtils.dropManyTables(this.client, this.howMany, this.dbName, this.tblName);
        }

        @Benchmark
        public void getValidWriteIds(CoreContext.ThreadState state) throws TException {
            LOG.debug("executing getValidWriteIds");
            state.client.getValidWriteIds(this.fullTableNames);
        }
    }

    @State(value=Scope.Benchmark)
    public static class TestAllocateTableWriteIds
    extends CoreContext {
        String dbName = "test_db";
        String tblName = "tmp_table";

        @Benchmark
        public void allocateTableWriteIds(ThreadState state) throws TException {
            state.client.allocateTableWriteIds(this.dbName, this.tblName, state.openTxns);
        }

        private static long executeOpenTxnAndGetTxnId(HMSClient client) {
            return (Long)Util.throwingSupplierWrapper(() -> (Long)client.openTxn(1).get(0));
        }

        @State(value=Scope.Thread)
        public static class ThreadState
        extends CoreContext.ThreadState {
            List<Long> openTxns = new ArrayList<Long>();
            long txnId;

            @Setup
            public void iterSetup() {
                this.txnId = TestAllocateTableWriteIds.executeOpenTxnAndGetTxnId(this.client);
                LOG.info("opened txn, id={}", (Object)this.txnId);
                this.openTxns.add(this.txnId);
            }

            @Override
            @TearDown
            public void doTearDown() throws Exception {
                this.client.abortTxns(this.openTxns);
                if (!BenchmarkUtils.checkTxnsCleaned(this.client, this.openTxns)) {
                    LOG.error("Something went wrong with the cleanup of txns");
                }
                LOG.info("aborted all opened txns");
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class TestLocking
    extends CoreContext {
        private int nTables;
        @Param(value={"0"})
        private int nPartitions;
        private List<LockComponent> lockComponents;

        @Override
        @Setup
        public void setup() {
            this.nTables = this.nPartitions != 0 ? this.howMany / this.nPartitions : this.howMany;
            this.createLockComponents();
        }

        @Benchmark
        public void lock(ThreadState state) {
            LOG.debug("sending lock request");
            this.executeLock(state.client, state.txnId, this.lockComponents);
        }

        private void createLockComponents() {
            this.lockComponents = new ArrayList<LockComponent>();
            for (int i = 0; i < this.nTables; ++i) {
                for (int j = 0; j < this.nPartitions - (this.nPartitions > 1 ? 1 : 0); ++j) {
                    this.lockComponents.add(new Util.LockComponentBuilder().setDbName("default").setTableName(String.format("tmp_table_%d", i)).setPartitionName("p_" + j).setShared().setOperationType(DataOperationType.SELECT).build());
                }
                if (this.nPartitions == 1) continue;
                this.lockComponents.add(new Util.LockComponentBuilder().setDbName("default").setTableName(String.format("tmp_table_%d", i)).setShared().setOperationType(DataOperationType.SELECT).build());
            }
        }

        private static long executeOpenTxnAndGetTxnId(HMSClient client) {
            return (Long)Util.throwingSupplierWrapper(() -> (Long)client.openTxn(1).get(0));
        }

        private void executeLock(HMSClient client, long txnId, List<LockComponent> lockComponents) {
            LockRequest req = new LockRequest(lockComponents, "hclient", "localhost");
            req.setTxnid(txnId);
            Util.throwingSupplierWrapper(() -> client.lock(req));
        }

        @State(value=Scope.Thread)
        public static class ThreadState
        extends CoreContext.ThreadState {
            List<Long> openTxns = new ArrayList<Long>();
            long txnId;

            @Setup(value=Level.Invocation)
            public void iterSetup() {
                this.txnId = TestLocking.executeOpenTxnAndGetTxnId(this.client);
                LOG.debug("opened txn, id={}", (Object)this.txnId);
                this.openTxns.add(this.txnId);
            }

            @Override
            @TearDown
            public void doTearDown() throws Exception {
                this.client.abortTxns(this.openTxns);
                if (!BenchmarkUtils.checkTxnsCleaned(this.client, this.openTxns)) {
                    LOG.error("Something went wrong with the cleanup of txns");
                }
                LOG.debug("aborted all opened txns");
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class TestOpenTxn
    extends CoreContext {
        @Benchmark
        public void openTxn(ThreadState state) throws TException {
            state.addTxn(state.client.openTxn(this.howMany));
            LOG.debug("opened txns, count=", (Object)this.howMany);
        }

        @State(value=Scope.Thread)
        public static class ThreadState
        extends CoreContext.ThreadState {
            List<Long> openTxns = new ArrayList<Long>();

            @Override
            @TearDown
            public void doTearDown() throws Exception {
                this.client.abortTxns(this.openTxns);
                LOG.debug("aborted all opened txns");
            }

            void addTxn(List<Long> openTxn) {
                this.openTxns.addAll(openTxn);
            }
        }
    }
}

