/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.llap.LlapUgiFactory;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.security.LlapUgiHelper;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapUgiManager {
    private static final Logger LOG = LoggerFactory.getLogger(LlapUgiManager.class);
    private final ConcurrentMap<QueryIdentifier, UserGroupInformation> ugis = new ConcurrentHashMap<QueryIdentifier, UserGroupInformation>();
    private final LlapUgiFactory ugiFactory;

    private LlapUgiManager(Configuration conf) {
        try {
            this.ugiFactory = LlapUgiHelper.createLlapUgiFactory(conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LlapUgiManager getInstance(Configuration daemonConf) {
        return new LlapUgiManager(daemonConf);
    }

    public UserGroupInformation getOrCreateUgi(QueryIdentifier queryIdentifier, String user, Credentials credentials) {
        return this.ugis.computeIfAbsent(queryIdentifier, k -> {
            try {
                UserGroupInformation ugi = this.ugiFactory.createUgi(user);
                ugi.addCredentials(credentials);
                LOG.info("Created ugi {} for queryIdentifier '{}', current ugis #: {}", new Object[]{ugi, queryIdentifier, this.ugis.size()});
                return ugi;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void closeAllForUgi(QueryIdentifier queryIdentifier) {
        LOG.debug("Closing all FileSystems for queryIdentifier '{}'", (Object)queryIdentifier);
        try {
            FileSystem.closeAllForUGI((UserGroupInformation)((UserGroupInformation)this.ugis.get(queryIdentifier)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.ugis.remove(queryIdentifier);
    }
}

