/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.service.AsyncTaskCopyAuxJars;
import org.apache.hadoop.hive.llap.cli.service.AsyncTaskCopyConfigs;
import org.apache.hadoop.hive.llap.cli.service.AsyncTaskCopyLocalJars;
import org.apache.hadoop.hive.llap.cli.service.AsyncTaskCreateUdfFile;
import org.apache.hadoop.hive.llap.cli.service.AsyncTaskDownloadTezJars;
import org.apache.hadoop.hive.llap.cli.service.LlapServiceCommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LlapTarComponentGatherer {
    private static final Logger LOG = LoggerFactory.getLogger((String)LlapTarComponentGatherer.class.getName());
    private final Map<String, Future<Void>> tasks = new HashMap<String, Future<Void>>();
    private final LlapServiceCommandLine cl;
    private final HiveConf conf;
    private final Properties directProperties;
    private final FileSystem fs;
    private final FileSystem rawFs;
    private final ExecutorService executor;
    private final Path libDir;
    private final Path tezDir;
    private final Path udfDir;
    private final Path confDir;

    LlapTarComponentGatherer(LlapServiceCommandLine cl, HiveConf conf, Properties directProperties, FileSystem fs, FileSystem rawFs, ExecutorService executor, Path tmpDir) {
        this.cl = cl;
        this.conf = conf;
        this.directProperties = directProperties;
        this.fs = fs;
        this.rawFs = rawFs;
        this.executor = executor;
        this.libDir = new Path(tmpDir, "lib");
        this.tezDir = new Path(this.libDir, "tez");
        this.udfDir = new Path(this.libDir, "udfs");
        this.confDir = new Path(tmpDir, "conf");
    }

    void createDirs() throws Exception {
        if (!this.rawFs.mkdirs(this.tezDir)) {
            LOG.warn("mkdirs for " + this.tezDir + " returned false");
        }
        if (!this.rawFs.mkdirs(this.udfDir)) {
            LOG.warn("mkdirs for " + this.udfDir + " returned false");
        }
        if (!this.rawFs.mkdirs(this.confDir)) {
            LOG.warn("mkdirs for " + this.confDir + " returned false");
        }
    }

    void submitTarComponentGatherTasks() {
        ExecutorCompletionService<Void> asyncRunner = new ExecutorCompletionService<Void>(this.executor);
        this.tasks.put("downloadTezJars", asyncRunner.submit(new AsyncTaskDownloadTezJars(this.conf, this.fs, this.rawFs, this.libDir, this.tezDir)));
        this.tasks.put("copyLocalJars", asyncRunner.submit(new AsyncTaskCopyLocalJars(this.rawFs, this.libDir)));
        this.tasks.put("copyAuxJars", asyncRunner.submit(new AsyncTaskCopyAuxJars(this.cl, this.conf, this.rawFs, this.libDir)));
        this.tasks.put("createUdfFile", asyncRunner.submit(new AsyncTaskCreateUdfFile(this.conf, this.fs, this.rawFs, this.udfDir, this.confDir)));
        this.tasks.put("copyConfigs", asyncRunner.submit(new AsyncTaskCopyConfigs(this.cl, this.conf, this.directProperties, this.rawFs, this.confDir)));
    }

    void waitForFinish() throws Exception {
        for (Map.Entry<String, Future<Void>> task : this.tasks.entrySet()) {
            long t1 = System.nanoTime();
            task.getValue().get();
            long t2 = System.nanoTime();
            LOG.debug(task.getKey() + " waited for " + (t2 - t1) + " ns");
        }
    }
}

