/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.ShutdownHookManager;

public interface ProactiveEvictingCachePolicy {
    public void notifyProactiveEvictionMark();

    public static abstract class Impl
    implements ProactiveEvictingCachePolicy {
        protected final boolean proactiveEvictionEnabled;
        protected final boolean instantProactiveEviction;
        private final long proactiveEvictionSweepIntervalInMs;
        private static ScheduledExecutorService PROACTIVE_EVICTION_SWEEPER_EXECUTOR = null;
        AtomicLong lastMarkTime = new AtomicLong(0L);
        AtomicLong lastSweepTime = new AtomicLong(1L);

        protected Impl(Configuration conf) {
            this.proactiveEvictionEnabled = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_ENABLED);
            this.instantProactiveEviction = this.proactiveEvictionEnabled && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_INSTANT_DEALLOC);
            this.proactiveEvictionSweepIntervalInMs = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_SWEEP_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
            if (this.proactiveEvictionEnabled) {
                PROACTIVE_EVICTION_SWEEPER_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Proactive-Eviction-Sweeper").setDaemon(true).build());
                PROACTIVE_EVICTION_SWEEPER_EXECUTOR.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        long sweepTime = lastSweepTime.get();
                        long markTime = lastMarkTime.get();
                        if (markTime >= sweepTime) {
                            lastSweepTime.set(System.currentTimeMillis());
                            this.evictProactively();
                        }
                    }
                }, 0L, this.proactiveEvictionSweepIntervalInMs, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void notifyProactiveEvictionMark() {
            this.lastMarkTime.set(System.currentTimeMillis());
        }

        public abstract void evictProactively();

        static {
            ShutdownHookManager.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (PROACTIVE_EVICTION_SWEEPER_EXECUTOR != null) {
                        PROACTIVE_EVICTION_SWEEPER_EXECUTOR.shutdownNow();
                    }
                }
            });
        }
    }
}

