/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.counters;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheCounters;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.tez.common.counters.TezCounters;

public class QueryFragmentCounters
implements LowLevelCacheCounters {
    private final boolean doUseTimeCounters;
    private final AtomicLongArray fixedCounters = new AtomicLongArray(LlapIOCounters.values().length);
    private final Object[] descs = new Object[Desc.values().length];
    private final TezCounters tezCounters;

    public QueryFragmentCounters(Configuration conf, TezCounters tezCounters) {
        this.doUseTimeCounters = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ORC_ENABLE_TIME_COUNTERS);
        this.tezCounters = tezCounters;
        if (!this.doUseTimeCounters) {
            this.setCounter(LlapIOCounters.TOTAL_IO_TIME_NS, -1L);
            this.setCounter(LlapIOCounters.DECODE_TIME_NS, -1L);
            this.setCounter(LlapIOCounters.HDFS_TIME_NS, -1L);
            this.setCounter(LlapIOCounters.CONSUMER_TIME_NS, -1L);
        }
    }

    public void incrCounter(LlapIOCounters counter) {
        this.incrCounter(counter, 1L);
    }

    public void incrCounter(LlapIOCounters counter, long delta) {
        this.fixedCounters.addAndGet(counter.ordinal(), delta);
        if (this.tezCounters != null) {
            this.tezCounters.findCounter((Enum)LlapIOCounters.values()[counter.ordinal()]).increment(delta);
        }
    }

    @Override
    public final long startTimeCounter() {
        return this.doUseTimeCounters ? System.nanoTime() : 0L;
    }

    public void incrTimeCounter(LlapIOCounters counter, long startTime) {
        if (!this.doUseTimeCounters) {
            return;
        }
        long delta = System.nanoTime() - startTime;
        this.fixedCounters.addAndGet(counter.ordinal(), delta);
        if (this.tezCounters != null) {
            this.tezCounters.findCounter((Enum)LlapIOCounters.values()[counter.ordinal()]).increment(delta);
        }
    }

    public void setCounter(LlapIOCounters counter, long value) {
        this.fixedCounters.set(counter.ordinal(), value);
        if (this.tezCounters != null) {
            this.tezCounters.findCounter((Enum)LlapIOCounters.values()[counter.ordinal()]).setValue(value);
        }
    }

    public void setDesc(Desc key, Object desc) {
        this.descs[key.ordinal()] = desc;
    }

    @Override
    public void recordCacheHit(long bytesHit) {
        this.incrCounter(LlapIOCounters.CACHE_HIT_BYTES, bytesHit);
    }

    @Override
    public void recordCacheMiss(long bytesMissed) {
        this.incrCounter(LlapIOCounters.CACHE_MISS_BYTES, bytesMissed);
    }

    @Override
    public void recordAllocBytes(long bytesUsed, long bytesAllocated) {
        this.incrCounter(LlapIOCounters.ALLOCATED_USED_BYTES, bytesUsed);
        this.incrCounter(LlapIOCounters.ALLOCATED_BYTES, bytesAllocated);
    }

    @Override
    public void recordHdfsTime(long startTime) {
        this.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("Fragment counters for [");
        for (i = 0; i < this.descs.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (this.descs[i] == null) continue;
            sb.append(this.descs[i]);
        }
        sb.append("]: [ ");
        for (i = 0; i < this.fixedCounters.length(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(LlapIOCounters.values()[i].name()).append("=").append(this.fixedCounters.get(i));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static enum Desc {
        MACHINE,
        TABLE,
        FILE,
        STRIPES;

    }
}

