/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.hive.llap.Row;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapRowRecordReader
implements RecordReader<NullWritable, Row> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapRowRecordReader.class);
    protected final Configuration conf;
    protected final RecordReader<NullWritable, Text> reader;
    protected final Schema schema;
    protected final SerDe serde;
    protected final Text textData = new Text();

    public LlapRowRecordReader(Configuration conf, Schema schema, RecordReader<NullWritable, Text> reader) throws IOException {
        this.conf = conf;
        this.schema = schema;
        this.reader = reader;
        try {
            this.serde = this.initSerDe(conf);
        }
        catch (SerDeException err) {
            throw new IOException(err);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public Row createValue() {
        return new Row(this.schema);
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public boolean next(NullWritable key, Row value) throws IOException {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        boolean hasNext = this.reader.next((Object)key, (Object)this.textData);
        if (hasNext) {
            try {
                StructObjectInspector rowOI = (StructObjectInspector)this.serde.getObjectInspector();
                Object rowObj = this.serde.deserialize((Writable)this.textData);
                List colFields = rowOI.getAllStructFieldRefs();
                block6: for (int idx = 0; idx < colFields.size(); ++idx) {
                    StructField field = (StructField)colFields.get(idx);
                    Object colValue = rowOI.getStructFieldData(rowObj, field);
                    Preconditions.checkState((field.getFieldObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0) != 0, (Object)("Cannot handle non-primitive column type " + field.getFieldObjectInspector().getTypeName()));
                    PrimitiveObjectInspector poi = (PrimitiveObjectInspector)field.getFieldObjectInspector();
                    switch (poi.getPrimitiveCategory()) {
                        case CHAR: {
                            value.setValue(idx, (Writable)((HiveCharWritable)poi.getPrimitiveWritableObject(colValue)).getPaddedValue());
                            continue block6;
                        }
                        case VARCHAR: {
                            value.setValue(idx, (Writable)((HiveVarcharWritable)poi.getPrimitiveWritableObject(colValue)).getTextValue());
                            continue block6;
                        }
                        default: {
                            value.setValue(idx, (Writable)poi.getPrimitiveWritableObject(colValue));
                        }
                    }
                }
            }
            catch (SerDeException err) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error deserializing row from text: " + this.textData);
                }
                throw new IOException("Error deserializing row data", err);
            }
        }
        return hasNext;
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected SerDe initSerDe(Configuration conf) throws SerDeException {
        Properties props = new Properties();
        StringBuffer columnsBuffer = new StringBuffer();
        StringBuffer typesBuffer = new StringBuffer();
        boolean isFirst = true;
        for (FieldDesc colDesc : this.schema.getColumns()) {
            if (!isFirst) {
                columnsBuffer.append(',');
                typesBuffer.append(',');
            }
            columnsBuffer.append(colDesc.getName());
            typesBuffer.append(colDesc.getTypeDesc().toString());
            isFirst = false;
        }
        String columns = columnsBuffer.toString();
        String types = typesBuffer.toString();
        props.put("columns", columns);
        props.put("columns.types", types);
        LazySimpleSerDe serde = new LazySimpleSerDe();
        serde.initialize(conf, props);
        return serde;
    }
}

