/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.security.LlapTokenProvider;

public class LlapProxy {
    private static final String IMPL_CLASS = "org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl";
    private static final String TOKEN_CLASS = "org.apache.hadoop.hive.llap.security.LlapSecurityHelper";
    private static LlapIo io = null;
    private static LlapTokenProvider tokenProvider = null;
    private static final Object tpInitLock = new Object();
    private static volatile boolean isTpInitDone = false;
    private static boolean isDaemon = false;

    public static void setDaemon(boolean isDaemon) {
        LlapProxy.isDaemon = isDaemon;
    }

    public static boolean isDaemon() {
        return isDaemon;
    }

    public static LlapIo getIo() {
        return io;
    }

    public static void initializeLlapIo(Configuration conf) {
        if (io != null) {
            return;
        }
        try {
            io = LlapProxy.createIoImpl(conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot initialize local server", e);
        }
    }

    private static LlapIo createIoImpl(Configuration conf) throws IOException {
        try {
            Class<?> clazz = Class.forName(IMPL_CLASS);
            Constructor<?> ctor = clazz.getDeclaredConstructor(Configuration.class);
            ctor.setAccessible(true);
            return (LlapIo)ctor.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create impl class", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LlapTokenProvider getOrInitTokenProvider(Configuration conf) {
        if (isTpInitDone) {
            return tokenProvider;
        }
        Object object = tpInitLock;
        synchronized (object) {
            if (isTpInitDone) {
                return tokenProvider;
            }
            try {
                tokenProvider = LlapProxy.createTokenProviderImpl(conf);
                isTpInitDone = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot initialize token provider", e);
            }
            return tokenProvider;
        }
    }

    private static LlapTokenProvider createTokenProviderImpl(Configuration conf) throws IOException {
        try {
            Class<?> clazz = Class.forName(TOKEN_CLASS);
            Constructor<?> ctor = clazz.getDeclaredConstructor(Configuration.class);
            ctor.setAccessible(true);
            return (LlapTokenProvider)ctor.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create token provider class", e);
        }
    }

    public static void close() {
        if (io != null) {
            io.close();
        }
    }
}

