/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TimestampUtil {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    };

    private TimestampUtil() {
    }

    public static long timestampToMicros(Timestamp timestamp) {
        long millis = timestamp.getTime() * 1000L;
        long micros = (long)timestamp.getNanos() % 1000000L / 1000L;
        if (micros >= 0L) {
            return millis + micros;
        }
        return millis + 1000000L + micros;
    }

    public static Timestamp microsToTimestamp(long micros) {
        long millis = micros / 1000L;
        long nanos = micros % 1000000L * 1000L;
        if (nanos < 0L) {
            --millis;
            nanos += 1000000000L;
        }
        Timestamp timestamp = new Timestamp(millis);
        timestamp.setNanos((int)nanos);
        return timestamp;
    }

    public static String timestampToString(Timestamp timestamp) {
        long micros = TimestampUtil.timestampToMicros(timestamp);
        return TimestampUtil.timestampToString(micros);
    }

    public static String timestampToString(long micros) {
        long tsMillis = micros / 1000L;
        long tsMicros = micros % 1000000L;
        String tsStr = DATE_FORMAT.get().format(new Date(tsMillis));
        return String.format("%s.%06dZ", tsStr, tsMicros);
    }
}

