/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.dns;

import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.buffer.ByteBuf;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.channel.ChannelHandler;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.dns.DnsMessageUtil;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.dns.DnsRecordEncoder;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.dns.DnsResponse;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().ioBuffer(1024);
        buf.writerIndex(buf.writerIndex() + 2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, buf.readableBytes() - 2);
        out.add(buf);
    }
}

