/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.spitter;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;

public class DateIntervalSplitter
implements IntervalSplitter {
    @Override
    public List<MutablePair<String, String>> getIntervals(String lowerBound, String upperBound, int numPartitions, TypeInfo typeInfo) {
        ArrayList<MutablePair<String, String>> intervals = new ArrayList<MutablePair<String, String>>();
        Date dateLower = Date.valueOf(lowerBound);
        Date dateUpper = Date.valueOf(upperBound);
        double dateInterval = (double)(dateUpper.getTime() - dateLower.getTime()) / (double)numPartitions;
        for (int i = 0; i < numPartitions; ++i) {
            Date splitDateUpper;
            Date splitDateLower = new Date(Math.round((double)dateLower.getTime() + dateInterval * (double)i));
            if (splitDateLower.compareTo(splitDateUpper = new Date(Math.round((double)dateLower.getTime() + dateInterval * (double)(i + 1)))) >= 0) continue;
            intervals.add((MutablePair<String, String>)new MutablePair((Object)splitDateLower.toString(), (Object)splitDateUpper.toString()));
        }
        return intervals;
    }
}

