/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.writer.HiveFileWriterFactory;
import org.apache.iceberg.mr.hive.writer.HiveIcebergCopyOnWriteRecordWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergDeleteWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergRecordWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.hive.writer.WriterRegistry;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.DeleteFileSet;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializationUtil;
import org.apache.iceberg.util.SnapshotUtil;

public class WriterBuilder {
    private final Table table;
    private final Supplier<Map<String, DeleteFileSet>> rewritableDeletes;
    private final Context context;
    private final String tableName;
    private TaskAttemptID attemptID;
    private String queryId;
    private Context.Operation operation;
    private static AtomicInteger operationNum = new AtomicInteger(0);
    public static final String ICEBERG_DELETE_SKIPROWDATA = "iceberg.delete.skiprowdata";
    public static final boolean ICEBERG_DELETE_SKIPROWDATA_DEFAULT = true;

    private WriterBuilder(Table table, UnaryOperator<String> ops) {
        this.table = table;
        this.tableName = (String)ops.apply("name");
        this.context = new Context(table.properties(), ops, this.tableName);
        this.operation = HiveCustomStorageHandlerUtils.getWriteOperation(ops, (String)this.tableName);
        this.rewritableDeletes = () -> this.rewritableDeletes(ops);
    }

    public static WriterBuilder builderFor(Table table, UnaryOperator<String> ops) {
        return new WriterBuilder(table, ops);
    }

    public WriterBuilder attemptID(TaskAttemptID newAttemptID) {
        this.attemptID = newAttemptID;
        return this;
    }

    public WriterBuilder queryId(String newQueryId) {
        this.queryId = newQueryId;
        return this;
    }

    public WriterBuilder operation(Context.Operation newOperation) {
        this.operation = newOperation;
        return this;
    }

    public HiveIcebergWriter build() {
        HiveIcebergWriterBase writer;
        int partitionId = this.attemptID.getTaskID().getId();
        int taskId = this.attemptID.getId();
        String operationId = this.queryId + "-" + String.valueOf(this.attemptID.getJobID()) + "-" + operationNum.incrementAndGet();
        OutputFileFactory dataFileFactory = OutputFileFactory.builderFor(this.table, partitionId, taskId).format(this.context.dataFileFormat()).operationId(operationId).build();
        OutputFileFactory deleteFileFactory = OutputFileFactory.builderFor(this.table, partitionId, taskId).format(this.context.deleteFileFormat()).operationId(operationId).suffix("pos-deletes").build();
        HiveFileWriterFactory writerFactory = HiveFileWriterFactory.builderFor(this.table).dataFileFormat(this.context.dataFileFormat()).dataSchema(this.table.schema()).deleteFileFormat(this.context.deleteFileFormat()).positionDeleteRowSchema(this.context.skipRowData() || !this.context.inputOrdered() ? null : this.table.schema()).build();
        boolean isCOW = IcebergTableUtil.isCopyOnWriteMode(this.operation, this.table.properties()::getOrDefault);
        if (isCOW) {
            writer = new HiveIcebergCopyOnWriteRecordWriter(this.table, writerFactory, dataFileFactory, this.context);
        } else {
            writer = switch (this.operation) {
                case Context.Operation.DELETE -> new HiveIcebergDeleteWriter(this.table, this.rewritableDeletes.get(), writerFactory, deleteFileFactory, this.context);
                case Context.Operation.OTHER -> new HiveIcebergRecordWriter(this.table, writerFactory, dataFileFactory, this.context);
                default -> throw new IllegalArgumentException("Unsupported operation when creating IcebergRecordWriter: " + this.operation.name());
            };
        }
        WriterRegistry.registerWriter(this.attemptID, this.tableName, writer);
        return writer;
    }

    private Map<String, DeleteFileSet> rewritableDeletes(UnaryOperator<String> ops) {
        Snapshot snapshot = SnapshotUtil.latestSnapshot(this.table, (String)ops.apply("iceberg.mr.output.table.snapshot.ref"));
        boolean caseSensitive = (Boolean)ObjectUtils.defaultIfNull((Object)Boolean.parseBoolean((String)ops.apply("iceberg.mr.case.sensitive")), (Object)true);
        Expression filterExpression = (Expression)SerializationUtil.deserializeFromBase64((String)ops.apply("iceberg.mr.filter.expression"));
        BatchScan scan = (BatchScan)this.table.newBatchScan().useSnapshot(snapshot.snapshotId()).caseSensitive(caseSensitive);
        if (filterExpression != null) {
            scan = (BatchScan)scan.filter(filterExpression);
        }
        if (this.shouldRewriteDeletes()) {
            return WriterBuilder.rewritableDeletes(scan, this.context.useDVs());
        }
        return null;
    }

    private boolean shouldRewriteDeletes() {
        return this.context.useDVs() || this.context.deleteGranularity() == DeleteGranularity.FILE;
    }

    private static Map<String, DeleteFileSet> rewritableDeletes(BatchScan scan, boolean forDVs) {
        HashMap<String, DeleteFileSet> rewritableDeletes = Maps.newHashMap();
        try (CloseableIterable<ScanTask> tasksIterable = scan.planFiles();){
            tasksIterable.forEach(task -> {
                FileScanTask fileScanTask = task.asFileScanTask();
                fileScanTask.deletes().forEach(deleteFile -> {
                    if (WriterBuilder.shouldRewrite(deleteFile, forDVs)) {
                        rewritableDeletes.computeIfAbsent(((DataFile)fileScanTask.file()).location(), ignored -> DeleteFileSet.create()).add(deleteFile);
                    }
                });
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to close table scan: %s", scan), e);
        }
        return rewritableDeletes;
    }

    private static boolean shouldRewrite(DeleteFile deleteFile, boolean forDVs) {
        if (forDVs) {
            return deleteFile.content() != FileContent.EQUALITY_DELETES;
        }
        return ContentFileUtil.isFileScoped(deleteFile);
    }

    static class Context {
        private final FileFormat dataFileFormat;
        private final long targetDataFileSize;
        private final FileFormat deleteFileFormat;
        private final long targetDeleteFileSize;
        private final DeleteGranularity deleteGranularity;
        private final boolean useFanoutWriter;
        private final boolean inputOrdered;
        private final boolean isMergeTask;
        private final boolean skipRowData;
        private final boolean useDVs;
        private final Set<String> missingColumns;

        Context(Map<String, String> properties, UnaryOperator<String> ops, String tableName) {
            String dataFileFormatName = properties.getOrDefault("write.format.default", "parquet");
            this.dataFileFormat = FileFormat.valueOf(dataFileFormatName.toUpperCase(Locale.ENGLISH));
            String deleteFileFormatName = properties.getOrDefault("write.delete.format.default", dataFileFormatName);
            this.deleteFileFormat = FileFormat.valueOf(deleteFileFormatName.toUpperCase(Locale.ENGLISH));
            this.targetDataFileSize = PropertyUtil.propertyAsLong(properties, "write.target-file-size-bytes", 0x20000000L);
            this.targetDeleteFileSize = PropertyUtil.propertyAsLong(properties, "write.delete.target-file-size-bytes", 0x20000000L);
            this.inputOrdered = HiveCustomStorageHandlerUtils.getWriteOperationIsSorted(ops, (String)tableName);
            this.useFanoutWriter = !this.inputOrdered && IcebergTableUtil.isFanoutEnabled(properties);
            this.isMergeTask = HiveCustomStorageHandlerUtils.isMergeTaskEnabled(ops, (String)tableName);
            this.deleteGranularity = DeleteGranularity.PARTITION;
            this.useDVs = IcebergTableUtil.formatVersion(properties) > 2;
            this.skipRowData = this.useDVs || PropertyUtil.propertyAsBoolean(properties, WriterBuilder.ICEBERG_DELETE_SKIPROWDATA, true);
            this.missingColumns = Optional.ofNullable((String)ops.apply("missingColumns")).map(columns -> Arrays.stream(columns.split(",")).collect(Collectors.toCollection(HashSet::new))).orElse(Sets.newHashSet());
        }

        FileFormat dataFileFormat() {
            return this.dataFileFormat;
        }

        long targetDataFileSize() {
            return this.targetDataFileSize;
        }

        FileFormat deleteFileFormat() {
            return this.deleteFileFormat;
        }

        long targetDeleteFileSize() {
            return this.targetDeleteFileSize;
        }

        DeleteGranularity deleteGranularity() {
            return this.deleteGranularity;
        }

        boolean useFanoutWriter() {
            return this.useFanoutWriter;
        }

        boolean inputOrdered() {
            return this.inputOrdered;
        }

        boolean isMergeTask() {
            return this.isMergeTask;
        }

        boolean skipRowData() {
            return this.skipRowData;
        }

        public boolean useDVs() {
            return this.useDVs;
        }

        public Set<String> missingColumns() {
            return this.missingColumns;
        }
    }
}

