/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.util.SerializationUtil;

public class IcebergMergeSplit
extends FileSplit
implements InputSplit {
    private transient Configuration conf;
    private ContentFile contentFile;

    public IcebergMergeSplit() {
    }

    public IcebergMergeSplit(Configuration conf, CombineHiveInputFormat.CombineHiveInputSplit split, Integer partition, Properties properties) throws IOException {
        super(split.getPaths()[partition], split.getStartOffsets()[partition], split.getLengths()[partition], split.getLocations());
        this.conf = conf;
        Path path = split.getPaths()[partition];
        this.contentFile = (ContentFile)properties.get(path);
    }

    public long getLength() {
        return this.contentFile.fileSizeInBytes();
    }

    public String[] getLocations() {
        return new String[]{"*"};
    }

    public void write(DataOutput out) throws IOException {
        byte[] data = SerializationUtil.serializeToBytes(this.contentFile);
        out.writeInt(data.length);
        out.write(data);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.contentFile = (ContentFile)SerializationUtil.deserializeFromBytes(data);
    }

    public ContentFile getContentFile() {
        return this.contentFile;
    }
}

