/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class ParquetSchemaFieldNameVisitor
extends TypeWithSchemaVisitor<Type> {
    private final MessageType originalFileSchema;
    private final Map<Integer, Type> typesById = Maps.newHashMap();
    private StringBuilder sb = new StringBuilder();
    private static final String DUMMY_COL_NAME = "<<DUMMY_FOR_RECREATED_FIELD_IN_FILESCHEMA>>";

    ParquetSchemaFieldNameVisitor(MessageType originalFileSchema) {
        this.originalFileSchema = originalFileSchema;
    }

    @Override
    public Type message(Types.StructType expected, MessageType prunedFileSchema, List<Type> fields) {
        return this.struct(expected, prunedFileSchema.asGroupType(), (List)fields);
    }

    @Override
    public Type struct(Types.StructType expected, GroupType struct, List<Type> fields) {
        boolean isMessageType = struct instanceof MessageType;
        List<Object> expectedFields = expected != null ? expected.fields() : ImmutableList.of();
        ArrayList<Type> types = Lists.newArrayListWithExpectedSize(expectedFields.size());
        for (Types.NestedField nestedField : expectedFields) {
            int id = nestedField.fieldId();
            if (MetadataColumns.metadataFieldIds().contains(id)) continue;
            Type fieldInPrunedFileSchema = this.typesById.get(id);
            if (fieldInPrunedFileSchema == null) {
                if (!this.originalFileSchema.containsField(nestedField.name())) {
                    this.appendToColNamesList(isMessageType, nestedField.name());
                    continue;
                }
                this.appendToColNamesList(isMessageType, DUMMY_COL_NAME);
                continue;
            }
            types.add(fieldInPrunedFileSchema);
            this.appendToColNamesList(isMessageType, fieldInPrunedFileSchema.getName());
        }
        if (!isMessageType) {
            GroupType groupType = new GroupType(Type.Repetition.REPEATED, (String)this.fieldNames.peek(), types);
            if (struct.getId() != null) {
                this.typesById.put(struct.getId().intValue(), groupType);
            }
            return groupType;
        }
        return new MessageType("table", types);
    }

    private void appendToColNamesList(boolean isMessageType, String colName) {
        if (isMessageType) {
            this.sb.append(colName).append(',');
        }
    }

    @Override
    public Type primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
        if (primitive.getId() != null) {
            this.typesById.put(primitive.getId().intValue(), primitive);
        }
        return primitive;
    }

    @Override
    public Type list(Types.ListType iList, GroupType array, Type element) {
        if (array.getId() != null) {
            this.typesById.put(array.getId().intValue(), array);
        }
        return array;
    }

    @Override
    public Type map(Types.MapType iMap, GroupType map, Type key, Type value) {
        if (map.getId() != null) {
            this.typesById.put(map.getId().intValue(), map);
        }
        return map;
    }

    public String retrieveColumnNameList() {
        this.sb.setLength(this.sb.length() - 1);
        return this.sb.toString();
    }
}

