/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.CachingDeleteLoader;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.data.DeleteLoader;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mr.hive.vector.HiveBatchContext;
import org.apache.iceberg.mr.hive.vector.HiveRow;
import org.apache.iceberg.mr.hive.vector.HiveStructLike;

public class HiveDeleteFilter
extends DeleteFilter<HiveRow> {
    private final FileIO io;
    private final HiveStructLike asStructLike;
    private final Configuration conf;

    public HiveDeleteFilter(FileIO io, FileScanTask task, Schema tableSchema, Schema requestedSchema, Configuration conf) {
        super(((DataFile)task.file()).path().toString(), task.deletes(), tableSchema, requestedSchema);
        this.io = io;
        this.asStructLike = new HiveStructLike(this.requiredSchema().asStruct());
        this.conf = conf;
    }

    @Override
    protected DeleteLoader newDeleteLoader() {
        return new CachingDeleteLoader(x$0 -> this.loadInputFile((DeleteFile)x$0), this.conf);
    }

    @Override
    protected StructLike asStructLike(HiveRow record) {
        return this.asStructLike.wrap(record);
    }

    @Override
    protected long pos(HiveRow record) {
        return (Long)record.get(MetadataColumns.ROW_POSITION.fieldId());
    }

    @Override
    protected void markRowDeleted(HiveRow row) {
        row.setDeleted(true);
    }

    @Override
    protected InputFile getInputFile(String location) {
        return this.io.newInputFile(location);
    }

    public CloseableIterable<HiveBatchContext> filterBatch(CloseableIterable<HiveBatchContext> batches) {
        final DeleteFilterBatchIterator iterator = new DeleteFilterBatchIterator(batches);
        return new CloseableIterable<HiveBatchContext>(){

            @Override
            public CloseableIterator<HiveBatchContext> iterator() {
                return iterator;
            }

            @Override
            public void close() throws IOException {
                iterator.close();
            }
        };
    }

    private class DeleteFilterBatchIterator
    implements CloseableIterator<HiveBatchContext> {
        private final SwappableHiveRowIterable deleteInputIterable = new SwappableHiveRowIterable();
        private final CloseableIterable<HiveRow> deleteOutputIterable;
        private final CloseableIterator<HiveBatchContext> srcIterator;

        DeleteFilterBatchIterator(CloseableIterable<HiveBatchContext> batches) {
            this.deleteOutputIterable = HiveDeleteFilter.this.filter(this.deleteInputIterable);
            this.srcIterator = batches.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.srcIterator.hasNext();
        }

        @Override
        public HiveBatchContext next() {
            try {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                HiveBatchContext batchContext = (HiveBatchContext)this.srcIterator.next();
                VectorizedRowBatch batch = batchContext.getBatch();
                int oldSize = batch.size;
                int newSize = 0;
                try (CloseableIterator<HiveRow> rowIterator = batchContext.rowIterator();){
                    this.deleteInputIterable.currentRowIterator = rowIterator;
                    for (HiveRow row : this.deleteOutputIterable) {
                        if (row.isDeleted()) continue;
                        batch.selected[newSize++] = row.physicalBatchIndex();
                    }
                }
                if (newSize < oldSize) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
                return batchContext;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.srcIterator, this.deleteOutputIterable});
        }
    }

    private static class SwappableHiveRowIterable
    implements CloseableIterable<HiveRow> {
        private CloseableIterator<HiveRow> currentRowIterator;

        private SwappableHiveRowIterable() {
        }

        @Override
        public CloseableIterator<HiveRow> iterator() {
            return this.currentRowIterator;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.currentRowIterator);
        }
    }
}

