/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.Deserializer;
import org.apache.iceberg.mr.hive.HiveTableUtil;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergSerDe
extends AbstractSerDe {
    public static final String CTAS_EXCEPTION_MSG = "CTAS target table must be a HiveCatalog table. For other catalog types, the target Iceberg table would be created successfully but the table will not be registered in HMS. This means that even though the CTAS query succeeds, the new table wouldn't be immediately queryable from Hive, since HMS does not know about it.";
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergSerDe.class);
    private ObjectInspector inspector;
    private Schema tableSchema;
    private Schema projectedSchema;
    private Collection<String> partitionColumns;
    private final Map<ObjectInspector, Deserializer> deserializers = Maps.newHashMapWithExpectedSize(1);
    private final Container<Record> row = new Container();
    private final Map<String, String> jobConf = Maps.newHashMap();

    public void initialize(Configuration conf, Properties serDeProperties, Properties partitionProperties) throws SerDeException {
        block17: {
            super.initialize(conf, serDeProperties, partitionProperties);
            if (serDeProperties.get("iceberg.mr.table.schema") != null) {
                this.tableSchema = SchemaParser.fromJson(serDeProperties.getProperty("iceberg.mr.table.schema"));
                if (serDeProperties.get("iceberg.mr.table.partition.spec") != null) {
                    PartitionSpec spec = PartitionSpecParser.fromJson(this.tableSchema, serDeProperties.getProperty("iceberg.mr.table.partition.spec"));
                    this.partitionColumns = spec.fields().stream().map(PartitionField::name).collect(Collectors.toList());
                } else {
                    this.partitionColumns = ImmutableList.of();
                }
            } else {
                try {
                    Table table = IcebergTableUtil.getTable(conf, serDeProperties);
                    this.tableSchema = table.schema();
                    this.partitionColumns = table.spec().fields().stream().map(PartitionField::name).collect(Collectors.toList());
                    LOG.info("Using schema from existing table {}", (Object)SchemaParser.toJson(this.tableSchema));
                }
                catch (Exception e) {
                    block16: {
                        if (serDeProperties.get("metadata_location") != null) {
                            try (HadoopFileIO fileIO = new HadoopFileIO(conf);){
                                TableMetadata metadata = TableMetadataParser.read((FileIO)fileIO, serDeProperties.getProperty("metadata_location"));
                                this.tableSchema = metadata.schema();
                                this.partitionColumns = metadata.spec().fields().stream().map(PartitionField::name).collect(Collectors.toList());
                                if (!this.getColumnNames().isEmpty() || !this.getPartitionColumnNames().isEmpty()) {
                                    throw new SerDeException("Column names can not be provided along with metadata location.");
                                }
                                break block16;
                            }
                        }
                        boolean autoConversion = conf.getBoolean("iceberg.mr.schema.auto.conversion", false);
                        this.tableSchema = this.hiveSchemaOrThrow(e, autoConversion);
                        this.partitionColumns = ImmutableList.of();
                    }
                    if (!(e instanceof NoSuchTableException) || !HiveTableUtil.isCtas(serDeProperties) || Catalogs.hiveCatalog(conf, serDeProperties)) break block17;
                    throw new SerDeException(CTAS_EXCEPTION_MSG);
                }
            }
        }
        this.projectedSchema = HiveIcebergSerDe.projectedSchema(conf, serDeProperties.getProperty("name"), this.tableSchema, this.jobConf);
        if (!IcebergTableUtil.isFanoutEnabled(Maps.fromProperties(serDeProperties))) {
            HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_SORT_DYNAMIC_PARTITION_THRESHOLD, (int)1);
        }
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, (String)"nonstrict");
        try {
            this.inspector = IcebergObjectInspector.create(this.projectedSchema);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    private static Schema projectedSchema(Configuration conf, String tableName, Schema tableSchema, Map<String, String> jobConf) {
        Context.Operation operation = HiveCustomStorageHandlerUtils.getWriteOperation(arg_0 -> ((Configuration)conf).get(arg_0), (String)tableName);
        if (operation == null) {
            Schema projectedSchema;
            jobConf.put("iceberg.mr.case.sensitive", "false");
            String[] selectedColumns = ColumnProjectionUtils.getReadColumnNames((Configuration)conf);
            String[] distinctSelectedColumns = (String[])Arrays.stream(selectedColumns).distinct().toArray(String[]::new);
            Schema schema = projectedSchema = distinctSelectedColumns.length > 0 ? tableSchema.caseInsensitiveSelect(distinctSelectedColumns) : tableSchema;
            if (projectedSchema.columns().size() != distinctSelectedColumns.length) {
                return tableSchema;
            }
            return projectedSchema;
        }
        boolean isCOW = IcebergTableUtil.isCopyOnWriteMode(operation, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        if (isCOW) {
            return IcebergAcidUtil.createSerdeSchemaForDelete(tableSchema.columns());
        }
        switch (operation) {
            case DELETE: {
                return IcebergAcidUtil.createSerdeSchemaForDelete(tableSchema.columns());
            }
            case UPDATE: {
                return IcebergAcidUtil.createSerdeSchemaForUpdate(tableSchema.columns());
            }
            case OTHER: {
                return tableSchema;
            }
        }
        throw new IllegalArgumentException("Unsupported operation " + operation);
    }

    public Class<? extends Writable> getSerializedClass() {
        return Container.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) {
        Deserializer deserializer = this.deserializers.get(objectInspector);
        if (deserializer == null) {
            deserializer = new Deserializer.Builder().schema(this.projectedSchema).sourceInspector((StructObjectInspector)objectInspector).writerInspector((StructObjectInspector)this.inspector).build();
            this.deserializers.put(objectInspector, deserializer);
        }
        this.row.set(deserializer.deserialize(o));
        return this.row;
    }

    public void handleJobLevelConfiguration(HiveConf conf) {
        this.jobConf.forEach((arg_0, arg_1) -> ((HiveConf)conf).set(arg_0, arg_1));
    }

    public Object deserialize(Writable writable) {
        return ((Container)writable).get();
    }

    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    private Schema hiveSchemaOrThrow(Exception previousException, boolean autoConversion) throws SerDeException {
        ArrayList<String> names = Lists.newArrayList();
        names.addAll(this.getColumnNames());
        names.addAll(this.getPartitionColumnNames());
        ArrayList<TypeInfo> types = Lists.newArrayList();
        types.addAll(this.getColumnTypes());
        types.addAll(this.getPartitionColumnTypes());
        ArrayList<String> comments = Lists.newArrayList();
        comments.addAll(this.getColumnComments());
        comments.addAll(this.getPartitionColumnComments());
        if (!names.isEmpty() && !types.isEmpty()) {
            Schema hiveSchema = HiveSchemaUtil.convert(names, types, comments, autoConversion);
            LOG.info("Using hive schema {}", (Object)SchemaParser.toJson(hiveSchema));
            return hiveSchema;
        }
        throw new SerDeException("Please provide an existing table or a valid schema", (Throwable)previousException);
    }

    public Collection<String> partitionColumns() {
        return this.partitionColumns;
    }

    public boolean shouldStoreFieldsInMetastore(Map<String, String> tableParams) {
        return true;
    }

    public Schema getTableSchema() {
        return this.tableSchema;
    }
}

