/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.fast;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveIntervalDayTime;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazySimpleSerializeWrite
implements SerializeWrite {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazySimpleSerializeWrite.class.getName());
    private LazySerDeParameters lazyParams;
    private byte[] separators;
    private boolean[] needsEscape;
    private boolean isEscaped;
    private byte escapeChar;
    private byte[] nullSequenceBytes;
    private ByteStream.Output output;
    private int fieldCount;
    private int index;
    private int currentLevel;
    private Deque<Integer> indexStack = new ArrayDeque<Integer>();
    private DateWritableV2 dateWritable;
    private TimestampWritableV2 timestampWritable;
    private HiveIntervalYearMonthWritable hiveIntervalYearMonthWritable;
    private HiveIntervalDayTimeWritable hiveIntervalDayTimeWritable;
    private HiveIntervalDayTime hiveIntervalDayTime;
    private HiveDecimalWritable hiveDecimalWritable;
    private byte[] decimalScratchBuffer;

    public LazySimpleSerializeWrite(int fieldCount, LazySerDeParameters lazyParams) {
        this();
        this.fieldCount = fieldCount;
        this.lazyParams = lazyParams;
        this.separators = lazyParams.getSeparators();
        this.isEscaped = lazyParams.isEscaped();
        this.escapeChar = lazyParams.getEscapeChar();
        this.needsEscape = lazyParams.getNeedsEscape();
        this.nullSequenceBytes = lazyParams.getNullSequence().getBytes();
    }

    private LazySimpleSerializeWrite() {
    }

    @Override
    public void set(ByteStream.Output output) {
        this.output = output;
        output.reset();
        this.index = 0;
        this.currentLevel = 0;
    }

    @Override
    public void setAppend(ByteStream.Output output) {
        this.output = output;
        this.index = 0;
        this.currentLevel = 0;
    }

    @Override
    public void reset() {
        this.output.reset();
        this.index = 0;
        this.currentLevel = 0;
    }

    @Override
    public void writeNull() throws IOException {
        this.beginPrimitive();
        this.output.write(this.nullSequenceBytes);
        this.finishPrimitive();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.beginPrimitive();
        if (v) {
            this.output.write(LazyUtils.trueBytes, 0, LazyUtils.trueBytes.length);
        } else {
            this.output.write(LazyUtils.falseBytes, 0, LazyUtils.falseBytes.length);
        }
        this.finishPrimitive();
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.beginPrimitive();
        LazyInteger.writeUTF8(this.output, v);
        this.finishPrimitive();
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.beginPrimitive();
        LazyInteger.writeUTF8(this.output, v);
        this.finishPrimitive();
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.beginPrimitive();
        LazyInteger.writeUTF8(this.output, v);
        this.finishPrimitive();
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.beginPrimitive();
        LazyLong.writeUTF8(this.output, v);
        this.finishPrimitive();
    }

    @Override
    public void writeFloat(float vf) throws IOException {
        this.beginPrimitive();
        ByteBuffer b = Text.encode((String)String.valueOf(vf));
        this.output.write(b.array(), 0, b.limit());
        this.finishPrimitive();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.beginPrimitive();
        ByteBuffer b = Text.encode((String)String.valueOf(v));
        this.output.write(b.array(), 0, b.limit());
        this.finishPrimitive();
    }

    @Override
    public void writeString(byte[] v) throws IOException {
        this.beginPrimitive();
        LazyUtils.writeEscaped(this.output, v, 0, v.length, this.isEscaped, this.escapeChar, this.needsEscape);
        this.finishPrimitive();
    }

    @Override
    public void writeString(byte[] v, int start, int length) throws IOException {
        this.beginPrimitive();
        LazyUtils.writeEscaped(this.output, v, start, length, this.isEscaped, this.escapeChar, this.needsEscape);
        this.finishPrimitive();
    }

    @Override
    public void writeHiveChar(HiveChar hiveChar) throws IOException {
        this.beginPrimitive();
        ByteBuffer b = Text.encode((String)hiveChar.getPaddedValue());
        LazyUtils.writeEscaped(this.output, b.array(), 0, b.limit(), this.isEscaped, this.escapeChar, this.needsEscape);
        this.finishPrimitive();
    }

    @Override
    public void writeHiveVarchar(HiveVarchar hiveVarchar) throws IOException {
        this.beginPrimitive();
        ByteBuffer b = Text.encode((String)hiveVarchar.getValue());
        LazyUtils.writeEscaped(this.output, b.array(), 0, b.limit(), this.isEscaped, this.escapeChar, this.needsEscape);
        this.finishPrimitive();
    }

    @Override
    public void writeBinary(byte[] v) throws IOException {
        this.beginPrimitive();
        byte[] toEncode = new byte[v.length];
        System.arraycopy(v, 0, toEncode, 0, v.length);
        byte[] toWrite = Base64.encodeBase64((byte[])toEncode);
        this.output.write(toWrite, 0, toWrite.length);
        this.finishPrimitive();
    }

    @Override
    public void writeBinary(byte[] v, int start, int length) throws IOException {
        this.beginPrimitive();
        byte[] toEncode = new byte[length];
        System.arraycopy(v, start, toEncode, 0, length);
        byte[] toWrite = Base64.encodeBase64((byte[])toEncode);
        this.output.write(toWrite, 0, toWrite.length);
        this.finishPrimitive();
    }

    @Override
    public void writeDate(Date date) throws IOException {
        this.beginPrimitive();
        if (this.dateWritable == null) {
            this.dateWritable = new DateWritableV2();
        }
        this.dateWritable.set(date);
        LazyDate.writeUTF8(this.output, this.dateWritable);
        this.finishPrimitive();
    }

    @Override
    public void writeDate(int dateAsDays) throws IOException {
        this.beginPrimitive();
        if (this.dateWritable == null) {
            this.dateWritable = new DateWritableV2();
        }
        this.dateWritable.set(dateAsDays);
        LazyDate.writeUTF8(this.output, this.dateWritable);
        this.finishPrimitive();
    }

    @Override
    public void writeTimestamp(Timestamp v) throws IOException {
        this.beginPrimitive();
        if (this.timestampWritable == null) {
            this.timestampWritable = new TimestampWritableV2();
        }
        this.timestampWritable.set(v);
        LazyTimestamp.writeUTF8(this.output, this.timestampWritable);
        this.finishPrimitive();
    }

    @Override
    public void writeHiveIntervalYearMonth(HiveIntervalYearMonth viyt) throws IOException {
        this.beginPrimitive();
        if (this.hiveIntervalYearMonthWritable == null) {
            this.hiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();
        }
        this.hiveIntervalYearMonthWritable.set(viyt);
        LazyHiveIntervalYearMonth.writeUTF8(this.output, this.hiveIntervalYearMonthWritable);
        this.finishPrimitive();
    }

    @Override
    public void writeHiveIntervalYearMonth(int totalMonths) throws IOException {
        this.beginPrimitive();
        if (this.hiveIntervalYearMonthWritable == null) {
            this.hiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();
        }
        this.hiveIntervalYearMonthWritable.set(totalMonths);
        LazyHiveIntervalYearMonth.writeUTF8(this.output, this.hiveIntervalYearMonthWritable);
        this.finishPrimitive();
    }

    @Override
    public void writeHiveIntervalDayTime(HiveIntervalDayTime vidt) throws IOException {
        this.beginPrimitive();
        if (this.hiveIntervalDayTimeWritable == null) {
            this.hiveIntervalDayTimeWritable = new HiveIntervalDayTimeWritable();
        }
        this.hiveIntervalDayTimeWritable.set(vidt);
        LazyHiveIntervalDayTime.writeUTF8(this.output, this.hiveIntervalDayTimeWritable);
        this.finishPrimitive();
    }

    @Override
    public void writeDecimal64(long decimal64Long, int scale) throws IOException {
        if (this.hiveDecimalWritable == null) {
            this.hiveDecimalWritable = new HiveDecimalWritable();
        }
        this.hiveDecimalWritable.deserialize64(decimal64Long, scale);
        this.writeHiveDecimal(this.hiveDecimalWritable, scale);
    }

    @Override
    public void writeHiveDecimal(HiveDecimal dec, int scale) throws IOException {
        this.beginPrimitive();
        if (this.decimalScratchBuffer == null) {
            this.decimalScratchBuffer = new byte[79];
        }
        LazyHiveDecimal.writeUTF8((OutputStream)this.output, dec, scale, this.decimalScratchBuffer);
        this.finishPrimitive();
    }

    @Override
    public void writeHiveDecimal(HiveDecimalWritable decWritable, int scale) throws IOException {
        this.beginPrimitive();
        if (this.decimalScratchBuffer == null) {
            this.decimalScratchBuffer = new byte[79];
        }
        LazyHiveDecimal.writeUTF8((OutputStream)this.output, decWritable, scale, this.decimalScratchBuffer);
        this.finishPrimitive();
    }

    private void beginComplex() {
        if (this.index > 0) {
            this.output.write(this.separators[this.currentLevel]);
        }
        this.indexStack.push(this.index);
        this.index = 0;
        ++this.currentLevel;
    }

    private void finishComplex() {
        --this.currentLevel;
        this.index = this.indexStack.pop();
        ++this.index;
    }

    @Override
    public void beginList(List list) {
        this.beginComplex();
    }

    @Override
    public void separateList() {
    }

    @Override
    public void finishList() {
        this.finishComplex();
    }

    @Override
    public void beginMap(Map<?, ?> map) {
        this.beginComplex();
        ++this.currentLevel;
    }

    @Override
    public void separateKey() {
        this.index = 0;
        this.output.write(this.separators[this.currentLevel]);
    }

    @Override
    public void separateKeyValuePair() {
        this.index = 0;
        this.output.write(this.separators[this.currentLevel - 1]);
    }

    @Override
    public void finishMap() {
        --this.currentLevel;
        this.finishComplex();
    }

    @Override
    public void beginStruct(List fieldValues) {
        this.beginComplex();
    }

    @Override
    public void separateStruct() {
    }

    @Override
    public void finishStruct() {
        this.finishComplex();
    }

    @Override
    public void beginUnion(int tag) throws IOException {
        this.beginComplex();
        this.writeInt(tag);
        this.output.write(this.separators[this.currentLevel]);
        this.index = 0;
    }

    @Override
    public void finishUnion() {
        this.finishComplex();
    }

    private void beginPrimitive() {
        if (this.index > 0) {
            this.output.write(this.separators[this.currentLevel]);
        }
    }

    private void finishPrimitive() {
        ++this.index;
    }
}

