/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.PathUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTable {
    private static final Logger LOG = LoggerFactory.getLogger(LoadTable.class);
    private final Context context;
    private final ReplLogger replLogger;
    private final TableContext tableContext;
    private final TaskTracker tracker;
    private final TableEvent event;

    public LoadTable(TableEvent event, Context context, ReplLogger replLogger, TableContext tableContext, TaskTracker limiter) throws SemanticException, IOException {
        this.event = event;
        this.context = context;
        this.replLogger = replLogger;
        this.tableContext = tableContext;
        this.tracker = new TaskTracker(limiter);
    }

    public TaskTracker tasks() throws SemanticException {
        try {
            if (this.event.shouldNotReplicate()) {
                return this.tracker;
            }
            String dbName = this.tableContext.dbNameToLoadIn;
            ImportTableDesc tableDesc = this.tableContext.overrideProperties(this.event.tableDesc(dbName));
            Table table = ImportSemanticAnalyzer.tableIfExists(tableDesc, this.context.hiveDb);
            Database parentDb = this.context.hiveDb.getDatabase(tableDesc.getDatabaseName());
            if (parentDb == null && !this.tableContext.waitOnPrecursor()) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(tableDesc.getDatabaseName()));
            }
            Task<?> tblRootTask = null;
            ReplUtils.ReplLoadOpType loadTblType = this.getLoadTableType(table);
            switch (loadTblType) {
                case LOAD_NEW: {
                    break;
                }
                case LOAD_REPLACE: {
                    tblRootTask = this.dropTableTask(table);
                    break;
                }
                case LOAD_SKIP: {
                    return this.tracker;
                }
            }
            if (tableDesc.getLocation() == null) {
                tableDesc.setLocation(this.location(tableDesc, parentDb));
            }
            this.newTableTasks(tableDesc, tblRootTask);
            Task<?> ckptTask = ReplUtils.getTableCheckpointTask(tableDesc, null, this.context.dumpDirectory, this.context.hiveConf);
            if (!ImportSemanticAnalyzer.isPartitioned(tableDesc)) {
                Task<?> replLogTask = ReplUtils.getTableReplLogTask(tableDesc, this.replLogger, this.context.hiveConf);
                ckptTask.addDependentTask(replLogTask);
            }
            this.tracker.addDependentTask(ckptTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private ReplUtils.ReplLoadOpType getLoadTableType(Table table) throws InvalidOperationException, HiveException {
        if (table == null) {
            return ReplUtils.ReplLoadOpType.LOAD_NEW;
        }
        if (ReplUtils.replCkptStatus(table.getDbName(), table.getParameters(), this.context.dumpDirectory)) {
            return ReplUtils.ReplLoadOpType.LOAD_SKIP;
        }
        return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
    }

    private void newTableTasks(ImportTableDesc tblDesc, Task<?> tblRootTask) throws Exception {
        Table table = tblDesc.toTable(this.context.hiveConf);
        ReplicationSpec replicationSpec = this.event.replicationSpec();
        Task<? extends Serializable> createTableTask = tblDesc.getCreateTableTask(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), this.context.hiveConf);
        if (tblRootTask == null) {
            tblRootTask = createTableTask;
        } else {
            tblRootTask.addDependentTask(createTableTask);
        }
        if (replicationSpec.isMetadataOnly()) {
            this.tracker.addTask(tblRootTask);
            return;
        }
        Task<? extends Serializable> parentTask = createTableTask;
        if (replicationSpec.isTransactionalTableDump()) {
            List<String> partNames = ImportSemanticAnalyzer.isPartitioned(tblDesc) ? this.event.partitions(tblDesc) : null;
            ReplTxnWork replTxnWork = new ReplTxnWork(tblDesc.getDatabaseName(), tblDesc.getTableName(), partNames, replicationSpec.getValidWriteIdList(), ReplTxnWork.OperationType.REPL_WRITEID_STATE);
            Task<ReplTxnWork> replTxnTask = TaskFactory.get(replTxnWork, this.context.hiveConf);
            parentTask.addDependentTask(replTxnTask);
            parentTask = replTxnTask;
        }
        if (!ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
            LOG.debug("adding dependent ReplTxnTask/CopyWork/MoveWork for table");
            Task<?> loadTableTask = this.loadTableTask(table, replicationSpec, new Path(tblDesc.getLocation()), this.event.metadataPath());
            parentTask.addDependentTask(loadTableTask);
        }
        this.tracker.addTask(tblRootTask);
    }

    private String location(ImportTableDesc tblDesc, Database parentDb) throws MetaException, SemanticException {
        if (!this.tableContext.waitOnPrecursor()) {
            return this.context.warehouse.getDefaultTablePath(parentDb, tblDesc.getTableName(), tblDesc.isExternal()).toString();
        }
        Path tablePath = this.context.warehouse.getDefaultTablePath(tblDesc.getDatabaseName(), tblDesc.getTableName(), tblDesc.isExternal());
        return this.context.warehouse.getDnsPath(tablePath).toString();
    }

    private Task<?> loadTableTask(Table table, ReplicationSpec replicationSpec, Path tgtPath, Path fromURI) {
        Path dataPath = new Path(fromURI, "data");
        Path tmpPath = PathUtils.getExternalTmpPath(tgtPath, this.context.pathInfo);
        Task<?> copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, dataPath, tmpPath, this.context.hiveConf);
        MoveWork moveWork = new MoveWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), null, null, false);
        if (AcidUtils.isTransactionalTable(table)) {
            LoadMultiFilesDesc loadFilesWork = new LoadMultiFilesDesc(Collections.singletonList(tmpPath), Collections.singletonList(tgtPath), true, null, null);
            moveWork.setMultiFilesDesc(loadFilesWork);
        } else {
            LoadTableDesc loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), new TreeMap<String, String>(), replicationSpec.isReplace() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, (Long)0L);
            moveWork.setLoadTableWork(loadTableWork);
        }
        Task<MoveWork> loadTableTask = TaskFactory.get(moveWork, this.context.hiveConf);
        copyTask.addDependentTask(loadTableTask);
        return copyTask;
    }

    private Task<?> dropTableTask(Table table) {
        assert (table != null);
        DropTableDesc dropTblDesc = new DropTableDesc(table.getFullyQualifiedName(), table.getTableType(), true, false, this.event.replicationSpec());
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), dropTblDesc), this.context.hiveConf);
    }
}

