/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.fm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javolution.util.FastBitSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.fm.FMSketchUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMSketch
implements NumDistinctValueEstimator {
    static final Logger LOG = LoggerFactory.getLogger((String)FMSketch.class.getName());
    public static final int BIT_VECTOR_SIZE = 31;
    private static final double PHI = 0.77351;
    private final int[] a;
    private final int[] b;
    private final FastBitSet[] bitVector;
    private final Random aValue;
    private final Random bValue;
    private int numBitVectors;

    public FMSketch(int numBitVectors) {
        int i;
        this.numBitVectors = numBitVectors;
        this.bitVector = new FastBitSet[numBitVectors];
        for (i = 0; i < numBitVectors; ++i) {
            this.bitVector[i] = new FastBitSet(31);
        }
        this.a = new int[numBitVectors];
        this.b = new int[numBitVectors];
        this.aValue = new Random(99397L);
        this.bValue = new Random(9876413L);
        for (i = 0; i < numBitVectors; ++i) {
            int randVal;
            while ((randVal = this.aValue.nextInt()) % 2 == 0) {
            }
            this.a[i] = randVal;
            while ((randVal = this.bValue.nextInt()) % 2 == 0) {
            }
            this.b[i] = randVal;
            if (this.a[i] < 0) {
                this.a[i] = this.a[i] + 0x40000000;
            }
            if (this.b[i] >= 0) continue;
            this.b[i] = this.b[i] + 0x40000000;
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.numBitVectors; ++i) {
            this.bitVector[i].clear();
        }
    }

    public FastBitSet getBitVector(int index) {
        return this.bitVector[index];
    }

    public FastBitSet setBitVector(FastBitSet fastBitSet, int index) {
        this.bitVector[index] = fastBitSet;
        return this.bitVector[index];
    }

    public int getNumBitVectors() {
        return this.numBitVectors;
    }

    public int getBitVectorSize() {
        return 31;
    }

    public void printNumDistinctValueEstimator() {
        String t = new String();
        LOG.debug("NumDistinctValueEstimator");
        LOG.debug("Number of Vectors: {}", (Object)this.numBitVectors);
        LOG.debug("Vector Size: {}", (Object)31);
        for (int i = 0; i < this.numBitVectors; ++i) {
            t = t + this.bitVector[i].toString();
        }
        LOG.debug("Serialized Vectors: ");
        LOG.debug(t);
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            FMSketchUtils.serializeFM(bos, this);
            byte[] result = bos.toByteArray();
            bos.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NumDistinctValueEstimator deserialize(byte[] buf) {
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            FMSketch n = FMSketchUtils.deserializeFM(is);
            ((InputStream)is).close();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int generateHash(long v, int hashNum) {
        int mod = Integer.MAX_VALUE;
        long tempHash = (long)this.a[hashNum] * v + (long)this.b[hashNum];
        int hash = (int)(tempHash %= (long)mod);
        if (hash < 0) {
            hash += mod;
        }
        return hash;
    }

    private int generateHashForPCSA(long v) {
        int mod = 0x20000000;
        long tempHash = (long)this.a[0] * v + (long)this.b[0];
        int hash = (int)(tempHash %= (long)mod);
        if (hash < 0) {
            hash = hash + mod + 1;
        }
        return hash;
    }

    @Override
    public void addToEstimator(long v) {
        for (int i = 0; i < this.numBitVectors; ++i) {
            int index;
            int hash = this.generateHash(v, i);
            for (index = 0; index < 31 && hash % 2 == 0; ++index) {
                hash >>= 1;
            }
            this.bitVector[i].set(index);
        }
    }

    public void addToEstimatorPCSA(long v) {
        int index;
        int hash = this.generateHashForPCSA(v);
        int rho = hash / this.numBitVectors;
        for (index = 0; index < 31 && rho % 2 == 0; ++index) {
            rho >>= 1;
        }
        this.bitVector[hash % this.numBitVectors].set(index);
    }

    @Override
    public void addToEstimator(double d) {
        int v = new Double(d).hashCode();
        this.addToEstimator(v);
    }

    public void addToEstimatorPCSA(double d) {
        int v = new Double(d).hashCode();
        this.addToEstimatorPCSA(v);
    }

    @Override
    public void addToEstimator(HiveDecimal decimal) {
        int v = decimal.hashCode();
        this.addToEstimator(v);
    }

    public void addToEstimatorPCSA(HiveDecimal decimal) {
        int v = decimal.hashCode();
        this.addToEstimatorPCSA(v);
    }

    public void mergeEstimators(FMSketch o) {
        for (int i = 0; i < this.numBitVectors; ++i) {
            this.bitVector[i].or(o.getBitVector(i));
        }
    }

    public long estimateNumDistinctValuesPCSA() {
        double numDistinctValues = 0.0;
        long S = 0L;
        for (int i = 0; i < this.numBitVectors; ++i) {
            int index;
            for (index = 0; this.bitVector[i].get(index) && index < 31; ++index) {
            }
            S += (long)index;
        }
        numDistinctValues = (double)this.numBitVectors / 0.77351 * Math.pow(2.0, S / (long)this.numBitVectors);
        return (long)numDistinctValues;
    }

    @Override
    public long estimateNumDistinctValues() {
        int sumLeastSigZero = 0;
        for (int i = 0; i < this.numBitVectors; ++i) {
            int leastSigZero = this.bitVector[i].nextClearBit(0);
            sumLeastSigZero += leastSigZero;
        }
        double avgLeastSigZero = (double)sumLeastSigZero / ((double)this.numBitVectors * 1.0) - Math.log(0.77351) / Math.log(2.0);
        double numDistinctValues = Math.pow(2.0, avgLeastSigZero);
        return (long)numDistinctValues;
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    static int lengthFor(JavaDataModel model, Integer numVector) {
        int length = model.object();
        length += model.primitive1() * 2;
        length += model.primitive2();
        length += model.lengthForRandom() * 2;
        if (numVector == null) {
            numVector = 16;
        }
        if (numVector > 0) {
            length += model.array() * 3;
            length += model.primitive1() * numVector * 2;
            length += (model.object() + model.array() + model.primitive1() + model.primitive2()) * numVector;
        }
        return length;
    }

    @Override
    public int lengthFor(JavaDataModel model) {
        return FMSketch.lengthFor(model, this.getNumBitVectors());
    }

    @Override
    public void mergeEstimators(NumDistinctValueEstimator o) {
        for (int i = 0; i < this.numBitVectors; ++i) {
            this.bitVector[i].or(((FMSketch)o).getBitVector(i));
        }
    }

    @Override
    public void addToEstimator(String s) {
        int v = s.hashCode();
        this.addToEstimator(v);
    }

    @Override
    public boolean canMerge(NumDistinctValueEstimator o) {
        return o instanceof FMSketch && this.numBitVectors == ((FMSketch)o).numBitVectors;
    }
}

