/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class StringGroupScalarGreaterEqualStringGroupColumnBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected byte[] value;
    protected int outputColumn;

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        block13: {
            int[] start;
            int[] length;
            byte[][] vector;
            int n;
            boolean[] nullPos;
            int[] sel;
            block14: {
                BytesColumnVector inputColVector;
                block12: {
                    if (this.childExpressions != null) {
                        super.evaluateChildren(batch);
                    }
                    inputColVector = (BytesColumnVector)batch.cols[this.colNum];
                    LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
                    sel = batch.selected;
                    nullPos = inputColVector.isNull;
                    boolean[] outNull = outputColVector.isNull;
                    n = batch.size;
                    vector = inputColVector.vector;
                    length = inputColVector.length;
                    start = inputColVector.start;
                    long[] outVector = outputColVector.vector;
                    if (n == 0) {
                        return;
                    }
                    outputColVector.isRepeating = false;
                    if (!inputColVector.noNulls) break block12;
                    outputColVector.noNulls = true;
                    if (inputColVector.isRepeating) {
                        outputColVector.isRepeating = true;
                        outVector[0] = StringExpr.compare(this.value, 0, this.value.length, vector[0], start[0], length[0]) >= 0 ? 1L : 0L;
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) >= 0 ? 1L : 0L;
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) >= 0 ? 1L : 0L;
                        }
                    }
                    break block13;
                }
                outputColVector.noNulls = false;
                if (!inputColVector.isRepeating) break block14;
                outputColVector.isRepeating = true;
                outNull[0] = nullPos[0];
                if (nullPos[0]) break block13;
                outVector[0] = StringExpr.compare(this.value, 0, this.value.length, vector[0], start[0], length[0]) >= 0 ? 1L : 0L;
                break block13;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outNull[i] = nullPos[i];
                    if (nullPos[i]) continue;
                    outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) >= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outNull[i] = nullPos[i];
                    if (nullPos[i]) continue;
                    outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) >= 0 ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + StringGroupScalarGreaterEqualStringGroupColumnBase.displayUtf8Bytes(this.value) + ", col " + this.colNum;
    }
}

