/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.io.Text;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileFormatException;
import org.apache.orc.FileMetaInfo;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.WriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderImpl
implements Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderImpl.class);
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    protected final FileSystem fileSystem;
    private final long maxLength;
    protected final Path path;
    protected final CompressionKind compressionKind;
    protected final CompressionCodec codec;
    protected final int bufferSize;
    private final List<OrcProto.StripeStatistics> stripeStats;
    private final int metadataSize;
    protected final List<OrcProto.Type> types;
    private final TypeDescription schema;
    private final List<OrcProto.UserMetadataItem> userMetadata;
    private final List<OrcProto.ColumnStatistics> fileStats;
    private final List<StripeInformation> stripes;
    protected final int rowIndexStride;
    private final long contentLength;
    private final long numberOfRows;
    private long deserializedSize = -1L;
    protected final Configuration conf;
    private final List<Integer> versionList;
    private final OrcFile.WriterVersion writerVersion;
    private final ByteBuffer footerMetaAndPsBuffer;

    @Override
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public List<String> getMetadataKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            result.add(item.getName());
        }
        return result;
    }

    @Override
    public ByteBuffer getMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return item.getValue().asReadOnlyByteBuffer();
        }
        throw new IllegalArgumentException("Can't find user metadata " + key);
    }

    @Override
    public boolean hasMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    @Override
    public int getCompressionSize() {
        return this.bufferSize;
    }

    @Override
    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.types;
    }

    @Override
    public OrcFile.Version getFileVersion() {
        for (OrcFile.Version version : OrcFile.Version.values()) {
            if (this.versionList == null || this.versionList.isEmpty() || version.getMajor() != this.versionList.get(0).intValue() || version.getMinor() != this.versionList.get(1).intValue()) continue;
            return version;
        }
        return OrcFile.Version.V_0_11;
    }

    @Override
    public OrcFile.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Override
    public int getRowIndexStride() {
        return this.rowIndexStride;
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        ColumnStatistics[] result = new ColumnStatistics[this.types.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ColumnStatisticsImpl.deserialize(this.fileStats.get(i));
        }
        return result;
    }

    public TypeDescription getSchema() {
        return this.schema;
    }

    protected static void ensureOrcFooter(FSDataInputStream in, Path path, int psLen, ByteBuffer buffer) throws IOException {
        int magicLength = "ORC".length();
        int fullLength = magicLength + 1;
        if (psLen < fullLength || buffer.remaining() < fullLength) {
            throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - fullLength;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)magicLength).equals("ORC")) {
            byte[] header = new byte[magicLength];
            in.readFully(0L, header, 0, magicLength);
            if (!Text.decode((byte[])header, (int)0, (int)magicLength).equals("ORC")) {
                throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript.");
            }
        }
    }

    private static String versionString(List<Integer> version) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < version.size(); ++i) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(version.get(i));
        }
        return buffer.toString();
    }

    protected static void checkOrcVersion(Logger log, Path path, List<Integer> version) {
        if (version.size() >= 1) {
            int major = version.get(0);
            int minor = 0;
            if (version.size() >= 2) {
                minor = version.get(1);
            }
            if (major > OrcFile.Version.CURRENT.getMajor() || major == OrcFile.Version.CURRENT.getMajor() && minor > OrcFile.Version.CURRENT.getMinor()) {
                log.warn(path + " was written by a future Hive version " + ReaderImpl.versionString(version) + ". This file may not be readable by this version of Hive.");
            }
        }
    }

    public ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        FileSystem fs = options.getFilesystem();
        if (fs == null) {
            fs = path.getFileSystem(options.getConfiguration());
        }
        this.fileSystem = fs;
        this.path = path;
        this.conf = options.getConfiguration();
        this.maxLength = options.getMaxLength();
        FileMetadata fileMetadata = options.getFileMetadata();
        if (fileMetadata != null) {
            this.compressionKind = fileMetadata.getCompressionKind();
            this.bufferSize = fileMetadata.getCompressionBufferSize();
            this.codec = WriterImpl.createCodec(this.compressionKind);
            this.metadataSize = fileMetadata.getMetadataSize();
            this.stripeStats = fileMetadata.getStripeStats();
            this.versionList = fileMetadata.getVersionList();
            this.writerVersion = OrcFile.WriterVersion.from(fileMetadata.getWriterVersionNum());
            this.types = fileMetadata.getTypes();
            this.rowIndexStride = fileMetadata.getRowIndexStride();
            this.contentLength = fileMetadata.getContentLength();
            this.numberOfRows = fileMetadata.getNumberOfRows();
            this.fileStats = fileMetadata.getFileStats();
            this.stripes = fileMetadata.getStripes();
            this.userMetadata = null;
            this.footerMetaAndPsBuffer = null;
        } else {
            FileMetaInfo footerMetaData;
            if (options.getFileMetaInfo() != null) {
                footerMetaData = options.getFileMetaInfo();
                this.footerMetaAndPsBuffer = null;
            } else {
                footerMetaData = ReaderImpl.extractMetaInfoFromFooter(fs, path, options.getMaxLength());
                this.footerMetaAndPsBuffer = footerMetaData.footerMetaAndPsBuffer;
            }
            MetaInfoObjExtractor rInfo = new MetaInfoObjExtractor(footerMetaData.compressionType, footerMetaData.bufferSize, footerMetaData.metadataSize, footerMetaData.footerBuffer);
            this.compressionKind = rInfo.compressionKind;
            this.codec = rInfo.codec;
            this.bufferSize = rInfo.bufferSize;
            this.metadataSize = rInfo.metadataSize;
            this.stripeStats = rInfo.metadata.getStripeStatsList();
            this.types = rInfo.footer.getTypesList();
            this.rowIndexStride = rInfo.footer.getRowIndexStride();
            this.contentLength = rInfo.footer.getContentLength();
            this.numberOfRows = rInfo.footer.getNumberOfRows();
            this.userMetadata = rInfo.footer.getMetadataList();
            this.fileStats = rInfo.footer.getStatisticsList();
            this.versionList = footerMetaData.versionList;
            this.writerVersion = footerMetaData.writerVersion;
            this.stripes = ReaderImpl.convertProtoStripesToStripes(rInfo.footer.getStripesList());
        }
        this.schema = OrcUtils.convertTypeFromProtobuf(this.types, (int)0);
    }

    public static OrcFile.WriterVersion getWriterVersion(int writerVersion) {
        for (OrcFile.WriterVersion version : OrcFile.WriterVersion.values()) {
            if (version.getId() != writerVersion) continue;
            return version;
        }
        return OrcFile.WriterVersion.FUTURE;
    }

    private static OrcProto.Footer extractFooter(ByteBuffer bb, int footerAbsPos, int footerSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(footerAbsPos);
        bb.limit(footerAbsPos + footerSize);
        return OrcProto.Footer.parseFrom(InStream.createCodedInputStream("footer", Lists.newArrayList(new BufferChunk(bb, 0L)), footerSize, codec, bufferSize));
    }

    private static OrcProto.Metadata extractMetadata(ByteBuffer bb, int metadataAbsPos, int metadataSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(metadataAbsPos);
        bb.limit(metadataAbsPos + metadataSize);
        return OrcProto.Metadata.parseFrom(InStream.createCodedInputStream("metadata", Lists.newArrayList(new BufferChunk(bb, 0L)), metadataSize, codec, bufferSize));
    }

    private static OrcProto.PostScript extractPostScript(ByteBuffer bb, Path path, int psLen, int psAbsOffset) throws IOException {
        assert (bb.hasArray());
        CodedInputStream in = CodedInputStream.newInstance(bb.array(), bb.arrayOffset() + psAbsOffset, psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
        ReaderImpl.checkOrcVersion(LOG, path, ps.getVersionList());
        switch (ps.getCompression()) {
            case NONE: {
                break;
            }
            case ZLIB: {
                break;
            }
            case SNAPPY: {
                break;
            }
            case LZO: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression");
            }
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileMetaInfo extractMetaInfoFromFooter(FileSystem fs, Path path, long maxFileLength) throws IOException {
        FSDataInputStream file = fs.open(path);
        ByteBuffer buffer = null;
        ByteBuffer fullFooterBuffer = null;
        OrcProto.PostScript ps = null;
        OrcFile.WriterVersion writerVersion = null;
        try {
            long size = maxFileLength == Long.MAX_VALUE ? fs.getFileStatus(path).getLen() : maxFileLength;
            int readSize = (int)Math.min(size, 16384L);
            buffer = ByteBuffer.allocate(readSize);
            assert (buffer.position() == 0);
            file.readFully(size - (long)readSize, buffer.array(), buffer.arrayOffset(), readSize);
            buffer.position(0);
            int psLen = buffer.get(readSize - 1) & 0xFF;
            ReaderImpl.ensureOrcFooter(file, path, psLen, buffer);
            int psOffset = readSize - 1 - psLen;
            ps = ReaderImpl.extractPostScript(buffer, path, psLen, psOffset);
            int footerSize = (int)ps.getFooterLength();
            int metadataSize = (int)ps.getMetadataLength();
            writerVersion = ReaderImpl.extractWriterVersion(ps);
            int extra = Math.max(0, psLen + 1 + footerSize + metadataSize - readSize);
            if (extra > 0) {
                ByteBuffer extraBuf = ByteBuffer.allocate(extra + readSize);
                file.readFully(size - (long)readSize - (long)extra, extraBuf.array(), extraBuf.arrayOffset() + extraBuf.position(), extra);
                extraBuf.position(extra);
                extraBuf.put(buffer);
                buffer = extraBuf;
                buffer.position(0);
                fullFooterBuffer = buffer.slice();
                buffer.limit(footerSize + metadataSize);
            } else {
                buffer.position(psOffset - footerSize - metadataSize);
                fullFooterBuffer = buffer.slice();
                buffer.limit(psOffset);
            }
            buffer.mark();
        }
        finally {
            try {
                file.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close the file after another error", (Throwable)ex);
            }
        }
        return new FileMetaInfo(ps.getCompression().toString(), (int)ps.getCompressionBlockSize(), (int)ps.getMetadataLength(), buffer, ps.getVersionList(), writerVersion, fullFooterBuffer);
    }

    protected static OrcFile.WriterVersion extractWriterVersion(OrcProto.PostScript ps) {
        return ps.hasWriterVersion() ? ReaderImpl.getWriterVersion(ps.getWriterVersion()) : OrcFile.WriterVersion.ORIGINAL;
    }

    protected static List<StripeInformation> convertProtoStripesToStripes(List<OrcProto.StripeInformation> stripes) {
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>(stripes.size());
        for (OrcProto.StripeInformation info : stripes) {
            result.add(new StripeInformationImpl(info));
        }
        return result;
    }

    @Override
    public ByteBuffer getSerializedFileFooter() {
        return this.footerMetaAndPsBuffer;
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rows(new Reader.Options());
    }

    public RecordReader rows(Reader.Options options) throws IOException {
        LOG.info("Reading ORC rows from " + this.path + " with " + options);
        boolean[] include = options.getInclude();
        if (include == null) {
            include = new boolean[this.types.size()];
            Arrays.fill(include, true);
            options.include(include);
        }
        return new RecordReaderImpl(this, options);
    }

    @Override
    public long getRawDataSize() {
        if (this.deserializedSize == -1L) {
            ArrayList<Integer> indices = Lists.newArrayList();
            for (int i = 0; i < this.fileStats.size(); ++i) {
                indices.add(i);
            }
            this.deserializedSize = this.getRawDataSizeFromColIndices(indices);
        }
        return this.deserializedSize;
    }

    @Override
    public long getRawDataSizeFromColIndices(List<Integer> colIndices) {
        return ReaderImpl.getRawDataSizeFromColIndices(colIndices, this.types, this.fileStats);
    }

    public static long getRawDataSizeFromColIndices(List<Integer> colIndices, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) {
        long result = 0L;
        for (int colIdx : colIndices) {
            result += ReaderImpl.getRawDataSizeOfColumn(colIdx, types, stats);
        }
        return result;
    }

    private static long getRawDataSizeOfColumn(int colIdx, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) {
        OrcProto.ColumnStatistics colStat = stats.get(colIdx);
        long numVals = colStat.getNumberOfValues();
        OrcProto.Type type = types.get(colIdx);
        switch (type.getKind()) {
            case BINARY: {
                return colStat.getBinaryStatistics().getSum();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                numVals = numVals == 0L ? 1L : numVals;
                int avgStrLen = (int)(colStat.getStringStatistics().getSum() / numVals);
                return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgStrLen);
            }
            case TIMESTAMP: {
                return numVals * (long)JavaDataModel.get().lengthOfTimestamp();
            }
            case DATE: {
                return numVals * (long)JavaDataModel.get().lengthOfDate();
            }
            case DECIMAL: {
                return numVals * (long)JavaDataModel.get().lengthOfDecimal();
            }
            case DOUBLE: 
            case LONG: {
                return numVals * (long)JavaDataModel.get().primitive2();
            }
            case FLOAT: 
            case INT: 
            case SHORT: 
            case BOOLEAN: 
            case BYTE: {
                return numVals * (long)JavaDataModel.get().primitive1();
            }
        }
        LOG.debug("Unknown primitive category: " + type.getKind());
        return 0L;
    }

    @Override
    public long getRawDataSizeOfColumns(List<String> colNames) {
        List<Integer> colIndices = this.getColumnIndicesFromNames(colNames);
        return this.getRawDataSizeFromColIndices(colIndices);
    }

    private List<Integer> getColumnIndicesFromNames(List<String> colNames) {
        OrcProto.Type type = this.types.get(0);
        ArrayList<Integer> colIndices = Lists.newArrayList();
        List<String> fieldNames = type.getFieldNamesList();
        for (String colName : colNames) {
            if (!fieldNames.contains(colName)) {
                String s = "Cannot find field for: " + colName + " in ";
                for (String fn : fieldNames) {
                    s = s + fn + ", ";
                }
                LOG.warn(s);
                continue;
            }
            int fieldIdx = fieldNames.indexOf(colName);
            int idxStart = type.getSubtypes(fieldIdx);
            int idxEnd = fieldIdx + 1 > fieldNames.size() - 1 ? this.getLastIdx() + 1 : type.getSubtypes(fieldIdx + 1);
            if (idxStart == idxEnd) {
                colIndices.add(idxStart);
                continue;
            }
            for (int i = idxStart; i < idxEnd; ++i) {
                colIndices.add(i);
            }
        }
        return colIndices;
    }

    private int getLastIdx() {
        HashSet<Integer> indices = new HashSet<Integer>();
        for (OrcProto.Type type : this.types) {
            indices.addAll(type.getSubtypesList());
        }
        return (Integer)Collections.max(indices);
    }

    @Override
    public List<OrcProto.StripeStatistics> getOrcProtoStripeStatistics() {
        return this.stripeStats;
    }

    @Override
    public List<OrcProto.ColumnStatistics> getOrcProtoFileStatistics() {
        return this.fileStats;
    }

    @Override
    public List<StripeStatistics> getStripeStatistics() {
        ArrayList<StripeStatistics> result = new ArrayList<StripeStatistics>();
        for (OrcProto.StripeStatistics ss : this.stripeStats) {
            result.add(new StripeStatistics(ss.getColStatsList()));
        }
        return result;
    }

    public List<OrcProto.UserMetadataItem> getOrcProtoUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public List<Integer> getVersionList() {
        return this.versionList;
    }

    @Override
    public int getMetadataSize() {
        return this.metadataSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ORC Reader(");
        buffer.append(this.path);
        if (this.maxLength != -1L) {
            buffer.append(", ");
            buffer.append(this.maxLength);
        }
        buffer.append(")");
        return buffer.toString();
    }

    private static class MetaInfoObjExtractor {
        final CompressionKind compressionKind;
        final CompressionCodec codec;
        final int bufferSize;
        final int metadataSize;
        final OrcProto.Metadata metadata;
        final OrcProto.Footer footer;

        MetaInfoObjExtractor(String codecStr, int bufferSize, int metadataSize, ByteBuffer footerBuffer) throws IOException {
            this.compressionKind = CompressionKind.valueOf(codecStr.toUpperCase());
            this.bufferSize = bufferSize;
            this.codec = WriterImpl.createCodec(this.compressionKind);
            this.metadataSize = metadataSize;
            int position = footerBuffer.position();
            int footerBufferSize = footerBuffer.limit() - footerBuffer.position() - metadataSize;
            this.metadata = ReaderImpl.extractMetadata(footerBuffer, position, metadataSize, this.codec, bufferSize);
            this.footer = ReaderImpl.extractFooter(footerBuffer, position + metadataSize, footerBufferSize, this.codec, bufferSize);
            footerBuffer.position(position);
        }
    }

    public static class StripeInformationImpl
    implements StripeInformation {
        private final OrcProto.StripeInformation stripe;

        public StripeInformationImpl(OrcProto.StripeInformation stripe) {
            this.stripe = stripe;
        }

        @Override
        public long getOffset() {
            return this.stripe.getOffset();
        }

        @Override
        public long getLength() {
            return this.stripe.getDataLength() + this.getIndexLength() + this.getFooterLength();
        }

        @Override
        public long getDataLength() {
            return this.stripe.getDataLength();
        }

        @Override
        public long getFooterLength() {
            return this.stripe.getFooterLength();
        }

        @Override
        public long getIndexLength() {
            return this.stripe.getIndexLength();
        }

        @Override
        public long getNumberOfRows() {
            return this.stripe.getNumberOfRows();
        }

        public String toString() {
            return "offset: " + this.getOffset() + " data: " + this.getDataLength() + " rows: " + this.getNumberOfRows() + " tail: " + this.getFooterLength() + " index: " + this.getIndexLength();
        }
    }
}

