/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveMultiJoin;

public class HiveRelFieldTrimmer
extends RelFieldTrimmer {
    protected static final Log LOG = LogFactory.getLog(HiveRelFieldTrimmer.class);

    public HiveRelFieldTrimmer(SqlValidator validator, RelBuilder relBuilder) {
        super(validator, relBuilder);
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveMultiJoin join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = join.getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept((RexVisitor)inputFinder);
        ImmutableBitSet fieldsUsedPlus = inputFinder.inputBitSet.build();
        int inputStartPos = 0;
        int changeCount = 0;
        int newFieldCount = 0;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            Iterator iterator = fieldsUsedPlus.iterator();
            while (iterator.hasNext()) {
                int bit = (Integer)iterator.next();
                if (bit < inputStartPos || bit >= inputStartPos + inputFieldCount) continue;
                inputFieldsUsed.set(bit - inputStartPos);
            }
            Set inputExtraFields = Collections.emptySet();
            RelFieldTrimmer.TrimResult trimResult = this.trimChild((RelNode)join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add((RelNode)trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            inputStartPos += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount();
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)newFieldCount);
        int offset = 0;
        int newOffset = 0;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount();
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new RelFieldTrimmer.TrimResult((RelNode)join, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, newInputs.toArray(new RelNode[newInputs.size()]));
        RexNode newConditionExpr = (RexNode)conditionExpr.accept((RexVisitor)shuttle);
        RelDataType newRowType = RelOptUtil.permute((RelDataTypeFactory)join.getCluster().getTypeFactory(), (RelDataType)join.getRowType(), (Mapping)mapping);
        HiveMultiJoin newJoin = new HiveMultiJoin(join.getCluster(), newInputs, newConditionExpr, newRowType, join.getJoinInputs(), join.getJoinTypes(), join.getJoinFilters());
        return new RelFieldTrimmer.TrimResult((RelNode)newJoin, mapping);
    }
}

