/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;

public final class HiveJoinAddNotNullRule
extends RelOptRule {
    private static final String NOT_NULL_FUNC_NAME = "isnotnull";
    public static final HiveJoinAddNotNullRule INSTANCE = new HiveJoinAddNotNullRule(HiveRelFactories.HIVE_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public HiveJoinAddNotNullRule(RelFactories.FilterFactory filterFactory) {
        super(HiveJoinAddNotNullRule.operand(Join.class, (RelOptRuleOperand)HiveJoinAddNotNullRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveJoinAddNotNullRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveJoinAddNotNullRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveJoinAddNotNullRule.any())}));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        Join join = (Join)call.rel(0);
        RelNode leftInput = call.rel(1);
        RelNode rightInput = call.rel(2);
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        try {
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        }
        catch (CalciteSemanticException e) {
            return;
        }
        HashSet<Integer> joinLeftKeyPositions = new HashSet<Integer>();
        HashSet<Integer> joinRightKeyPositions = new HashSet<Integer>();
        for (int i = 0; i < joinPredInfo.getEquiJoinPredicateElements().size(); ++i) {
            HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(i);
            joinLeftKeyPositions.addAll(joinLeafPredInfo.getProjsFromLeftPartOfJoinKeysInChildSchema());
            joinRightKeyPositions.addAll(joinLeafPredInfo.getProjsFromRightPartOfJoinKeysInChildSchema());
        }
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        Map<String, RexNode> newLeftConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, leftInput, joinLeftKeyPositions);
        Map<String, RexNode> newRightConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, rightInput, joinRightKeyPositions);
        if (newLeftConditions == null && newRightConditions == null) {
            return;
        }
        if (newLeftConditions != null) {
            if (leftInput instanceof HiveFilter) {
                leftInput = leftInput.getInput(0);
            }
            leftInput = HiveJoinAddNotNullRule.createHiveFilterConjunctiveCondition(this.filterFactory, rexBuilder, leftInput, newLeftConditions.values());
        }
        if (newRightConditions != null) {
            if (rightInput instanceof HiveFilter) {
                rightInput = rightInput.getInput(0);
            }
            rightInput = HiveJoinAddNotNullRule.createHiveFilterConjunctiveCondition(this.filterFactory, rexBuilder, rightInput, newRightConditions.values());
        }
        Join newJoin = join.copy(join.getTraitSet(), join.getCondition(), leftInput, rightInput, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newJoin);
        call.transformTo((RelNode)newJoin);
    }

    private static Map<String, RexNode> getNotNullConditions(RelOptCluster cluster, RexBuilder rexBuilder, RelNode input, Set<Integer> inputKeyPositions) {
        boolean added = false;
        Map<Object, Object> newConditions = input instanceof HiveFilter ? HiveJoinAddNotNullRule.splitCondition(((HiveFilter)input).getCondition()) : new HashMap();
        for (int pos : inputKeyPositions) {
            RexNode cond;
            String digest;
            RelDataType keyType = ((RelDataTypeField)input.getRowType().getFieldList().get(pos)).getType();
            if (!keyType.isNullable() || newConditions.containsKey(digest = (cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexBuilder.makeInputRef(input, pos)})).toString())) continue;
            newConditions.put(digest, cond);
            added = true;
        }
        if (!added) {
            return null;
        }
        return newConditions;
    }

    private static Map<String, RexNode> splitCondition(RexNode condition) {
        HashMap<String, RexNode> newConditions = new HashMap<String, RexNode>();
        if (condition.getKind() == SqlKind.AND) {
            for (RexNode node : ((RexCall)condition).getOperands()) {
                newConditions.put(node.toString(), node);
            }
        } else {
            newConditions.put(condition.toString(), condition);
        }
        return newConditions;
    }

    private static RelNode createHiveFilterConjunctiveCondition(RelFactories.FilterFactory filterFactory, RexBuilder rexBuilder, RelNode input, Collection<RexNode> conditions) {
        RexNode newCondition = RexUtil.composeConjunction((RexBuilder)rexBuilder, conditions, (boolean)false);
        return filterFactory.createFilter(input, newCondition);
    }
}

