/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.IntList;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveAggregate
extends Aggregate
implements HiveRelNode {
    public HiveAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, indicator, groupSet, groupSets, aggCalls);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new HiveAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return RelMetadataQuery.getNonCumulativeCost((RelNode)this);
    }

    public double getRows() {
        return RelMetadataQuery.getDistinctRowCount((RelNode)this, (ImmutableBitSet)this.groupSet, (RexNode)this.getCluster().getRexBuilder().makeLiteral(true));
    }

    public boolean isBucketedInput() {
        return RelMetadataQuery.distribution((RelNode)this.getInput()).getKeys().containsAll(this.groupSet.asList());
    }

    protected RelDataType deriveRowType() {
        return HiveAggregate.deriveRowType(this.getCluster().getTypeFactory(), this.getInput().getRowType(), this.indicator, this.groupSet, this.groupSets, this.aggCalls);
    }

    public static RelDataType deriveRowType(RelDataTypeFactory typeFactory, RelDataType inputRowType, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        int groupKey;
        IntList groupList = groupSet.toList();
        assert (groupList.size() == groupSet.cardinality());
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        List fieldList = inputRowType.getFieldList();
        HashSet<String> containedNames = Sets.newHashSet();
        Iterator iterator = groupList.iterator();
        while (iterator.hasNext()) {
            groupKey = (Integer)iterator.next();
            containedNames.add(((RelDataTypeField)fieldList.get(groupKey)).getName());
            builder.add((RelDataTypeField)fieldList.get(groupKey));
        }
        if (indicator) {
            iterator = groupList.iterator();
            while (iterator.hasNext()) {
                groupKey = (Integer)iterator.next();
                RelDataType booleanType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
                String name = "i$" + ((RelDataTypeField)fieldList.get(groupKey)).getName();
                int i = 0;
                while (containedNames.contains(name)) {
                    name = name + "_" + i++;
                }
                containedNames.add(name);
                builder.add(name, booleanType);
            }
        }
        for (Ord aggCall : Ord.zip(aggCalls)) {
            String name = ((AggregateCall)aggCall.e).name != null ? ((AggregateCall)aggCall.e).name : "$f" + (groupList.size() + aggCall.i);
            int i = 0;
            while (containedNames.contains(name)) {
                name = name + "_" + i++;
            }
            containedNames.add(name);
            builder.add(name, ((AggregateCall)aggCall.e).type);
        }
        return builder.build();
    }
}

