/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManagerImpl;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTxnManager
extends HiveTxnManagerImpl {
    private static final String CLASS_NAME = DbTxnManager.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private DbLockManager lockMgr = null;
    private IMetaStoreClient client = null;
    private long txnId = 0L;
    private int statementId = -1;
    private static ScheduledExecutorService heartbeatExecutorService = null;
    private ScheduledFuture<?> heartbeatTask = null;
    private Runnable shutdownRunner = new Runnable(){

        @Override
        public void run() {
            if (heartbeatExecutorService != null && !heartbeatExecutorService.isShutdown() && !heartbeatExecutorService.isTerminated()) {
                LOG.info("Shutting down Heartbeater thread pool.");
                heartbeatExecutorService.shutdown();
            }
        }
    };
    static final int SHUTDOWN_HOOK_PRIORITY = 0;

    DbTxnManager() {
        ShutdownHookManager.addShutdownHook(this.shutdownRunner, 0);
    }

    @Override
    void setHiveConf(HiveConf conf) {
        super.setHiveConf(conf);
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            throw new RuntimeException(ErrorMsg.DBTXNMGR_REQUIRES_CONCURRENCY.getMsg());
        }
    }

    @Override
    public long openTxn(String user) throws LockException {
        this.init();
        if (this.isTxnOpen()) {
            throw new LockException("Transaction already opened. " + JavaUtils.txnIdToString(this.txnId));
        }
        try {
            this.txnId = this.client.openTxn(user);
            this.statementId = 0;
            LOG.debug("Opened " + JavaUtils.txnIdToString(this.txnId));
            return this.txnId;
        }
        catch (TException e) {
            throw new LockException(e, ErrorMsg.METASTORE_COMMUNICATION_FAILED);
        }
    }

    @Override
    public HiveLockManager getLockManager() throws LockException {
        this.init();
        if (this.lockMgr == null) {
            this.lockMgr = new DbLockManager(this.client);
        }
        return this.lockMgr;
    }

    @Override
    public void acquireLocks(QueryPlan plan, Context ctx, String username) throws LockException {
        this.acquireLocks(plan, ctx, username, true);
        this.startHeartbeat();
    }

    LockState acquireLocks(QueryPlan plan, Context ctx, String username, boolean isBlocking) throws LockException {
        LockComponent comp;
        Table t;
        LockComponentBuilder compBuilder;
        this.init();
        this.getLockManager();
        boolean atLeastOneLock = false;
        LockRequestBuilder rqstBuilder = new LockRequestBuilder();
        LOG.info("Setting lock request transaction to " + JavaUtils.txnIdToString(this.txnId) + " for queryId=" + plan.getQueryId());
        rqstBuilder.setTransactionId(this.txnId).setUser(username);
        block16: for (ReadEntity input : plan.getInputs()) {
            if (!input.needsLock() || input.isUpdateOrDelete()) continue;
            compBuilder = new LockComponentBuilder();
            compBuilder.setShared();
            t = null;
            switch (input.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(input.getDatabase().getName());
                    break;
                }
                case TABLE: {
                    t = input.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: 
                case DUMMYPARTITION: {
                    compBuilder.setPartitionName(input.getPartition().getName());
                    t = input.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block16;
                }
            }
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request " + comp.toString());
            rqstBuilder.addLockComponent(comp);
            atLeastOneLock = true;
        }
        block17: for (WriteEntity output : plan.getOutputs()) {
            if (output.getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR) continue;
            compBuilder = new LockComponentBuilder();
            t = null;
            LOG.debug("output is null " + (output == null));
            switch (output.getWriteType()) {
                case DDL_EXCLUSIVE: 
                case INSERT_OVERWRITE: {
                    compBuilder.setExclusive();
                    break;
                }
                case INSERT: 
                case DDL_SHARED: {
                    compBuilder.setShared();
                    break;
                }
                case UPDATE: 
                case DELETE: {
                    compBuilder.setSemiShared();
                    break;
                }
                case DDL_NO_LOCK: {
                    continue block17;
                }
                default: {
                    throw new RuntimeException("Unknown write type " + output.getWriteType().toString());
                }
            }
            switch (output.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(output.getDatabase().getName());
                    break;
                }
                case TABLE: 
                case DUMMYPARTITION: {
                    t = output.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: {
                    compBuilder.setPartitionName(output.getPartition().getName());
                    t = output.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block17;
                }
            }
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request " + comp.toString());
            rqstBuilder.addLockComponent(comp);
            atLeastOneLock = true;
        }
        if (!atLeastOneLock) {
            LOG.debug("No locks needed for queryId" + plan.getQueryId());
            return null;
        }
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>(1);
        if (this.isTxnOpen()) {
            ++this.statementId;
        }
        LockState lockState = this.lockMgr.lock(rqstBuilder.build(), plan.getQueryId(), isBlocking, locks);
        ctx.setHiveLocks(locks);
        return lockState;
    }

    @VisibleForTesting
    void acquireLocksWithHeartbeatDelay(QueryPlan plan, Context ctx, String username, long delay) throws LockException {
        this.acquireLocks(plan, ctx, username, true);
        this.startHeartbeat(delay);
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) throws LockException {
        if (this.lockMgr != null) {
            this.stopHeartbeat();
            this.lockMgr.releaseLocks(hiveLocks);
        }
    }

    @Override
    public void commitTxn() throws LockException {
        if (!this.isTxnOpen()) {
            throw new RuntimeException("Attempt to commit before opening a transaction");
        }
        try {
            this.lockMgr.clearLocalLockRecords();
            this.stopHeartbeat();
            LOG.debug("Committing txn " + JavaUtils.txnIdToString(this.txnId));
            this.client.commitTxn(this.txnId);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString(this.txnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(this.txnId));
        }
        catch (TxnAbortedException e) {
            LOG.error("Transaction " + JavaUtils.txnIdToString(this.txnId) + " aborted");
            throw new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString(this.txnId));
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.txnId = 0L;
            this.statementId = -1;
        }
    }

    @Override
    public void rollbackTxn() throws LockException {
        if (!this.isTxnOpen()) {
            throw new RuntimeException("Attempt to rollback before opening a transaction");
        }
        try {
            this.lockMgr.clearLocalLockRecords();
            this.stopHeartbeat();
            LOG.debug("Rolling back " + JavaUtils.txnIdToString(this.txnId));
            this.client.rollbackTxn(this.txnId);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString(this.txnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(this.txnId));
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.txnId = 0L;
            this.statementId = -1;
        }
    }

    @Override
    public void heartbeat() throws LockException {
        List<HiveLock> locks;
        if (this.isTxnOpen()) {
            DbLockManager.DbHiveLock dummyLock = new DbLockManager.DbHiveLock(0L);
            locks = new ArrayList<HiveLock>(1);
            locks.add(dummyLock);
        } else {
            locks = this.lockMgr.getLocks(false, false);
        }
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Sending heartbeat for ").append(JavaUtils.txnIdToString(this.txnId)).append(" and");
            for (HiveLock lock2 : locks) {
                sb.append(" ").append(lock2.toString());
            }
            LOG.info(sb.toString());
        }
        if (!this.isTxnOpen() && locks.isEmpty()) {
            return;
        }
        for (HiveLock lock3 : locks) {
            long lockId = ((DbLockManager.DbHiveLock)lock3).lockId;
            try {
                this.client.heartbeat(this.txnId, lockId);
            }
            catch (NoSuchLockException e) {
                LOG.error("Unable to find lock " + JavaUtils.lockIdToString(lockId));
                throw new LockException(e, ErrorMsg.LOCK_NO_SUCH_LOCK, JavaUtils.lockIdToString(lockId));
            }
            catch (NoSuchTxnException e) {
                LOG.error("Unable to find transaction " + JavaUtils.txnIdToString(this.txnId));
                throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(this.txnId));
            }
            catch (TxnAbortedException e) {
                LOG.error("Transaction aborted " + JavaUtils.txnIdToString(this.txnId));
                throw new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString(this.txnId));
            }
            catch (TException e) {
                throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg() + "(" + JavaUtils.txnIdToString(this.txnId) + "," + lock3.toString() + ")", e);
            }
        }
    }

    private void startHeartbeat() throws LockException {
        this.startHeartbeat(0L);
    }

    void startHeartbeat(long delay) throws LockException {
        long heartbeatInterval = DbTxnManager.getHeartbeatInterval(this.conf);
        assert (heartbeatInterval > 0L);
        this.heartbeatTask = heartbeatExecutorService.scheduleAtFixedRate(new Heartbeater(this), delay, heartbeatInterval, TimeUnit.MILLISECONDS);
        LOG.info("Started " + Heartbeater.class.getName() + " with delay/interval = " + 0 + "/" + heartbeatInterval + " " + (Object)((Object)TimeUnit.MILLISECONDS));
    }

    private void stopHeartbeat() {
        if (this.heartbeatTask != null && !this.heartbeatTask.isCancelled() && !this.heartbeatTask.isDone()) {
            this.heartbeatTask.cancel(true);
            this.heartbeatTask = null;
        }
    }

    @Override
    public ValidTxnList getValidTxns() throws LockException {
        this.init();
        try {
            return this.client.getValidTxns(this.txnId);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public boolean supportsExplicitLock() {
        return false;
    }

    @Override
    public boolean useNewShowLocksFormat() {
        return true;
    }

    @Override
    public boolean supportsAcid() {
        return true;
    }

    @Override
    protected void destruct() {
        try {
            this.stopHeartbeat();
            if (this.shutdownRunner != null) {
                ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
            }
            if (this.isTxnOpen()) {
                this.rollbackTxn();
            }
            if (this.lockMgr != null) {
                this.lockMgr.close();
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception " + e.getClass().getName() + " with message <" + e.getMessage() + ">, swallowing as there is nothing we can do with it.");
        }
    }

    private void init() throws LockException {
        if (this.client == null) {
            if (this.conf == null) {
                throw new RuntimeException("Must call setHiveConf before any other methods.");
            }
            try {
                Hive db = Hive.get(this.conf);
                this.client = db.getMSC();
                this.initHeartbeatExecutorService();
            }
            catch (MetaException e) {
                throw new LockException(ErrorMsg.METASTORE_COULD_NOT_INITIATE.getMsg(), e);
            }
            catch (HiveException e) {
                throw new LockException(ErrorMsg.METASTORE_COULD_NOT_INITIATE.getMsg(), e);
            }
        }
    }

    private synchronized void initHeartbeatExecutorService() {
        if (heartbeatExecutorService != null && !heartbeatExecutorService.isShutdown() && !heartbeatExecutorService.isTerminated()) {
            return;
        }
        int threadPoolSize = this.conf.getIntVar(HiveConf.ConfVars.HIVE_TXN_HEARTBEAT_THREADPOOL_SIZE);
        heartbeatExecutorService = Executors.newScheduledThreadPool(threadPoolSize, new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Heartbeater-" + this.threadCounter.getAndIncrement());
            }
        });
        ((ScheduledThreadPoolExecutor)heartbeatExecutorService).setRemoveOnCancelPolicy(true);
    }

    @Override
    public boolean isTxnOpen() {
        return this.txnId > 0L;
    }

    @Override
    public long getCurrentTxnId() {
        return this.txnId;
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    public static long getHeartbeatInterval(Configuration conf) throws LockException {
        long interval = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_TXN_TIMEOUT, TimeUnit.MILLISECONDS) / 2L;
        if (interval == 0L) {
            throw new LockException(HiveConf.ConfVars.HIVE_TXN_MANAGER.toString() + " not set," + " heartbeats won't be sent");
        }
        return interval;
    }

    public static class Heartbeater
    implements Runnable {
        private HiveTxnManager txnMgr;

        public Heartbeater(HiveTxnManager txnMgr) {
            this.txnMgr = txnMgr;
        }

        @Override
        public void run() {
            try {
                LOG.debug("Heartbeating...");
                this.txnMgr.heartbeat();
            }
            catch (LockException e) {
                LOG.error("Failed trying to heartbeat " + e.getMessage());
            }
        }
    }
}

