/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.LlapWrappableInputFormatInterface;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowReader;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.FileMetaInfo;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcInputFormat
implements InputFormat<NullWritable, OrcStruct>,
InputFormatChecker,
VectorizedInputFormatInterface,
LlapWrappableInputFormatInterface,
SelfDescribingInputFormatInterface,
AcidInputFormat<NullWritable, OrcStruct>,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final Logger LOG = LoggerFactory.getLogger(OrcInputFormat.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private static final long DEFAULT_MIN_SPLIT_SIZE = 0x1000000L;
    private static final long DEFAULT_MAX_SPLIT_SIZE = 0x10000000L;
    private static final double MIN_INCLUDED_LOCATION = 0.8;
    private static boolean SCHEMA_TYPES_IS_ORIGINAL = true;

    @Override
    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return conf.get("hive.doing.acid") != null || AcidUtils.isAcid(path, conf);
    }

    public boolean isAcidRead(Configuration conf, InputSplit inputSplit) {
        if (!(inputSplit instanceof OrcSplit)) {
            return false;
        }
        return HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
    }

    private static int getRootColumn(boolean isOriginal) {
        return isOriginal ? 0 : 6;
    }

    public static void raiseAcidTablesMustBeReadWithAcidReaderException(Configuration conf) throws IOException {
        String hiveInputFormat = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEINPUTFORMAT);
        if (hiveInputFormat.equals(HiveInputFormat.class.getName())) {
            throw new IOException(ErrorMsg.ACID_TABLES_MUST_BE_READ_WITH_ACID_READER.getErrorCodedMsg());
        }
        throw new IOException(ErrorMsg.ACID_TABLES_MUST_BE_READ_WITH_HIVEINPUTFORMAT.getErrorCodedMsg());
    }

    public static RecordReader createReaderFromFile(Reader file, Configuration conf, long offset, long length) throws IOException {
        boolean isTransactionalTableScan = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
        if (isTransactionalTableScan) {
            OrcInputFormat.raiseAcidTablesMustBeReadWithAcidReaderException(conf);
        }
        TypeDescription schema = OrcInputFormat.getDesiredRowTypeDescr(conf, false);
        Reader.Options options = new Reader.Options().range(offset, length);
        options.schema(schema);
        boolean isOriginal = OrcInputFormat.isOriginal(file);
        List<OrcProto.Type> types = file.getTypes();
        options.include(OrcInputFormat.genIncludedColumns(types, conf, isOriginal));
        OrcInputFormat.setSearchArgument(options, types, conf, isOriginal);
        return file.rowsOptions(options);
    }

    public static boolean isOriginal(Reader file) {
        return !file.hasMetadataValue("hive.acid.key.index");
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId, int rootColumn) {
        result[typeId - rootColumn] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcInputFormat.includeColumnRecursive(types, result, type.getSubtypes(i), rootColumn);
        }
    }

    public static void translateSargToTableColIndexes(SearchArgument sarg, Configuration conf, int rootColumn) {
        String[] idStrs;
        String nameStr = OrcInputFormat.getNeededColumnNamesString(conf);
        String idStr = OrcInputFormat.getSargColumnIDsString(conf);
        String[] knownNames = nameStr.split(",");
        String[] stringArray = idStrs = idStr == null ? null : idStr.split(",");
        assert (idStrs == null || knownNames.length == idStrs.length);
        HashMap<String, Integer> nameIdMap = new HashMap<String, Integer>();
        for (int i = 0; i < knownNames.length; ++i) {
            Integer newId = idStrs != null ? Integer.parseInt(idStrs[i]) : i;
            Integer oldId = nameIdMap.put(knownNames[i], newId);
            if (oldId == null || oldId.intValue() == newId.intValue()) continue;
            throw new RuntimeException("Multiple IDs for " + knownNames[i] + " in column strings: [" + idStr + "], [" + nameStr + "]");
        }
        List<PredicateLeaf> leaves = sarg.getLeaves();
        for (int i = 0; i < leaves.size(); ++i) {
            PredicateLeaf pl = leaves.get(i);
            Integer colId = (Integer)nameIdMap.get(pl.getColumnName());
            String newColName = RecordReaderImpl.encodeTranslatedSargColumn(rootColumn, colId);
            SearchArgumentFactory.setPredicateLeafColumn(pl, newColName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SARG translated into " + sarg);
        }
    }

    public static boolean[] genIncludedColumns(List<OrcProto.Type> types, List<Integer> included, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        int numColumns = types.size() - rootColumn;
        boolean[] result = new boolean[numColumns];
        result[0] = true;
        OrcProto.Type root = types.get(rootColumn);
        for (int i = 0; i < root.getSubtypesCount(); ++i) {
            if (!included.contains(i)) continue;
            OrcInputFormat.includeColumnRecursive(types, result, root.getSubtypes(i), rootColumn);
        }
        return result;
    }

    public static boolean[] genIncludedColumns(List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        if (!ColumnProjectionUtils.isReadAllColumns(conf)) {
            List<Integer> included = ColumnProjectionUtils.getReadColumnIDs(conf);
            return OrcInputFormat.genIncludedColumns(types, included, isOriginal);
        }
        return null;
    }

    public static String[] getSargColumnNames(String[] originalColumnNames, List<OrcProto.Type> types, boolean[] includedColumns, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        String[] columnNames = new String[types.size() - rootColumn];
        int i = 0;
        for (int columnId : types.get(rootColumn).getSubtypesList()) {
            if (includedColumns != null && !includedColumns[columnId - rootColumn]) continue;
            columnNames[columnId - rootColumn] = originalColumnNames[i++];
        }
        return columnNames;
    }

    static void setSearchArgument(Reader.Options options, List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        String neededColumnNames = OrcInputFormat.getNeededColumnNamesString(conf);
        if (neededColumnNames == null) {
            LOG.debug("No ORC pushdown predicate - no column names");
            options.searchArgument(null, null);
            return;
        }
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf(conf);
        if (sarg == null) {
            LOG.debug("No ORC pushdown predicate");
            options.searchArgument(null, null);
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("ORC pushdown predicate: " + sarg);
        }
        options.searchArgument(sarg, OrcInputFormat.getSargColumnNames(neededColumnNames.split(","), types, options.getInclude(), isOriginal));
    }

    static boolean canCreateSargFromConf(Configuration conf) {
        if (OrcInputFormat.getNeededColumnNamesString(conf) == null) {
            LOG.debug("No ORC pushdown predicate - no column names");
            return false;
        }
        if (!ConvertAstToSearchArg.canCreateFromConf(conf)) {
            LOG.debug("No ORC pushdown predicate");
            return false;
        }
        return true;
    }

    private static String[] extractNeededColNames(List<OrcProto.Type> types, Configuration conf, boolean[] include, boolean isOriginal) {
        String colNames = OrcInputFormat.getNeededColumnNamesString(conf);
        if (colNames == null) {
            return null;
        }
        return OrcInputFormat.extractNeededColNames(types, colNames, include, isOriginal);
    }

    private static String[] extractNeededColNames(List<OrcProto.Type> types, String columnNamesString, boolean[] include, boolean isOriginal) {
        return OrcInputFormat.getSargColumnNames(columnNamesString.split(","), types, include, isOriginal);
    }

    private static String getNeededColumnNamesString(Configuration conf) {
        return conf.get("hive.io.file.readcolumn.names");
    }

    private static String getSargColumnIDsString(Configuration conf) {
        return conf.getBoolean("hive.io.file.read.all.columns", true) ? null : conf.get("hive.io.file.readcolumn.ids");
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
        if (Utilities.isVectorMode(conf)) {
            return new VectorizedOrcInputFormat().validateInput(fs, conf, files);
        }
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            if (file.getLen() == 0L) {
                return false;
            }
            try {
                OrcFile.createReader(file.getPath(), OrcFile.readerOptions(conf).filesystem(fs));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static Path[] getInputPaths(Configuration conf) throws IOException {
        String dirs = conf.get("mapred.input.dir");
        if (dirs == null) {
            throw new IOException("Configuration mapred.input.dir is not defined.");
        }
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    static List<OrcSplit> generateSplitsInfo(Configuration conf) throws IOException {
        return OrcInputFormat.generateSplitsInfo(conf, -1);
    }

    static List<OrcSplit> generateSplitsInfo(Configuration conf, int numSplits) throws IOException {
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_ENABLED)) {
            conf = new HiveConf(conf, OrcInputFormat.class);
        }
        Context context = new Context(conf, numSplits);
        if (LOG.isInfoEnabled()) {
            LOG.info("ORC pushdown predicate: " + context.sarg);
        }
        boolean useFileIds = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_INCLUDE_FILE_ID_IN_SPLITS);
        ArrayList<OrcSplit> splits = Lists.newArrayList();
        ArrayList pathFutures = Lists.newArrayList();
        ArrayList<Future<Void>> strategyFutures = Lists.newArrayList();
        ArrayList<Future<List<OrcSplit>>> splitFutures = Lists.newArrayList();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Path[] paths = OrcInputFormat.getInputPaths(conf);
        ExecutorCompletionService<AcidDirInfo> ecs = new ExecutorCompletionService<AcidDirInfo>(Context.threadPool);
        for (Path dir : paths) {
            FileSystem fs = dir.getFileSystem(conf);
            FileGenerator fileGenerator = new FileGenerator(context, fs, dir, useFileIds, ugi);
            pathFutures.add(ecs.submit(fileGenerator));
        }
        try {
            CombinedCtx combinedCtx = context.splitStrategyBatchMs > 0 ? new CombinedCtx() : null;
            long maxWaitUs = context.splitStrategyBatchMs * 1000000;
            int resultsLeft = paths.length;
            while (resultsLeft > 0) {
                AcidDirInfo adi = null;
                if (combinedCtx != null && combinedCtx.combined != null) {
                    long waitTimeUs = combinedCtx.combineStartUs + maxWaitUs - System.nanoTime();
                    if (waitTimeUs >= 0L) {
                        Future f = ecs.poll(waitTimeUs, TimeUnit.NANOSECONDS);
                        adi = f == null ? null : (AcidDirInfo)f.get();
                    }
                } else {
                    adi = (AcidDirInfo)ecs.take().get();
                }
                if (adi == null) {
                    assert (combinedCtx.combined != null);
                    OrcInputFormat.scheduleSplits(combinedCtx.combined, context, splitFutures, strategyFutures);
                    combinedCtx.combined = null;
                    continue;
                }
                --resultsLeft;
                SplitStrategy<?> splitStrategy = OrcInputFormat.determineSplitStrategy(combinedCtx, context, adi.fs, adi.splitPath, adi.acidInfo, adi.baseOrOriginalFiles, ugi);
                if (splitStrategy == null) continue;
                if (isDebugEnabled) {
                    LOG.debug("Split strategy: {}", splitStrategy);
                }
                if (splitStrategy instanceof ETLSplitStrategy) {
                    OrcInputFormat.scheduleSplits((ETLSplitStrategy)splitStrategy, context, splitFutures, strategyFutures);
                    continue;
                }
                List<?> readySplits = splitStrategy.getSplits();
                splits.addAll(readySplits);
            }
            if (combinedCtx != null && combinedCtx.combined != null) {
                OrcInputFormat.scheduleSplits(combinedCtx.combined, context, splitFutures, strategyFutures);
                combinedCtx.combined = null;
            }
            for (Future future : strategyFutures) {
                future.get();
            }
            for (Future future : splitFutures) {
                splits.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            OrcInputFormat.cancelFutures(pathFutures);
            OrcInputFormat.cancelFutures(strategyFutures);
            OrcInputFormat.cancelFutures(splitFutures);
            throw new RuntimeException("ORC split generation failed with exception: " + e.getMessage(), e);
        }
        if (context.cacheStripeDetails) {
            LOG.info("FooterCacheHitRatio: " + context.cacheHitCounter.get() + "/" + context.numFilesCounter.get());
        }
        if (isDebugEnabled) {
            for (OrcSplit split : splits) {
                LOG.debug(split + " projected_columns_uncompressed_size: " + split.getColumnarProjectionSize());
            }
        }
        return splits;
    }

    private static void scheduleSplits(ETLSplitStrategy splitStrategy, Context context, List<Future<List<OrcSplit>>> splitFutures, List<Future<Void>> strategyFutures) throws IOException {
        Future<Void> ssFuture = splitStrategy.generateSplitWork(context, splitFutures);
        if (ssFuture == null) {
            return;
        }
        strategyFutures.add(ssFuture);
    }

    private static <T> void cancelFutures(List<Future<T>> futures) {
        for (Future<T> future : futures) {
            future.cancel(true);
        }
    }

    private static SplitStrategy<?> combineOrCreateETLStrategy(CombinedCtx combinedCtx, Context context, FileSystem fs, Path dir, List<HadoopShims.HdfsFileStatusWithId> files, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered, boolean isOriginal, UserGroupInformation ugi) {
        if (!deltas.isEmpty() || combinedCtx == null) {
            return new ETLSplitStrategy(context, fs, dir, files, isOriginal, deltas, covered, ugi);
        }
        if (combinedCtx.combined == null) {
            combinedCtx.combined = new ETLSplitStrategy(context, fs, dir, files, isOriginal, deltas, covered, ugi);
            combinedCtx.combineStartUs = System.nanoTime();
            return null;
        }
        ETLSplitStrategy.CombineResult r = combinedCtx.combined.combineWith(fs, dir, files, isOriginal);
        switch (r) {
            case YES: {
                return null;
            }
            case NO_AND_CONTINUE: {
                return new ETLSplitStrategy(context, fs, dir, files, isOriginal, deltas, covered, ugi);
            }
            case NO_AND_SWAP: {
                ETLSplitStrategy oldBase = combinedCtx.combined;
                combinedCtx.combined = new ETLSplitStrategy(context, fs, dir, files, isOriginal, deltas, covered, ugi);
                combinedCtx.combineStartUs = System.nanoTime();
                return oldBase;
            }
        }
        throw new AssertionError((Object)("Unknown result " + (Object)((Object)r)));
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (isDebugEnabled) {
            LOG.debug("getSplits started");
        }
        List<OrcSplit> result = OrcInputFormat.generateSplitsInfo((Configuration)job, numSplits);
        if (isDebugEnabled) {
            LOG.debug("getSplits finished");
        }
        return result.toArray(new InputSplit[result.size()]);
    }

    private org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> createVectorizedReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        return new VectorizedOrcInputFormat().getRecordReader(split, conf, reporter);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        boolean vectorMode = Utilities.isVectorMode((Configuration)conf);
        boolean isAcidRead = this.isAcidRead((Configuration)conf, inputSplit);
        if (!isAcidRead) {
            if (vectorMode) {
                return this.createVectorizedReader(inputSplit, conf, reporter);
            }
            return new OrcRecordReader(OrcFile.createReader(((FileSplit)inputSplit).getPath(), OrcFile.readerOptions((Configuration)conf)), (Configuration)conf, (FileSplit)inputSplit);
        }
        OrcSplit split = (OrcSplit)inputSplit;
        reporter.setStatus(inputSplit.toString());
        AcidInputFormat.Options options = new AcidInputFormat.Options((Configuration)conf).reporter(reporter);
        AcidInputFormat.RowReader<OrcStruct> inner = this.getReader(inputSplit, options);
        if (vectorMode) {
            return new VectorizedOrcAcidRowReader(inner, (Configuration)conf, Utilities.getMapWork((Configuration)conf).getVectorizedRowBatchCtx(), (FileSplit)inputSplit);
        }
        return new NullKeyRecordReader(inner, (Configuration)conf);
    }

    @Override
    public AcidInputFormat.RowReader<OrcStruct> getReader(InputSplit inputSplit, AcidInputFormat.Options options) throws IOException {
        Reader reader;
        int bucket;
        OrcSplit split = (OrcSplit)inputSplit;
        Path path = split.getPath();
        Path root = split.hasBase() ? (split.isOriginal() ? path.getParent() : path.getParent().getParent()) : path;
        Path[] deltas = AcidUtils.deserializeDeltas(root, split.getDeltas());
        Configuration conf = options.getConfiguration();
        TypeDescription schema = OrcInputFormat.getDesiredRowTypeDescr(conf, true);
        Reader.Options readOptions = new Reader.Options().schema(schema);
        readOptions.range(split.getStart(), split.getLength());
        final List<OrcProto.Type> schemaTypes = OrcUtils.getOrcTypes(schema);
        readOptions.include(OrcInputFormat.genIncludedColumns(schemaTypes, conf, SCHEMA_TYPES_IS_ORIGINAL));
        OrcInputFormat.setSearchArgument(readOptions, schemaTypes, conf, SCHEMA_TYPES_IS_ORIGINAL);
        if (split.hasBase()) {
            bucket = AcidUtils.parseBaseBucketFilename(split.getPath(), conf).getBucket();
            reader = OrcFile.createReader(path, OrcFile.readerOptions(conf));
        } else {
            bucket = (int)split.getStart();
            reader = null;
        }
        String txnString = conf.get("hive.txn.valid.txns", "9223372036854775807:");
        ValidReadTxnList validTxnList = new ValidReadTxnList(txnString);
        final OrcRawRecordMerger records = new OrcRawRecordMerger(conf, true, reader, split.isOriginal(), bucket, validTxnList, readOptions, deltas);
        return new AcidInputFormat.RowReader<OrcStruct>(){
            OrcStruct innerRecord;
            {
                this.innerRecord = records.createValue();
            }

            @Override
            public ObjectInspector getObjectInspector() {
                return OrcStruct.createObjectInspector(0, schemaTypes);
            }

            public boolean next(RecordIdentifier recordIdentifier, OrcStruct orcStruct) throws IOException {
                boolean result;
                while ((result = records.next(recordIdentifier, this.innerRecord)) && OrcRecordUpdater.getOperation(this.innerRecord) == 2) {
                }
                if (result) {
                    orcStruct.linkFields(OrcRecordUpdater.getRow(this.innerRecord));
                }
                return result;
            }

            public RecordIdentifier createKey() {
                return records.createKey();
            }

            public OrcStruct createValue() {
                return new OrcStruct(records.getColumns());
            }

            public long getPos() throws IOException {
                return records.getPos();
            }

            public void close() throws IOException {
                records.close();
            }

            public float getProgress() throws IOException {
                return records.getProgress();
            }
        };
    }

    static Path findOriginalBucket(FileSystem fs, Path directory, int bucket) throws IOException {
        for (FileStatus stat : fs.listStatus(directory)) {
            String name = stat.getPath().getName();
            String numberPart = name.substring(0, name.indexOf(95));
            if (!org.apache.commons.lang3.StringUtils.isNumeric(numberPart) || Integer.parseInt(numberPart) != bucket) continue;
            return stat.getPath();
        }
        throw new IllegalArgumentException("Can't find bucket " + bucket + " in " + directory);
    }

    public static boolean[] pickStripesViaTranslatedSarg(SearchArgument sarg, OrcFile.WriterVersion writerVersion, List<OrcProto.Type> types, List<StripeStatistics> stripeStats, int stripeCount) {
        LOG.info("Translated ORC pushdown predicate: " + sarg);
        assert (sarg != null);
        if (stripeStats == null || writerVersion == OrcFile.WriterVersion.ORIGINAL) {
            return null;
        }
        List<PredicateLeaf> sargLeaves = sarg.getLeaves();
        int[] filterColumns = RecordReaderImpl.mapTranslatedSargColumns(types, sargLeaves);
        return OrcInputFormat.pickStripesInternal(sarg, filterColumns, stripeStats, stripeCount, null);
    }

    private static boolean[] pickStripes(SearchArgument sarg, String[] sargColNames, OrcFile.WriterVersion writerVersion, boolean isOriginal, List<StripeStatistics> stripeStats, int stripeCount, Path filePath) {
        if (sarg == null || stripeStats == null || writerVersion == OrcFile.WriterVersion.ORIGINAL) {
            return null;
        }
        List<PredicateLeaf> sargLeaves = sarg.getLeaves();
        int[] filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx(sargLeaves, sargColNames, OrcInputFormat.getRootColumn(isOriginal));
        return OrcInputFormat.pickStripesInternal(sarg, filterColumns, stripeStats, stripeCount, filePath);
    }

    private static boolean[] pickStripesInternal(SearchArgument sarg, int[] filterColumns, List<StripeStatistics> stripeStats, int stripeCount, Path filePath) {
        boolean[] includeStripe = new boolean[stripeCount];
        for (int i = 0; i < includeStripe.length; ++i) {
            boolean bl = includeStripe[i] = i >= stripeStats.size() || OrcInputFormat.isStripeSatisfyPredicate(stripeStats.get(i), sarg, filterColumns);
            if (!isDebugEnabled || includeStripe[i]) continue;
            LOG.debug("Eliminating ORC stripe-" + i + " of file '" + filePath + "'  as it did not satisfy predicate condition.");
        }
        return includeStripe;
    }

    private static boolean isStripeSatisfyPredicate(StripeStatistics stripeStatistics, SearchArgument sarg, int[] filterColumns) {
        List<PredicateLeaf> predLeaves = sarg.getLeaves();
        SearchArgument.TruthValue[] truthValues = new SearchArgument.TruthValue[predLeaves.size()];
        for (int pred = 0; pred < truthValues.length; ++pred) {
            if (filterColumns[pred] != -1) {
                ColumnStatistics stats = stripeStatistics.getColumnStatistics()[filterColumns[pred]];
                truthValues[pred] = RecordReaderImpl.evaluatePredicate(stats, predLeaves.get(pred), null);
                continue;
            }
            truthValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
        }
        return sarg.evaluate(truthValues).isNeeded();
    }

    @VisibleForTesting
    static SplitStrategy<?> determineSplitStrategy(CombinedCtx combinedCtx, Context context, FileSystem fs, Path dir, AcidUtils.Directory dirInfo, List<HadoopShims.HdfsFileStatusWithId> baseOrOriginalFiles, UserGroupInformation ugi) {
        boolean isOriginal;
        Path base = dirInfo.getBaseDirectory();
        List<HadoopShims.HdfsFileStatusWithId> original = dirInfo.getOriginalFiles();
        List<AcidInputFormat.DeltaMetaData> deltas = AcidUtils.serializeDeltas(dirInfo.getCurrentDirectories());
        boolean[] covered = new boolean[context.numBuckets];
        boolean bl = isOriginal = base == null;
        if (base != null || !original.isEmpty()) {
            long totalFileSize = 0L;
            for (HadoopShims.HdfsFileStatusWithId child : baseOrOriginalFiles) {
                totalFileSize += child.getFileStatus().getLen();
                AcidOutputFormat.Options opts = AcidUtils.parseBaseBucketFilename(child.getFileStatus().getPath(), context.conf);
                int b = opts.getBucket();
                if (b < 0 || b >= covered.length) continue;
                covered[b] = true;
            }
            int numFiles = baseOrOriginalFiles.size();
            long avgFileSize = totalFileSize / (long)numFiles;
            int totalFiles = context.numFilesCounter.addAndGet(numFiles);
            switch (context.splitStrategyKind) {
                case BI: {
                    return new BISplitStrategy(context, fs, dir, baseOrOriginalFiles, isOriginal, deltas, covered);
                }
                case ETL: {
                    return OrcInputFormat.combineOrCreateETLStrategy(combinedCtx, context, fs, dir, baseOrOriginalFiles, deltas, covered, isOriginal, ugi);
                }
            }
            if (avgFileSize > context.maxSize || totalFiles <= context.minSplits) {
                return OrcInputFormat.combineOrCreateETLStrategy(combinedCtx, context, fs, dir, baseOrOriginalFiles, deltas, covered, isOriginal, ugi);
            }
            return new BISplitStrategy(context, fs, dir, baseOrOriginalFiles, isOriginal, deltas, covered);
        }
        return new ACIDSplitStrategy(dir, context.numBuckets, deltas, covered);
    }

    @Override
    public AcidInputFormat.RawReader<OrcStruct> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidTxnList validTxnList, Path baseDirectory, Path[] deltaDirectory) throws IOException {
        Reader reader = null;
        boolean isOriginal = false;
        if (baseDirectory != null) {
            Path bucketFile;
            if (baseDirectory.getName().startsWith("base_")) {
                bucketFile = AcidUtils.createBucketFile(baseDirectory, bucket);
            } else {
                isOriginal = true;
                bucketFile = OrcInputFormat.findOriginalBucket(baseDirectory.getFileSystem(conf), baseDirectory, bucket);
            }
            reader = OrcFile.createReader(bucketFile, OrcFile.readerOptions(conf));
        }
        return new OrcRawRecordMerger(conf, collapseEvents, reader, isOriginal, bucket, validTxnList, new Reader.Options(), deltaDirectory);
    }

    public static ArrayList<TypeDescription> typeDescriptionsFromHiveTypeProperty(String hiveTypeProperty) {
        ArrayList<TypeInfo> typeInfoList = TypeInfoUtils.getTypeInfosFromTypeString(hiveTypeProperty);
        ArrayList<TypeDescription> typeDescrList = new ArrayList<TypeDescription>(typeInfoList.size());
        for (TypeInfo typeInfo : typeInfoList) {
            typeDescrList.add(OrcInputFormat.convertTypeInfo(typeInfo));
        }
        return typeDescrList;
    }

    public static TypeDescription convertTypeInfo(TypeInfo info) {
        switch (info.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo pinfo = (PrimitiveTypeInfo)info;
                switch (pinfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return TypeDescription.createBoolean();
                    }
                    case BYTE: {
                        return TypeDescription.createByte();
                    }
                    case SHORT: {
                        return TypeDescription.createShort();
                    }
                    case INT: {
                        return TypeDescription.createInt();
                    }
                    case LONG: {
                        return TypeDescription.createLong();
                    }
                    case FLOAT: {
                        return TypeDescription.createFloat();
                    }
                    case DOUBLE: {
                        return TypeDescription.createDouble();
                    }
                    case STRING: {
                        return TypeDescription.createString();
                    }
                    case DATE: {
                        return TypeDescription.createDate();
                    }
                    case TIMESTAMP: {
                        return TypeDescription.createTimestamp();
                    }
                    case BINARY: {
                        return TypeDescription.createBinary();
                    }
                    case DECIMAL: {
                        DecimalTypeInfo dinfo = (DecimalTypeInfo)pinfo;
                        return TypeDescription.createDecimal().withScale(dinfo.getScale()).withPrecision(dinfo.getPrecision());
                    }
                    case VARCHAR: {
                        BaseCharTypeInfo cinfo = (BaseCharTypeInfo)pinfo;
                        return TypeDescription.createVarchar().withMaxLength(cinfo.getLength());
                    }
                    case CHAR: {
                        BaseCharTypeInfo cinfo = (BaseCharTypeInfo)pinfo;
                        return TypeDescription.createChar().withMaxLength(cinfo.getLength());
                    }
                }
                throw new IllegalArgumentException("ORC doesn't handle primitive category " + (Object)((Object)pinfo.getPrimitiveCategory()));
            }
            case LIST: {
                ListTypeInfo linfo = (ListTypeInfo)info;
                return TypeDescription.createList(OrcInputFormat.convertTypeInfo(linfo.getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo minfo = (MapTypeInfo)info;
                return TypeDescription.createMap(OrcInputFormat.convertTypeInfo(minfo.getMapKeyTypeInfo()), OrcInputFormat.convertTypeInfo(minfo.getMapValueTypeInfo()));
            }
            case UNION: {
                UnionTypeInfo minfo = (UnionTypeInfo)info;
                TypeDescription result = TypeDescription.createUnion();
                for (TypeInfo child : minfo.getAllUnionObjectTypeInfos()) {
                    result.addUnionChild(OrcInputFormat.convertTypeInfo(child));
                }
                return result;
            }
            case STRUCT: {
                StructTypeInfo sinfo = (StructTypeInfo)info;
                TypeDescription result = TypeDescription.createStruct();
                for (String fieldName : sinfo.getAllStructFieldNames()) {
                    result.addField(fieldName, OrcInputFormat.convertTypeInfo(sinfo.getStructFieldTypeInfo(fieldName)));
                }
                return result;
            }
        }
        throw new IllegalArgumentException("ORC doesn't handle " + (Object)((Object)info.getCategory()));
    }

    public static TypeDescription getDesiredRowTypeDescr(Configuration conf, boolean isAcidRead) throws IOException {
        String columnNameProperty = null;
        String columnTypeProperty = null;
        ArrayList<String> schemaEvolutionColumnNames = null;
        ArrayList<TypeDescription> schemaEvolutionTypeDescrs = null;
        boolean haveSchemaEvolutionProperties = false;
        if (isAcidRead || HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION)) {
            columnNameProperty = conf.get("schema.evolution.columns");
            columnTypeProperty = conf.get("schema.evolution.columns.types");
            boolean bl = haveSchemaEvolutionProperties = columnNameProperty != null && columnTypeProperty != null;
            if (haveSchemaEvolutionProperties) {
                schemaEvolutionColumnNames = Lists.newArrayList(columnNameProperty.split(","));
                if (schemaEvolutionColumnNames.size() == 0) {
                    haveSchemaEvolutionProperties = false;
                } else {
                    schemaEvolutionTypeDescrs = OrcInputFormat.typeDescriptionsFromHiveTypeProperty(columnTypeProperty);
                    if (schemaEvolutionTypeDescrs.size() != schemaEvolutionColumnNames.size()) {
                        haveSchemaEvolutionProperties = false;
                    }
                }
            } else if (isAcidRead) {
                throw new IOException(ErrorMsg.SCHEMA_REQUIRED_TO_READ_ACID_TABLES.getErrorCodedMsg());
            }
        }
        if (haveSchemaEvolutionProperties) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Using schema evolution configuration variables schema.evolution.columns " + schemaEvolutionColumnNames.toString() + " / schema.evolution.columns.types " + schemaEvolutionTypeDescrs.toString() + " (isAcidRead " + isAcidRead + ")");
            }
        } else {
            columnNameProperty = conf.get("columns");
            columnTypeProperty = conf.get("columns.types");
            if (columnTypeProperty == null || columnNameProperty == null) {
                return null;
            }
            schemaEvolutionColumnNames = Lists.newArrayList(columnNameProperty.split(","));
            if (schemaEvolutionColumnNames.size() == 0) {
                return null;
            }
            schemaEvolutionTypeDescrs = OrcInputFormat.typeDescriptionsFromHiveTypeProperty(columnTypeProperty);
            if (schemaEvolutionTypeDescrs.size() != schemaEvolutionColumnNames.size()) {
                return null;
            }
            int virtualColumnClipNum = -1;
            int columnNum = 0;
            for (String columnName : schemaEvolutionColumnNames) {
                if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(columnName)) {
                    virtualColumnClipNum = columnNum;
                    break;
                }
                ++columnNum;
            }
            if (virtualColumnClipNum != -1) {
                schemaEvolutionColumnNames = Lists.newArrayList(schemaEvolutionColumnNames.subList(0, virtualColumnClipNum));
                schemaEvolutionTypeDescrs = Lists.newArrayList(schemaEvolutionTypeDescrs.subList(0, virtualColumnClipNum));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Using column configuration variables columns " + schemaEvolutionColumnNames.toString() + " / columns.types " + schemaEvolutionTypeDescrs.toString() + " (isAcidRead " + isAcidRead + ")");
            }
        }
        TypeDescription result = TypeDescription.createStruct();
        for (int i = 0; i < schemaEvolutionColumnNames.size(); ++i) {
            result.addField(schemaEvolutionColumnNames.get(i), (TypeDescription)schemaEvolutionTypeDescrs.get(i));
        }
        return result;
    }

    public static class MetastoreCache
    implements FooterCache {
        private final LocalCache localCache;
        private boolean isWarnLogged = false;
        private HiveConf conf;

        public MetastoreCache(LocalCache lc) {
            this.localCache = lc;
        }

        @Override
        public FileInfo[] getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files) throws IOException {
            Hive hive;
            FileInfo[] result = this.localCache.getAndValidate(files);
            assert (result.length == files.size());
            HashMap<Long, Integer> posMap = new HashMap<Long, Integer>(files.size());
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != null) continue;
                HadoopShims.HdfsFileStatusWithId file = files.get(i);
                Long fileId = file.getFileId();
                if (fileId == null) {
                    if (this.isWarnLogged && !isDebugEnabled) continue;
                    LOG.warn("Not using metastore cache because fileId is missing: " + file.getFileStatus().getPath());
                    this.isWarnLogged = true;
                    continue;
                }
                posMap.put(fileId, i);
            }
            Iterator<Map.Entry<Long, ByteBuffer>> iter = null;
            try {
                hive = this.getHive();
                iter = hive.getFileMetadata(Lists.newArrayList(posMap.keySet()), this.conf).iterator();
            }
            catch (HiveException ex) {
                throw new IOException(ex);
            }
            ArrayList<Long> corruptIds = null;
            while (iter.hasNext()) {
                Map.Entry<Long, ByteBuffer> e = iter.next();
                int ix = (Integer)posMap.get(e.getKey());
                assert (result[ix] == null);
                HadoopShims.HdfsFileStatusWithId file = files.get(ix);
                assert (file.getFileId() == e.getKey());
                result[ix] = MetastoreCache.createFileInfoFromMs(file, e.getValue());
                if (result[ix] == null) {
                    if (corruptIds == null) {
                        corruptIds = new ArrayList<Long>();
                    }
                    corruptIds.add(file.getFileId());
                    continue;
                }
                this.localCache.put(file.getFileStatus().getPath(), result[ix]);
            }
            if (corruptIds != null) {
                try {
                    hive.clearFileMetadata(corruptIds);
                }
                catch (HiveException ex) {
                    LOG.error("Failed to clear corrupt cache data", (Throwable)ex);
                }
            }
            return result;
        }

        private Hive getHive() throws HiveException {
            return Hive.getWithFastCheck(this.conf);
        }

        private static FileInfo createFileInfoFromMs(HadoopShims.HdfsFileStatusWithId file, ByteBuffer bb) throws IOException {
            FileStatus fs = file.getFileStatus();
            ReaderImpl.FooterInfo fi = null;
            ByteBuffer original = bb.duplicate();
            try {
                fi = ReaderImpl.extractMetaInfoFromFooter(bb, fs.getPath());
            }
            catch (Exception ex) {
                byte[] data = new byte[original.remaining()];
                System.arraycopy(original.array(), original.arrayOffset() + original.position(), data, 0, data.length);
                String msg = "Failed to parse the footer stored in cache for file ID " + file.getFileId() + " " + original + " [ " + Hex.encodeHexString((byte[])data) + " ]";
                LOG.error(msg, (Throwable)ex);
                return null;
            }
            return new FileInfo(fs.getModificationTime(), fs.getLen(), fi.getStripes(), fi.getMetadata(), fi.getFooter().getTypesList(), fi.getFooter().getStatisticsList(), fi.getFileMetaInfo(), fi.getFileMetaInfo().writerVersion, file.getFileId());
        }

        @Override
        public void put(Long fileId, FileStatus file, FileMetaInfo fileMetaInfo, Reader orcReader) throws IOException {
            this.localCache.put(fileId, file, fileMetaInfo, orcReader);
            if (fileId != null) {
                try {
                    this.getHive().putFileMetadata(Lists.newArrayList(fileId), Lists.newArrayList(((ReaderImpl)orcReader).getSerializedFileFooter()));
                }
                catch (HiveException e) {
                    throw new IOException(e);
                }
            }
        }

        public void configure(HiveConf queryConfig) {
            this.conf = queryConfig;
        }

        @Override
        public boolean isBlocking() {
            return true;
        }
    }

    private static class LocalCache
    implements FooterCache {
        private final Cache<Path, FileInfo> cache;

        public LocalCache(int numThreads, int cacheStripeDetailsSize) {
            this.cache = CacheBuilder.newBuilder().concurrencyLevel(numThreads).initialCapacity(cacheStripeDetailsSize).maximumSize(cacheStripeDetailsSize).softValues().build();
        }

        @Override
        public FileInfo[] getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files) {
            FileInfo[] result = new FileInfo[files.size()];
            int i = -1;
            for (HadoopShims.HdfsFileStatusWithId fileWithId : files) {
                ++i;
                FileStatus file = fileWithId.getFileStatus();
                Path path = file.getPath();
                Long fileId = fileWithId.getFileId();
                FileInfo fileInfo = this.cache.getIfPresent(path);
                if (isDebugEnabled) {
                    LOG.debug("Info " + (fileInfo == null ? "not " : "") + "cached for path: " + path);
                }
                if (fileInfo == null) continue;
                if (fileId != null && fileInfo.fileId != null && fileId == fileInfo.fileId || fileInfo.modificationTime == file.getModificationTime() && fileInfo.size == file.getLen()) {
                    result[i] = fileInfo;
                    continue;
                }
                this.cache.invalidate(path);
                if (!isDebugEnabled) continue;
                LOG.debug("Meta-Info for : " + path + " changed. CachedModificationTime: " + fileInfo.modificationTime + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + fileInfo.size + ", CurrentLength: " + file.getLen());
            }
            return result;
        }

        public void put(Path path, FileInfo fileInfo) {
            this.cache.put(path, fileInfo);
        }

        @Override
        public void put(Long fileId, FileStatus file, FileMetaInfo fileMetaInfo, Reader orcReader) throws IOException {
            this.cache.put(file.getPath(), new FileInfo(file.getModificationTime(), file.getLen(), orcReader.getStripes(), orcReader.getStripeStatistics(), orcReader.getTypes(), orcReader.getOrcProtoFileStatistics(), fileMetaInfo, orcReader.getWriterVersion(), fileId));
        }

        @Override
        public boolean isBlocking() {
            return false;
        }
    }

    public static interface FooterCache {
        public FileInfo[] getAndValidate(List<HadoopShims.HdfsFileStatusWithId> var1) throws IOException;

        public boolean isBlocking();

        public void put(Long var1, FileStatus var2, FileMetaInfo var3, Reader var4) throws IOException;
    }

    public static final class NullKeyRecordReader
    implements AcidInputFormat.AcidRecordReader<NullWritable, OrcStruct> {
        private final RecordIdentifier id;
        private final AcidInputFormat.RowReader<OrcStruct> inner;

        @Override
        public RecordIdentifier getRecordIdentifier() {
            return this.id;
        }

        private NullKeyRecordReader(AcidInputFormat.RowReader<OrcStruct> inner, Configuration conf) {
            this.inner = inner;
            this.id = (RecordIdentifier)inner.createKey();
        }

        public boolean next(NullWritable nullWritable, OrcStruct orcStruct) throws IOException {
            return this.inner.next(this.id, orcStruct);
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return (OrcStruct)this.inner.createValue();
        }

        public long getPos() throws IOException {
            return this.inner.getPos();
        }

        public void close() throws IOException {
            this.inner.close();
        }

        public float getProgress() throws IOException {
            return this.inner.getProgress();
        }
    }

    private static class FileInfo {
        private final long modificationTime;
        private final long size;
        private final Long fileId;
        private final List<StripeInformation> stripeInfos;
        private FileMetaInfo fileMetaInfo;
        private final List<StripeStatistics> stripeStats;
        private final List<OrcProto.ColumnStatistics> fileStats;
        private final List<OrcProto.Type> types;
        private final OrcFile.WriterVersion writerVersion;

        FileInfo(long modificationTime, long size, List<StripeInformation> stripeInfos, List<StripeStatistics> stripeStats, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> fileStats, FileMetaInfo fileMetaInfo, OrcFile.WriterVersion writerVersion, Long fileId) {
            this.modificationTime = modificationTime;
            this.size = size;
            this.fileId = fileId;
            this.stripeInfos = stripeInfos;
            this.fileMetaInfo = fileMetaInfo;
            this.stripeStats = stripeStats;
            this.types = types;
            this.fileStats = fileStats;
            this.writerVersion = writerVersion;
        }
    }

    @VisibleForTesting
    static final class CombinedCtx {
        ETLSplitStrategy combined;
        long combineStartUs;

        CombinedCtx() {
        }
    }

    static final class SplitGenerator
    implements Callable<List<OrcSplit>> {
        private final Context context;
        private final FileSystem fs;
        private final HadoopShims.HdfsFileStatusWithId fileWithId;
        private final FileStatus file;
        private final long blockSize;
        private final TreeMap<Long, BlockLocation> locations;
        private final FileInfo fileInfo;
        private List<StripeInformation> stripes;
        private FileMetaInfo fileMetaInfo;
        private List<StripeStatistics> stripeStats;
        private List<OrcProto.Type> types;
        private boolean[] includedCols;
        private final boolean isOriginal;
        private final List<AcidInputFormat.DeltaMetaData> deltas;
        private final boolean hasBase;
        private OrcFile.WriterVersion writerVersion;
        private long projColsUncompressedSize;
        private final List<OrcSplit> deltaSplits;
        private final UserGroupInformation ugi;

        public SplitGenerator(SplitInfo splitInfo, UserGroupInformation ugi) throws IOException {
            this.ugi = ugi;
            this.context = splitInfo.context;
            this.fs = splitInfo.fs;
            this.fileWithId = splitInfo.fileWithId;
            this.file = this.fileWithId.getFileStatus();
            this.blockSize = this.file.getBlockSize();
            this.fileInfo = splitInfo.fileInfo;
            this.locations = SHIMS.getLocationsWithOffset(this.fs, this.fileWithId.getFileStatus());
            this.isOriginal = splitInfo.isOriginal;
            this.deltas = splitInfo.deltas;
            this.hasBase = splitInfo.hasBase;
            this.projColsUncompressedSize = -1L;
            this.deltaSplits = splitInfo.getSplits();
        }

        Path getPath() {
            return this.fileWithId.getFileStatus().getPath();
        }

        public String toString() {
            return "splitter(" + this.fileWithId.getFileStatus().getPath() + ")";
        }

        static long getOverlap(long offset1, long length1, long offset2, long length2) {
            long end1 = offset1 + length1;
            long end2 = offset2 + length2;
            if (end2 <= offset1 || end1 <= offset2) {
                return 0L;
            }
            return Math.min(end1, end2) - Math.max(offset1, offset2);
        }

        OrcSplit createSplit(long offset, long length, FileMetaInfo fileMetaInfo) throws IOException {
            String[] hosts;
            Map.Entry<Long, BlockLocation> startEntry = this.locations.floorEntry(offset);
            BlockLocation start = startEntry.getValue();
            if (offset + length <= start.getOffset() + start.getLength()) {
                hosts = start.getHosts();
            } else {
                Map.Entry<Long, BlockLocation> endEntry = this.locations.floorEntry(offset + length);
                NavigableMap<Long, BlockLocation> navigableMap = this.locations.subMap(startEntry.getKey(), true, endEntry.getKey(), true);
                HashMap<String, LongWritable> sizes = new HashMap<String, LongWritable>();
                long maxSize = 0L;
                for (BlockLocation block : navigableMap.values()) {
                    long overlap = SplitGenerator.getOverlap(offset, length, block.getOffset(), block.getLength());
                    if (overlap > 0L) {
                        for (String host : block.getHosts()) {
                            LongWritable val = (LongWritable)sizes.get(host);
                            if (val == null) {
                                val = new LongWritable();
                                sizes.put(host, val);
                            }
                            val.set(val.get() + overlap);
                            maxSize = Math.max(maxSize, val.get());
                        }
                        continue;
                    }
                    throw new IOException("File " + this.fileWithId.getFileStatus().getPath().toString() + " should have had overlap on block starting at " + block.getOffset());
                }
                long threshold = (long)((double)maxSize * 0.8);
                ArrayList<String> hostList = new ArrayList<String>();
                for (BlockLocation block : navigableMap.values()) {
                    for (String host : block.getHosts()) {
                        if (!sizes.containsKey(host)) continue;
                        if (((LongWritable)sizes.get(host)).get() >= threshold) {
                            hostList.add(host);
                        }
                        sizes.remove(host);
                    }
                }
                hosts = new String[hostList.size()];
                hostList.toArray(hosts);
            }
            long fileLen = this.file.getLen();
            double splitRatio = (double)length / (double)fileLen;
            long scaledProjSize = this.projColsUncompressedSize > 0L ? (long)(splitRatio * (double)this.projColsUncompressedSize) : fileLen;
            return new OrcSplit(this.file.getPath(), this.fileWithId.getFileId(), offset, length, hosts, fileMetaInfo, this.isOriginal, this.hasBase, this.deltas, scaledProjSize);
        }

        @Override
        public List<OrcSplit> call() throws IOException {
            if (this.ugi == null) {
                return this.callInternal();
            }
            try {
                return (List)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<OrcSplit>>(){

                    @Override
                    public List<OrcSplit> run() throws Exception {
                        return SplitGenerator.this.callInternal();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        private List<OrcSplit> callInternal() throws IOException {
            this.populateAndCacheStripeDetails();
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            boolean[] includeStripe = null;
            if ((this.deltas == null || this.deltas.isEmpty()) && this.context.sarg != null) {
                String[] colNames = OrcInputFormat.extractNeededColNames((List<OrcProto.Type>)this.types, this.context.conf, this.includedCols, this.isOriginal);
                if (colNames == null) {
                    LOG.warn("Skipping split elimination for {} as column names is null", (Object)this.file.getPath());
                } else {
                    includeStripe = OrcInputFormat.pickStripes(this.context.sarg, colNames, this.writerVersion, this.isOriginal, this.stripeStats, this.stripes.size(), this.file.getPath());
                }
            }
            if (includeStripe == null) {
                includeStripe = new boolean[this.stripes.size()];
                Arrays.fill(includeStripe, true);
            }
            long currentOffset = -1L;
            long currentLength = 0L;
            int idx = -1;
            for (StripeInformation stripe : this.stripes) {
                if (!includeStripe[++idx]) {
                    if (currentOffset == -1L) continue;
                    splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
                    currentOffset = -1L;
                    continue;
                }
                if (currentOffset != -1L && currentLength > this.context.minSize && currentOffset / this.blockSize != stripe.getOffset() / this.blockSize) {
                    splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
                    currentOffset = -1L;
                }
                if (currentOffset == -1L) {
                    currentOffset = stripe.getOffset();
                    currentLength = stripe.getLength();
                } else {
                    currentLength = stripe.getOffset() + stripe.getLength() - currentOffset;
                }
                if (currentLength < this.context.maxSize) continue;
                splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
                currentOffset = -1L;
            }
            if (currentOffset != -1L) {
                splits.add(this.createSplit(currentOffset, currentLength, this.fileMetaInfo));
            }
            splits.addAll(this.deltaSplits);
            return splits;
        }

        private void populateAndCacheStripeDetails() throws IOException {
            List colStatsLocal;
            List typesLocal;
            if (this.fileInfo != null) {
                this.stripes = this.fileInfo.stripeInfos;
                this.stripeStats = this.fileInfo.stripeStats;
                this.fileMetaInfo = this.fileInfo.fileMetaInfo;
                typesLocal = this.types = this.fileInfo.types;
                colStatsLocal = this.fileInfo.fileStats;
                this.writerVersion = this.fileInfo.writerVersion;
                if (this.fileMetaInfo == null && this.context.footerInSplits) {
                    Reader orcReader = this.createOrcReader();
                    this.fileInfo.fileMetaInfo = ((ReaderImpl)orcReader).getFileMetaInfo();
                    assert (this.fileInfo.stripeStats != null && this.fileInfo.types != null && this.fileInfo.writerVersion != null);
                    this.context.footerCache.put(this.fileWithId.getFileId(), this.file, this.fileInfo.fileMetaInfo, orcReader);
                }
            } else {
                Reader orcReader = this.createOrcReader();
                this.stripes = orcReader.getStripes();
                this.types = orcReader.getTypes();
                typesLocal = this.types;
                colStatsLocal = orcReader.getOrcProtoFileStatistics();
                this.writerVersion = orcReader.getWriterVersion();
                this.stripeStats = orcReader.getStripeStatistics();
                FileMetaInfo fileMetaInfo = this.fileMetaInfo = this.context.footerInSplits ? ((ReaderImpl)orcReader).getFileMetaInfo() : null;
                if (this.context.cacheStripeDetails) {
                    Long fileId = this.fileWithId.getFileId();
                    this.context.footerCache.put(fileId, this.file, this.fileMetaInfo, orcReader);
                }
            }
            this.includedCols = OrcInputFormat.genIncludedColumns(this.types, this.context.conf, this.isOriginal);
            this.projColsUncompressedSize = this.computeProjectionSize(typesLocal, colStatsLocal, this.includedCols, this.isOriginal);
        }

        private Reader createOrcReader() throws IOException {
            return OrcFile.createReader(this.file.getPath(), OrcFile.readerOptions(this.context.conf).filesystem(this.fs));
        }

        private long computeProjectionSize(List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats, boolean[] includedCols, boolean isOriginal) {
            int rootIdx = OrcInputFormat.getRootColumn(isOriginal);
            ArrayList<Integer> internalColIds = Lists.newArrayList();
            if (includedCols != null) {
                for (int i = 0; i < includedCols.length; ++i) {
                    if (!includedCols[i]) continue;
                    internalColIds.add(rootIdx + i);
                }
            }
            return ReaderImpl.getRawDataSizeFromColIndices(internalColIds, types, stats);
        }
    }

    static final class FileGenerator
    implements Callable<AcidDirInfo> {
        private final Context context;
        private final FileSystem fs;
        private final Path dir;
        private final boolean useFileIds;
        private final UserGroupInformation ugi;

        FileGenerator(Context context, FileSystem fs, Path dir, boolean useFileIds, UserGroupInformation ugi) {
            this.context = context;
            this.fs = fs;
            this.dir = dir;
            this.useFileIds = useFileIds;
            this.ugi = ugi;
        }

        @Override
        public AcidDirInfo call() throws IOException {
            if (this.ugi == null) {
                return this.callInternal();
            }
            try {
                return (AcidDirInfo)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AcidDirInfo>(){

                    @Override
                    public AcidDirInfo run() throws Exception {
                        return FileGenerator.this.callInternal();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        private AcidDirInfo callInternal() throws IOException {
            AcidUtils.Directory dirInfo = AcidUtils.getAcidState(this.dir, this.context.conf, this.context.transactionList, this.useFileIds);
            Path base = dirInfo.getBaseDirectory();
            List<HadoopShims.HdfsFileStatusWithId> children = base == null ? dirInfo.getOriginalFiles() : this.findBaseFiles(base, this.useFileIds);
            return new AcidDirInfo(this.fs, this.dir, dirInfo, children);
        }

        private List<HadoopShims.HdfsFileStatusWithId> findBaseFiles(Path base, boolean useFileIds) throws IOException {
            if (useFileIds) {
                try {
                    return SHIMS.listLocatedHdfsStatus(this.fs, base, AcidUtils.hiddenFileFilter);
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API", t);
                }
            }
            List<FileStatus> children = SHIMS.listLocatedStatus(this.fs, base, AcidUtils.hiddenFileFilter);
            ArrayList<HadoopShims.HdfsFileStatusWithId> result = new ArrayList<HadoopShims.HdfsFileStatusWithId>(children.size());
            for (FileStatus child : children) {
                result.add(AcidUtils.createOriginalObj(null, child));
            }
            return result;
        }
    }

    static class ACIDSplitStrategy
    implements SplitStrategy<OrcSplit> {
        Path dir;
        List<AcidInputFormat.DeltaMetaData> deltas;
        boolean[] covered;
        int numBuckets;

        public ACIDSplitStrategy(Path dir, int numBuckets, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered) {
            this.dir = dir;
            this.numBuckets = numBuckets;
            this.deltas = deltas;
            this.covered = covered;
        }

        @Override
        public List<OrcSplit> getSplits() throws IOException {
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            if (!this.deltas.isEmpty()) {
                for (int b = 0; b < this.numBuckets; ++b) {
                    if (this.covered[b]) continue;
                    splits.add(new OrcSplit(this.dir, null, b, 0L, new String[0], null, false, false, this.deltas, -1L));
                }
            }
            return splits;
        }

        public String toString() {
            return ACIDSplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class BISplitStrategy
    extends ACIDSplitStrategy {
        List<HadoopShims.HdfsFileStatusWithId> fileStatuses;
        boolean isOriginal;
        List<AcidInputFormat.DeltaMetaData> deltas;
        FileSystem fs;
        Context context;
        Path dir;

        public BISplitStrategy(Context context, FileSystem fs, Path dir, List<HadoopShims.HdfsFileStatusWithId> fileStatuses, boolean isOriginal, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered) {
            super(dir, context.numBuckets, deltas, covered);
            this.context = context;
            this.fileStatuses = fileStatuses;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.fs = fs;
            this.dir = dir;
        }

        @Override
        public List<OrcSplit> getSplits() throws IOException {
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            for (HadoopShims.HdfsFileStatusWithId file : this.fileStatuses) {
                FileStatus fileStatus = file.getFileStatus();
                String[] hosts = SHIMS.getLocationsWithOffset(this.fs, fileStatus).firstEntry().getValue().getHosts();
                OrcSplit orcSplit = new OrcSplit(fileStatus.getPath(), file.getFileId(), 0L, fileStatus.getLen(), hosts, null, this.isOriginal, true, this.deltas, -1L);
                splits.add(orcSplit);
            }
            splits.addAll(super.getSplits());
            return splits;
        }

        @Override
        public String toString() {
            return BISplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class ETLSplitStrategy
    implements SplitStrategy<SplitInfo>,
    Callable<Void> {
        private static final int ETL_COMBINE_FILE_LIMIT = 500;
        Context context;
        List<ETLDir> dirs;
        List<HadoopShims.HdfsFileStatusWithId> files;
        boolean isOriginal;
        List<AcidInputFormat.DeltaMetaData> deltas;
        boolean[] covered;
        private List<Future<List<OrcSplit>>> splitFuturesRef;
        private final UserGroupInformation ugi;

        public ETLSplitStrategy(Context context, FileSystem fs, Path dir, List<HadoopShims.HdfsFileStatusWithId> children, boolean isOriginal, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered, UserGroupInformation ugi) {
            assert (!children.isEmpty());
            this.context = context;
            this.dirs = Lists.newArrayList(new ETLDir(dir, fs, children.size()));
            this.files = children;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.covered = covered;
            this.ugi = ugi;
        }

        @Override
        public List<SplitInfo> getSplits() throws IOException {
            LocalCache cache;
            ArrayList<SplitInfo> result = new ArrayList<SplitInfo>(this.files.size());
            FooterCache footerCache = this.context.cacheStripeDetails ? (this.deltas == null ? this.context.footerCache : Context.localCache) : (cache = null);
            if (cache != null) {
                FileInfo[] infos = cache.getAndValidate(this.files);
                int dirIx = -1;
                int fileInDirIx = -1;
                int filesInDirCount = 0;
                ETLDir dir = null;
                for (int i = 0; i < this.files.size(); ++i) {
                    HadoopShims.HdfsFileStatusWithId file;
                    FileInfo info;
                    if (++fileInDirIx == filesInDirCount) {
                        dir = this.dirs.get(++dirIx);
                        filesInDirCount = dir.fileCount;
                    }
                    if ((info = infos[i]) != null) {
                        this.context.cacheHitCounter.incrementAndGet();
                    }
                    if ((file = this.files.get(i)).getFileStatus().getLen() <= 0L) continue;
                    result.add(new SplitInfo(this.context, dir.fs, file, info, this.isOriginal, this.deltas, true, dir.dir, this.covered));
                }
            } else {
                int dirIx = -1;
                int fileInDirIx = -1;
                int filesInDirCount = 0;
                ETLDir dir = null;
                for (HadoopShims.HdfsFileStatusWithId file : this.files) {
                    if (++fileInDirIx == filesInDirCount) {
                        dir = this.dirs.get(++dirIx);
                        filesInDirCount = dir.fileCount;
                    }
                    if (file.getFileStatus().getLen() <= 0L) continue;
                    result.add(new SplitInfo(this.context, dir.fs, file, null, this.isOriginal, this.deltas, true, dir.dir, this.covered));
                }
            }
            return result;
        }

        public String toString() {
            if (this.dirs.size() == 1) {
                return ETLSplitStrategy.class.getSimpleName() + " strategy for " + this.dirs.get(0).dir;
            }
            StringBuilder sb = new StringBuilder(ETLSplitStrategy.class.getSimpleName() + " strategy for ");
            boolean isFirst = true;
            for (ETLDir dir : this.dirs) {
                if (!isFirst) {
                    sb.append(", ");
                }
                isFirst = false;
                sb.append(dir.dir);
            }
            return sb.toString();
        }

        public CombineResult combineWith(FileSystem fs, Path dir, List<HadoopShims.HdfsFileStatusWithId> otherFiles, boolean isOriginal) {
            if (this.files.size() + otherFiles.size() > 500 || this.isOriginal != isOriginal) {
                return this.files.size() > otherFiles.size() ? CombineResult.NO_AND_SWAP : CombineResult.NO_AND_CONTINUE;
            }
            this.files.addAll(otherFiles);
            this.dirs.add(new ETLDir(dir, fs, otherFiles.size()));
            return CombineResult.YES;
        }

        public Future<Void> generateSplitWork(Context context, List<Future<List<OrcSplit>>> splitFutures) throws IOException {
            if (context.cacheStripeDetails && context.footerCache.isBlocking() || context.forceThreadpool) {
                this.splitFuturesRef = splitFutures;
                return Context.threadPool.submit(this);
            }
            this.runGetSplitsSync(splitFutures, null);
            return null;
        }

        @Override
        public Void call() throws IOException {
            if (this.ugi == null) {
                this.runGetSplitsSync(this.splitFuturesRef, null);
                return null;
            }
            try {
                return (Void)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ETLSplitStrategy.this.runGetSplitsSync(ETLSplitStrategy.this.splitFuturesRef, ETLSplitStrategy.this.ugi);
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runGetSplitsSync(List<Future<List<OrcSplit>>> splitFutures, UserGroupInformation ugi) throws IOException {
            List<SplitInfo> splits = this.getSplits();
            ArrayList<Future<List<OrcSplit>>> localList = new ArrayList<Future<List<OrcSplit>>>(splits.size());
            UserGroupInformation tpUgi = ugi == null ? UserGroupInformation.getCurrentUser() : ugi;
            for (SplitInfo splitInfo : splits) {
                localList.add(Context.threadPool.submit(new SplitGenerator(splitInfo, tpUgi)));
            }
            List<Future<List<OrcSplit>>> list = splitFutures;
            synchronized (list) {
                splitFutures.addAll(localList);
            }
        }

        static enum CombineResult {
            YES,
            NO_AND_CONTINUE,
            NO_AND_SWAP;

        }

        private static class ETLDir {
            private final int fileCount;
            private final Path dir;
            private final FileSystem fs;

            public ETLDir(Path dir, FileSystem fs, int fileCount) {
                this.dir = dir;
                this.fs = fs;
                this.fileCount = fileCount;
            }
        }
    }

    @VisibleForTesting
    static final class SplitInfo
    extends ACIDSplitStrategy {
        private final Context context;
        private final FileSystem fs;
        private final HadoopShims.HdfsFileStatusWithId fileWithId;
        private final FileInfo fileInfo;
        private final boolean isOriginal;
        private final List<AcidInputFormat.DeltaMetaData> deltas;
        private final boolean hasBase;

        SplitInfo(Context context, FileSystem fs, HadoopShims.HdfsFileStatusWithId fileWithId, FileInfo fileInfo, boolean isOriginal, List<AcidInputFormat.DeltaMetaData> deltas, boolean hasBase, Path dir, boolean[] covered) throws IOException {
            super(dir, context.numBuckets, deltas, covered);
            this.context = context;
            this.fs = fs;
            this.fileWithId = fileWithId;
            this.fileInfo = fileInfo;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.hasBase = hasBase;
        }

        @VisibleForTesting
        public SplitInfo(Context context, FileSystem fs, FileStatus fileStatus, FileInfo fileInfo, boolean isOriginal, ArrayList<AcidInputFormat.DeltaMetaData> deltas, boolean hasBase, Path dir, boolean[] covered) throws IOException {
            this(context, fs, AcidUtils.createOriginalObj(null, fileStatus), fileInfo, isOriginal, deltas, hasBase, dir, covered);
        }
    }

    @VisibleForTesting
    static interface SplitStrategy<T> {
        public List<T> getSplits() throws IOException;
    }

    @VisibleForTesting
    static final class AcidDirInfo {
        final FileSystem fs;
        final Path splitPath;
        final AcidUtils.Directory acidInfo;
        final List<HadoopShims.HdfsFileStatusWithId> baseOrOriginalFiles;

        public AcidDirInfo(FileSystem fs, Path splitPath, AcidUtils.Directory acidInfo, List<HadoopShims.HdfsFileStatusWithId> baseOrOriginalFiles) {
            this.splitPath = splitPath;
            this.acidInfo = acidInfo;
            this.baseOrOriginalFiles = baseOrOriginalFiles;
            this.fs = fs;
        }
    }

    static class Context {
        private final Configuration conf;
        private FooterCache footerCache;
        private static LocalCache localCache;
        private static MetastoreCache metaCache;
        static ExecutorService threadPool;
        private final int numBuckets;
        private final int splitStrategyBatchMs;
        private final long maxSize;
        private final long minSize;
        private final int minSplits;
        private final boolean footerInSplits;
        private final boolean cacheStripeDetails;
        private final boolean forceThreadpool;
        private final AtomicInteger cacheHitCounter = new AtomicInteger(0);
        private final AtomicInteger numFilesCounter = new AtomicInteger(0);
        private final ValidTxnList transactionList;
        private SplitStrategyKind splitStrategyKind;
        private final SearchArgument sarg;

        Context(Configuration conf) {
            this(conf, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(Configuration conf, int minSplits) {
            this.conf = conf;
            this.forceThreadpool = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_IN_TEST);
            this.sarg = ConvertAstToSearchArg.createFromConf(conf);
            this.minSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.MAPREDMINSPLITSIZE, 0x1000000L);
            this.maxSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE, 0x10000000L);
            String ss = conf.get(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname);
            if (ss == null || ss.equals(SplitStrategyKind.HYBRID.name())) {
                this.splitStrategyKind = SplitStrategyKind.HYBRID;
            } else {
                LOG.info("Enforcing " + ss + " ORC split strategy");
                this.splitStrategyKind = SplitStrategyKind.valueOf(ss);
            }
            this.footerInSplits = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_INCLUDE_FILE_FOOTER_IN_SPLITS);
            this.numBuckets = Math.max(conf.getInt("bucket_count", 0), 0);
            this.splitStrategyBatchMs = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_SPLIT_DIRECTORY_BATCH_MS);
            LOG.debug("Number of buckets specified by conf file is " + this.numBuckets);
            int cacheStripeDetailsSize = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_SIZE);
            int numThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_COMPUTE_SPLITS_NUM_THREADS);
            this.cacheStripeDetails = cacheStripeDetailsSize > 0;
            this.minSplits = Math.min(cacheStripeDetailsSize, minSplits);
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                if (threadPool == null) {
                    threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ORC_GET_SPLITS #%d").build());
                }
                if (this.cacheStripeDetails) {
                    boolean useMetastoreCache = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_ENABLED);
                    if (localCache == null) {
                        localCache = new LocalCache(numThreads, cacheStripeDetailsSize);
                    }
                    if (useMetastoreCache) {
                        if (metaCache == null) {
                            metaCache = new MetastoreCache(localCache);
                        }
                        assert (conf instanceof HiveConf);
                        metaCache.configure((HiveConf)conf);
                    }
                    this.footerCache = useMetastoreCache ? metaCache : localCache;
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                String value = conf.get("hive.txn.valid.txns", "9223372036854775807:");
                this.transactionList = new ValidReadTxnList(value);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        static int getCurrentThreadPoolSize() {
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return threadPool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)threadPool).getPoolSize() : (threadPool == null ? 0 : -1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public static void resetThreadPool() {
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                threadPool = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        static {
            threadPool = null;
        }
    }

    private static class OrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct>,
    StatsProvidingRecordReader {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private final int numColumns;
        private float progress = 0.0f;
        private final Reader file;
        private final SerDeStats stats;

        OrcRecordReader(Reader file, Configuration conf, FileSplit split) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            this.file = file;
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            this.offset = split.getStart();
            this.length = split.getLength();
            this.reader = OrcInputFormat.createReaderFromFile(file, conf, this.offset, this.length);
            this.stats = new SerDeStats();
        }

        public boolean next(NullWritable key, OrcStruct value) throws IOException {
            if (this.reader.hasNext()) {
                this.reader.next(value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return new OrcStruct(this.numColumns);
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }

        @Override
        public SerDeStats getStats() {
            this.stats.setRawDataSize(this.file.getRawDataSize());
            this.stats.setRowCount(this.file.getNumberOfRows());
            return this.stats;
        }
    }

    static enum SplitStrategyKind {
        HYBRID,
        BI,
        ETL;

    }
}

