/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTask
extends Task<MoveWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(MoveTask.class);

    private void moveFile(Path sourcePath, Path targetPath, boolean isDfsDir) throws Exception {
        FileSystem fs = sourcePath.getFileSystem((Configuration)this.conf);
        if (isDfsDir) {
            String mesg = "Moving data to: " + targetPath.toString();
            String mesg_detail = " from " + sourcePath.toString();
            this.console.printInfo(mesg, mesg_detail);
            if (fs.exists(sourcePath)) {
                Path deletePath = null;
                if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_INSERT_INTO_MULTILEVEL_DIRS)) {
                    deletePath = this.createTargetPath(targetPath, fs);
                }
                if (!Hive.moveFile(this.conf, sourcePath, targetPath, true, false)) {
                    try {
                        if (deletePath != null) {
                            fs.delete(deletePath, true);
                        }
                    }
                    catch (IOException e) {
                        LOG.info("Unable to delete the path created for facilitating rename" + deletePath);
                    }
                    throw new HiveException("Unable to rename: " + sourcePath + " to: " + targetPath);
                }
            } else if (!fs.mkdirs(targetPath)) {
                throw new HiveException("Unable to make directory: " + targetPath);
            }
        } else {
            String mesg = "Copying data to local directory " + targetPath.toString();
            String mesg_detail = " from " + sourcePath.toString();
            this.console.printInfo(mesg, mesg_detail);
            LocalFileSystem dstFs = FileSystem.getLocal((Configuration)this.conf);
            if (dstFs.delete(targetPath, true) || !dstFs.exists(targetPath)) {
                if (fs.exists(sourcePath)) {
                    FileStatus[] srcs;
                    try {
                        if (!dstFs.exists(targetPath) && !FileUtils.mkdir((FileSystem)dstFs, targetPath, false, this.conf)) {
                            throw new HiveException("Failed to create local target directory for copy:" + targetPath);
                        }
                    }
                    catch (IOException e) {
                        throw new HiveException("Unable to create target directory for copy" + targetPath, e);
                    }
                    FileSystem srcFs = sourcePath.getFileSystem((Configuration)this.conf);
                    for (FileStatus status : srcs = srcFs.listStatus(sourcePath, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                        fs.copyToLocalFile(status.getPath(), targetPath);
                    }
                } else if (!dstFs.mkdirs(targetPath)) {
                    throw new HiveException("Unable to make local directory: " + targetPath);
                }
            } else {
                throw new AccessControlException("Unable to delete the existing destination directory: " + targetPath);
            }
        }
    }

    private Path createTargetPath(Path targetPath, FileSystem fs) throws IOException {
        Path deletePath = null;
        Path mkDirPath = targetPath.getParent();
        if (mkDirPath != null && !fs.exists(mkDirPath)) {
            Path actualPath;
            for (actualPath = mkDirPath; actualPath != null && !fs.exists(actualPath); actualPath = actualPath.getParent()) {
                deletePath = actualPath;
            }
            fs.mkdirs(mkDirPath);
            HadoopShims shims = ShimLoader.getHadoopShims();
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS)) {
                try {
                    HadoopShims.HdfsFileStatus status = shims.getFullFileStatus(this.conf, fs, actualPath);
                    shims.setFullFileStatus(this.conf, status, fs, actualPath);
                }
                catch (Exception e) {
                    LOG.warn("Error setting permissions or group of " + actualPath, (Throwable)e);
                }
            }
        }
        return deletePath;
    }

    private void releaseLocks(LoadTableDesc ltd) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            return;
        }
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveTxnManager().getLockManager();
        WriteEntity output = ctx.getLoadTableOutputMap().get(ltd);
        List<HiveLockObj> lockObjects = ctx.getOutputLockObjects().get(output);
        if (lockObjects == null) {
            return;
        }
        for (HiveLockObj lockObj : lockObjects) {
            List<HiveLock> locks = lockMgr.getLocks(lockObj.getObj(), false, true);
            for (HiveLock lock2 : locks) {
                if (lock2.getHiveLockMode() != lockObj.getMode()) continue;
                LOG.info("about to release lock for output: " + output.toString() + " lock: " + lock2.getHiveLockObject().getName());
                lockMgr.unlock(lock2);
                ctx.getHiveLocks().remove(lock2);
            }
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            LoadTableDesc tbd;
            LoadMultiFilesDesc lmfd;
            LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
            if (lfd != null) {
                Path targetPath = lfd.getTargetDir();
                Path sourcePath = lfd.getSourcePath();
                this.moveFile(sourcePath, targetPath, lfd.getIsDfsDir());
            }
            if ((lmfd = ((MoveWork)this.work).getLoadMultiFilesWork()) != null) {
                boolean isDfsDir = lmfd.getIsDfsDir();
                for (int i = 0; i < lmfd.getSourceDirs().size(); ++i) {
                    Path srcPath = lmfd.getSourceDirs().get(i);
                    Path destPath = lmfd.getTargetDirs().get(i);
                    FileSystem fs = destPath.getFileSystem((Configuration)this.conf);
                    if (!fs.exists(destPath.getParent())) {
                        fs.mkdirs(destPath.getParent());
                    }
                    this.moveFile(srcPath, destPath, isDfsDir);
                }
            }
            if ((tbd = ((MoveWork)this.work).getLoadTableWork()) != null) {
                StringBuilder mesg = new StringBuilder("Loading data to table ").append(tbd.getTable().getTableName());
                if (tbd.getPartitionSpec().size() > 0) {
                    mesg.append(" partition (");
                    Map<String, String> partSpec = tbd.getPartitionSpec();
                    for (String key : partSpec.keySet()) {
                        mesg.append(key).append('=').append(partSpec.get(key)).append(", ");
                    }
                    mesg.setLength(mesg.length() - 2);
                    mesg.append(')');
                }
                String mesg_detail = " from " + tbd.getSourcePath();
                this.console.printInfo(mesg.toString(), mesg_detail);
                Table table = this.db.getTable(tbd.getTable().getTableName());
                if (((MoveWork)this.work).getCheckFileFormat()) {
                    ArrayList<FileStatus> files;
                    FileSystem srcFs;
                    try {
                        srcFs = tbd.getSourcePath().getFileSystem((Configuration)this.conf);
                        FileStatus[] dirs = srcFs.globStatus(tbd.getSourcePath());
                        files = new ArrayList<FileStatus>();
                        for (int i = 0; dirs != null && i < dirs.length; ++i) {
                            files.addAll(Arrays.asList(srcFs.listStatus(dirs[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER)));
                            if (files.size() <= 0) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw new HiveException("addFiles: filesystem error in check phase", e);
                    }
                    if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVECHECKFILEFORMAT)) {
                        boolean flag = true;
                        if (tbd.getDPCtx() == null) {
                            Partition oldPart;
                            flag = tbd.getPartitionSpec() == null || tbd.getPartitionSpec().isEmpty() ? HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, tbd.getTable().getInputFileFormatClass(), files) : ((oldPart = this.db.getPartition(table, tbd.getPartitionSpec(), false)) == null ? HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, tbd.getTable().getInputFileFormatClass(), files) : HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, oldPart.getInputFormatClass(), files));
                            if (!flag) {
                                throw new HiveException("Wrong file format. Please check the file's format.");
                            }
                        } else {
                            LOG.warn("Skipping file format check as dpCtx is not null");
                        }
                    }
                }
                LineageInfo.DataContainer dc = null;
                if (tbd.getPartitionSpec().size() == 0) {
                    dc = new LineageInfo.DataContainer(table.getTTable());
                    this.db.loadTable(tbd.getSourcePath(), tbd.getTable().getTableName(), tbd.getReplace(), ((MoveWork)this.work).isSrcLocal(), this.isSkewedStoredAsDirs(tbd), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID);
                    if (((MoveWork)this.work).getOutputs() != null) {
                        ((MoveWork)this.work).getOutputs().add(new WriteEntity(table, tbd.getReplace() ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT));
                    }
                } else {
                    DynamicPartitionCtx dpCtx;
                    LOG.info("Partition is: " + tbd.getPartitionSpec().toString());
                    List<BucketingSortingCtx.BucketCol> bucketCols = null;
                    List<BucketingSortingCtx.SortCol> sortCols = null;
                    int numBuckets = -1;
                    Task task = this;
                    String path = tbd.getSourcePath().toUri().toString();
                    while (task.getParentTasks() != null && task.getParentTasks().size() == 1 && !((task = task.getParentTasks().get(0)) instanceof MergeFileTask) && !(task instanceof MapredLocalTask)) {
                        if (task instanceof MapRedTask) {
                            MapredWork work = (MapredWork)task.getWork();
                            MapWork mapWork = work.getMapWork();
                            bucketCols = mapWork.getBucketedColsByDirectory().get(path);
                            sortCols = mapWork.getSortedColsByDirectory().get(path);
                            if (work.getReduceWork() != null) {
                                numBuckets = work.getReduceWork().getNumReduceTasks();
                            }
                            if (bucketCols != null || sortCols != null) assert (work.isFinalMapRed());
                            break;
                        }
                        if (!(task instanceof MoveTask) || ((MoveWork)((MoveTask)task).getWork()).getLoadFileWork() == null) continue;
                        path = ((MoveWork)((MoveTask)task).getWork()).getLoadFileWork().getSourcePath().toUri().toString();
                    }
                    if ((dpCtx = tbd.getDPCtx()) != null && dpCtx.getNumDPCols() > 0) {
                        List<LinkedHashMap<String, String>> dps = Utilities.getFullDPSpecs(this.conf, dpCtx);
                        if (dps != null && dps.size() > 0) {
                            this.pushFeed(Task.FeedType.DYNAMIC_PARTITIONS, dps);
                        }
                        this.console.printInfo(System.getProperty("line.separator"));
                        long startTime = System.currentTimeMillis();
                        Map<Map<String, String>, Partition> dp = this.db.loadDynamicPartitions(tbd.getSourcePath(), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getReplace(), dpCtx.getNumDPCols(), this.isSkewedStoredAsDirs(tbd), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID, SessionState.get().getTxnMgr().getCurrentTxnId());
                        this.console.printInfo("\t Time taken to load dynamic partitions: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
                        if (dp.size() == 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ERROR_ON_EMPTY_PARTITION)) {
                            throw new HiveException("This query creates no partitions. To turn off this error, set hive.error.on.empty.partition=false.");
                        }
                        startTime = System.currentTimeMillis();
                        for (Map.Entry<Map<String, String>, Partition> entry : dp.entrySet()) {
                            Partition partn = entry.getValue();
                            if (bucketCols != null || sortCols != null) {
                                this.updatePartitionBucketSortColumns(table, partn, bucketCols, numBuckets, sortCols);
                            }
                            WriteEntity enty = new WriteEntity(partn, tbd.getReplace() ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT);
                            if (((MoveWork)this.work).getOutputs() != null) {
                                ((MoveWork)this.work).getOutputs().add(enty);
                            }
                            if (this.queryPlan.getOutputs() == null) {
                                this.queryPlan.setOutputs(new LinkedHashSet<WriteEntity>());
                            }
                            this.queryPlan.getOutputs().add(enty);
                            dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
                            if (SessionState.get() != null && ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.DELETE && ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.UPDATE) {
                                SessionState.get().getLineageState().setLineage(tbd.getSourcePath(), dc, table.getCols());
                            }
                            LOG.info("\tLoading partition " + entry.getKey());
                        }
                        this.console.printInfo("\t Time taken for adding to write entity : " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
                        dc = null;
                    } else {
                        List<String> partVals = MetaStoreUtils.getPvals(table.getPartCols(), tbd.getPartitionSpec());
                        this.db.validatePartitionNameCharacters(partVals);
                        this.db.loadPartition(tbd.getSourcePath(), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getReplace(), tbd.getInheritTableSpecs(), this.isSkewedStoredAsDirs(tbd), ((MoveWork)this.work).isSrcLocal(), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID);
                        Partition partn = this.db.getPartition(table, tbd.getPartitionSpec(), false);
                        if (bucketCols != null || sortCols != null) {
                            this.updatePartitionBucketSortColumns(table, partn, bucketCols, numBuckets, sortCols);
                        }
                        dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
                        if (((MoveWork)this.work).getOutputs() != null) {
                            ((MoveWork)this.work).getOutputs().add(new WriteEntity(partn, tbd.getReplace() ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT));
                        }
                    }
                }
                if (SessionState.get() != null && dc != null) {
                    List<FieldSchema> tableCols = null;
                    switch (((MoveWork)this.work).getLoadTableWork().getWriteType()) {
                        case DELETE: 
                        case UPDATE: {
                            tableCols = new ArrayList<FieldSchema>();
                            break;
                        }
                        default: {
                            tableCols = table.getCols();
                        }
                    }
                    SessionState.get().getLineageState().setLineage(tbd.getSourcePath(), dc, tableCols);
                }
                this.releaseLocks(tbd);
            }
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private boolean isSkewedStoredAsDirs(LoadTableDesc tbd) {
        return tbd.getLbCtx() == null ? false : tbd.getLbCtx().isSkewedStoredAsDir();
    }

    private void updatePartitionBucketSortColumns(Table table, Partition partn, List<BucketingSortingCtx.BucketCol> bucketCols, int numBuckets, List<BucketingSortingCtx.SortCol> sortCols) throws IOException, InvalidOperationException, HiveException {
        boolean updateBucketCols = false;
        if (bucketCols != null) {
            FileSystem fileSys = partn.getDataLocation().getFileSystem((Configuration)this.conf);
            FileStatus[] fileStatus = HiveStatsUtils.getFileStatusRecurse(partn.getDataLocation(), 1, fileSys);
            if (fileStatus.length == numBuckets) {
                ArrayList<String> newBucketCols = new ArrayList<String>();
                updateBucketCols = true;
                for (BucketingSortingCtx.BucketCol bucketCol : bucketCols) {
                    if (bucketCol.getIndexes().get(0) < partn.getCols().size()) {
                        newBucketCols.add(partn.getCols().get(bucketCol.getIndexes().get(0)).getName());
                        continue;
                    }
                    updateBucketCols = false;
                    break;
                }
                if (updateBucketCols) {
                    partn.getBucketCols().clear();
                    partn.getBucketCols().addAll(newBucketCols);
                    partn.getTPartition().getSd().setNumBuckets(numBuckets);
                }
            }
        }
        boolean updateSortCols = false;
        if (sortCols != null) {
            ArrayList<Order> newSortCols = new ArrayList<Order>();
            updateSortCols = true;
            for (BucketingSortingCtx.SortCol sortCol : sortCols) {
                if (sortCol.getIndexes().get(0) < partn.getCols().size()) {
                    newSortCols.add(new Order(partn.getCols().get(sortCol.getIndexes().get(0)).getName(), sortCol.getSortOrder() == '+' ? BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC : BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_DESC));
                    continue;
                }
                updateSortCols = false;
                break;
            }
            if (updateSortCols) {
                partn.getSortCols().clear();
                partn.getSortCols().addAll(newSortCols);
            }
        }
        if (updateBucketCols || updateSortCols) {
            this.db.alterPartition(table.getDbName(), table.getTableName(), partn);
        }
    }

    public boolean isLocal() {
        LoadTableDesc tbd = ((MoveWork)this.work).getLoadTableWork();
        if (tbd != null) {
            return false;
        }
        LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
        if (lfd != null) {
            return !lfd.getIsDfsDir();
        }
        return false;
    }

    @Override
    public StageType getType() {
        return StageType.MOVE;
    }

    @Override
    public String getName() {
        return "MOVE";
    }
}

