/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateTask;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableAlterPartDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableExchangePartition;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowConfDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTxnsDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveV1Authorizer;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.common.util.AnnotationUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.exec.DDLTask");
    private static final int separator = 9;
    private static final int terminator = 10;
    private static String INTERMEDIATE_ARCHIVED_DIR_SUFFIX;
    private static String INTERMEDIATE_ORIGINAL_DIR_SUFFIX;
    private static String INTERMEDIATE_EXTRACTED_DIR_SUFFIX;
    private MetaDataFormatter formatter;
    private final HiveAuthorizationTranslator defaultAuthorizationTranslator = new DefaultHiveAuthorizationTranslator();
    private static final String[] DELIMITER_PREFIXES;
    public static final String DATABASE_PATH_SUFFIX = ".db";

    @Override
    public boolean requireLock() {
        return this.work != null && ((DDLWork)this.work).getNeedLock();
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx, CompilationOpContext opContext) {
        super.initialize(conf, queryPlan, ctx, opContext);
        this.formatter = MetaDataFormatUtils.getFormatter(conf);
        INTERMEDIATE_ARCHIVED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        INTERMEDIATE_ORIGINAL_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        INTERMEDIATE_EXTRACTED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            MsckDesc msckDesc;
            Hive db = Hive.get(this.conf);
            CreateDatabaseDesc createDatabaseDesc = ((DDLWork)this.work).getCreateDatabaseDesc();
            if (null != createDatabaseDesc) {
                return this.createDatabase(db, createDatabaseDesc);
            }
            DropDatabaseDesc dropDatabaseDesc = ((DDLWork)this.work).getDropDatabaseDesc();
            if (dropDatabaseDesc != null) {
                return this.dropDatabase(db, dropDatabaseDesc);
            }
            LockDatabaseDesc lockDatabaseDesc = ((DDLWork)this.work).getLockDatabaseDesc();
            if (lockDatabaseDesc != null) {
                return this.lockDatabase(lockDatabaseDesc);
            }
            UnlockDatabaseDesc unlockDatabaseDesc = ((DDLWork)this.work).getUnlockDatabaseDesc();
            if (unlockDatabaseDesc != null) {
                return this.unlockDatabase(unlockDatabaseDesc);
            }
            SwitchDatabaseDesc switchDatabaseDesc = ((DDLWork)this.work).getSwitchDatabaseDesc();
            if (switchDatabaseDesc != null) {
                return this.switchDatabase(db, switchDatabaseDesc);
            }
            DescDatabaseDesc descDatabaseDesc = ((DDLWork)this.work).getDescDatabaseDesc();
            if (descDatabaseDesc != null) {
                return this.descDatabase(descDatabaseDesc);
            }
            AlterDatabaseDesc alterDatabaseDesc = ((DDLWork)this.work).getAlterDatabaseDesc();
            if (alterDatabaseDesc != null) {
                return this.alterDatabase(alterDatabaseDesc);
            }
            CreateTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            CreateIndexDesc crtIndex = ((DDLWork)this.work).getCreateIndexDesc();
            if (crtIndex != null) {
                return this.createIndex(db, crtIndex);
            }
            AlterIndexDesc alterIndex = ((DDLWork)this.work).getAlterIndexDesc();
            if (alterIndex != null) {
                return this.alterIndex(db, alterIndex);
            }
            DropIndexDesc dropIdx = ((DDLWork)this.work).getDropIdxDesc();
            if (dropIdx != null) {
                return this.dropIndex(db, dropIdx);
            }
            CreateTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            DropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                this.dropTableOrPartitions(db, dropTbl);
                return 0;
            }
            AlterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                return this.alterTable(db, alterTbl);
            }
            CreateViewDesc crtView = ((DDLWork)this.work).getCreateViewDesc();
            if (crtView != null) {
                return this.createView(db, crtView);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartitions(db, addPartitionDesc);
            }
            RenamePartitionDesc renamePartitionDesc = ((DDLWork)this.work).getRenamePartitionDesc();
            if (renamePartitionDesc != null) {
                return this.renamePartition(db, renamePartitionDesc);
            }
            AlterTableSimpleDesc simpleDesc = ((DDLWork)this.work).getAlterTblSimpleDesc();
            if (simpleDesc != null) {
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.TOUCH) {
                    return this.touch(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.ARCHIVE) {
                    return this.archive(db, simpleDesc, driverContext);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.UNARCHIVE) {
                    return this.unarchive(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.COMPACT) {
                    return this.compact(db, simpleDesc);
                }
            }
            if ((msckDesc = ((DDLWork)this.work).getMsckDesc()) != null) {
                return this.msck(db, msckDesc);
            }
            DescTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            DescFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(descFunc);
            }
            ShowDatabasesDesc showDatabases = ((DDLWork)this.work).getShowDatabasesDesc();
            if (showDatabases != null) {
                return this.showDatabases(db, showDatabases);
            }
            ShowTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTables(db, showTbls);
            }
            ShowColumnsDesc showCols = ((DDLWork)this.work).getShowColumnsDesc();
            if (showCols != null) {
                return this.showColumns(db, showCols);
            }
            ShowTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            ShowTblPropertiesDesc showTblProperties = ((DDLWork)this.work).getShowTblPropertiesDesc();
            if (showTblProperties != null) {
                return this.showTableProperties(db, showTblProperties);
            }
            ShowFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(showFuncs);
            }
            ShowLocksDesc showLocks = ((DDLWork)this.work).getShowLocksDesc();
            if (showLocks != null) {
                return this.showLocks(showLocks);
            }
            ShowCompactionsDesc compactionsDesc = ((DDLWork)this.work).getShowCompactionsDesc();
            if (compactionsDesc != null) {
                return this.showCompactions(compactionsDesc);
            }
            ShowTxnsDesc txnsDesc = ((DDLWork)this.work).getShowTxnsDesc();
            if (txnsDesc != null) {
                return this.showTxns(txnsDesc);
            }
            LockTableDesc lockTbl = ((DDLWork)this.work).getLockTblDesc();
            if (lockTbl != null) {
                return this.lockTable(lockTbl);
            }
            UnlockTableDesc unlockTbl = ((DDLWork)this.work).getUnlockTblDesc();
            if (unlockTbl != null) {
                return this.unlockTable(unlockTbl);
            }
            ShowPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
            ShowCreateDatabaseDesc showCreateDb = ((DDLWork)this.work).getShowCreateDbDesc();
            if (showCreateDb != null) {
                return this.showCreateDatabase(db, showCreateDb);
            }
            ShowCreateTableDesc showCreateTbl = ((DDLWork)this.work).getShowCreateTblDesc();
            if (showCreateTbl != null) {
                return this.showCreateTable(db, showCreateTbl);
            }
            ShowConfDesc showConf = ((DDLWork)this.work).getShowConfDesc();
            if (showConf != null) {
                return this.showConf(db, showConf);
            }
            RoleDDLDesc roleDDLDesc = ((DDLWork)this.work).getRoleDDLDesc();
            if (roleDDLDesc != null) {
                return this.roleDDL(roleDDLDesc);
            }
            GrantDesc grantDesc = ((DDLWork)this.work).getGrantDesc();
            if (grantDesc != null) {
                return this.grantOrRevokePrivileges(grantDesc.getPrincipals(), grantDesc.getPrivileges(), grantDesc.getPrivilegeSubjectDesc(), grantDesc.getGrantor(), grantDesc.getGrantorType(), grantDesc.isGrantOption(), true);
            }
            RevokeDesc revokeDesc = ((DDLWork)this.work).getRevokeDesc();
            if (revokeDesc != null) {
                return this.grantOrRevokePrivileges(revokeDesc.getPrincipals(), revokeDesc.getPrivileges(), revokeDesc.getPrivilegeSubjectDesc(), null, null, revokeDesc.isGrantOption(), false);
            }
            ShowGrantDesc showGrantDesc = ((DDLWork)this.work).getShowGrantDesc();
            if (showGrantDesc != null) {
                return this.showGrants(showGrantDesc);
            }
            GrantRevokeRoleDDL grantOrRevokeRoleDDL = ((DDLWork)this.work).getGrantRevokeRoleDDL();
            if (grantOrRevokeRoleDDL != null) {
                return this.grantOrRevokeRole(grantOrRevokeRoleDDL);
            }
            ShowIndexesDesc showIndexes = ((DDLWork)this.work).getShowIndexesDesc();
            if (showIndexes != null) {
                return this.showIndexes(db, showIndexes);
            }
            AlterTablePartMergeFilesDesc mergeFilesDesc = ((DDLWork)this.work).getMergeFilesDesc();
            if (mergeFilesDesc != null) {
                return this.mergeFiles(db, mergeFilesDesc, driverContext);
            }
            AlterTableAlterPartDesc alterPartDesc = ((DDLWork)this.work).getAlterTableAlterPartDesc();
            if (alterPartDesc != null) {
                return this.alterTableAlterPart(db, alterPartDesc);
            }
            TruncateTableDesc truncateTableDesc = ((DDLWork)this.work).getTruncateTblDesc();
            if (truncateTableDesc != null) {
                return this.truncateTable(db, truncateTableDesc);
            }
            AlterTableExchangePartition alterTableExchangePartition = ((DDLWork)this.work).getAlterTableExchangePartition();
            if (alterTableExchangePartition != null) {
                return this.exchangeTablePartition(db, alterTableExchangePartition);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            return 1;
        }
        assert (false);
        return 0;
    }

    private void failed(Throwable e) {
        while (e.getCause() != null && e.getClass() == RuntimeException.class) {
            e = e.getCause();
        }
        this.setException(e);
        LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showConf(Hive db, ShowConfDesc showConf) throws Exception {
        HiveConf.ConfVars conf = HiveConf.getConfVars(showConf.getConfName());
        if (conf == null) {
            throw new HiveException("invalid configuration name " + showConf.getConfName());
        }
        String description = conf.getDescription();
        String defaultValue = conf.getDefaultValue();
        try (DataOutputStream output = this.getOutputStream(showConf.getResFile());){
            if (defaultValue != null) {
                output.write(defaultValue.getBytes());
            }
            output.write(9);
            output.write(conf.typeString().getBytes());
            output.write(9);
            if (description != null) {
                output.write(description.replaceAll(" *\n *", " ").getBytes());
            }
            output.write(10);
        }
        return 0;
    }

    private DataOutputStream getOutputStream(String resFile) throws HiveException {
        try {
            return this.getOutputStream(new Path(resFile));
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private DataOutputStream getOutputStream(Path outputFile) throws HiveException {
        try {
            FileSystem fs = outputFile.getFileSystem((Configuration)this.conf);
            return fs.create(outputFile);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private int mergeFiles(Hive db, AlterTablePartMergeFilesDesc mergeFilesDesc, DriverContext driverContext) throws HiveException {
        Task task;
        ListBucketingCtx lbCtx = mergeFilesDesc.getLbCtx();
        boolean lbatc = lbCtx == null ? false : lbCtx.isSkewedStoredAsDir();
        int lbd = lbCtx == null ? 0 : lbCtx.calculateListBucketingLevel();
        MergeFileWork mergeWork = new MergeFileWork(mergeFilesDesc.getInputDir(), mergeFilesDesc.getOutputDir(), mergeFilesDesc.getInputFormatClass().getName());
        LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
        ArrayList<String> inputDirstr = new ArrayList<String>(1);
        inputDirstr.add(mergeFilesDesc.getInputDir().toString());
        pathToAliases.put(mergeFilesDesc.getInputDir().get(0).toString(), inputDirstr);
        mergeWork.setPathToAliases(pathToAliases);
        mergeWork.setListBucketingCtx(mergeFilesDesc.getLbCtx());
        mergeWork.resolveConcatenateMerge(db.getConf());
        mergeWork.setMapperCannotSpanPartns(true);
        mergeWork.setSourceTableInputFormat(mergeFilesDesc.getInputFormatClass().getName());
        FileMergeDesc fmd = mergeFilesDesc.getInputFormatClass().equals(RCFileInputFormat.class) ? new RCFileMergeDesc() : new OrcFileMergeDesc();
        fmd.setDpCtx(null);
        fmd.setHasDynamicPartitions(false);
        fmd.setListBucketingAlterTableConcatenate(lbatc);
        fmd.setListBucketingDepth(lbd);
        fmd.setOutputPath(mergeFilesDesc.getOutputDir());
        CompilationOpContext opContext = driverContext.getCtx().getOpContext();
        Operator<FileMergeDesc> mergeOp = OperatorFactory.get(opContext, fmd);
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        aliasToWork.put(mergeFilesDesc.getInputDir().toString(), mergeOp);
        mergeWork.setAliasToWork(aliasToWork);
        DriverContext driverCxt = new DriverContext();
        if (this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            TezWork tezWork = new TezWork(this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID), this.conf);
            mergeWork.setName("File Merge");
            tezWork.add(mergeWork);
            task = new TezTask();
            task.setWork(tezWork);
        } else {
            task = new MergeFileTask();
            task.setWork(mergeWork);
        }
        task.initialize(db.getConf(), this.getQueryPlan(), driverCxt, opContext);
        int ret = task.execute(driverCxt);
        return ret;
    }

    private HiveAuthorizer getSessionAuthorizer() {
        HiveAuthorizer authorizer = SessionState.get().getAuthorizerV2();
        if (authorizer == null) {
            authorizer = new HiveV1Authorizer(this.conf, this.db);
        }
        return authorizer;
    }

    private int grantOrRevokeRole(GrantRevokeRoleDDL grantOrRevokeRoleDDL) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        HivePrincipal grantorPrinc = null;
        if (grantOrRevokeRoleDDL.getGrantor() != null) {
            grantorPrinc = new HivePrincipal(grantOrRevokeRoleDDL.getGrantor(), AuthorizationUtils.getHivePrincipalType(grantOrRevokeRoleDDL.getGrantorType()));
        }
        List<HivePrincipal> principals = AuthorizationUtils.getHivePrincipals(grantOrRevokeRoleDDL.getPrincipalDesc(), this.getAuthorizationTranslator(authorizer));
        List<String> roles = grantOrRevokeRoleDDL.getRoles();
        boolean grantOption = grantOrRevokeRoleDDL.isGrantOption();
        if (grantOrRevokeRoleDDL.getGrant()) {
            authorizer.grantRole(principals, roles, grantOption, grantorPrinc);
        } else {
            authorizer.revokeRole(principals, roles, grantOption, grantorPrinc);
        }
        return 0;
    }

    private HiveAuthorizationTranslator getAuthorizationTranslator(HiveAuthorizer authorizer) throws HiveAuthzPluginException {
        if (authorizer.getHiveAuthorizationTranslator() == null) {
            return this.defaultAuthorizationTranslator;
        }
        return (HiveAuthorizationTranslator)authorizer.getHiveAuthorizationTranslator();
    }

    private int showGrants(ShowGrantDesc showGrantDesc) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        try {
            List<HivePrivilegeInfo> privInfos = authorizer.showPrivileges(this.getAuthorizationTranslator(authorizer).getHivePrincipal(showGrantDesc.getPrincipalDesc()), this.getAuthorizationTranslator(authorizer).getHivePrivilegeObject(showGrantDesc.getHiveObj()));
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
            this.writeToFile(DDLTask.writeGrantInfo(privInfos, testMode), showGrantDesc.getResFile());
        }
        catch (IOException e) {
            throw new HiveException("Error in show grant statement", e);
        }
        return 0;
    }

    private int grantOrRevokePrivileges(List<PrincipalDesc> principals, List<PrivilegeDesc> privileges, PrivilegeObjectDesc privSubjectDesc, String grantor, PrincipalType grantorType, boolean grantOption, boolean isGrant) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        List<HivePrincipal> hivePrincipals = AuthorizationUtils.getHivePrincipals(principals, this.getAuthorizationTranslator(authorizer));
        List<HivePrivilege> hivePrivileges = AuthorizationUtils.getHivePrivileges(privileges, this.getAuthorizationTranslator(authorizer));
        HivePrivilegeObject hivePrivObject = this.getAuthorizationTranslator(authorizer).getHivePrivilegeObject(privSubjectDesc);
        HivePrincipal grantorPrincipal = new HivePrincipal(grantor, AuthorizationUtils.getHivePrincipalType(grantorType));
        if (isGrant) {
            authorizer.grantPrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        } else {
            authorizer.revokePrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        }
        return 0;
    }

    private int roleDDL(RoleDDLDesc roleDDLDesc) throws Exception {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        RoleDDLDesc.RoleOperation operation = roleDDLDesc.getOperation();
        switch (operation) {
            case CREATE_ROLE: {
                authorizer.createRole(roleDDLDesc.getName(), null);
                break;
            }
            case DROP_ROLE: {
                authorizer.dropRole(roleDDLDesc.getName());
                break;
            }
            case SHOW_ROLE_GRANT: {
                boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
                List<HiveRoleGrant> roles = authorizer.getRoleGrantInfoForPrincipal(AuthorizationUtils.getHivePrincipal(roleDDLDesc.getName(), roleDDLDesc.getPrincipalType()));
                this.writeToFile(DDLTask.writeRolesGrantedInfo(roles, testMode), roleDDLDesc.getResFile());
                break;
            }
            case SHOW_ROLES: {
                List<String> allRoles = authorizer.getAllRoles();
                this.writeListToFileAfterSort(allRoles, roleDDLDesc.getResFile());
                break;
            }
            case SHOW_CURRENT_ROLE: {
                List<String> roleNames = authorizer.getCurrentRoleNames();
                this.writeListToFileAfterSort(roleNames, roleDDLDesc.getResFile());
                break;
            }
            case SET_ROLE: {
                authorizer.setCurrentRole(roleDDLDesc.getName());
                break;
            }
            case SHOW_ROLE_PRINCIPALS: {
                boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
                List<HiveRoleGrant> roleGrants = authorizer.getPrincipalGrantInfoForRole(roleDDLDesc.getName());
                this.writeToFile(this.writeHiveRoleGrantInfo(roleGrants, testMode), roleDDLDesc.getResFile());
                break;
            }
            default: {
                throw new HiveException("Unkown role operation " + operation.getOperationName());
            }
        }
        return 0;
    }

    private String writeHiveRoleGrantInfo(List<HiveRoleGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (HiveRoleGrant roleGrant : roleGrants) {
            DDLTask.appendNonNull(builder, roleGrant.getPrincipalName(), true);
            DDLTask.appendNonNull(builder, roleGrant.getPrincipalType());
            DDLTask.appendNonNull(builder, roleGrant.isGrantOption());
            DDLTask.appendNonNull(builder, roleGrant.getGrantor());
            DDLTask.appendNonNull(builder, roleGrant.getGrantorType());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
        }
        return builder.toString();
    }

    private void writeListToFileAfterSort(List<String> entries, String resFile) throws IOException {
        Collections.sort(entries);
        StringBuilder sb = new StringBuilder();
        for (String entry : entries) {
            DDLTask.appendNonNull(sb, entry, true);
        }
        this.writeToFile(sb.toString(), resFile);
    }

    private int alterDatabase(AlterDatabaseDesc alterDbDesc) throws HiveException {
        String dbName = alterDbDesc.getDatabaseName();
        Database database = this.db.getDatabase(dbName);
        if (database == null) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        switch (alterDbDesc.getAlterType()) {
            case ALTER_PROPERTY: {
                Map<String, String> newParams = alterDbDesc.getDatabaseProperties();
                Map<String, String> params = database.getParameters();
                if (params != null && newParams != null) {
                    params.putAll(newParams);
                    database.setParameters(params);
                    break;
                }
                database.setParameters(newParams);
                break;
            }
            case ALTER_OWNER: {
                database.setOwnerName(alterDbDesc.getOwnerPrincipal().getName());
                database.setOwnerType(alterDbDesc.getOwnerPrincipal().getType());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported alter database type! : " + (Object)((Object)alterDbDesc.getAlterType())));
            }
        }
        this.db.alterDatabase(database.getName(), database);
        return 0;
    }

    private int dropIndex(Hive db, DropIndexDesc dropIdx) throws HiveException {
        db.dropIndex(dropIdx.getTableName(), dropIdx.getIndexName(), dropIdx.isThrowException(), true);
        return 0;
    }

    private int createIndex(Hive db, CreateIndexDesc crtIndex) throws HiveException {
        if (crtIndex.getSerde() != null) {
            this.validateSerDe(crtIndex.getSerde());
        }
        String indexTableName = crtIndex.getIndexTableName();
        if (!Utilities.isDefaultNameNode(this.conf)) {
            this.makeLocationQualified(crtIndex, indexTableName);
        }
        db.createIndex(crtIndex.getTableName(), crtIndex.getIndexName(), crtIndex.getIndexTypeHandlerClass(), crtIndex.getIndexedCols(), crtIndex.getIndexTableName(), crtIndex.getDeferredRebuild(), crtIndex.getInputFormat(), crtIndex.getOutputFormat(), crtIndex.getSerde(), crtIndex.getStorageHandler(), crtIndex.getLocation(), crtIndex.getIdxProps(), crtIndex.getTblProps(), crtIndex.getSerdeProps(), crtIndex.getCollItemDelim(), crtIndex.getFieldDelim(), crtIndex.getFieldEscape(), crtIndex.getLineDelim(), crtIndex.getMapKeyDelim(), crtIndex.getIndexComment());
        if (HiveUtils.getIndexHandler(this.conf, crtIndex.getIndexTypeHandlerClass()).usesIndexTable()) {
            Table indexTable = db.getTable(indexTableName);
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(indexTable, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private int alterIndex(Hive db, AlterIndexDesc alterIndex) throws HiveException {
        String baseTableName = alterIndex.getBaseTableName();
        String indexName = alterIndex.getIndexName();
        Index idx = db.getIndex(baseTableName, indexName);
        switch (alterIndex.getOp()) {
            case ADDPROPS: {
                idx.getParameters().putAll(alterIndex.getProps());
                break;
            }
            case UPDATETIMESTAMP: {
                try {
                    HashMap<String, String> props = new HashMap<String, String>();
                    HashMap<LinkedHashMap<String, String>, Long> basePartTs = new HashMap<LinkedHashMap<String, String>, Long>();
                    Table baseTbl = db.getTable(baseTableName);
                    if (baseTbl.isPartitioned()) {
                        List<Partition> baseParts = alterIndex.getSpec() != null ? db.getPartitions(baseTbl, alterIndex.getSpec()) : db.getPartitions(baseTbl);
                        if (baseParts != null) {
                            for (Partition p : baseParts) {
                                FileSystem fs = p.getDataLocation().getFileSystem((Configuration)db.getConf());
                                FileStatus fss = fs.getFileStatus(p.getDataLocation());
                                basePartTs.put(p.getSpec(), fss.getModificationTime());
                            }
                        }
                    } else {
                        FileSystem fs = baseTbl.getPath().getFileSystem((Configuration)db.getConf());
                        FileStatus fss = fs.getFileStatus(baseTbl.getPath());
                        basePartTs.put(null, fss.getModificationTime());
                    }
                    for (Map spec : basePartTs.keySet()) {
                        if (spec != null) {
                            props.put(spec.toString(), ((Long)basePartTs.get(spec)).toString());
                            continue;
                        }
                        props.put("base_timestamp", ((Long)basePartTs.get(null)).toString());
                    }
                    idx.getParameters().putAll(props);
                    break;
                }
                catch (HiveException e) {
                    throw new HiveException("ERROR: Failed to update index timestamps");
                }
                catch (IOException e) {
                    throw new HiveException("ERROR: Failed to look up timestamps on filesystem");
                }
            }
            default: {
                this.console.printError("Unsupported Alter commnad");
                return 1;
            }
        }
        if (!this.updateModifiedParameters(idx.getParameters(), this.conf)) {
            return 1;
        }
        try {
            db.alterIndex(baseTableName, indexName, idx);
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info("alter index: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int addPartitions(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        List<Partition> parts = db.createPartitions(addPartitionDesc);
        for (Partition part : parts) {
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part, WriteEntity.WriteType.INSERT));
        }
        return 0;
    }

    private int renamePartition(Hive db, RenamePartitionDesc renamePartitionDesc) throws HiveException {
        LinkedHashMap<String, String> oldPartSpec;
        Table tbl = db.getTable(renamePartitionDesc.getTableName());
        Partition oldPart = db.getPartition(tbl, oldPartSpec = renamePartitionDesc.getOldPartSpec(), false);
        if (oldPart == null) {
            String partName = FileUtils.makePartName(new ArrayList<String>(oldPartSpec.keySet()), new ArrayList<String>(oldPartSpec.values()));
            throw new HiveException("Rename partition: source partition [" + partName + "] does not exist.");
        }
        Partition part = db.getPartition(tbl, oldPartSpec, false);
        part.setValues(renamePartitionDesc.getNewPartSpec());
        db.renamePartition(tbl, oldPartSpec, part);
        Partition newPart = db.getPartition(tbl, renamePartitionDesc.getNewPartSpec(), false);
        ((DDLWork)this.work).getInputs().add(new ReadEntity(oldPart));
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(newPart, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int alterTableAlterPart(Hive db, AlterTableAlterPartDesc alterPartitionDesc) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int touch(Hive db, AlterTableSimpleDesc touchDesc) throws HiveException {
        Table tbl = db.getTable(touchDesc.getTableName());
        if (touchDesc.getPartSpec() == null) {
            try {
                db.alterTable(touchDesc.getTableName(), tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Uable to update table");
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(tbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            Partition part = db.getPartition(tbl, touchDesc.getPartSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                db.alterPartition(touchDesc.getTableName(), part);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private void setIsArchived(Partition p, boolean state, int level) {
        Map<String, String> params = p.getParameters();
        if (state) {
            params.put("is_archived", "true");
            params.put(ArchiveUtils.ARCHIVING_LEVEL, Integer.toString(level));
        } else {
            params.remove("is_archived");
            params.remove(ArchiveUtils.ARCHIVING_LEVEL);
        }
    }

    private String getOriginalLocation(Partition p) {
        Map<String, String> params = p.getParameters();
        return params.get("original_location");
    }

    private void setOriginalLocation(Partition p, String loc) {
        Map<String, String> params = p.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    private void setArchived(Partition p, Path harPath, int level) {
        assert (!ArchiveUtils.isArchived(p));
        this.setIsArchived(p, true, level);
        this.setOriginalLocation(p, p.getLocation());
        p.setLocation(harPath.toString());
    }

    private void setUnArchived(Partition p) {
        assert (ArchiveUtils.isArchived(p));
        String parentDir = this.getOriginalLocation(p);
        this.setIsArchived(p, false, 0);
        this.setOriginalLocation(p, null);
        assert (parentDir != null);
        p.setLocation(parentDir);
    }

    private boolean pathExists(Path p) throws HiveException {
        try {
            FileSystem fs = p.getFileSystem((Configuration)this.conf);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void deleteDir(Path dir) throws HiveException {
        try {
            Warehouse wh = new Warehouse(this.conf);
            wh.deleteDir(dir, true);
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
    }

    boolean partitionInCustomLocation(Table tbl, Partition p) throws HiveException {
        String subdir = null;
        try {
            subdir = Warehouse.makePartName(tbl.getPartCols(), p.getValues());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to get partition's directory", e);
        }
        Path tableDir = tbl.getDataLocation();
        if (tableDir == null) {
            throw new HiveException("Table has no location set");
        }
        String standardLocation = new Path(tableDir, subdir).toString();
        if (ArchiveUtils.isArchived(p)) {
            return !this.getOriginalLocation(p).equals(standardLocation);
        }
        return !p.getLocation().equals(standardLocation);
    }

    private int archive(Hive db, AlterTableSimpleDesc simpleDesc, DriverContext driverContext) throws HiveException {
        Table tbl = db.getTable(simpleDesc.getTableName());
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("ARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : p.getDataLocation();
        }
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateOriginalDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
        this.console.printInfo("intermediate.archived is " + intermediateArchivedDir.toString());
        this.console.printInfo("intermediate.original is " + intermediateOriginalDir.toString());
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        URI archiveUri = new Path(originalDir, archiveName).toUri();
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        for (Partition p : partitions) {
            if (!ArchiveUtils.isArchived(p)) continue;
            if (ArchiveUtils.getArchivingLevel(p) != partSpecInfo.values.size()) {
                String name = ArchiveUtils.getPartialName(p, ArchiveUtils.getArchivingLevel(p));
                String m = String.format("Conflict with existing archive %s", name);
                throw new HiveException(m);
            }
            throw new HiveException("Partition(s) already archived");
        }
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateOriginalDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed ARCHIVE");
        }
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(intermediateOriginalDir)) {
            Path tmpPath = new Path(driverContext.getCtx().getExternalTmpPath(originalDir), "partlevel");
            this.console.printInfo("Creating " + archiveName + " for " + originalDir.toString());
            this.console.printInfo("in " + tmpPath);
            this.console.printInfo("Please wait... (this may take a while)");
            int ret = 0;
            try {
                int maxJobNameLen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
                String jobname = String.format("Archiving %s@%s", tbl.getTableName(), partSpecInfo.getName());
                jobname = Utilities.abbreviate(jobname, maxJobNameLen - 6);
                this.conf.set("mapreduce.job.name", jobname);
                HadoopArchives har = new HadoopArchives((Configuration)this.conf);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-archiveName");
                args.add(archiveName);
                args.add("-p");
                args.add(originalDir.toString());
                args.add(tmpPath.toString());
                ret = ToolRunner.run((Tool)har, (String[])args.toArray(new String[0]));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
            try {
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateArchivedDir);
                if (this.pathExists(intermediateArchivedDir)) {
                    throw new HiveException("The intermediate archive directory already exists.");
                }
                fs.rename(tmpPath, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException("Error while moving tmp directory");
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.console.printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        if (!this.pathExists(intermediateOriginalDir)) {
            this.console.printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.console.printInfo(intermediateOriginalDir + " already exists. " + "Assuming it contains the original files in the partition");
        }
        if (!this.pathExists(originalDir)) {
            this.console.printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        try {
            for (Partition p : partitions) {
                URI originalPartitionUri = ArchiveUtils.addSlash(p.getDataLocation().toUri());
                URI harPartitionDir = harHelper.getHarUri(originalPartitionUri);
                StringBuilder authority = new StringBuilder();
                if (harPartitionDir.getUserInfo() != null) {
                    authority.append(harPartitionDir.getUserInfo()).append("@");
                }
                authority.append(harPartitionDir.getHost());
                if (harPartitionDir.getPort() != -1) {
                    authority.append(":").append(harPartitionDir.getPort());
                }
                Path harPath = new Path(harPartitionDir.getScheme(), authority.toString(), harPartitionDir.getPath());
                this.setArchived(p, harPath, partSpecInfo.values.size());
                db.alterPartition(simpleDesc.getTableName(), p);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
        if (this.pathExists(intermediateOriginalDir)) {
            this.deleteDir(intermediateOriginalDir);
        }
        if (recovery) {
            this.console.printInfo("Recovery after ARCHIVE succeeded");
        }
        return 0;
    }

    private int unarchive(Hive db, AlterTableSimpleDesc simpleDesc) throws HiveException, URISyntaxException {
        Table tbl = db.getTable(simpleDesc.getTableName());
        if (simpleDesc.getPartSpec() == null) {
            throw new HiveException("UNARCHIVE is for partitions only");
        }
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        int partSpecLevel = partSpec.size();
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("UNARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : new Path(p.getLocation());
        }
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateExtractedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_EXTRACTED_DIR_SUFFIX);
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateExtractedDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed UNARCHIVE");
        }
        for (Partition p : partitions) {
            this.checkArchiveProperty(partSpecLevel, recovery, p);
        }
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        Path archivePath = new Path(originalDir, archiveName);
        URI archiveUri = archivePath.toUri();
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        URI sourceUri = harHelper.getHarUri(originalUri);
        Path sourceDir = new Path(sourceUri.getScheme(), sourceUri.getAuthority(), sourceUri.getPath());
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(archivePath)) {
            throw new HiveException("Haven't found any archive where it should be");
        }
        Path tmpPath = this.driverContext.getCtx().getExternalTmpPath(originalDir);
        try {
            fs = tmpPath.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (!this.pathExists(intermediateExtractedDir) && !this.pathExists(intermediateArchivedDir)) {
            try {
                String copySource = sourceDir.toString();
                String copyDest = tmpPath.toString();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(copySource);
                args.add(copyDest);
                this.console.printInfo("Copying " + copySource + " to " + copyDest);
                FileSystem srcFs = FileSystem.get((URI)sourceDir.toUri(), (Configuration)this.conf);
                srcFs.initialize(sourceDir.toUri(), (Configuration)this.conf);
                FsShell fss = new FsShell((Configuration)this.conf);
                int ret = 0;
                try {
                    ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                if (ret != 0) {
                    throw new HiveException("Error while copying files from archive, return code=" + ret);
                }
                this.console.printInfo("Succefully Copied " + copySource + " to " + copyDest);
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateExtractedDir);
                if (fs.exists(intermediateExtractedDir)) {
                    throw new HiveException("Invalid state: the intermediate extracted directory already exists.");
                }
                fs.rename(tmpPath, intermediateExtractedDir);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        if (!this.pathExists(intermediateArchivedDir)) {
            try {
                this.console.printInfo("Moving " + originalDir + " to " + intermediateArchivedDir);
                fs.rename(originalDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(intermediateArchivedDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        if (!this.pathExists(originalDir)) {
            try {
                this.console.printInfo("Moving " + intermediateExtractedDir + " to " + originalDir);
                fs.rename(intermediateExtractedDir, originalDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the extracted files in the partition");
        }
        for (Partition p : partitions) {
            this.setUnArchived(p);
            try {
                db.alterPartition(simpleDesc.getTableName(), p);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.deleteDir(intermediateArchivedDir);
        }
        if (recovery) {
            this.console.printInfo("Recovery after UNARCHIVE succeeded");
        }
        return 0;
    }

    private void checkArchiveProperty(int partSpecLevel, boolean recovery, Partition p) throws HiveException {
        if (!ArchiveUtils.isArchived(p) && !recovery) {
            throw new HiveException("Partition " + p.getName() + " is not archived.");
        }
        int archiveLevel = ArchiveUtils.getArchivingLevel(p);
        if (partSpecLevel > archiveLevel) {
            throw new HiveException("Partition " + p.getName() + " is archived at level " + archiveLevel + ", and given partspec only has " + partSpecLevel + " specs.");
        }
    }

    private void msckAddPartitionsOneByOne(Hive db, Table table, List<CheckResult.PartitionResult> partsNotInMs, List<String> repairOutput) {
        for (CheckResult.PartitionResult part : partsNotInMs) {
            try {
                db.createPartition(table, Warehouse.makeSpecFromName(part.getPartitionName()));
                repairOutput.add("Repair: Added partition to metastore " + table.getTableName() + ':' + part.getPartitionName());
            }
            catch (Exception e) {
                LOG.warn("Repair error, could not add partition to metastore: ", (Throwable)e);
            }
        }
    }

    private int compact(Hive db, AlterTableSimpleDesc desc) throws HiveException {
        Table tbl = db.getTable(desc.getTableName());
        String partName = null;
        if (desc.getPartSpec() == null) {
            if (tbl.isPartitioned()) {
                throw new HiveException(ErrorMsg.NO_COMPACTION_PARTITION, new String[0]);
            }
        } else {
            LinkedHashMap<String, String> partSpec = desc.getPartSpec();
            List<Partition> partitions = db.getPartitions(tbl, partSpec);
            if (partitions.size() > 1) {
                throw new HiveException(ErrorMsg.TOO_MANY_COMPACTION_PARTITIONS, new String[0]);
            }
            if (partitions.size() == 0) {
                throw new HiveException(ErrorMsg.INVALID_PARTITION_SPEC, new String[0]);
            }
            partName = partitions.get(0).getName();
        }
        db.compact(tbl.getDbName(), tbl.getTableName(), partName, desc.getCompactionType());
        this.console.printInfo("Compaction enqueued.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        result = new CheckResult();
        repairOutput = new ArrayList<String>();
        try {
            checker = new HiveMetaStoreChecker(db);
            names = Utilities.getDbTableName(msckDesc.getTableName());
            checker.checkMetastore(names[0], names[1], msckDesc.getPartSpecs(), result);
            partsNotInMs = result.getPartitionsNotInMs();
            if (msckDesc.isRepairPartitions() == false) return 0;
            if (partsNotInMs.isEmpty() != false) return 0;
            vals = null;
            settingStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_MSCK_PATH_VALIDATION);
            doValidate = "ignore".equals(settingStr) == false;
            v0 = doSkip = doValidate != false && "skip".equals(settingStr) != false;
            if (!doValidate) ** GOTO lbl26
            iter = partsNotInMs.iterator();
            while (true) {
                if (iter.hasNext()) {
                    part = iter.next();
                    try {
                        vals = Warehouse.makeValsFromName(part.getPartitionName(), vals);
                    }
                    catch (MetaException ex) {
                        throw new HiveException(ex);
                    }
                    ex = vals.iterator();
                    break;
                }
lbl26:
                // 3 sources

                table = db.getTable(msckDesc.getTableName());
                apd = new AddPartitionDesc(table.getDbName(), table.getTableName(), false);
                try {
                    ex = partsNotInMs.iterator();
                    while (true) {
                        if (!ex.hasNext()) {
                            db.createPartitions(apd);
                            return 0;
                        }
                        part = (CheckResult.PartitionResult)ex.next();
                        apd.addPartition(Warehouse.makeSpecFromName(part.getPartitionName()), null);
                        repairOutput.add("Repair: Added partition to metastore " + msckDesc.getTableName() + ':' + part.getPartitionName());
                    }
                }
                catch (Exception e) {
                    DDLTask.LOG.info("Could not bulk-add partitions to metastore; trying one by one", (Throwable)e);
                    repairOutput.clear();
                    this.msckAddPartitionsOneByOne(db, table, partsNotInMs, repairOutput);
                    return 0;
                }
                break;
            }
        }
        catch (HiveException e) {
            DDLTask.LOG.warn("Failed to run metacheck: ", (Throwable)e);
            var6_11 = 1;
            return var6_11;
        }
        catch (IOException e) {
            DDLTask.LOG.warn("Failed to run metacheck: ", (Throwable)e);
            var6_12 = 1;
            return var6_12;
        }
        finally {
            resultOut = null;
            try {
                resFile = new Path(msckDesc.getResFile());
                fs = resFile.getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                DDLTask.LOG.warn("Failed to save metacheck output: ", (Throwable)e);
                fs = 1;
                return fs;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        DDLTask.LOG.warn("Failed to close output file: ", (Throwable)e);
                        return 1;
                    }
                }
            }
        }
        while (true) {
            if (!ex.hasNext()) ** continue;
            val = (String)ex.next();
            escapedPath = FileUtils.escapePathName(val);
            if (!DDLTask.$assertionsDisabled && escapedPath == null) {
                throw new AssertionError();
            }
            if (escapedPath.equals(val)) ** continue;
            errorMsg = "Repair: Cannot add partition " + msckDesc.getTableName() + ':' + part.getPartitionName() + " due to invalid characters in the name";
            if (doSkip == false) throw new HiveException(errorMsg);
            repairOutput.add(errorMsg);
            iter.remove();
        }
    }

    private boolean writeMsckResult(List<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    private int showPartitions(Hive db, ShowPartitionsDesc showParts) throws HiveException {
        String tabName = showParts.getTabName();
        Table tbl = null;
        List<String> parts = null;
        tbl = db.getTable(tabName);
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tabName);
        }
        parts = showParts.getPartSpec() != null ? db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), showParts.getPartSpec(), (short)-1) : db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), (short)-1);
        DataOutputStream outStream = this.getOutputStream(showParts.getResFile());
        try {
            this.formatter.showTablePartitions(outStream, parts);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "show partitions for table " + tabName);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showCreateDatabase(Hive db, ShowCreateDatabaseDesc showCreateDb) throws HiveException {
        DataOutputStream outStream = this.getOutputStream(showCreateDb.getResFile());
        try {
            String dbName = showCreateDb.getDatabaseName();
            int n = this.showCreateDatabase(db, outStream, dbName);
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
    }

    private int showCreateDatabase(Hive db, DataOutputStream outStream, String databaseName) throws Exception {
        Database database = db.getDatabase(databaseName);
        StringBuilder createDb_str = new StringBuilder();
        createDb_str.append("CREATE DATABASE `").append(database.getName()).append("`\n");
        if (database.getDescription() != null) {
            createDb_str.append("COMMENT\n  '");
            createDb_str.append(this.escapeHiveCommand(database.getDescription())).append("'\n");
        }
        createDb_str.append("LOCATION\n  '");
        createDb_str.append(database.getLocationUri()).append("'\n");
        String propertiesToString = this.propertiesToString(database.getParameters(), null);
        if (!propertiesToString.isEmpty()) {
            createDb_str.append("WITH DBPROPERTIES (\n");
            createDb_str.append(propertiesToString).append(")\n");
        }
        outStream.write(createDb_str.toString().getBytes("UTF-8"));
        return 0;
    }

    private int showCreateTable(Hive db, ShowCreateTableDesc showCreateTbl) throws HiveException {
        DataOutputStream outStream = this.getOutputStream(showCreateTbl.getResFile());
        try {
            String tableName = showCreateTbl.getTableName();
            int n = this.showCreateTable(db, outStream, tableName);
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
    }

    private int showCreateTable(Hive db, DataOutputStream outStream, String tableName) throws HiveException {
        String EXTERNAL = "external";
        String TEMPORARY = "temporary";
        String LIST_COLUMNS = "columns";
        String TBL_COMMENT = "tbl_comment";
        String LIST_PARTITIONS = "partitions";
        String SORT_BUCKET = "sort_bucket";
        String ROW_FORMAT = "row_format";
        String TBL_LOCATION = "tbl_location";
        String TBL_PROPERTIES = "tbl_properties";
        boolean needsLocation = true;
        StringBuilder createTab_str = new StringBuilder();
        Table tbl = db.getTable(tableName, false);
        ArrayList<String> duplicateProps = new ArrayList<String>();
        try {
            needsLocation = DDLTask.doesTableNeedLocation(tbl);
            if (tbl.isView()) {
                String createTab_stmt = "CREATE VIEW `" + tableName + "` AS " + tbl.getViewExpandedText();
                outStream.writeBytes(createTab_stmt.toString());
                return 0;
            }
            createTab_str.append("CREATE <temporary><external>TABLE `");
            createTab_str.append(tableName + "`(\n");
            createTab_str.append("<columns>)\n");
            createTab_str.append("<tbl_comment>\n");
            createTab_str.append("<partitions>\n");
            createTab_str.append("<sort_bucket>\n");
            createTab_str.append("<row_format>\n");
            if (needsLocation) {
                createTab_str.append("LOCATION\n");
                createTab_str.append("<tbl_location>\n");
            }
            createTab_str.append("TBLPROPERTIES (\n");
            createTab_str.append("<tbl_properties>)\n");
            ST createTab_stmt = new ST(createTab_str.toString());
            String tbl_temp = "";
            if (tbl.isTemporary()) {
                duplicateProps.add("TEMPORARY");
                tbl_temp = "TEMPORARY ";
            }
            String tbl_external = "";
            if (tbl.getTableType() == TableType.EXTERNAL_TABLE) {
                duplicateProps.add("EXTERNAL");
                tbl_external = "EXTERNAL ";
            }
            String tbl_columns = "";
            List<FieldSchema> cols = tbl.getCols();
            ArrayList<String> columns = new ArrayList<String>();
            for (FieldSchema col : cols) {
                String columnDesc = "  `" + col.getName() + "` " + col.getType();
                if (col.getComment() != null) {
                    columnDesc = columnDesc + " COMMENT '" + this.escapeHiveCommand(col.getComment()) + "'";
                }
                columns.add(columnDesc);
            }
            tbl_columns = StringUtils.join(columns, ", \n");
            String tbl_comment = "";
            String tabComment = tbl.getProperty("comment");
            if (tabComment != null) {
                duplicateProps.add("comment");
                tbl_comment = "COMMENT '" + this.escapeHiveCommand(tabComment) + "'";
            }
            String tbl_partitions = "";
            List<FieldSchema> partKeys = tbl.getPartitionKeys();
            if (partKeys.size() > 0) {
                tbl_partitions = tbl_partitions + "PARTITIONED BY ( \n";
                ArrayList<String> partCols = new ArrayList<String>();
                for (FieldSchema partKey : partKeys) {
                    String partColDesc = "  `" + partKey.getName() + "` " + partKey.getType();
                    if (partKey.getComment() != null) {
                        partColDesc = partColDesc + " COMMENT '" + this.escapeHiveCommand(partKey.getComment()) + "'";
                    }
                    partCols.add(partColDesc);
                }
                tbl_partitions = tbl_partitions + StringUtils.join(partCols, ", \n");
                tbl_partitions = tbl_partitions + ")";
            }
            String tbl_sort_bucket = "";
            List<String> buckCols = tbl.getBucketCols();
            if (buckCols.size() > 0) {
                duplicateProps.add("SORTBUCKETCOLSPREFIX");
                tbl_sort_bucket = tbl_sort_bucket + "CLUSTERED BY ( \n  ";
                tbl_sort_bucket = tbl_sort_bucket + StringUtils.join(buckCols, ", \n  ");
                tbl_sort_bucket = tbl_sort_bucket + ") \n";
                List<Order> sortCols = tbl.getSortCols();
                if (sortCols.size() > 0) {
                    tbl_sort_bucket = tbl_sort_bucket + "SORTED BY ( \n";
                    ArrayList<String> sortKeys = new ArrayList<String>();
                    for (Order sortCol : sortCols) {
                        String sortKeyDesc = "  " + sortCol.getCol() + " ";
                        if (sortCol.getOrder() == BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC) {
                            sortKeyDesc = sortKeyDesc + "ASC";
                        } else if (sortCol.getOrder() == BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_DESC) {
                            sortKeyDesc = sortKeyDesc + "DESC";
                        }
                        sortKeys.add(sortKeyDesc);
                    }
                    tbl_sort_bucket = tbl_sort_bucket + StringUtils.join(sortKeys, ", \n");
                    tbl_sort_bucket = tbl_sort_bucket + ") \n";
                }
                tbl_sort_bucket = tbl_sort_bucket + "INTO " + tbl.getNumBuckets() + " BUCKETS";
            }
            StringBuilder tbl_row_format = new StringBuilder();
            StorageDescriptor sd = tbl.getTTable().getSd();
            SerDeInfo serdeInfo = sd.getSerdeInfo();
            Map<String, String> serdeParams = serdeInfo.getParameters();
            tbl_row_format.append("ROW FORMAT SERDE \n");
            tbl_row_format.append("  '" + this.escapeHiveCommand(serdeInfo.getSerializationLib()) + "' \n");
            if (tbl.getStorageHandler() == null) {
                if ("1".equals(serdeParams.get("serialization.format"))) {
                    serdeParams.remove("serialization.format");
                }
                if (!serdeParams.isEmpty()) {
                    this.appendSerdeParams(tbl_row_format, serdeParams).append(" \n");
                }
                tbl_row_format.append("STORED AS INPUTFORMAT \n  '" + this.escapeHiveCommand(sd.getInputFormat()) + "' \n");
                tbl_row_format.append("OUTPUTFORMAT \n  '" + this.escapeHiveCommand(sd.getOutputFormat()) + "'");
            } else {
                duplicateProps.add("storage_handler");
                tbl_row_format.append("STORED BY \n  '" + this.escapeHiveCommand(tbl.getParameters().get("storage_handler")) + "' \n");
                if (!serdeParams.isEmpty()) {
                    this.appendSerdeParams(tbl_row_format, serdeInfo.getParameters());
                }
            }
            String tbl_location = "  '" + this.escapeHiveCommand(sd.getLocation()) + "'";
            String tbl_properties = this.propertiesToString(tbl.getParameters(), duplicateProps);
            createTab_stmt.add("temporary", (Object)tbl_temp);
            createTab_stmt.add("external", (Object)tbl_external);
            createTab_stmt.add("columns", (Object)tbl_columns);
            createTab_stmt.add("tbl_comment", (Object)tbl_comment);
            createTab_stmt.add("partitions", (Object)tbl_partitions);
            createTab_stmt.add("sort_bucket", (Object)tbl_sort_bucket);
            createTab_stmt.add("row_format", (Object)tbl_row_format);
            if (needsLocation) {
                createTab_stmt.add("tbl_location", (Object)tbl_location);
            }
            createTab_stmt.add("tbl_properties", (Object)tbl_properties);
            outStream.writeBytes(createTab_stmt.render());
        }
        catch (IOException e) {
            LOG.info("show create table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        return 0;
    }

    private String propertiesToString(Map<String, String> props, List<String> exclude) {
        String prop_string = "";
        if (!props.isEmpty()) {
            TreeMap<String, String> properties = new TreeMap<String, String>(props);
            ArrayList<String> realProps = new ArrayList<String>();
            for (String key : properties.keySet()) {
                if (properties.get(key) == null || exclude != null && exclude.contains(key)) continue;
                realProps.add("  '" + key + "'='" + this.escapeHiveCommand(StringEscapeUtils.escapeJava((String)properties.get(key))) + "'");
            }
            prop_string = prop_string + StringUtils.join(realProps, ", \n");
        }
        return prop_string;
    }

    private StringBuilder appendSerdeParams(StringBuilder builder, Map<String, String> serdeParam) {
        serdeParam = new TreeMap<String, String>(serdeParam);
        builder.append("WITH SERDEPROPERTIES ( \n");
        ArrayList<String> serdeCols = new ArrayList<String>();
        for (Map.Entry<String, String> entry : serdeParam.entrySet()) {
            serdeCols.add("  '" + entry.getKey() + "'='" + this.escapeHiveCommand(StringEscapeUtils.escapeJava(entry.getValue())) + "'");
        }
        builder.append(StringUtils.join(serdeCols, ", \n")).append(')');
        return builder;
    }

    private int showIndexes(Hive db, ShowIndexesDesc showIndexes) throws HiveException {
        String tableName = showIndexes.getTableName();
        Table tbl = null;
        List<Index> indexes = null;
        tbl = db.getTable(tableName);
        indexes = db.getIndexes(tbl.getDbName(), tbl.getTableName(), (short)-1);
        DataOutputStream outStream = this.getOutputStream(showIndexes.getResFile());
        try {
            if (showIndexes.isFormatted()) {
                outStream.writeBytes(MetaDataFormatUtils.getIndexColumnsHeader());
                outStream.write(10);
                outStream.write(10);
            }
            for (Index index : indexes) {
                outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(index));
            }
        }
        catch (FileNotFoundException e) {
            LOG.info("show indexes: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e.toString());
        }
        catch (IOException e) {
            LOG.info("show indexes: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e.toString());
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showDatabases(Hive db, ShowDatabasesDesc showDatabasesDesc) throws HiveException {
        List<String> databases = null;
        if (showDatabasesDesc.getPattern() != null) {
            LOG.info("pattern: " + showDatabasesDesc.getPattern());
            databases = db.getDatabasesByPattern(showDatabasesDesc.getPattern());
        } else {
            databases = db.getAllDatabases();
        }
        LOG.info("results : " + databases.size());
        DataOutputStream outStream = this.getOutputStream(showDatabasesDesc.getResFile());
        try {
            this.formatter.showDatabases(outStream, databases);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "show databases");
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showTables(Hive db, ShowTablesDesc showTbls) throws HiveException {
        List<String> tbls = null;
        String dbName = showTbls.getDbName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        if (showTbls.getPattern() != null) {
            LOG.info("pattern: " + showTbls.getPattern());
            tbls = db.getTablesByPattern(dbName, showTbls.getPattern());
            LOG.info("results : " + tbls.size());
        } else {
            tbls = db.getAllTables(dbName);
        }
        DataOutputStream outStream = this.getOutputStream(showTbls.getResFile());
        try {
            TreeSet<String> sortedTbls = new TreeSet<String>(tbls);
            this.formatter.showTables(outStream, sortedTbls);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "in database" + dbName);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    public int showColumns(Hive db, ShowColumnsDesc showCols) throws HiveException {
        Table table = db.getTable(showCols.getTableName());
        DataOutputStream outStream = this.getOutputStream(showCols.getResFile());
        try {
            List<FieldSchema> cols = table.getCols();
            cols.addAll(table.getPartCols());
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(cols, false, isOutputPadded, null));
        }
        catch (IOException e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showFunctions(ShowFunctionsDesc showFuncs) throws HiveException {
        Set<String> funcs = null;
        if (showFuncs.getPattern() != null) {
            LOG.info("pattern: " + showFuncs.getPattern());
            if (showFuncs.getIsLikePattern()) {
                funcs = FunctionRegistry.getFunctionNamesByLikePattern(showFuncs.getPattern());
            } else {
                this.console.printInfo("SHOW FUNCTIONS is deprecated, please use SHOW FUNCTIONS LIKE instead.");
                funcs = FunctionRegistry.getFunctionNames(showFuncs.getPattern());
            }
            LOG.info("results : " + funcs.size());
        } else {
            funcs = FunctionRegistry.getFunctionNames();
        }
        DataOutputStream outStream = this.getOutputStream(showFuncs.getResFile());
        try {
            TreeSet<String> sortedFuncs = new TreeSet<String>(funcs);
            sortedFuncs.removeAll(serdeConstants.PrimitiveTypes);
            Iterator iterFuncs = sortedFuncs.iterator();
            while (iterFuncs.hasNext()) {
                outStream.writeBytes((String)iterFuncs.next());
                outStream.write(10);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showLocks(ShowLocksDesc showLocks) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (txnManager.useNewShowLocksFormat()) {
            return this.showLocksNewFormat(showLocks, lockMgr);
        }
        boolean isExt = showLocks.isExt();
        if (lockMgr == null) {
            throw new HiveException("show Locks LockManager not specified");
        }
        DataOutputStream outStream = this.getOutputStream(showLocks.getResFile());
        try {
            List<HiveLock> locks = null;
            locks = showLocks.getTableName() == null ? lockMgr.getLocks(false, isExt) : lockMgr.getLocks(HiveLockObject.createFrom(this.db, showLocks.getTableName(), showLocks.getPartSpec()), true, isExt);
            Collections.sort(locks, new Comparator<HiveLock>(){

                @Override
                public int compare(HiveLock o1, HiveLock o2) {
                    int cmp = o1.getHiveLockObject().getName().compareTo(o2.getHiveLockObject().getName());
                    if (cmp == 0) {
                        if (o1.getHiveLockMode() == o2.getHiveLockMode()) {
                            return cmp;
                        }
                        if (o1.getHiveLockMode() == HiveLockMode.EXCLUSIVE) {
                            return -1;
                        }
                        return 1;
                    }
                    return cmp;
                }
            });
            for (HiveLock lock2 : locks) {
                HiveLockObject.HiveLockObjectData lockData;
                outStream.writeBytes(lock2.getHiveLockObject().getDisplayName());
                outStream.write(9);
                outStream.writeBytes(lock2.getHiveLockMode().toString());
                if (isExt && (lockData = lock2.getHiveLockObject().getData()) != null) {
                    outStream.write(10);
                    outStream.writeBytes("LOCK_QUERYID:" + lockData.getQueryId());
                    outStream.write(10);
                    outStream.writeBytes("LOCK_TIME:" + lockData.getLockTime());
                    outStream.write(10);
                    outStream.writeBytes("LOCK_MODE:" + lockData.getLockMode());
                    outStream.write(10);
                    outStream.writeBytes("LOCK_QUERYSTRING:" + lockData.getQueryStr());
                }
                outStream.write(10);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e.toString(), e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showLocksNewFormat(ShowLocksDesc showLocks, HiveLockManager lm) throws HiveException {
        if (!(lm instanceof DbLockManager)) {
            throw new RuntimeException("New lock format only supported with db lock manager.");
        }
        DbLockManager lockMgr = (DbLockManager)lm;
        ShowLocksResponse rsp = lockMgr.getLocks();
        DataOutputStream os = this.getOutputStream(showLocks.getResFile());
        try {
            os.writeBytes("Lock ID");
            os.write(9);
            os.writeBytes("Database");
            os.write(9);
            os.writeBytes("Table");
            os.write(9);
            os.writeBytes("Partition");
            os.write(9);
            os.writeBytes("State");
            os.write(9);
            os.writeBytes("Type");
            os.write(9);
            os.writeBytes("Transaction ID");
            os.write(9);
            os.writeBytes("Last Hearbeat");
            os.write(9);
            os.writeBytes("Acquired At");
            os.write(9);
            os.writeBytes("User");
            os.write(9);
            os.writeBytes("Hostname");
            os.write(10);
            List<ShowLocksResponseElement> locks = rsp.getLocks();
            if (locks != null) {
                for (ShowLocksResponseElement lock2 : locks) {
                    os.writeBytes(Long.toString(lock2.getLockid()));
                    os.write(9);
                    os.writeBytes(lock2.getDbname());
                    os.write(9);
                    os.writeBytes(lock2.getTablename() == null ? "NULL" : lock2.getTablename());
                    os.write(9);
                    os.writeBytes(lock2.getPartname() == null ? "NULL" : lock2.getPartname());
                    os.write(9);
                    os.writeBytes(lock2.getState().toString());
                    os.write(9);
                    os.writeBytes(lock2.getType().toString());
                    os.write(9);
                    os.writeBytes(lock2.getTxnid() == 0L ? "NULL" : Long.toString(lock2.getTxnid()));
                    os.write(9);
                    os.writeBytes(Long.toString(lock2.getLastheartbeat()));
                    os.write(9);
                    os.writeBytes(lock2.getAcquiredat() == 0L ? "NULL" : Long.toString(lock2.getAcquiredat()));
                    os.write(9);
                    os.writeBytes(lock2.getUser());
                    os.write(9);
                    os.writeBytes(lock2.getHostname());
                    os.write(9);
                    os.write(10);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        finally {
            IOUtils.closeStream((Closeable)os);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showCompactions(ShowCompactionsDesc desc) throws HiveException {
        ShowCompactResponse rsp = this.db.showCompactions();
        DataOutputStream os = this.getOutputStream(desc.getResFile());
        try {
            os.writeBytes("Database");
            os.write(9);
            os.writeBytes("Table");
            os.write(9);
            os.writeBytes("Partition");
            os.write(9);
            os.writeBytes("Type");
            os.write(9);
            os.writeBytes("State");
            os.write(9);
            os.writeBytes("Worker");
            os.write(9);
            os.writeBytes("Start Time");
            os.write(10);
            if (rsp.getCompacts() != null) {
                for (ShowCompactResponseElement e : rsp.getCompacts()) {
                    os.writeBytes(e.getDbname());
                    os.write(9);
                    os.writeBytes(e.getTablename());
                    os.write(9);
                    String part = e.getPartitionname();
                    os.writeBytes(part == null ? "NULL" : part);
                    os.write(9);
                    os.writeBytes(e.getType().toString());
                    os.write(9);
                    os.writeBytes(e.getState());
                    os.write(9);
                    String wid = e.getWorkerid();
                    os.writeBytes(wid == null ? "NULL" : wid);
                    os.write(9);
                    os.writeBytes(Long.toString(e.getStart()));
                    os.write(10);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("show compactions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)os);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showTxns(ShowTxnsDesc desc) throws HiveException {
        GetOpenTxnsInfoResponse rsp = this.db.showTransactions();
        DataOutputStream os = this.getOutputStream(desc.getResFile());
        try {
            os.writeBytes("Transaction ID");
            os.write(9);
            os.writeBytes("Transaction State");
            os.write(9);
            os.writeBytes("User");
            os.write(9);
            os.writeBytes("Hostname");
            os.write(10);
            for (TxnInfo txn : rsp.getOpen_txns()) {
                os.writeBytes(Long.toString(txn.getId()));
                os.write(9);
                os.writeBytes(txn.getState().toString());
                os.write(9);
                os.writeBytes(txn.getUser());
                os.write(9);
                os.writeBytes(txn.getHostname());
                os.write(10);
            }
        }
        catch (IOException e) {
            LOG.warn("show transactions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)os);
        }
        return 0;
    }

    private int lockTable(LockTableDesc lockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.lockTable(this.db, lockTbl);
    }

    private int lockDatabase(LockDatabaseDesc lockDb) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.lockDatabase(this.db, lockDb);
    }

    private int unlockDatabase(UnlockDatabaseDesc unlockDb) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.unlockDatabase(this.db, unlockDb);
    }

    private int unlockTable(UnlockTableDesc unlockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        return txnManager.unlockTable(this.db, unlockTbl);
    }

    private int describeFunction(DescFunctionDesc descFunc) throws HiveException, SQLException {
        String funcName = descFunc.getName();
        DataOutputStream outStream = this.getOutputStream(descFunc.getResFile());
        try {
            Description desc = null;
            Class<?> funcClass = null;
            FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(funcName);
            if (functionInfo != null) {
                funcClass = functionInfo.getFunctionClass();
            }
            if (funcClass != null) {
                desc = AnnotationUtils.getAnnotation(funcClass, Description.class);
            }
            if (desc != null) {
                outStream.writeBytes(desc.value().replace("_FUNC_", funcName));
                if (descFunc.isExtended()) {
                    Set<String> synonyms = FunctionRegistry.getFunctionSynonyms(funcName);
                    if (synonyms.size() > 0) {
                        outStream.writeBytes("\nSynonyms: " + StringUtils.join(synonyms, ", "));
                    }
                    if (desc.extended().length() > 0) {
                        outStream.writeBytes("\n" + desc.extended().replace("_FUNC_", funcName));
                    }
                }
            } else if (funcClass != null) {
                outStream.writeBytes("There is no documentation for function '" + funcName + "'");
            } else {
                outStream.writeBytes("Function '" + funcName + "' does not exist.");
            }
            outStream.write(10);
        }
        catch (FileNotFoundException e) {
            LOG.warn("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int descDatabase(DescDatabaseDesc descDatabase) throws HiveException {
        DataOutputStream outStream = this.getOutputStream(descDatabase.getResFile());
        try {
            Database database = this.db.getDatabase(descDatabase.getDatabaseName());
            if (database == null) {
                throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, descDatabase.getDatabaseName());
            }
            Map<String, String> params = null;
            if (descDatabase.isExt()) {
                params = database.getParameters();
            }
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST) && params != null) {
                params = new TreeMap<String, String>(params);
            }
            String location = database.getLocationUri();
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST)) {
                location = "location/in/test";
            }
            PrincipalType ownerType = database.getOwnerType();
            this.formatter.showDatabaseDescription(outStream, database.getName(), database.getDescription(), location, database.getOwnerName(), null == ownerType ? null : ownerType.name(), params);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showTableStatus(Hive db, ShowTableStatusDesc showTblStatus) throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        HashMap<String, String> part = showTblStatus.getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = db.getTable(showTblStatus.getDbName(), showTblStatus.getPattern());
            par = db.getPartition(tbl, part, false);
            if (par == null) {
                throw new HiveException("Partition " + part + " for table " + showTblStatus.getPattern() + " does not exist.");
            }
            tbls.add(tbl);
        } else {
            LOG.info("pattern: " + showTblStatus.getPattern());
            List<String> tblStr = db.getTablesForDb(showTblStatus.getDbName(), showTblStatus.getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = db.getTable(showTblStatus.getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info("results : " + tblStr.size());
        }
        DataOutputStream outStream = this.getOutputStream(showTblStatus.getResFile());
        try {
            this.formatter.showTableStatus(outStream, db, this.conf, tbls, part, par);
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "show table status");
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private int showTableProperties(Hive db, ShowTblPropertiesDesc showTblPrpt) throws HiveException {
        String tableName = showTblPrpt.getTableName();
        Table tbl = db.getTable(tableName, false);
        try {
            if (tbl == null) {
                String errMsg = "Table " + tableName + " does not exist";
                this.writeToFile(errMsg, showTblPrpt.getResFile());
                return 0;
            }
            LOG.info("DDLTask: show properties for " + tbl.getTableName());
            StringBuilder builder = new StringBuilder();
            String propertyName = showTblPrpt.getPropertyName();
            if (propertyName != null) {
                String propertyValue = tbl.getProperty(propertyName);
                if (propertyValue == null) {
                    String errMsg = "Table " + tableName + " does not have property: " + propertyName;
                    builder.append(errMsg);
                } else {
                    builder.append(propertyValue);
                }
            } else {
                TreeMap<String, String> properties = new TreeMap<String, String>(tbl.getParameters());
                for (Map.Entry entry : properties.entrySet()) {
                    DDLTask.appendNonNull(builder, entry.getKey(), true);
                    DDLTask.appendNonNull(builder, entry.getValue());
                }
            }
            LOG.info("DDLTask: written data for showing properties of " + tbl.getTableName());
            this.writeToFile(builder.toString(), showTblPrpt.getResFile());
        }
        catch (FileNotFoundException e) {
            LOG.info("show table properties: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (IOException e) {
            LOG.info("show table properties: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String data, String file) throws IOException {
        Path resFile = new Path(file);
        FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
        FSDataOutputStream out = fs.create(resFile);
        try {
            if (data != null && !data.isEmpty()) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write(data);
                writer.write(10);
                writer.flush();
            }
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }

    private int describeTable(Hive db, DescTableDesc descTbl) throws HiveException {
        String colPath = descTbl.getColumnPath();
        String tableName = descTbl.getTableName();
        Table tbl = db.getTable(tableName, false);
        if (tbl == null) {
            throw new HiveException(ErrorMsg.INVALID_TABLE, tableName);
        }
        Partition part = null;
        if (descTbl.getPartSpec() != null) {
            part = db.getPartition(tbl, descTbl.getPartSpec(), false);
            if (part == null) {
                throw new HiveException(ErrorMsg.INVALID_PARTITION, StringUtils.join(descTbl.getPartSpec().keySet(), ','), tableName);
            }
            tbl = part.getTable();
        }
        DataOutputStream outStream = this.getOutputStream(descTbl.getResFile());
        try {
            String errorMsgs;
            LOG.info("DDLTask: got data for " + tbl.getTableName());
            List<FieldSchema> cols = null;
            List<ColumnStatisticsObj> colStats = null;
            Deserializer deserializer = tbl.getDeserializer(true);
            if (deserializer instanceof AbstractSerDe && (errorMsgs = ((AbstractSerDe)deserializer).getConfigurationErrors()) != null && !errorMsgs.isEmpty()) {
                throw new SQLException(errorMsgs);
            }
            if (colPath.equals(tableName)) {
                List<FieldSchema> list = cols = part == null || tbl.getTableType() == TableType.VIRTUAL_VIEW ? tbl.getCols() : part.getCols();
                if (!descTbl.isFormatted()) {
                    cols.addAll(tbl.getPartCols());
                }
            } else {
                cols = Hive.getFieldsFromDeserializer(colPath, deserializer);
                if (descTbl.isFormatted()) {
                    String colName = colPath.split("\\.")[1];
                    String[] dbTab = Utilities.getDbTableName(tableName);
                    ArrayList<String> colNames = new ArrayList<String>();
                    colNames.add(colName.toLowerCase());
                    if (null == part) {
                        colStats = db.getTableColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), colNames);
                    } else {
                        ArrayList<String> partitions = new ArrayList<String>();
                        partitions.add(part.getName());
                        colStats = db.getPartitionColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), partitions, colNames).get(part.getName());
                    }
                }
            }
            DDLTask.fixDecimalColumnTypeName(cols);
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            this.formatter.describeTable(outStream, colPath, tableName, tbl, part, cols, descTbl.isFormatted(), descTbl.isExt(), descTbl.isPretty(), isOutputPadded, colStats);
            LOG.info("DDLTask: written data for " + tbl.getTableName());
        }
        catch (SQLException e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, tableName);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private static void fixDecimalColumnTypeName(List<FieldSchema> cols) {
        for (FieldSchema col : cols) {
            if (!"decimal".equals(col.getType())) continue;
            col.setType(DecimalTypeInfo.getQualifiedName(10, 0));
        }
    }

    static String writeGrantInfo(List<HivePrivilegeInfo> privileges, boolean testMode) {
        if (privileges == null || privileges.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(privileges, new Comparator<HivePrivilegeInfo>(){

            @Override
            public int compare(HivePrivilegeInfo o1, HivePrivilegeInfo o2) {
                int compare = o1.getObject().compareTo(o2.getObject());
                if (compare == 0) {
                    compare = o1.getPrincipal().compareTo(o2.getPrincipal());
                }
                if (compare == 0) {
                    compare = o1.getPrivilege().compareTo(o2.getPrivilege());
                }
                return compare;
            }
        });
        for (HivePrivilegeInfo privilege : privileges) {
            HivePrincipal principal = privilege.getPrincipal();
            HivePrivilegeObject resource = privilege.getObject();
            HivePrincipal grantor = privilege.getGrantorPrincipal();
            DDLTask.appendNonNull(builder, resource.getDbname(), true);
            DDLTask.appendNonNull(builder, resource.getObjectName());
            DDLTask.appendNonNull(builder, resource.getPartKeys());
            DDLTask.appendNonNull(builder, resource.getColumns());
            DDLTask.appendNonNull(builder, principal.getName());
            DDLTask.appendNonNull(builder, (Object)principal.getType());
            DDLTask.appendNonNull(builder, privilege.getPrivilege().getName());
            DDLTask.appendNonNull(builder, privilege.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)privilege.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, grantor.getName());
        }
        return builder.toString();
    }

    static String writeRoleGrantsInfo(List<RolePrincipalGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (RolePrincipalGrant roleGrant : roleGrants) {
            DDLTask.appendNonNull(builder, roleGrant.getRoleName(), true);
            DDLTask.appendNonNull(builder, roleGrant.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, roleGrant.getGrantorName());
        }
        return builder.toString();
    }

    static String writeRolesGrantedInfo(List<HiveRoleGrant> roles, boolean testMode) {
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roles);
        for (HiveRoleGrant role : roles) {
            DDLTask.appendNonNull(builder, role.getRoleName(), true);
            DDLTask.appendNonNull(builder, role.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)role.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, role.getGrantor());
        }
        return builder.toString();
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value) {
        return DDLTask.appendNonNull(builder, value, false);
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value, boolean firstColumn) {
        if (!firstColumn) {
            builder.append('\t');
        } else if (builder.length() > 0) {
            builder.append('\n');
        }
        if (value != null) {
            builder.append(value);
        }
        return builder;
    }

    private int alterTable(Hive db, AlterTableDesc alterTbl) throws HiveException {
        Table tbl = db.getTable(alterTbl.getOldName());
        List<Object> allPartitions = null;
        if (alterTbl.getPartSpec() != null) {
            HashMap<String, String> partSpec = alterTbl.getPartSpec();
            if (DDLSemanticAnalyzer.isFullSpec(tbl, partSpec)) {
                allPartitions = new ArrayList();
                Partition part = db.getPartition(tbl, partSpec, false);
                if (part == null) {
                    throw new HiveException(ErrorMsg.INVALID_PARTITION, StringUtils.join(alterTbl.getPartSpec().keySet(), ',') + " for table " + alterTbl.getOldName());
                }
                allPartitions.add(part);
            } else {
                allPartitions = db.getPartitions(tbl, alterTbl.getPartSpec());
            }
        }
        Table oldTbl = tbl;
        tbl = oldTbl.copy();
        if (allPartitions != null) {
            for (Partition partition : allPartitions) {
                this.alterTableOrSinglePartition(alterTbl, tbl, partition);
            }
        } else {
            this.alterTableOrSinglePartition(alterTbl, tbl, null);
        }
        if (allPartitions == null) {
            this.updateModifiedParameters(tbl.getTTable().getParameters(), this.conf);
            tbl.checkValidity(this.conf);
        } else {
            for (Partition partition : allPartitions) {
                this.updateModifiedParameters(partition.getParameters(), this.conf);
            }
        }
        try {
            if (allPartitions == null) {
                db.alterTable(alterTbl.getOldName(), tbl, alterTbl.getIsCascade());
            } else {
                db.alterPartitions(tbl.getTableName(), allPartitions);
            }
        }
        catch (InvalidOperationException e) {
            LOG.error("alter table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        if (allPartitions != null) {
            for (Partition partition : allPartitions) {
                ((DDLWork)this.work).getInputs().add(new ReadEntity(partition));
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK));
            }
        } else {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private boolean isSchemaEvolutionEnabled(Table tbl) {
        boolean isAcid = AcidUtils.isTablePropertyTransactional(tbl.getMetadata());
        return isAcid || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
    }

    private int alterTableOrSinglePartition(AlterTableDesc alterTbl, Table tbl, Partition part) throws HiveException {
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME) {
            tbl.setDbName(Utilities.getDatabaseName(alterTbl.getNewName()));
            tbl.setTableName(Utilities.getTableName(alterTbl.getNewName()));
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCOLS) {
            List<FieldSchema> oldCols = part == null ? tbl.getColsForMetastore() : part.getColsForMetastore();
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            ArrayList<FieldSchema> newCols = alterTbl.getNewCols();
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            if (serializationLib.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
                sd.setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newColName);
                    }
                    oldCols.add(newCol);
                }
                sd.setCols(oldCols);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAMECOLUMN) {
            boolean isOrcSchemaEvolution;
            List<FieldSchema> oldCols = part == null ? tbl.getColsForMetastore() : part.getColsForMetastore();
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            boolean bl = isOrcSchemaEvolution = sd.getInputFormat().equals(OrcInputFormat.class.getName()) && this.isSchemaEvolutionEnabled(tbl);
            if (isOrcSchemaEvolution && (first || afterCol != null && !afterCol.trim().isEmpty())) {
                throw new HiveException(ErrorMsg.CANNOT_REORDER_COLUMNS, alterTbl.getOldName());
            }
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newName);
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    if (isOrcSchemaEvolution && !this.isSupportedTypeChange(col.getType(), type)) {
                        throw new HiveException(ErrorMsg.CANNOT_CHANGE_COLUMN_TYPE, col.getType(), type, newName);
                    }
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                throw new HiveException(ErrorMsg.INVALID_COLUMN, oldName);
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                throw new HiveException(ErrorMsg.INVALID_COLUMN, afterCol);
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            sd.setCols(newCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.REPLACECOLS) {
            boolean isOrcSchemaEvolution;
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            if (serializationLib.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(serializationLib.equals(MetadataTypedColumnsetSerDe.class.getName()) || serializationLib.equals(LazySimpleSerDe.class.getName()) || serializationLib.equals(ColumnarSerDe.class.getName()) || serializationLib.equals(DynamicSerDe.class.getName()) || serializationLib.equals(ParquetHiveSerDe.class.getName()) || serializationLib.equals(OrcSerde.class.getName()))) {
                throw new HiveException(ErrorMsg.CANNOT_REPLACE_COLUMNS, alterTbl.getOldName());
            }
            boolean bl = isOrcSchemaEvolution = serializationLib.equals(OrcSerde.class.getName()) && this.isSchemaEvolutionEnabled(tbl);
            if (isOrcSchemaEvolution) {
                List<FieldSchema> existingCols = sd.getCols();
                ArrayList<FieldSchema> replaceCols = alterTbl.getNewCols();
                if (replaceCols.size() < existingCols.size()) {
                    throw new HiveException(ErrorMsg.REPLACE_CANNOT_DROP_COLUMNS, alterTbl.getOldName());
                }
                for (int i = 0; i < existingCols.size(); ++i) {
                    String newColType;
                    String currentColType = existingCols.get(i).getType().toLowerCase().trim();
                    if (this.isSupportedTypeChange(currentColType, newColType = ((FieldSchema)replaceCols.get(i)).getType().toLowerCase().trim())) continue;
                    throw new HiveException(ErrorMsg.REPLACE_UNSUPPORTED_TYPE_CONVERSION, currentColType, newColType, ((FieldSchema)replaceCols.get(i)).getName());
                }
            }
            sd.setCols(alterTbl.getNewCols());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDPROPS) {
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.DROPPROPS) {
            Iterator<String> keyItr = alterTbl.getProps().keySet().iterator();
            while (keyItr.hasNext()) {
                tbl.getTTable().getParameters().remove(keyItr.next());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDEPROPS) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            sd.getSerdeInfo().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDE) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            String serdeName = alterTbl.getSerdeName();
            String oldSerdeName = sd.getSerdeInfo().getSerializationLib();
            if (this.isSchemaEvolutionEnabled(tbl) && oldSerdeName.equalsIgnoreCase(OrcSerde.class.getName()) && !serdeName.equalsIgnoreCase(OrcSerde.class.getName())) {
                throw new HiveException(ErrorMsg.CANNOT_CHANGE_SERDE, OrcSerde.class.getSimpleName(), alterTbl.getOldName());
            }
            sd.getSerdeInfo().setSerializationLib(serdeName);
            if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                sd.getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            }
            if (part != null) {
                part.getTPartition().getSd().setCols(part.getTPartition().getSd().getCols());
            } else if (Table.shouldStoreFieldsInMetastore(this.conf, serdeName, tbl.getParameters()) && !Table.hasMetastoreBasedSchema(this.conf, oldSerdeName)) {
                try {
                    Deserializer oldSerde = MetaStoreUtils.getDeserializer(this.conf, tbl.getTTable(), false, oldSerdeName);
                    tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getTableName(), oldSerde));
                }
                catch (MetaException ex) {
                    throw new HiveException(ex);
                }
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDFILEFORMAT) {
            StorageDescriptor sd;
            StorageDescriptor storageDescriptor = sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            if (this.isSchemaEvolutionEnabled(tbl) && sd.getInputFormat().equals(OrcInputFormat.class.getName()) && !alterTbl.getInputFormat().equals(OrcInputFormat.class.getName())) {
                throw new HiveException(ErrorMsg.CANNOT_CHANGE_FILEFORMAT, "ORC", alterTbl.getOldName());
            }
            sd.setInputFormat(alterTbl.getInputFormat());
            sd.setOutputFormat(alterTbl.getOutputFormat());
            if (alterTbl.getSerdeName() != null) {
                sd.getSerdeInfo().setSerializationLib(alterTbl.getSerdeName());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCLUSTERSORTCOLUMN) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
            if (!alterTbl.isTurnOffSorting()) {
                Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
            }
            if (alterTbl.getSortColumns() != null) {
                Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
            }
            if (alterTbl.isTurnOffSorting()) {
                sd.setSortCols(new ArrayList<Order>());
            } else if (alterTbl.getNumberBuckets() == -1) {
                sd.setBucketCols(new ArrayList<String>());
                sd.setNumBuckets(-1);
                sd.setSortCols(new ArrayList<Order>());
            } else {
                sd.setBucketCols(alterTbl.getBucketColumns());
                sd.setNumBuckets(alterTbl.getNumberBuckets());
                sd.setSortCols(alterTbl.getSortColumns());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            String newLocation = alterTbl.getNewLocation();
            try {
                URI locUri = new URI(newLocation);
                if (!locUri.isAbsolute() || locUri.getScheme() == null || locUri.getScheme().trim().equals("")) {
                    throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, newLocation);
                }
                sd.setLocation(newLocation);
            }
            catch (URISyntaxException e) {
                throw new HiveException(e);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSKEWEDBY) {
            List<String> skewedColNames = null;
            List<List<String>> skewedValues = null;
            if (alterTbl.isTurnOffSkewed()) {
                skewedColNames = new ArrayList<String>();
                skewedValues = new ArrayList<List<String>>();
            } else {
                skewedColNames = alterTbl.getSkewedColNames();
                skewedValues = alterTbl.getSkewedColValues();
            }
            if (null == tbl.getSkewedInfo()) {
                SkewedInfo skewedInfo = new SkewedInfo();
                skewedInfo.setSkewedColNames(skewedColNames);
                skewedInfo.setSkewedColValues(skewedValues);
                tbl.setSkewedInfo(skewedInfo);
            } else {
                tbl.setSkewedColNames(skewedColNames);
                tbl.setSkewedColValues(skewedValues);
            }
            tbl.setStoredAsSubDirectories(alterTbl.isStoredAsSubDirectories());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERSKEWEDLOCATION) {
            Map<List<String>, String> locMaps = alterTbl.getSkewedLocations();
            Set<List<String>> keys = locMaps.keySet();
            for (List<String> key : keys) {
                String newLocation = locMaps.get(key);
                try {
                    ArrayList<String> slk;
                    URI locUri = new URI(newLocation);
                    if (part != null) {
                        slk = new ArrayList<String>(key);
                        part.setSkewedValueLocationMap(slk, locUri.toString());
                        continue;
                    }
                    slk = new ArrayList<String>(key);
                    tbl.setSkewedValueLocationMap(slk, locUri.toString());
                }
                catch (URISyntaxException e) {
                    throw new HiveException(e);
                }
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERBUCKETNUM) {
            if (part != null) {
                if (part.getBucketCount() == alterTbl.getNumberBuckets()) {
                    return 0;
                }
                part.setBucketCount(alterTbl.getNumberBuckets());
            } else {
                if (tbl.getNumBuckets() == alterTbl.getNumberBuckets()) {
                    return 0;
                }
                tbl.setNumBuckets(alterTbl.getNumberBuckets());
            }
        } else {
            throw new HiveException(ErrorMsg.UNSUPPORTED_ALTER_TBL_OP, alterTbl.getOp().toString());
        }
        return 0;
    }

    private boolean isSupportedTypeChange(String currentType, String newType) {
        if (currentType != null && newType != null) {
            if ((currentType = currentType.toLowerCase().trim()).equals(newType = newType.toLowerCase().trim())) {
                return true;
            }
            if (PromotableTypes.types().contains(currentType) && PromotableTypes.types().contains(newType)) {
                PromotableTypes pCurrentType = PromotableTypes.valueOf(currentType.toUpperCase());
                PromotableTypes pNewType = PromotableTypes.valueOf(newType.toUpperCase());
                return pNewType.ordinal() >= pCurrentType.ordinal();
            }
            return false;
        }
        return true;
    }

    private void dropTableOrPartitions(Hive db, DropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable(dropTbl.getTableName());
        }
        catch (InvalidTableException invalidTableException) {
            // empty catch block
        }
        if (dropTbl.getPartSpecs() == null) {
            this.dropTable(db, tbl, dropTbl);
        } else {
            this.dropPartitions(db, tbl, dropTbl);
        }
    }

    private void dropPartitions(Hive db, Table tbl, DropTableDesc dropTbl) throws HiveException {
        ReplicationSpec replicationSpec = dropTbl.getReplicationSpec();
        if (replicationSpec.isInReplicationScope()) {
            for (DropTableDesc.PartSpec partSpec : dropTbl.getPartSpecs()) {
                try {
                    for (Partition p : Iterables.filter(db.getPartitionsByFilter(tbl, partSpec.getPartSpec().getExprString()), replicationSpec.allowEventReplacementInto())) {
                        db.dropPartition(tbl.getDbName(), tbl.getTableName(), p.getValues(), true);
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (Exception e) {
                    throw new HiveException(e.getMessage(), e);
                }
            }
            return;
        }
        List<Partition> droppedParts = db.dropPartitions(dropTbl.getTableName(), dropTbl.getPartSpecs(), PartitionDropOptions.instance().deleteData(true).ifExists(true).purgeData(dropTbl.getIfPurge()));
        for (Partition partition : droppedParts) {
            this.console.printInfo("Dropped the partition " + partition.getName());
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK));
        }
    }

    private void dropTable(Hive db, Table tbl, DropTableDesc dropTbl) throws HiveException {
        if (tbl != null) {
            if (tbl.isView()) {
                if (!dropTbl.getExpectView()) {
                    if (dropTbl.getIfExists()) {
                        return;
                    }
                    throw new HiveException("Cannot drop a view with DROP TABLE");
                }
            } else if (dropTbl.getExpectView()) {
                if (dropTbl.getIfExists()) {
                    return;
                }
                throw new HiveException("Cannot drop a base table with DROP VIEW");
            }
        }
        ReplicationSpec replicationSpec = dropTbl.getReplicationSpec();
        if (tbl != null && replicationSpec.isInReplicationScope() && !replicationSpec.allowEventReplacementInto(tbl)) {
            if (tbl.isPartitioned()) {
                PartitionIterable partitions = new PartitionIterable(db, tbl, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
                for (Partition p : Iterables.filter(partitions, replicationSpec.allowEventReplacementInto())) {
                    db.dropPartition(tbl.getDbName(), tbl.getTableName(), p.getValues(), true);
                }
            }
            return;
        }
        int partitionBatchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_OBJECTS_MAX);
        db.dropTable(dropTbl.getTableName(), dropTbl.getIfPurge());
        if (tbl != null) {
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
    }

    private boolean updateModifiedParameters(Map<String, String> params, HiveConf conf) throws HiveException {
        String user = null;
        user = SessionState.getUserFromAuthenticator();
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        return true;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        try {
            Deserializer d = ReflectionUtil.newInstance(this.conf.getClassByName(serdeName).asSubclass(Deserializer.class), this.conf);
            if (d != null) {
                LOG.debug("Found class for " + serdeName);
            }
        }
        catch (Exception e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createDatabase(Hive db, CreateDatabaseDesc crtDb) throws HiveException {
        Database database = new Database();
        database.setName(crtDb.getName());
        database.setDescription(crtDb.getComment());
        database.setLocationUri(crtDb.getLocationUri());
        database.setParameters(crtDb.getDatabaseProperties());
        database.setOwnerName(SessionState.getUserFromAuthenticator());
        database.setOwnerType(PrincipalType.USER);
        try {
            if (!Utilities.isDefaultNameNode(this.conf)) {
                this.makeLocationQualified(database);
            }
            db.createDatabase(database, crtDb.getIfNotExists());
        }
        catch (AlreadyExistsException ex) {
            throw new HiveException(ex, ErrorMsg.DATABSAE_ALREADY_EXISTS, crtDb.getName());
        }
        return 0;
    }

    private int dropDatabase(Hive db, DropDatabaseDesc dropDb) throws HiveException {
        try {
            String dbName = dropDb.getDatabaseName();
            db.dropDatabase(dbName, true, dropDb.getIfExists(), dropDb.isCasdade());
            if (dropDb.isCasdade()) {
                FunctionRegistry.unregisterPermanentFunctions(dbName);
            }
        }
        catch (NoSuchObjectException ex) {
            throw new HiveException(ex, ErrorMsg.DATABASE_NOT_EXISTS, dropDb.getDatabaseName());
        }
        return 0;
    }

    private int switchDatabase(Hive db, SwitchDatabaseDesc switchDb) throws HiveException {
        String dbName = switchDb.getDatabaseName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        SessionState.get().setCurrentDatabase(dbName);
        Database database = db.getDatabase(dbName);
        assert (database != null);
        Map<String, String> dbParams = database.getParameters();
        if (dbParams != null) {
            for (HiveConf.ConfVars var : HiveConf.dbVars) {
                String newValue = dbParams.get(var.varname);
                if (newValue == null) continue;
                LOG.info("Changing " + var.varname + " from " + this.conf.getVar(var) + " to " + newValue);
                this.conf.setVar(var, newValue);
            }
        }
        return 0;
    }

    private int createTable(Hive db, CreateTableDesc crtTbl) throws HiveException {
        Table tbl = crtTbl.getDatabaseName() == null || crtTbl.getTableName().contains(".") ? db.newTable(crtTbl.getTableName()) : new Table(crtTbl.getDatabaseName(), crtTbl.getTableName());
        if (crtTbl.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
        }
        if (crtTbl.getPartCols() != null) {
            tbl.setPartCols(crtTbl.getPartCols());
        }
        if (crtTbl.getNumBuckets() != -1) {
            tbl.setNumBuckets(crtTbl.getNumBuckets());
        }
        if (crtTbl.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", crtTbl.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (crtTbl.getSerName() == null) {
            if (storageHandler == null) {
                LOG.info("Default to LazySimpleSerDe for table " + crtTbl.getTableName());
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                String serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info("Use StorageHandler-supplied " + serDeClassName + " for table " + crtTbl.getTableName());
                tbl.setSerializationLib(serDeClassName);
            }
        } else {
            this.validateSerDe(crtTbl.getSerName());
            tbl.setSerializationLib(crtTbl.getSerName());
        }
        if (crtTbl.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", crtTbl.getFieldDelim());
            tbl.setSerdeParam("serialization.format", crtTbl.getFieldDelim());
        }
        if (crtTbl.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", crtTbl.getFieldEscape());
        }
        if (crtTbl.getCollItemDelim() != null) {
            tbl.setSerdeParam("colelction.delim", crtTbl.getCollItemDelim());
        }
        if (crtTbl.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", crtTbl.getMapKeyDelim());
        }
        if (crtTbl.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", crtTbl.getLineDelim());
        }
        if (crtTbl.getNullFormat() != null) {
            tbl.setSerdeParam("serialization.null.format", crtTbl.getNullFormat());
        }
        if (crtTbl.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : crtTbl.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (crtTbl.getCols() != null) {
            tbl.setFields(crtTbl.getCols());
        }
        if (crtTbl.getBucketCols() != null) {
            tbl.setBucketCols(crtTbl.getBucketCols());
        }
        if (crtTbl.getSortCols() != null) {
            tbl.setSortCols(crtTbl.getSortCols());
        }
        if (crtTbl.getComment() != null) {
            tbl.setProperty("comment", crtTbl.getComment());
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()));
        }
        if (crtTbl.getSkewedColNames() != null) {
            tbl.setSkewedColNames(crtTbl.getSkewedColNames());
        }
        if (crtTbl.getSkewedColValues() != null) {
            tbl.setSkewedColValues(crtTbl.getSkewedColValues());
        }
        tbl.getTTable().setTemporary(crtTbl.isTemporary());
        tbl.setStoredAsSubDirectories(crtTbl.isStoredAsSubDirectories());
        tbl.setInputFormatClass(crtTbl.getInputFormat());
        tbl.setOutputFormatClass(crtTbl.getOutputFormat());
        if (crtTbl.getInputFormat() != null && !crtTbl.getInputFormat().isEmpty()) {
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        }
        if (crtTbl.getOutputFormat() != null && !crtTbl.getOutputFormat().isEmpty()) {
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        }
        if (!Utilities.isDefaultNameNode(this.conf) && DDLTask.doesTableNeedLocation(tbl)) {
            this.makeLocationQualified(tbl.getDbName(), tbl.getTTable().getSd(), tbl.getTableName());
        }
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if (crtTbl.getReplaceMode()) {
            try {
                db.alterTable(tbl.getDbName() + "." + tbl.getTableName(), tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Unable to alter table. " + e.getMessage(), e);
            }
        } else {
            db.createTable(tbl, crtTbl.getIfNotExists());
        }
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    private int createTableLike(Hive db, CreateTableLikeDesc crtTbl) throws Exception {
        Table tbl;
        Table oldtbl = db.getTable(crtTbl.getLikeTableName());
        if (oldtbl.getTableType() == TableType.VIRTUAL_VIEW) {
            String targetTableName = crtTbl.getTableName();
            tbl = db.newTable(targetTableName);
            if (crtTbl.getTblProps() != null) {
                tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
            }
            tbl.setTableType(TableType.MANAGED_TABLE);
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            }
            tbl.setFields(oldtbl.getCols());
            tbl.setPartCols(oldtbl.getPartCols());
            if (crtTbl.getDefaultSerName() == null) {
                LOG.info("Default to LazySimpleSerDe for table " + crtTbl.getTableName());
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                this.validateSerDe(crtTbl.getDefaultSerName());
                tbl.setSerializationLib(crtTbl.getDefaultSerName());
            }
            if (crtTbl.getDefaultSerdeProps() != null) {
                for (Map.Entry<String, String> m : crtTbl.getDefaultSerdeProps().entrySet()) {
                    tbl.setSerdeParam(m.getKey(), m.getValue());
                }
            }
            tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
            tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        } else {
            tbl = oldtbl;
            String targetTableName = crtTbl.getTableName();
            String[] names = Utilities.getDbTableName(targetTableName);
            tbl.setDbName(names[0]);
            tbl.setTableName(names[1]);
            tbl.setOwner(SessionState.getUserFromAuthenticator());
            if (crtTbl.getLocation() != null) {
                tbl.setDataLocation(new Path(crtTbl.getLocation()));
            } else {
                tbl.unsetDataLocation();
            }
            Class<? extends Deserializer> serdeClass = oldtbl.getDeserializerClass();
            Map<String, String> params = tbl.getParameters();
            SerDeSpec spec = AnnotationUtils.getAnnotation(serdeClass, SerDeSpec.class);
            String paramsStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.DDL_CTL_PARAMETERS_WHITELIST);
            HashSet<String> retainer = new HashSet<String>();
            retainer.add("storage_handler");
            if (spec != null && spec.schemaProps() != null) {
                retainer.addAll(Arrays.asList(spec.schemaProps()));
            }
            if (paramsStr != null) {
                retainer.addAll(Arrays.asList(paramsStr.split(",")));
            }
            if (!retainer.isEmpty()) {
                params.keySet().retainAll(retainer);
            } else {
                params.clear();
            }
            if (crtTbl.getTblProps() != null) {
                params.putAll(crtTbl.getTblProps());
            }
            if (crtTbl.isUserStorageFormat()) {
                tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
                tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
                tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
                tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
                if (crtTbl.getDefaultSerName() == null) {
                    LOG.info("Default to LazySimpleSerDe for like table " + crtTbl.getTableName());
                    tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                } else {
                    this.validateSerDe(crtTbl.getDefaultSerName());
                    tbl.setSerializationLib(crtTbl.getDefaultSerName());
                }
            }
            tbl.getTTable().setTemporary(crtTbl.isTemporary());
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            } else {
                tbl.getParameters().remove("EXTERNAL");
            }
        }
        if (!Utilities.isDefaultNameNode(this.conf)) {
            this.makeLocationQualified(tbl.getDbName(), tbl.getTTable().getSd(), tbl.getTableName());
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    private int createView(Hive db, CreateViewDesc crtView) throws HiveException {
        Table oldview = db.getTable(crtView.getViewName(), false);
        if (crtView.getOrReplace() && oldview != null) {
            oldview.setViewOriginalText(crtView.getViewOriginalText());
            oldview.setViewExpandedText(crtView.getViewExpandedText());
            oldview.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                oldview.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                oldview.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            oldview.setPartCols(crtView.getPartCols());
            oldview.checkValidity(null);
            try {
                db.alterTable(crtView.getViewName(), oldview);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(oldview, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            Table tbl = db.newTable(crtView.getViewName());
            tbl.setTableType(TableType.VIRTUAL_VIEW);
            tbl.setSerializationLib(null);
            tbl.clearSerDeInfo();
            tbl.setViewOriginalText(crtView.getViewOriginalText());
            tbl.setViewExpandedText(crtView.getViewExpandedText());
            tbl.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                tbl.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                tbl.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            if (crtView.getPartCols() != null) {
                tbl.setPartCols(crtView.getPartCols());
            }
            db.createTable(tbl, crtView.getIfNotExists());
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private int truncateTable(Hive db, TruncateTableDesc truncateTableDesc) throws HiveException {
        if (truncateTableDesc.getColumnIndexes() != null) {
            ColumnTruncateWork truncateWork = new ColumnTruncateWork(truncateTableDesc.getColumnIndexes(), truncateTableDesc.getInputDir(), truncateTableDesc.getOutputDir());
            truncateWork.setListBucketingCtx(truncateTableDesc.getLbCtx());
            truncateWork.setMapperCannotSpanPartns(true);
            DriverContext driverCxt = new DriverContext();
            ColumnTruncateTask taskExec = new ColumnTruncateTask();
            taskExec.initialize(db.getConf(), null, driverCxt, null);
            taskExec.setWork(truncateWork);
            taskExec.setQueryPlan(this.getQueryPlan());
            return taskExec.execute(driverCxt);
        }
        String tableName = truncateTableDesc.getTableName();
        Map<String, String> partSpec = truncateTableDesc.getPartSpec();
        Table table = db.getTable(tableName, true);
        try {
            HadoopShims shim = ShimLoader.getHadoopShims();
            for (Path location : this.getLocations(db, table, partSpec)) {
                FileSystem fs = location.getFileSystem((Configuration)this.conf);
                HadoopShims.HdfsFileStatus fullFileStatus = shim.getFullFileStatus(this.conf, fs, location);
                fs.delete(location, true);
                fs.mkdirs(location);
                try {
                    shim.setFullFileStatus(this.conf, fullFileStatus, fs, location);
                }
                catch (Exception e) {
                    LOG.warn("Error setting permissions of " + location, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }

    private int exchangeTablePartition(Hive db, AlterTableExchangePartition exchangePartition) throws HiveException {
        Map<String, String> partitionSpecs = exchangePartition.getPartitionSpecs();
        Table destTable = exchangePartition.getDestinationTable();
        Table sourceTable = exchangePartition.getSourceTable();
        List<Partition> partitions = db.exchangeTablePartitions(partitionSpecs, sourceTable.getDbName(), sourceTable.getTableName(), destTable.getDbName(), destTable.getTableName());
        for (Partition partition : partitions) {
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(new Partition(sourceTable, partition.getSpec(), null), WriteEntity.WriteType.DELETE));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(new Partition(destTable, partition.getSpec(), null), WriteEntity.WriteType.INSERT));
        }
        return 0;
    }

    private List<Path> getLocations(Hive db, Table table, Map<String, String> partSpec) throws HiveException, InvalidOperationException {
        ArrayList<Path> locations;
        block4: {
            block2: {
                block3: {
                    locations = new ArrayList<Path>();
                    if (partSpec != null) break block2;
                    if (!table.isPartitioned()) break block3;
                    for (Partition partition : db.getPartitions(table)) {
                        locations.add(partition.getDataLocation());
                        if (!this.needToUpdateStats(partition.getParameters())) continue;
                        db.alterPartition(table.getDbName(), table.getTableName(), partition);
                    }
                    break block4;
                }
                locations.add(table.getPath());
                if (!this.needToUpdateStats(table.getParameters())) break block4;
                db.alterTable(table.getDbName() + "." + table.getTableName(), table);
                break block4;
            }
            for (Partition partition : db.getPartitionsByNames(table, partSpec)) {
                locations.add(partition.getDataLocation());
                if (!this.needToUpdateStats(partition.getParameters())) continue;
                db.alterPartition(table.getDbName(), table.getTableName(), partition);
            }
        }
        return locations;
    }

    private boolean needToUpdateStats(Map<String, String> props) {
        if (null == props) {
            return false;
        }
        boolean statsPresent = false;
        for (String stat : StatsSetupConst.supportedStats) {
            String statVal = props.get(stat);
            if (statVal == null || Long.parseLong(statVal) <= 0L) continue;
            statsPresent = true;
            props.put(stat, "0");
        }
        StatsSetupConst.setBasicStatsState(props, "true");
        props.put("STATS_GENERATED_VIA_STATS_TASK", "true");
        StatsSetupConst.clearColumnStatsState(props);
        return statsPresent;
    }

    private String escapeHiveCommand(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return "DDL";
    }

    private void makeLocationQualified(String databaseName, StorageDescriptor sd, String name) throws HiveException {
        Path path = null;
        if (!sd.isSetLocation()) {
            if (databaseName.equalsIgnoreCase("default")) {
                path = new Path(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE), MetaStoreUtils.encodeTableName(name.toLowerCase()));
            }
        } else {
            path = new Path(sd.getLocation());
        }
        if (path != null) {
            sd.setLocation(Utilities.getQualifiedPath(this.conf, path));
        }
    }

    private void makeLocationQualified(CreateIndexDesc crtIndex, String name) throws HiveException {
        Path path = null;
        if (crtIndex.getLocation() == null) {
            if (Utilities.getDatabaseName(name).equalsIgnoreCase("default")) {
                String warehouse = HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE);
                String tableName = Utilities.getTableName(name);
                path = new Path(warehouse, tableName.toLowerCase());
            }
        } else {
            path = new Path(crtIndex.getLocation());
        }
        if (path != null) {
            crtIndex.setLocation(Utilities.getQualifiedPath(this.conf, path));
        }
    }

    private void makeLocationQualified(Database database) throws HiveException {
        if (database.isSetLocationUri()) {
            database.setLocationUri(Utilities.getQualifiedPath(this.conf, new Path(database.getLocationUri())));
        } else {
            database.setLocationUri(Utilities.getQualifiedPath(this.conf, new Path(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE), database.getName().toLowerCase() + DATABASE_PATH_SUFFIX)));
        }
    }

    private static boolean doesTableNeedLocation(Table tbl) {
        boolean retval = true;
        if (tbl.getStorageHandler() != null) {
            retval = !tbl.getStorageHandler().toString().equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler");
        }
        return retval;
    }

    static {
        DELIMITER_PREFIXES = new String[]{"FIELDS TERMINATED BY", "COLLECTION ITEMS TERMINATED BY", "MAP KEYS TERMINATED BY", "LINES TERMINATED BY", "NULL DEFINED AS"};
    }

    static enum PromotableTypes {
        SMALLINT,
        INT,
        BIGINT;


        static List<String> types() {
            return ImmutableList.of(SMALLINT.toString().toLowerCase(), INT.toString().toLowerCase(), BIGINT.toString().toLowerCase());
        }
    }
}

