/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.filemeta;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.hbase.HBaseReadWrite;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;

public class OrcFileMetadataHandler
implements FileMetadataHandler {
    private final Configuration conf;
    private final PartitionExpressionProxy expressionProxy;
    private final HBaseReadWrite hbase;

    public OrcFileMetadataHandler(Configuration conf, PartitionExpressionProxy expressionProxy, HBaseReadWrite hbase) {
        this.conf = conf;
        this.expressionProxy = expressionProxy;
        this.hbase = hbase;
    }

    @Override
    public void getFileMetadataByExpr(List<Long> fileIds, byte[] expr, ByteBuffer[] metadatas, ByteBuffer[] results, boolean[] eliminated) throws IOException {
        SearchArgument sarg = this.expressionProxy.createSarg(expr);
        if (metadatas == null) {
            metadatas = new ByteBuffer[results.length];
        }
        this.hbase.getFileMetadata(fileIds, metadatas);
        for (int i = 0; i < metadatas.length; ++i) {
            if (metadatas[i] == null) continue;
            ByteBuffer result = this.expressionProxy.applySargToFileMetadata(sarg, metadatas[i]);
            boolean bl = eliminated[i] = result == null;
            if (eliminated[i]) continue;
            results[i] = result;
        }
    }
}

