/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@WindowFunctionDescription(description=@Description(name="first_value", value="_FUNC_(x)"), supportsWindow=true, pivotResult=false, impliesOrder=true)
public class GenericUDAFFirstValue
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFFirstValue.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length > 2) {
            throw new UDFArgumentTypeException(2, "At most 2 arguments expected");
        }
        if (parameters.length > 1 && !parameters[1].equals(TypeInfoFactory.booleanTypeInfo)) {
            throw new UDFArgumentTypeException(1, "second argument must be a boolean expression");
        }
        return this.createEvaluator();
    }

    protected GenericUDAFFirstValueEvaluator createEvaluator() {
        return new GenericUDAFFirstValueEvaluator();
    }

    static class FirstValStreamingFixedWindow
    extends GenericUDAFStreamingEvaluator<Object> {
        public FirstValStreamingFixedWindow(GenericUDAFEvaluator wrappedEval, int numPreceding, int numFollowing) {
            super(wrappedEval, numPreceding, numFollowing);
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            throw new UnsupportedOperationException();
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFEvaluator.AggregationBuffer underlying = this.wrappedEval.getNewAggregationBuffer();
            return new State(this.numPreceding, this.numFollowing, underlying);
        }

        protected ObjectInspector inputOI() {
            return ((GenericUDAFFirstValueEvaluator)this.wrappedEval).inputOI;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            State s = (State)agg;
            FirstValueBuffer fb = (FirstValueBuffer)s.wrappedBuf;
            if (fb.firstRow) {
                this.wrappedEval.iterate(fb, parameters);
            }
            Object o = ObjectInspectorUtils.copyToStandardObject(parameters[0], this.inputOI(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (!(s.numPreceding == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && !s.valueChain.isEmpty() || fb.skipNulls && o == null)) {
                s.valueChain.add(new ValIndexPair(o, s.numRows));
            }
            if (s.numRows >= s.numFollowing) {
                if (fb.skipNulls && s.valueChain.size() == 0) {
                    s.results.add(null);
                } else {
                    s.results.add(((ValIndexPair)((State)s).valueChain.getFirst()).val);
                }
            }
            ++s.numRows;
            if (s.valueChain.size() > 0) {
                int fIdx = ((ValIndexPair)((State)s).valueChain.getFirst()).idx;
                if (s.numPreceding != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && s.numRows > fIdx + s.numPreceding + s.numFollowing) {
                    s.valueChain.removeFirst();
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            State s = (State)agg;
            ValIndexPair r = s.valueChain.size() == 0 ? null : (ValIndexPair)s.valueChain.getFirst();
            for (int i = 0; i < s.numFollowing; ++i) {
                s.results.add(r == null ? null : r.val);
                ++s.numRows;
                if (r == null) continue;
                int fIdx = r.idx;
                if (s.numPreceding == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT || s.numRows <= fIdx + s.numPreceding + s.numFollowing || s.valueChain.isEmpty()) continue;
                s.valueChain.removeFirst();
                r = !s.valueChain.isEmpty() ? (ValIndexPair)s.valueChain.getFirst() : r;
            }
            return null;
        }

        class State
        extends GenericUDAFStreamingEvaluator.StreamingState {
            private final Deque<ValIndexPair> valueChain;

            public State(int numPreceding, int numFollowing, GenericUDAFEvaluator.AggregationBuffer buf) {
                super(FirstValStreamingFixedWindow.this, numPreceding, numFollowing, buf);
                this.valueChain = new ArrayDeque<ValIndexPair>(numPreceding + numFollowing + 1);
            }

            @Override
            public int estimate() {
                if (!(this.wrappedBuf instanceof GenericUDAFEvaluator.AbstractAggregationBuffer)) {
                    return -1;
                }
                int underlying = ((GenericUDAFEvaluator.AbstractAggregationBuffer)this.wrappedBuf).estimate();
                if (underlying == -1) {
                    return -1;
                }
                if (this.numPreceding == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    return -1;
                }
                int wdwSz = this.numPreceding + this.numFollowing + 1;
                return underlying + underlying * wdwSz + underlying * wdwSz + 12;
            }

            @Override
            protected void reset() {
                this.valueChain.clear();
                super.reset();
            }
        }
    }

    static class ValIndexPair {
        Object val;
        int idx;

        ValIndexPair(Object val, int idx) {
            this.val = val;
            this.idx = idx;
        }
    }

    public static class GenericUDAFFirstValueEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        ObjectInspector outputOI;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for Rank function");
            }
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new FirstValueBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((FirstValueBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            FirstValueBuffer fb = (FirstValueBuffer)agg;
            if (fb.firstRow) {
                fb.firstRow = false;
                if (parameters.length == 2) {
                    fb.skipNulls = PrimitiveObjectInspectorUtils.getBoolean(parameters[1], PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
                }
            }
            if (!fb.valSet) {
                fb.val = ObjectInspectorUtils.copyToStandardObject(parameters[0], this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                if (!fb.skipNulls || fb.val != null) {
                    fb.valSet = true;
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((FirstValueBuffer)agg).val;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            BoundaryDef start = wFrmDef.getStart();
            BoundaryDef end = wFrmDef.getEnd();
            return new FirstValStreamingFixedWindow(this, start.getAmt(), end.getAmt());
        }
    }

    static class FirstValueBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        Object val;
        boolean valSet;
        boolean firstRow;
        boolean skipNulls;

        FirstValueBuffer() {
            this.init();
        }

        void init() {
            this.val = null;
            this.valSet = false;
            this.firstRow = true;
            this.skipNulls = false;
        }
    }
}

