/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestUnrolledBitPack {
    private long val;
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    public TestUnrolledBitPack(long val) {
        this.val = val;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{-1}, {1}, {7}, {-128}, {32000}, {8300000}, {Integer.MAX_VALUE}, {540000000000L}, {140000000000000L}, {36000000000000000L}, {Long.MAX_VALUE}};
        return Arrays.asList(data);
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBitPacking() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            long[] inp = new long[]{this.val, 0L, this.val, this.val, 0L, this.val, 0L, this.val, this.val, 0L, this.val, 0L, this.val, this.val, 0L, 0L, this.val, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, this.val, 0L, 0L, this.val, 0L, this.val, 0L, 0L, this.val, this.val};
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }
}

