/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.txn.ValidCompactorTxnList;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.TestInputOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestAcidUtils {
    @Test
    public void testCreateFilename() throws Exception {
        Path p = new Path("/tmp");
        Configuration conf = new Configuration();
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).setOldStyle(true).bucket(1);
        Assert.assertEquals((Object)"/tmp/00001_0", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.bucket(123);
        Assert.assertEquals((Object)"/tmp/00123_0", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.bucket(23).minimumTransactionId(100L).maximumTransactionId(200L).writingBase(true).setOldStyle(false);
        Assert.assertEquals((Object)"/tmp/base_0000200/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingBase(false);
        Assert.assertEquals((Object)"/tmp/delta_0000100_0000200/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
    }

    @Test
    public void testParsing() throws Exception {
        Assert.assertEquals((long)123L, (long)AcidUtils.parseBase((Path)new Path("/tmp/base_000123")));
        Path dir = new Path("/tmp/tbl");
        Configuration conf = new Configuration();
        AcidOutputFormat.Options opts = AcidUtils.parseBaseBucketFilename((Path)new Path(dir, "base_567/bucket_123"), (Configuration)conf);
        Assert.assertEquals((Object)false, (Object)opts.getOldStyle());
        Assert.assertEquals((Object)true, (Object)opts.isWritingBase());
        Assert.assertEquals((long)567L, (long)opts.getMaximumTransactionId());
        Assert.assertEquals((long)0L, (long)opts.getMinimumTransactionId());
        Assert.assertEquals((long)123L, (long)opts.getBucket());
        opts = AcidUtils.parseBaseBucketFilename((Path)new Path(dir, "000123_0"), (Configuration)conf);
        Assert.assertEquals((Object)true, (Object)opts.getOldStyle());
        Assert.assertEquals((Object)true, (Object)opts.isWritingBase());
        Assert.assertEquals((long)123L, (long)opts.getBucket());
        Assert.assertEquals((long)0L, (long)opts.getMinimumTransactionId());
        Assert.assertEquals((long)0L, (long)opts.getMaximumTransactionId());
    }

    @Test
    public void testOriginal() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/random", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:"));
        Assert.assertEquals(null, (Object)dir.getBaseDirectory());
        Assert.assertEquals((long)0L, (long)dir.getCurrentDirectories().size());
        Assert.assertEquals((long)0L, (long)dir.getObsolete().size());
        List result = dir.getOriginalFiles();
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/000000_0", (Object)((FileStatus)result.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000001_1", (Object)((FileStatus)result.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000002_0", (Object)((FileStatus)result.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/random", (Object)((FileStatus)result.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/subdir/000000_0", (Object)((FileStatus)result.get(4)).getPath().toString());
    }

    @Test
    public void testOriginalDeltas() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/random", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_050_100/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_101_101/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:"));
        Assert.assertEquals(null, (Object)dir.getBaseDirectory());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)2L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_025", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_029_029", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        List result = dir.getOriginalFiles();
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/000000_0", (Object)((FileStatus)result.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000001_1", (Object)((FileStatus)result.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000002_0", (Object)((FileStatus)result.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/random", (Object)((FileStatus)result.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/subdir/000000_0", (Object)((FileStatus)result.get(4)).getPath().toString());
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)deltas.size());
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_030", (Object)delt.getPath().toString());
        Assert.assertEquals((long)25L, (long)delt.getMinTransaction());
        Assert.assertEquals((long)30L, (long)delt.getMaxTransaction());
        delt = (AcidUtils.ParsedDelta)deltas.get(1);
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_050_100", (Object)delt.getPath().toString());
        Assert.assertEquals((long)50L, (long)delt.getMinTransaction());
        Assert.assertEquals((long)100L, (long)delt.getMaxTransaction());
    }

    @Test
    public void testBaseDeltas() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_90_120/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_49", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)5L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_030", (Object)((FileStatus)obsolete.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_025", (Object)((FileStatus)obsolete.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_029_029", (Object)((FileStatus)obsolete.get(4)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getOriginalFiles().size());
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)deltas.size());
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_050_105", (Object)delt.getPath().toString());
        Assert.assertEquals((long)50L, (long)delt.getMinTransaction());
        Assert.assertEquals((long)105L, (long)delt.getMaxTransaction());
    }

    @Test
    public void testBestBase() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_25/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_100/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_200/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_200", (Object)dir.getBaseDirectory().toString());
        List obsoletes = dir.getObsolete();
        Assert.assertEquals((long)4L, (long)obsoletes.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)((FileStatus)obsoletes.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_100", (Object)((FileStatus)obsoletes.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_25", (Object)((FileStatus)obsoletes.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsoletes.get(3)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getOriginalFiles().size());
        Assert.assertEquals((long)0L, (long)dir.getCurrentDirectories().size());
        dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("10:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_200", (Object)dir.getBaseDirectory().toString());
    }

    @Test
    public void testObsoleteOriginals() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:"));
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)1L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)dir.getBaseDirectory().toString());
    }

    @Test
    public void testOverlapingDelta() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_50", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)2L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_052_55", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0060_60", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)4L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_40_60", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_00061_61", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_000062_62", (Object)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0000063_63", (Object)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnInRead() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_2_5", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidCompactorTxnList("100:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact2() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidCompactorTxnList("100:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
    }
}

